/*
 * Decompiled with CFR 0.152.
 */
package net.hibiscus.naturespirit.blocks.block_entities;

import com.mojang.serialization.DynamicOps;
import java.util.ArrayList;
import java.util.Collection;
import net.hibiscus.naturespirit.NatureSpirit;
import net.hibiscus.naturespirit.blocks.PizzaBlock;
import net.hibiscus.naturespirit.blocks.block_entities.PizzaToppingVariant;
import net.hibiscus.naturespirit.registration.NSBlocks;
import net.hibiscus.naturespirit.registration.NSDataComponents;
import net.hibiscus.naturespirit.registration.NSTags;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponentMap;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.Nullable;

public class PizzaBlockEntity
extends BlockEntity {
    public ArrayList<PizzaToppingVariant> toppings = new ArrayList();
    public int toppingCount = 0;

    public PizzaBlockEntity(BlockPos pos, BlockState state) {
        super(NSBlocks.PIZZA_BLOCK_ENTITY_TYPE.get(), pos, state);
    }

    protected void applyImplicitComponents(BlockEntity.DataComponentInput components) {
        super.applyImplicitComponents(components);
        if (components.get(NSDataComponents.TOPPINGS) != null) {
            this.toppings = new ArrayList((Collection)components.get(NSDataComponents.TOPPINGS.get()));
        }
        this.toppingCount = this.toppings != null ? this.toppings.size() : 0;
    }

    protected void collectImplicitComponents(DataComponentMap.Builder componentMapBuilder) {
        super.collectImplicitComponents(componentMapBuilder);
        componentMapBuilder.set(NSDataComponents.TOPPINGS.get(), this.toppings);
    }

    public void saveAdditional(CompoundTag nbt, HolderLookup.Provider registryLookup) {
        super.saveAdditional(nbt, registryLookup);
        nbt.put("toppings", (Tag)NSDataComponents.TOPPINGS.get().codec().encodeStart((DynamicOps)NbtOps.INSTANCE, this.toppings).getOrThrow());
    }

    public void loadAdditional(CompoundTag nbt, HolderLookup.Provider registryLookup) {
        super.loadAdditional(nbt, registryLookup);
        this.toppings.clear();
        if (nbt.contains("toppings")) {
            NSDataComponents.TOPPINGS.get().codec().parse((DynamicOps)NbtOps.INSTANCE, (Object)nbt.get("toppings")).resultOrPartial().ifPresent(list -> this.toppings.addAll((Collection<PizzaToppingVariant>)list));
        }
    }

    public boolean canPlaceTopping(ItemStack itemStack, Level world, PizzaBlockEntity pizzaBlockEntity) {
        boolean bl;
        ResourceLocation itemId = BuiltInRegistries.ITEM.getKey((Object)itemStack.getItem());
        PizzaToppingVariant toppingVariant = PizzaBlockEntity.getVariantFromItem(itemId, world);
        boolean bl2 = bl = (Integer)pizzaBlockEntity.getBlockState().getValue((Property)PizzaBlock.BITES) == 0 && pizzaBlockEntity.toppingCount < 4 && !itemStack.is(NSTags.Items.DISABLED_PIZZA_TOPPINGS) && toppingVariant != null && !this.toppings.contains(toppingVariant);
        if (bl) {
            this.toppings.add(toppingVariant);
        }
        return bl;
    }

    @Nullable
    public static PizzaToppingVariant getVariantFromItem(ResourceLocation itemId, Level world) {
        for (PizzaToppingVariant pizzaToppingVariant : world.registryAccess().registryOrThrow(NatureSpirit.PIZZA_TOPPING_VARIANT)) {
            if (!pizzaToppingVariant.itemId().equals((Object)itemId)) continue;
            return pizzaToppingVariant;
        }
        return null;
    }

    @Nullable
    public Packet<ClientGamePacketListener> getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }

    public CompoundTag getUpdateTag(HolderLookup.Provider registryLookup) {
        return this.saveWithoutMetadata(registryLookup);
    }
}

