/*
 * Decompiled with CFR 0.152.
 */
package net.hibiscus.naturespirit.blocks;

import java.util.Optional;
import net.hibiscus.naturespirit.blocks.DownwardVineBlock;
import net.hibiscus.naturespirit.blocks.DownwardsVinePlantBlock;
import net.minecraft.BlockUtil;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.LeavesBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.registries.DeferredBlock;
import org.jetbrains.annotations.NotNull;

public class VinesLeavesBlock
extends LeavesBlock
implements BonemealableBlock {
    public DeferredBlock<DownwardsVinePlantBlock> vinePlantBlock;
    public DeferredBlock<DownwardVineBlock> vineTipBlock;

    public VinesLeavesBlock(BlockBehaviour.Properties properties, DeferredBlock<DownwardsVinePlantBlock> vinePlantBlockInput, DeferredBlock<DownwardVineBlock> vineTipBlockInput) {
        super(properties);
        this.vinePlantBlock = vinePlantBlockInput;
        this.vineTipBlock = vineTipBlockInput;
    }

    public boolean isValidBonemealTarget(@NotNull LevelReader levelReader, @NotNull BlockPos blockPos, BlockState state) {
        Optional optional = BlockUtil.getTopConnectedBlock((BlockGetter)levelReader, (BlockPos)blockPos, (Block)((Block)this.vinePlantBlock.get()), (Direction)Direction.DOWN, (Block)((Block)this.vineTipBlock.get()));
        return optional.isPresent() && levelReader.getBlockState(((BlockPos)optional.get()).relative(Direction.DOWN)).isAir() || levelReader.getBlockState(blockPos.relative(Direction.DOWN)).isAir();
    }

    public boolean isBonemealSuccess(Level level, RandomSource randomSource, BlockPos blockPos, BlockState blockState) {
        return true;
    }

    public void performBonemeal(ServerLevel serverLevel, RandomSource randomSource, BlockPos blockPos, BlockState blockState) {
        Optional optional = BlockUtil.getTopConnectedBlock((BlockGetter)serverLevel, (BlockPos)blockPos, (Block)((Block)this.vinePlantBlock.get()), (Direction)Direction.DOWN, (Block)((Block)this.vineTipBlock.get()));
        if (optional.isPresent()) {
            BlockState blockState2 = serverLevel.getBlockState((BlockPos)optional.get());
            ((DownwardVineBlock)blockState2.getBlock()).performBonemeal(serverLevel, randomSource, (BlockPos)optional.get(), blockState2);
        }
        if (optional.isEmpty()) {
            serverLevel.setBlock(blockPos.below(), ((DownwardVineBlock)((Object)this.vineTipBlock.get())).defaultBlockState(), 2);
        }
    }
}

