/*
 * Decompiled with CFR 0.152.
 */
package net.hibiscus.naturespirit.blocks;

import net.hibiscus.naturespirit.registration.NSBlocks;
import net.hibiscus.naturespirit.registration.NSTags;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.MushroomBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.feature.ConfiguredFeature;

public class ShiitakeMushroomPlantBlock
extends MushroomBlock {
    public ShiitakeMushroomPlantBlock(BlockBehaviour.Properties settings, ResourceKey<ConfiguredFeature<?, ?>> featureKey) {
        super(featureKey, settings);
    }

    public static boolean getCompletdCircle(ServerLevel world, BlockPos pos) {
        return ShiitakeMushroomPlantBlock.isMushroom(pos, world) && ShiitakeMushroomPlantBlock.isMushroom(pos.west(), world) && ShiitakeMushroomPlantBlock.isMushroom(pos.west(2), world) && ShiitakeMushroomPlantBlock.isMushroom(pos.east().north(), world) && ShiitakeMushroomPlantBlock.isMushroom(pos.east().north(2), world) && ShiitakeMushroomPlantBlock.isMushroom(pos.east().north(3), world) && ShiitakeMushroomPlantBlock.isMushroom(pos.north(4), world) && ShiitakeMushroomPlantBlock.isMushroom(pos.north(4).west(), world) && ShiitakeMushroomPlantBlock.isMushroom(pos.north(4).west(2), world) && ShiitakeMushroomPlantBlock.isMushroom(pos.north(3).west(3), world) && ShiitakeMushroomPlantBlock.isMushroom(pos.north(2).west(3), world) && ShiitakeMushroomPlantBlock.isMushroom(pos.north().west(3), world);
    }

    public static boolean getCompletedPodzol(ServerLevel world, BlockPos pos) {
        return ShiitakeMushroomPlantBlock.isPodzol((pos = pos.below()).north(), world) && ShiitakeMushroomPlantBlock.isPodzol(pos.west().north(), world) && ShiitakeMushroomPlantBlock.isPodzol(pos.west(2).north(), world) && ShiitakeMushroomPlantBlock.isPodzol(pos.north(2), world) && ShiitakeMushroomPlantBlock.isPodzol(pos.west().north(2), world) && ShiitakeMushroomPlantBlock.isPodzol(pos.west(2).north(2), world) && ShiitakeMushroomPlantBlock.isPodzol(pos.north(3), world) && ShiitakeMushroomPlantBlock.isPodzol(pos.west().north(3), world) && ShiitakeMushroomPlantBlock.isPodzol(pos.west(2).north(3), world);
    }

    public static boolean getCompletedCoarseDirt(ServerLevel world, BlockPos pos) {
        return ShiitakeMushroomPlantBlock.isDirt((pos = pos.below()).north(), world) && ShiitakeMushroomPlantBlock.isDirt(pos.west().north(), world) && ShiitakeMushroomPlantBlock.isDirt(pos.west(2).north(), world) && ShiitakeMushroomPlantBlock.isDirt(pos.north(2), world) && ShiitakeMushroomPlantBlock.isDirt(pos.west().north(2), world) && ShiitakeMushroomPlantBlock.isDirt(pos.west(2).north(2), world) && ShiitakeMushroomPlantBlock.isDirt(pos.north(3), world) && ShiitakeMushroomPlantBlock.isDirt(pos.west().north(3), world) && ShiitakeMushroomPlantBlock.isDirt(pos.west(2).north(3), world);
    }

    public static boolean isMushroom(BlockPos pos, ServerLevel world) {
        return world.getBlockState(pos).is((Block)NSBlocks.SHIITAKE_MUSHROOM.get());
    }

    public static boolean isPodzol(BlockPos pos, ServerLevel world) {
        return world.getBlockState(pos).is(Blocks.PODZOL) || world.getBlockState(pos).is(BlockTags.DIRT) && !world.getBlockState(pos).is(Blocks.GRASS_BLOCK) && !world.getBlockState(pos).is((Block)NSBlocks.SANDY_SOIL.get());
    }

    public static boolean isDirt(BlockPos pos, ServerLevel world) {
        return world.getBlockState(pos).is(Blocks.COARSE_DIRT) || world.getBlockState(pos).is((Block)NSBlocks.SANDY_SOIL.get());
    }

    public boolean canSurvive(BlockState state, LevelReader world, BlockPos pos) {
        BlockPos blockPos = pos.below();
        BlockState blockState = world.getBlockState(blockPos);
        if (blockState.is(NSTags.Blocks.SHIITAKE_MUSHROOM_GROW_BLOCK)) {
            return true;
        }
        return world.getRawBrightness(pos, 0) < 14 && this.mayPlaceOn(blockState, (BlockGetter)world, blockPos);
    }

    public void randomTick(BlockState state, ServerLevel world, BlockPos pos, RandomSource random) {
        if (random.nextInt(25) == 0) {
            int i = 5;
            for (BlockPos blockPos : BlockPos.betweenClosed((BlockPos)pos.offset(-4, -1, -4), (BlockPos)pos.offset(4, 1, 4))) {
                if (!world.getBlockState(blockPos).is((Block)this) || --i > 0) continue;
                return;
            }
            BlockPos blockPos2 = pos.offset(random.nextInt(3) - 1, random.nextInt(2) - random.nextInt(2), random.nextInt(3) - 1);
            for (int k = 0; k < 4; ++k) {
                if (world.isEmptyBlock(blockPos2) && state.canSurvive((LevelReader)world, blockPos2)) {
                    pos = blockPos2;
                }
                blockPos2 = pos.offset(random.nextInt(3) - 1, random.nextInt(2) - random.nextInt(2), random.nextInt(3) - 1);
            }
            if (world.isEmptyBlock(blockPos2) && state.canSurvive((LevelReader)world, blockPos2)) {
                world.setBlock(blockPos2, state, 2);
            }
        }
        if (ShiitakeMushroomPlantBlock.getCompletdCircle(world, pos)) {
            BlockPos blockPos = pos.north(3).west(2).below();
            for (int i = 0; i < 3; ++i) {
                for (int j = 0; j < 3; ++j) {
                    BlockPos blockPos2 = blockPos.offset(i, 0, j);
                    if (world.getBlockState(blockPos2).is(Blocks.GRASS_BLOCK) && random.nextInt(25) == 0) {
                        world.setBlock(blockPos2, Blocks.PODZOL.defaultBlockState(), 2);
                    }
                    if (ShiitakeMushroomPlantBlock.getCompletedPodzol(world, pos) && random.nextInt(25) == 0) {
                        world.setBlock(blockPos2, Blocks.COARSE_DIRT.defaultBlockState(), 2);
                    }
                    if (!ShiitakeMushroomPlantBlock.getCompletedCoarseDirt(world, pos) || random.nextInt(25) != 0) continue;
                    world.setBlock(blockPos2, ((Block)NSBlocks.SANDY_SOIL.get()).defaultBlockState(), 2);
                }
            }
        }
    }
}

