/*
 * Decompiled with CFR 0.152.
 */
package net.hibiscus.naturespirit.blocks;

import java.util.Optional;
import net.hibiscus.naturespirit.blocks.block_entities.PizzaBlockEntity;
import net.hibiscus.naturespirit.blocks.block_entities.PizzaToppingVariant;
import net.hibiscus.naturespirit.registration.NSBlocks;
import net.hibiscus.naturespirit.registration.NSStatTypes;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class PizzaBlock
extends Block
implements EntityBlock {
    public static final int DEFAULT_COMPARATOR_OUTPUT = PizzaBlock.getComparatorOutput(0);
    protected static final VoxelShape[] BITES_TO_SHAPE;
    public static final IntegerProperty BITES;

    public PizzaBlock(BlockBehaviour.Properties settings) {
        super(settings);
        this.registerDefaultState((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)BITES, (Comparable)Integer.valueOf(0)));
    }

    protected static InteractionResult tryEat(LevelAccessor world, BlockPos pos, BlockState state, Player player) {
        Optional optionalPizzaBlockEntity;
        if (player.canEat(false) && (optionalPizzaBlockEntity = world.getBlockEntity(pos, NSBlocks.PIZZA_BLOCK_ENTITY_TYPE.get())).isPresent()) {
            PizzaBlockEntity pizzaBlockEntity = (PizzaBlockEntity)((Object)optionalPizzaBlockEntity.get());
            player.awardStat(NSStatTypes.EAT_PIZZA_SLICE.get());
            int foodAmount = 2;
            float saturationModifier = 0.2f;
            for (PizzaToppingVariant pizzaToppingVariant : pizzaBlockEntity.toppings) {
                foodAmount += pizzaToppingVariant.hunger();
                saturationModifier += pizzaToppingVariant.saturation();
            }
            player.getFoodData().eat(foodAmount, saturationModifier);
            int i = (Integer)state.getValue((Property)BITES);
            world.gameEvent((Entity)player, (Holder)GameEvent.EAT, pos);
            world.gameEvent((Entity)player, (Holder)GameEvent.BLOCK_CHANGE, pos);
            if (i < 3) {
                if (!world.isClientSide()) {
                    world.getServer().overworld().sendBlockUpdated(pos, state, state, 2);
                }
                world.setBlock(pos, (BlockState)state.setValue((Property)BITES, (Comparable)Integer.valueOf((Integer)state.getValue((Property)BITES) + 1)), 2);
                pizzaBlockEntity.setChanged();
            } else {
                world.removeBlock(pos, false);
                world.gameEvent((Entity)player, (Holder)GameEvent.BLOCK_DESTROY, pos);
            }
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    public static int getComparatorOutput(int bites) {
        return (7 - bites) * 2;
    }

    public ItemStack getCloneItemStack(LevelReader world, BlockPos pos, BlockState state) {
        Optional optionalPizzaBlockEntity = world.getBlockEntity(pos, NSBlocks.PIZZA_BLOCK_ENTITY_TYPE.get());
        if (optionalPizzaBlockEntity.isPresent()) {
            PizzaBlockEntity pizzaBlockEntity = (PizzaBlockEntity)((Object)optionalPizzaBlockEntity.get());
            int BITE_STATE = (Integer)state.getValue((Property)BITES);
            Item item = BITE_STATE == 0 ? (Item)NSBlocks.WHOLE_PIZZA.get() : (BITE_STATE == 1 ? (Item)NSBlocks.THREE_QUARTERS_PIZZA.get() : (BITE_STATE == 2 ? (Item)NSBlocks.HALF_PIZZA.get() : (Item)NSBlocks.QUARTER_PIZZA.get()));
            ItemStack itemStack = new ItemStack((ItemLike)item);
            pizzaBlockEntity.saveToItem(itemStack, (HolderLookup.Provider)world.registryAccess());
            return itemStack;
        }
        return super.getCloneItemStack(world, pos, state);
    }

    public VoxelShape getShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        int BITE_STATE = (Integer)state.getValue((Property)BITES);
        return BITES_TO_SHAPE[BITE_STATE];
    }

    public InteractionResult useWithoutItem(BlockState state, Level world, BlockPos pos, Player player, BlockHitResult hit) {
        Optional optionalPizzaBlockEntity = world.getBlockEntity(pos, NSBlocks.PIZZA_BLOCK_ENTITY_TYPE.get());
        if (optionalPizzaBlockEntity.isPresent()) {
            PizzaBlockEntity pizzaBlockEntity = (PizzaBlockEntity)((Object)optionalPizzaBlockEntity.get());
            ItemStack itemStack = player.getItemInHand(player.getUsedItemHand());
            Item item = itemStack.getItem();
            if (pizzaBlockEntity.canPlaceTopping(itemStack, world, pizzaBlockEntity)) {
                if (!player.isCreative()) {
                    itemStack.shrink(1);
                }
                if (!world.isClientSide()) {
                    world.sendBlockUpdated(pos, state, state, 2);
                }
                world.playSound(null, pos, SoundEvents.MOSS_PLACE, SoundSource.BLOCKS, 1.0f, 1.0f);
                ++pizzaBlockEntity.toppingCount;
                world.gameEvent((Entity)player, (Holder)GameEvent.BLOCK_CHANGE, pos);
                player.awardStat(Stats.ITEM_USED.get((Object)item));
                return InteractionResult.SUCCESS;
            }
            if (world.isClientSide) {
                if (PizzaBlock.tryEat((LevelAccessor)world, pos, state, player).consumesAction()) {
                    return InteractionResult.SUCCESS;
                }
                if (itemStack.isEmpty()) {
                    return InteractionResult.CONSUME;
                }
            }
            return PizzaBlock.tryEat((LevelAccessor)world, pos, state, player);
        }
        return super.useWithoutItem(state, world, pos, player, hit);
    }

    public BlockState updateShape(BlockState state, Direction direction, BlockState neighborState, LevelAccessor world, BlockPos pos, BlockPos neighborPos) {
        return direction == Direction.DOWN && !state.canSurvive((LevelReader)world, pos) ? Blocks.AIR.defaultBlockState() : super.updateShape(state, direction, neighborState, world, pos, neighborPos);
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{BITES});
    }

    public boolean canSurvive(BlockState state, LevelReader world, BlockPos pos) {
        BlockPos pos1 = pos.below();
        return world.getBlockState(pos1).isRedstoneConductor((BlockGetter)world, pos1);
    }

    public int getAnalogOutputSignal(BlockState state, Level world, BlockPos pos) {
        int BITE_STATE = (Integer)state.getValue((Property)BITES);
        return PizzaBlock.getComparatorOutput(BITE_STATE);
    }

    public boolean hasAnalogOutputSignal(BlockState state) {
        return true;
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new PizzaBlockEntity(pos, state);
    }

    static {
        BITES = IntegerProperty.create((String)"pizza_bites", (int)0, (int)3);
        BITES_TO_SHAPE = new VoxelShape[]{Block.box((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)3.0, (double)15.0), Shapes.or((VoxelShape)Block.box((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)3.0, (double)8.0), (VoxelShape)Block.box((double)1.0, (double)0.0, (double)1.0, (double)8.0, (double)3.0, (double)15.0)), Block.box((double)1.0, (double)0.0, (double)1.0, (double)8.0, (double)3.0, (double)15.0), Block.box((double)1.0, (double)0.0, (double)8.0, (double)8.0, (double)3.0, (double)15.0)};
    }
}

