/*
 * Decompiled with CFR 0.152.
 */
package net.hibiscus.naturespirit.blocks;

import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.util.ParticleUtils;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.LeavesBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.shapes.VoxelShape;

public class ParticleLeavesBlock
extends LeavesBlock {
    Supplier<? extends ParticleOptions> particle;
    int chance;

    public ParticleLeavesBlock(BlockBehaviour.Properties settings, Supplier<? extends ParticleOptions> particle, int chance) {
        super(settings);
        this.particle = particle;
        this.chance = chance;
    }

    public void animateTick(BlockState state, Level world, BlockPos pos, RandomSource random) {
        BlockPos blockPos;
        BlockState blockState;
        super.animateTick(state, world, pos, random);
        if (random.nextInt(this.chance) == 0 && !ParticleLeavesBlock.isFaceFull((VoxelShape)(blockState = world.getBlockState(blockPos = pos.below())).getCollisionShape((BlockGetter)world, blockPos), (Direction)Direction.UP)) {
            ParticleUtils.spawnParticleBelow((Level)world, (BlockPos)pos, (RandomSource)random, (ParticleOptions)this.particle.get());
        }
    }
}

