/*
 * Decompiled with CFR 0.152.
 */
package net.hibiscus.naturespirit.blocks;

import com.mojang.serialization.MapCodec;
import net.hibiscus.naturespirit.registration.NSBlocks;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.RodBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.BlockHitResult;

public class OliveBranchBlock
extends RodBlock
implements BonemealableBlock {
    public static final IntegerProperty AGE = BlockStateProperties.AGE_3;

    public OliveBranchBlock(BlockBehaviour.Properties settings) {
        super(settings);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)FACING, (Comparable)Direction.UP)).setValue((Property)AGE, (Comparable)Integer.valueOf(0)));
    }

    public BlockState getStateForPlacement(BlockPlaceContext ctx) {
        Direction direction = ctx.getClickedFace();
        BlockState blockState = ctx.getLevel().getBlockState(ctx.getClickedPos().relative(direction.getOpposite()));
        return blockState.is((Block)this) && blockState.getValue((Property)FACING) == direction ? (BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)direction.getOpposite()) : (BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)direction);
    }

    protected MapCodec<? extends RodBlock> codec() {
        return null;
    }

    public boolean isValidBonemealTarget(LevelReader world, BlockPos pos, BlockState state) {
        return (Integer)state.getValue((Property)AGE) < 3 || (world.getBlockState(pos.relative((Direction)state.getValue((Property)FACING), 1)).is(Blocks.AIR) || world.getBlockState(pos.relative(((Direction)state.getValue((Property)FACING)).getOpposite(), 1)).is(Blocks.AIR)) && (Integer)state.getValue((Property)AGE) == 3;
    }

    public boolean isBonemealSuccess(Level world, RandomSource random, BlockPos pos, BlockState state) {
        return true;
    }

    protected boolean isPathfindable(BlockState state, PathComputationType type) {
        return type == PathComputationType.AIR;
    }

    protected ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        return stack.is(Items.BONE_MEAL) ? ItemInteractionResult.SKIP_DEFAULT_BLOCK_INTERACTION : super.useItemOn(stack, state, world, pos, player, hand, hit);
    }

    public InteractionResult useWithoutItem(BlockState state, Level world, BlockPos pos, Player player, BlockHitResult hit) {
        boolean bl;
        int i = (Integer)state.getValue((Property)AGE);
        boolean bl2 = bl = i == 3;
        if (i > 1) {
            int j = 1 + world.random.nextInt(2);
            OliveBranchBlock.popResource((Level)world, (BlockPos)pos, (ItemStack)new ItemStack((ItemLike)NSBlocks.OLIVES.get(), j + (bl ? 1 : 0)));
            world.playSound(null, pos, SoundEvents.SWEET_BERRY_BUSH_PICK_BERRIES, SoundSource.BLOCKS, 1.0f, 0.8f + world.random.nextFloat() * 0.4f);
            world.setBlockAndUpdate(pos, (BlockState)state.setValue((Property)AGE, (Comparable)Integer.valueOf(0)));
            world.gameEvent((Entity)player, (Holder)GameEvent.BLOCK_CHANGE, pos);
            return InteractionResult.sidedSuccess((boolean)world.isClientSide());
        }
        return super.useWithoutItem(state, world, pos, player, hit);
    }

    public void randomTick(BlockState state, ServerLevel world, BlockPos pos, RandomSource random) {
        int i = (Integer)state.getValue((Property)AGE);
        if (world.getRawBrightness(pos, 0) >= 9 && i < 3 && random.nextInt(5) == 0) {
            state = (BlockState)state.setValue((Property)AGE, (Comparable)Integer.valueOf(i + 1));
            world.setBlock(pos, state, 2);
            world.gameEvent((Holder)GameEvent.BLOCK_CHANGE, pos, GameEvent.Context.of((BlockState)state));
        }
    }

    public void performBonemeal(ServerLevel world, RandomSource random, BlockPos pos, BlockState state) {
        if ((Integer)state.getValue((Property)AGE) > 2) {
            BlockPos adjacentPos = pos.relative((Direction)state.getValue((Property)FACING), 1);
            BlockState adjacentState = world.getBlockState(adjacentPos);
            BlockPos adjacentPos2 = pos.relative(((Direction)state.getValue((Property)FACING)).getOpposite(), 1);
            BlockState adjacentState2 = world.getBlockState(adjacentPos2);
            if (adjacentState.is(Blocks.AIR)) {
                world.setBlock(adjacentPos, (BlockState)state.setValue((Property)AGE, (Comparable)Integer.valueOf(0)), 2);
            } else if (adjacentState2.is(Blocks.AIR)) {
                world.setBlock(adjacentPos2, (BlockState)state.setValue((Property)AGE, (Comparable)Integer.valueOf(0)), 2);
            }
        } else {
            world.setBlockAndUpdate(pos, (BlockState)state.setValue((Property)AGE, (Comparable)Integer.valueOf((Integer)state.getValue((Property)AGE) + 1)));
        }
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{AGE, FACING});
    }
}

