/*
 * Decompiled with CFR 0.152.
 */
package net.hibiscus.naturespirit.blocks;

import com.mojang.serialization.MapCodec;
import net.hibiscus.naturespirit.blocks.CheeseCauldronBlock;
import net.hibiscus.naturespirit.blocks.NSCauldronBehavior;
import net.hibiscus.naturespirit.registration.NSBlocks;
import net.hibiscus.naturespirit.registration.NSParticleTypes;
import net.hibiscus.naturespirit.registration.NSTags;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.AbstractCauldronBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import org.jetbrains.annotations.NotNull;

public class MilkCauldronBlock
extends AbstractCauldronBlock {
    public static final BooleanProperty AGE_INTO_CHEESE = BooleanProperty.create((String)"age_into_cheese");

    public MilkCauldronBlock(BlockBehaviour.Properties settings) {
        super(settings, NSCauldronBehavior.MILK_CAULDRON_BEHAVIOR);
        this.registerDefaultState((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)AGE_INTO_CHEESE, (Comparable)Boolean.valueOf(false)));
    }

    protected MapCodec<? extends AbstractCauldronBlock> codec() {
        return null;
    }

    protected double getContentHeight(BlockState state) {
        return 0.9375;
    }

    public boolean isRandomlyTicking(@NotNull BlockState state) {
        return (Boolean)state.getValue((Property)AGE_INTO_CHEESE);
    }

    public ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        if (stack.is(NSTags.Items.CHEESE_MAKER) && !((Boolean)state.getValue((Property)AGE_INTO_CHEESE)).booleanValue()) {
            world.setBlock(pos, (BlockState)state.setValue((Property)AGE_INTO_CHEESE, (Comparable)Boolean.valueOf(true)), 2);
            BlockState blockState = world.getBlockState(pos);
            world.playSound(null, pos, SoundEvents.BUBBLE_COLUMN_BUBBLE_POP, SoundSource.BLOCKS, 1.0f, 1.0f);
            double d = blockState.getShape((BlockGetter)world, pos).max(Direction.Axis.Y, 0.5, 0.5) + 0.03125;
            RandomSource random = world.getRandom();
            for (int i = 0; i < 10; ++i) {
                double g = random.nextGaussian() * 0.02;
                double h = random.nextGaussian() * 0.02;
                double j = random.nextGaussian() * 0.02;
                world.addParticle((ParticleOptions)NSParticleTypes.MILK_PARTICLE.get(), (double)pos.getX() + (double)0.13125f + (double)0.7375f * random.nextDouble(), (double)pos.getY() + d + 1.0 + random.nextDouble() * (1.0 - d), (double)pos.getZ() + (double)0.13125f + (double)0.7375f * random.nextDouble(), g, h, j);
            }
            if (!player.isCreative() && !player.isSpectator()) {
                player.getItemInHand(player.getUsedItemHand()).shrink(1);
            }
            return ItemInteractionResult.SUCCESS;
        }
        return super.useItemOn(stack, state, world, pos, player, hand, hit);
    }

    public void randomTick(BlockState state, ServerLevel world, BlockPos pos, @NotNull RandomSource random) {
        if (random.nextInt(25) == 0) {
            world.setBlock(pos, ((CheeseCauldronBlock)((Object)NSBlocks.CHEESE_CAULDRON.get())).defaultBlockState(), 2);
        }
        super.randomTick(state, world, pos, random);
    }

    public ItemStack getCloneItemStack(LevelReader world, BlockPos pos, BlockState state) {
        return new ItemStack((ItemLike)Blocks.CAULDRON);
    }

    public boolean isFull(BlockState state) {
        return true;
    }

    public int getAnalogOutputSignal(BlockState state, Level world, BlockPos pos) {
        return 3;
    }

    protected void createBlockStateDefinition(// Could not load outer class - annotation placement on inner may be incorrect
     @NotNull StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{AGE_INTO_CHEESE});
    }
}

