/*
 * Decompiled with CFR 0.152.
 */
package net.hibiscus.naturespirit.blocks;

import java.util.Optional;
import net.hibiscus.naturespirit.blocks.LotusFlowerBlock;
import net.minecraft.BlockUtil;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class LotusStemBlock
extends Block
implements SimpleWaterloggedBlock {
    public static final IntegerProperty AGE;
    public static final BooleanProperty WATERLOGGED;
    public static final VoxelShape SHAPE;
    public static final Direction GROWTH_DIRECTION;
    public final Block headBlock;

    public LotusStemBlock(BlockBehaviour.Properties properties, Block headBlock) {
        super(properties);
        this.headBlock = headBlock;
        this.registerDefaultState((BlockState)this.stateDefinition.any());
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext ctx) {
        BlockState blockState = ctx.getLevel().getBlockState(ctx.getClickedPos().relative(GROWTH_DIRECTION));
        FluidState fluidState = ctx.getLevel().getFluidState(ctx.getClickedPos());
        boolean waterlogged = fluidState.is(FluidTags.WATER) && fluidState.getAmount() == 8;
        return !blockState.is(this.asBlock()) && !blockState.is(this.headBlock) ? (BlockState)this.getRandomGrowthState((LevelAccessor)ctx.getLevel()).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(waterlogged)) : (BlockState)this.asBlock().defaultBlockState().setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(waterlogged));
    }

    public boolean canSurvive(BlockState state, LevelReader levelReader, BlockPos pos) {
        BlockPos blockPos = pos.relative(GROWTH_DIRECTION.getOpposite());
        BlockState blockState = levelReader.getBlockState(blockPos);
        if (levelReader.getFluidState(pos).is(FluidTags.WATER)) {
            return (blockState.isFaceSturdy((BlockGetter)levelReader, pos, Direction.UP) || blockState.is(this.asBlock())) && !blockState.is(Blocks.MAGMA_BLOCK);
        }
        return blockState.is(this.asBlock()) || blockState.is(BlockTags.DIRT) || blockState.is(Blocks.CLAY) || blockState.is(Blocks.FARMLAND);
    }

    public boolean isRandomlyTicking(BlockState state) {
        return (Integer)state.getValue((Property)AGE) < 3;
    }

    public void randomTick(BlockState state, ServerLevel world, BlockPos pos, RandomSource random) {
        double growthChance = 0.1;
        if ((Integer)state.getValue((Property)AGE) < 3 && random.nextDouble() < growthChance && this.isFertilizable((LevelReader)world, pos, state, world.isClientSide())) {
            BlockPos blockPos = pos.relative(GROWTH_DIRECTION);
            if (world.getBlockState(blockPos).isAir()) {
                world.setBlockAndUpdate(blockPos, this.headBlock.defaultBlockState());
            } else if (world.getFluidState(blockPos).is(FluidTags.WATER)) {
                world.setBlockAndUpdate(blockPos, (BlockState)((BlockState)this.defaultBlockState().setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(world.getFluidState(blockPos).is(FluidTags.WATER)))).setValue((Property)AGE, (Comparable)Integer.valueOf(2)));
                if (world.getBlockState(blockPos.above()).isAir()) {
                    world.setBlockAndUpdate(blockPos.above(), this.headBlock.defaultBlockState());
                }
            } else if (world.getBlockState(blockPos).is(this.headBlock)) {
                if (!world.getFluidState(pos).is(FluidTags.WATER)) {
                    world.setBlockAndUpdate(blockPos, (BlockState)((BlockState)this.defaultBlockState().setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(world.getFluidState(blockPos).is(FluidTags.WATER)))).setValue((Property)AGE, (Comparable)Integer.valueOf(Math.min((Integer)state.getValue((Property)AGE) + 1, 3))));
                    world.setBlockAndUpdate(blockPos.above(), this.headBlock.defaultBlockState());
                } else {
                    world.setBlockAndUpdate(pos, (BlockState)((BlockState)this.defaultBlockState().setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(world.getFluidState(pos).is(FluidTags.WATER)))).setValue((Property)AGE, (Comparable)Integer.valueOf(3)));
                }
            }
        }
    }

    public BlockState updateShape(BlockState state, Direction direction, BlockState neighborState, LevelAccessor world, BlockPos pos, BlockPos neighborPos) {
        if (direction == GROWTH_DIRECTION.getOpposite() && !state.canSurvive((LevelReader)world, pos)) {
            world.scheduleTick(pos, this.asBlock(), 1);
        }
        if (direction == GROWTH_DIRECTION && neighborState.isAir()) {
            world.setBlock(pos, (BlockState)state.setValue((Property)AGE, (Comparable)Integer.valueOf(2)), 2);
        }
        return state;
    }

    public BlockState getRandomGrowthState(LevelAccessor world) {
        return (BlockState)this.defaultBlockState().setValue((Property)AGE, (Comparable)Integer.valueOf(world.getRandom().nextInt(3)));
    }

    protected BlockState age(BlockState state, RandomSource random) {
        return (BlockState)state.cycle((Property)AGE);
    }

    public boolean isFertilizable(LevelReader world, BlockPos pos, BlockState state, boolean isClient) {
        Optional<BlockPos> optional = this.getFlowerHeadPos((BlockGetter)world, pos, this.asBlock());
        Optional<BlockPos> optional2 = this.getStemHeadPos((BlockGetter)world, pos, this.asBlock());
        Optional<BlockPos> optional3 = this.getWaterPos((BlockGetter)world, pos, this.asBlock());
        BlockPos blockPos = optional2.isPresent() ? optional2.get().below() : (optional3.isPresent() ? optional3.get().below() : optional.orElse(pos));
        boolean lotusPowered = false;
        if (optional.isPresent()) {
            BlockPos blockPos2 = optional.get();
            LotusFlowerBlock lotusFlowerBlock = (LotusFlowerBlock)world.getBlockState(blockPos2).getBlock();
            lotusPowered = lotusFlowerBlock.isPowered(world, blockPos2);
        }
        return (world.getBlockState(blockPos.relative(GROWTH_DIRECTION)).isAir() || world.getFluidState(blockPos.relative(GROWTH_DIRECTION)).is(FluidTags.WATER)) && !lotusPowered;
    }

    public boolean canGrow(Level world, RandomSource random, BlockPos pos, BlockState state) {
        return true;
    }

    public void grow(ServerLevel world, RandomSource random, BlockPos pos, BlockState state) {
        Optional<BlockPos> optional = this.getFlowerHeadPos((BlockGetter)world, pos, this.asBlock());
        Optional<BlockPos> optional2 = this.getStemHeadPos((BlockGetter)world, pos, this.asBlock());
        Optional<BlockPos> optional3 = this.getWaterPos((BlockGetter)world, pos, this.asBlock());
        BlockPos blockPos = optional2.isPresent() ? optional2.get().below() : (optional3.isPresent() ? optional3.get().below() : optional.orElse(pos));
        int i = Math.min((Integer)state.getValue((Property)AGE) + 1, 3);
        if (world.getBlockState(blockPos).isAir() || world.getBlockState(blockPos).is(this.headBlock) || world.getBlockState(blockPos).is(this.asBlock()) || world.getFluidState(blockPos).is(FluidTags.WATER)) {
            BlockPos blockPos2;
            Player player;
            world.setBlockAndUpdate(blockPos, (BlockState)((BlockState)state.setValue((Property)AGE, (Comparable)Integer.valueOf(i))).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(world.getFluidState(blockPos).is(FluidTags.WATER))));
            if (world.getBlockState(blockPos.above()).is(Blocks.AIR)) {
                world.setBlockAndUpdate(blockPos.relative(GROWTH_DIRECTION, 1), this.headBlock.defaultBlockState());
            }
            if (world.getBlockState(blockPos.above()).is(Blocks.WATER)) {
                world.setBlockAndUpdate(blockPos.relative(GROWTH_DIRECTION, 1), (BlockState)((BlockState)this.asBlock().defaultBlockState().setValue((Property)AGE, (Comparable)Integer.valueOf(i))).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(world.getFluidState(blockPos.relative(GROWTH_DIRECTION, 1)).is(FluidTags.WATER))));
            }
            if (optional.isPresent() && (player = world.getNearestPlayer((double)(blockPos2 = optional.get()).getX(), (double)blockPos2.getY(), (double)blockPos2.getZ(), 1.25, false)) != null) {
                player.move(MoverType.SHULKER_BOX, new Vec3(0.0, 1.01, 0.0));
            }
        }
    }

    private Optional<BlockPos> getFlowerHeadPos(BlockGetter world, BlockPos pos, Block block) {
        return BlockUtil.getTopConnectedBlock((BlockGetter)world, (BlockPos)pos, (Block)block, (Direction)GROWTH_DIRECTION, (Block)this.headBlock);
    }

    private Optional<BlockPos> getStemHeadPos(BlockGetter world, BlockPos pos, Block block) {
        return BlockUtil.getTopConnectedBlock((BlockGetter)world, (BlockPos)pos, (Block)block, (Direction)GROWTH_DIRECTION, (Block)Blocks.AIR);
    }

    public static Optional<BlockPos> getStemHeadWaterPos(BlockGetter world, BlockPos pos, Block block) {
        return BlockUtil.getTopConnectedBlock((BlockGetter)world, (BlockPos)pos, (Block)Blocks.WATER, (Direction)GROWTH_DIRECTION, (Block)block);
    }

    private Optional<BlockPos> getWaterPos(BlockGetter world, BlockPos pos, Block block) {
        return BlockUtil.getTopConnectedBlock((BlockGetter)world, (BlockPos)pos, (Block)block, (Direction)GROWTH_DIRECTION, (Block)Blocks.WATER);
    }

    public FluidState getFluidState(BlockState state) {
        return (Boolean)state.getValue((Property)WATERLOGGED) != false ? Fluids.WATER.getSource(false) : super.getFluidState(state);
    }

    public void tick(BlockState state, ServerLevel world, BlockPos pos, RandomSource random) {
        if (!state.canSurvive((LevelReader)world, pos)) {
            world.destroyBlock(pos, true);
        }
    }

    public VoxelShape getShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        return SHAPE;
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{AGE}).add(new Property[]{WATERLOGGED});
    }

    static {
        SHAPE = Block.box((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)16.0, (double)15.0);
        GROWTH_DIRECTION = Direction.UP;
        AGE = BlockStateProperties.AGE_3;
        WATERLOGGED = BlockStateProperties.WATERLOGGED;
    }
}

