/*
 * Decompiled with CFR 0.152.
 */
package net.hibiscus.naturespirit.blocks;

import com.mojang.serialization.MapCodec;
import net.hibiscus.naturespirit.blocks.LotusStemBlock;
import net.hibiscus.naturespirit.registration.NSBlocks;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.vehicle.Boat;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.BushBlock;
import net.minecraft.world.level.block.SupportType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class LotusFlowerBlock
extends BushBlock
implements BonemealableBlock {
    protected static final VoxelShape SHAPE = Block.box((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)1.5, (double)14.0);

    public LotusFlowerBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    protected MapCodec<? extends BushBlock> codec() {
        return null;
    }

    public void entityInside(BlockState state, Level world, BlockPos pos, Entity entity) {
        super.entityInside(state, world, pos, entity);
        if (!world.isClientSide) {
            BlockState blockstate;
            if (entity instanceof Boat) {
                world.destroyBlock(new BlockPos((Vec3i)pos), true, entity);
            }
            if ((blockstate = world.getBlockState(pos.below())).is((Block)NSBlocks.LOTUS_STEM.get()) && LotusFlowerBlock.isEntityAbove(pos, entity) && !this.isPowered((LevelReader)world, pos)) {
                world.scheduleTick(pos, (Block)this, 4);
            }
        }
    }

    private int getRedstonePower(LevelReader world, BlockPos pos) {
        BlockState blockState;
        BlockPos.MutableBlockPos mutable = pos.mutable();
        do {
            mutable.move(Direction.DOWN);
            blockState = world.getBlockState((BlockPos)mutable);
            if (!world.hasNeighborSignal((BlockPos)mutable)) continue;
            return world.getBestNeighborSignal((BlockPos)mutable);
        } while (blockState.is((Block)NSBlocks.LOTUS_STEM.get()));
        return 0;
    }

    public boolean isPowered(LevelReader world, BlockPos pos) {
        return this.getRedstonePower(world, pos) > 0;
    }

    public boolean hasAnalogOutputSignal(BlockState state) {
        return true;
    }

    public int getAnalogOutputSignal(BlockState state, Level world, BlockPos pos) {
        return this.getRedstonePower((LevelReader)world, pos);
    }

    public void tick(BlockState state, ServerLevel world, BlockPos pos, RandomSource random) {
        super.tick(state, world, pos, random);
        BlockState blockstate = world.getBlockState(pos.below());
        if (blockstate.is((Block)NSBlocks.LOTUS_STEM.get()) && LotusFlowerBlock.isEntityAbove(pos, (Entity)world.getNearestPlayer((double)pos.getX(), (double)pos.getY(), (double)pos.getZ(), 1.25, false)) && !this.isPowered((LevelReader)world, pos)) {
            world.destroyBlock(pos, false);
            world.setBlockAndUpdate(pos.below(), this.defaultBlockState());
        }
    }

    private static boolean isEntityAbove(BlockPos pos, @Nullable Entity entity) {
        if (entity == null) {
            return false;
        }
        return entity.onGround() && entity.position().y > (double)pos.getY() && entity.isShiftKeyDown();
    }

    public ItemStack getCloneItemStack(LevelReader world, BlockPos pos, BlockState state) {
        return new ItemStack((ItemLike)NSBlocks.LOTUS_FLOWER_ITEM.get());
    }

    public VoxelShape getShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        return SHAPE;
    }

    protected boolean mayPlaceOn(BlockState floor, BlockGetter world, BlockPos pos) {
        FluidState fluidState = world.getFluidState(pos);
        FluidState fluidState2 = world.getFluidState(pos.above());
        return (fluidState.getType() == Fluids.WATER || floor.isFaceSturdy(world, pos, Direction.UP, SupportType.CENTER)) && fluidState2.getType() == Fluids.EMPTY || floor.is((Block)NSBlocks.LOTUS_STEM.get());
    }

    public boolean isValidBonemealTarget(LevelReader world, BlockPos pos, BlockState state) {
        return world.getBlockState(pos.above()).isAir() && !world.getBlockState(pos.below()).is(Blocks.WATER) && !this.isPowered(world, pos);
    }

    public boolean isBonemealSuccess(Level world, RandomSource random, BlockPos pos, BlockState state) {
        return true;
    }

    public void performBonemeal(ServerLevel world, RandomSource random, BlockPos pos, BlockState state) {
        Player player = world.getNearestPlayer((double)pos.getX(), (double)pos.getY(), (double)pos.getZ(), 1.25, false);
        if (player != null) {
            player.move(MoverType.SHULKER_BOX, new Vec3(0.0, 1.01, 0.0));
        }
        if (world.getBlockState(pos.below()).is((Block)NSBlocks.LOTUS_STEM.get())) {
            LotusStemBlock lotusStemBlock = (LotusStemBlock)world.getBlockState(pos.below()).getBlock();
            lotusStemBlock.grow(world, random, pos.below(), world.getBlockState(pos.below()));
        } else {
            world.setBlockAndUpdate(pos, (BlockState)((LotusStemBlock)((Object)NSBlocks.LOTUS_STEM.get())).defaultBlockState().setValue((Property)LotusStemBlock.WATERLOGGED, (Comparable)Boolean.valueOf(false)));
            world.setBlockAndUpdate(pos.above(), this.defaultBlockState());
        }
    }
}

