/*
 * Decompiled with CFR 0.152.
 */
package net.hibiscus.naturespirit.blocks;

import java.util.function.Supplier;
import net.hibiscus.naturespirit.registration.NSTags;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.DoublePlantBlock;
import net.minecraft.world.level.block.TallGrassBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.shapes.VoxelShape;

public class LargeDesertFernBlock
extends TallGrassBlock {
    protected static final VoxelShape SHAPE = Block.box((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)16.0, (double)14.0);
    private final Supplier<? extends Block> tallBlock;

    public LargeDesertFernBlock(BlockBehaviour.Properties properties, Supplier<? extends Block> tallBlock) {
        super(properties);
        this.tallBlock = tallBlock;
    }

    protected boolean mayPlaceOn(BlockState floor, BlockGetter world, BlockPos pos) {
        return floor.is(NSTags.Blocks.TURNIP_STEM_GROWS_ON) || floor.is(Blocks.FARMLAND);
    }

    public void performBonemeal(ServerLevel world, RandomSource random, BlockPos pos, BlockState state) {
        if (this.tallBlock.get().defaultBlockState().canSurvive((LevelReader)world, pos) && world.isEmptyBlock(pos.above())) {
            DoublePlantBlock.placeAt((LevelAccessor)world, (BlockState)this.tallBlock.get().defaultBlockState(), (BlockPos)pos, (int)2);
        }
    }
}

