/*
 * Decompiled with CFR 0.152.
 */
package net.hibiscus.naturespirit.blocks;

import net.hibiscus.naturespirit.blocks.BranchingTrunkBlock;
import net.hibiscus.naturespirit.registration.NSTags;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.PipeBlock;
import net.minecraft.world.level.block.SupportType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.BlockHitResult;

public class GrowingBranchingTrunkBlock
extends BranchingTrunkBlock
implements BonemealableBlock {
    public GrowingBranchingTrunkBlock(BlockBehaviour.Properties settings) {
        super(settings);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)NORTH, (Comparable)Boolean.valueOf(false))).setValue((Property)EAST, (Comparable)Boolean.valueOf(false))).setValue((Property)SOUTH, (Comparable)Boolean.valueOf(false))).setValue((Property)WEST, (Comparable)Boolean.valueOf(false))).setValue((Property)UP, (Comparable)Boolean.valueOf(false))).setValue((Property)DOWN, (Comparable)Boolean.valueOf(false))).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false))).setValue((Property)SHEARED, (Comparable)Boolean.valueOf(false)));
    }

    @Override
    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{NORTH, EAST, SOUTH, WEST, UP, DOWN, WATERLOGGED, SHEARED});
    }

    @Override
    public boolean isPathfindable(BlockState state, BlockGetter world, BlockPos pos, PathComputationType type) {
        return false;
    }

    public boolean isValidBonemealTarget(LevelReader world, BlockPos pos, BlockState state) {
        boolean isAnythingButDown = PipeBlock.PROPERTY_BY_DIRECTION.values().stream().anyMatch(booleanProperty -> booleanProperty != DOWN && (Boolean)state.getValue((Property)booleanProperty) != false);
        return !isAnythingButDown && (world.getBlockState(pos.above()).isAir() || world.getBlockState(pos.east()).isAir() || world.getBlockState(pos.west()).isAir() || world.getBlockState(pos.north()).isAir() || world.getBlockState(pos.south()).isAir());
    }

    @Override
    public BlockState updateShape(BlockState state, Direction direction, BlockState neighborState, LevelAccessor world, BlockPos pos, BlockPos neighborPos) {
        boolean bl = neighborState.isFaceSturdy((BlockGetter)world, pos, direction.getOpposite(), SupportType.CENTER) || neighborState.getBlock() instanceof BranchingTrunkBlock || neighborState.is(BlockTags.LEAVES) || direction == Direction.UP && neighborState.is(NSTags.Blocks.SUCCULENTS);
        return (Boolean)state.getValue((Property)SHEARED) == false ? (BlockState)state.setValue((Property)PROPERTY_BY_DIRECTION.get(direction), (Comparable)Boolean.valueOf(bl)) : state;
    }

    public ItemInteractionResult useItemOn(ItemStack itemStack, BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        if (itemStack.is(Items.SHEARS) && !((Boolean)state.getValue((Property)SHEARED)).booleanValue()) {
            if (player instanceof ServerPlayer) {
                CriteriaTriggers.ITEM_USED_ON_BLOCK.trigger((ServerPlayer)player, pos, itemStack);
            }
            world.playSound(player, pos, SoundEvents.GROWING_PLANT_CROP, SoundSource.BLOCKS, 1.0f, 1.0f);
            BlockState blockState2 = (BlockState)state.setValue((Property)SHEARED, (Comparable)Boolean.valueOf(true));
            world.setBlockAndUpdate(pos, blockState2);
            world.gameEvent((Holder)GameEvent.BLOCK_CHANGE, pos, GameEvent.Context.of((Entity)player, (BlockState)blockState2));
            player.getItemInHand(hand).hurtAndBreak(1, (LivingEntity)player, LivingEntity.getSlotForHand((InteractionHand)player.getUsedItemHand()));
            return ItemInteractionResult.sidedSuccess((boolean)world.isClientSide);
        }
        return super.useItemOn(itemStack, state, world, pos, player, hand, hit);
    }

    public boolean isBonemealSuccess(Level world, RandomSource random, BlockPos pos, BlockState state) {
        return random.nextFloat() < 0.35f;
    }

    public void performBonemeal(ServerLevel world, RandomSource random, BlockPos pos, BlockState state) {
        Direction direction = Direction.getRandom((RandomSource)random);
        if (direction == Direction.DOWN) {
            direction = Direction.UP;
        }
        if (world.getBlockState(pos.relative(direction)).isAir() && (world.getBlockState(pos.relative(direction).below()).isAir() || direction == Direction.UP)) {
            world.setBlockAndUpdate(pos.relative(direction), this.withConnectionProperties((BlockGetter)world, pos.relative(direction)));
            Direction direction2 = Direction.getRandom((RandomSource)random);
            if (world.getBlockState(pos.relative(direction).relative(direction2)).isAir() && direction2 != Direction.DOWN) {
                world.setBlockAndUpdate(pos.relative(direction).relative(direction2), this.withConnectionProperties((BlockGetter)world, pos.relative(direction).relative(direction2)));
                if (random.nextFloat() < 0.3f) {
                    world.setBlockAndUpdate(pos.relative(direction).relative(direction2).above(), this.withConnectionProperties((BlockGetter)world, pos.relative(direction).relative(direction2).above()));
                }
            }
        }
    }
}

