/*
 * Decompiled with CFR 0.152.
 */
package net.hibiscus.naturespirit.blocks;

import com.mojang.serialization.MapCodec;
import net.hibiscus.naturespirit.blocks.DownwardVineBlock;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.GrowingPlantBodyBlock;
import net.minecraft.world.level.block.GrowingPlantHeadBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.neoforge.registries.DeferredBlock;

public class DownwardsVinePlantBlock
extends GrowingPlantBodyBlock {
    public static final VoxelShape SHAPE = Block.box((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)16.0, (double)15.0);
    public DeferredBlock<DownwardVineBlock> headBlock;

    public DownwardsVinePlantBlock(BlockBehaviour.Properties properties, DeferredBlock<DownwardVineBlock> headBlock) {
        super(properties, Direction.DOWN, SHAPE, false);
        this.headBlock = headBlock;
    }

    public String getDescriptionId() {
        return ((DownwardVineBlock)((Object)this.headBlock.get())).getDescriptionId();
    }

    protected GrowingPlantHeadBlock getHeadBlock() {
        return (GrowingPlantHeadBlock)this.headBlock.get();
    }

    public boolean canSurvive(BlockState state, LevelReader levelReader, BlockPos pos) {
        BlockPos blockPos = pos.relative(this.growthDirection.getOpposite());
        BlockState blockState = levelReader.getBlockState(blockPos);
        if (!this.canAttachTo(blockState)) {
            return false;
        }
        return blockState.is(this.getBodyBlock()) || blockState.is((Block)this.getHeadBlock()) || blockState.isFaceSturdy((BlockGetter)levelReader, blockPos, this.growthDirection) || blockState.is(BlockTags.LEAVES);
    }

    protected MapCodec<? extends GrowingPlantBodyBlock> codec() {
        return null;
    }
}

