/*
 * Decompiled with CFR 0.152.
 */
package net.hibiscus.naturespirit.blocks;

import com.mojang.serialization.MapCodec;
import java.util.function.Supplier;
import net.hibiscus.naturespirit.blocks.DownwardsVinePlantBlock;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.GrowingPlantHeadBlock;
import net.minecraft.world.level.block.NetherVines;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.neoforge.registries.DeferredBlock;

public class DownwardVineBlock
extends GrowingPlantHeadBlock {
    protected static final VoxelShape SHAPE = Block.box((double)4.0, (double)9.0, (double)4.0, (double)12.0, (double)16.0, (double)12.0);
    private final Supplier<DeferredBlock<DownwardsVinePlantBlock>> vinesPlantBlock;

    public DownwardVineBlock(BlockBehaviour.Properties properties, Supplier<DeferredBlock<DownwardsVinePlantBlock>> vinesPlantBlock) {
        super(properties, Direction.DOWN, SHAPE, false, 0.1);
        this.vinesPlantBlock = vinesPlantBlock;
    }

    protected MapCodec<? extends GrowingPlantHeadBlock> codec() {
        return null;
    }

    protected int getBlocksToGrowWhenBonemealed(RandomSource randomSource) {
        return NetherVines.getBlocksToGrowWhenBonemealed((RandomSource)randomSource);
    }

    public Block getBodyBlock() {
        return (Block)this.vinesPlantBlock.get().get();
    }

    public boolean canGrowInto(BlockState state) {
        return state.isAir();
    }

    public boolean canSurvive(BlockState state, LevelReader levelReader, BlockPos pos) {
        BlockPos blockPos = pos.relative(this.growthDirection.getOpposite());
        BlockState blockState = levelReader.getBlockState(blockPos);
        if (!this.canAttachTo(blockState)) {
            return false;
        }
        return blockState.is((Block)this.getHeadBlock()) || blockState.is(this.getBodyBlock()) || blockState.isFaceSturdy((BlockGetter)levelReader, blockPos, this.growthDirection) || blockState.is(BlockTags.LEAVES);
    }
}

