/*
 * Decompiled with CFR 0.152.
 */
package net.hibiscus.naturespirit.blocks;

import com.mojang.serialization.MapCodec;
import java.util.function.Supplier;
import net.hibiscus.naturespirit.blocks.DesertTurnipBlock;
import net.hibiscus.naturespirit.items.DesertTurnipItem;
import net.hibiscus.naturespirit.registration.NSBlocks;
import net.hibiscus.naturespirit.registration.NSTags;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.BushBlock;
import net.minecraft.world.level.block.FarmBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class DesertTurnipStemBlock
extends BushBlock
implements BonemealableBlock {
    public static final int MAX_AGE = 7;
    public static final IntegerProperty AGE = BlockStateProperties.AGE_7;
    protected static final VoxelShape[] AGE_TO_SHAPE = new VoxelShape[]{Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)2.0, (double)16.0), Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)4.0, (double)16.0), Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)6.0, (double)16.0), Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)8.0, (double)16.0), Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)10.0, (double)16.0), Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)12.0, (double)16.0), Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)14.0, (double)16.0), Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0)};
    private final Block rootBlock;
    private final DesertTurnipBlock vegetableBlock;
    private final Supplier<DesertTurnipItem> pickBlockItem;

    public DesertTurnipStemBlock(DesertTurnipBlock vegetableBlock, Block rootBlock, BlockBehaviour.Properties settings) {
        super(settings);
        this.rootBlock = rootBlock;
        this.vegetableBlock = vegetableBlock;
        this.pickBlockItem = NSBlocks.DESERT_TURNIP;
        this.registerDefaultState((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)AGE, (Comparable)Integer.valueOf(0)));
    }

    protected static float getAvailableMoisture(Block block, BlockGetter world, BlockPos pos) {
        boolean bl2;
        float f = 1.0f;
        BlockPos blockPos = pos.below();
        for (int i = -1; i <= 1; ++i) {
            for (int j = -1; j <= 1; ++j) {
                float g = 0.0f;
                BlockState blockState = world.getBlockState(blockPos.offset(i, 0, j));
                if (blockState.is(Blocks.FARMLAND)) {
                    g = 1.0f;
                    if ((Integer)blockState.getValue((Property)FarmBlock.MOISTURE) > 0) {
                        g = 3.0f;
                    }
                }
                if (i != 0 || j != 0) {
                    g /= 4.0f;
                }
                f += g;
            }
        }
        BlockPos blockPos2 = pos.north();
        BlockPos blockPos3 = pos.south();
        BlockPos blockPos4 = pos.west();
        BlockPos blockPos5 = pos.east();
        boolean bl = world.getBlockState(blockPos4).is(block) || world.getBlockState(blockPos5).is(block);
        boolean bl3 = bl2 = world.getBlockState(blockPos2).is(block) || world.getBlockState(blockPos3).is(block);
        if (bl && bl2) {
            f /= 2.0f;
        } else {
            boolean bl32;
            boolean bl4 = bl32 = world.getBlockState(blockPos4.north()).is(block) || world.getBlockState(blockPos5.north()).is(block) || world.getBlockState(blockPos5.south()).is(block) || world.getBlockState(blockPos4.south()).is(block);
            if (bl32) {
                f /= 2.0f;
            }
        }
        return f;
    }

    protected MapCodec<? extends BushBlock> codec() {
        return null;
    }

    protected boolean mayPlaceOn(BlockState floor, BlockGetter world, BlockPos pos) {
        return floor.is(Blocks.FARMLAND) || floor.is(NSTags.Blocks.TURNIP_STEM_GROWS_ON);
    }

    public VoxelShape getShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        return AGE_TO_SHAPE[(Integer)state.getValue((Property)AGE)];
    }

    public void randomTick(BlockState state, ServerLevel world, BlockPos pos, RandomSource random) {
        float f;
        if (world.getRawBrightness(pos, 0) >= 9 && random.nextInt((int)(25.0f / (f = DesertTurnipStemBlock.getAvailableMoisture((Block)this, (BlockGetter)world, pos))) + 1) == 0) {
            int i = (Integer)state.getValue((Property)AGE);
            if (i < 7) {
                state = (BlockState)state.setValue((Property)AGE, (Comparable)Integer.valueOf(i + 1));
                world.setBlock(pos, state, 2);
            } else {
                Direction direction = Direction.DOWN;
                BlockPos blockPos = pos.relative(direction, 2);
                BlockPos blockPos2 = pos.relative(direction, 3);
                BlockState blockState = world.getBlockState(blockPos);
                BlockState blockState2 = world.getBlockState(blockPos2);
                boolean bl = blockState.is(NSTags.Blocks.TURNIP_ROOT_REPLACEABLE);
                boolean bl2 = blockState2.is(NSTags.Blocks.TURNIP_ROOT_REPLACEABLE);
                if (bl) {
                    if (bl2 || blockState2.is((Block)this.vegetableBlock)) {
                        world.setBlockAndUpdate(blockPos, this.rootBlock.defaultBlockState());
                    } else {
                        world.setBlockAndUpdate(blockPos, this.vegetableBlock.defaultBlockState());
                    }
                }
                if (!blockState.is(this.rootBlock) && !blockState.is((Block)this.vegetableBlock) && blockState2.is((Block)this.vegetableBlock)) {
                    state = (BlockState)state.setValue((Property)AGE, (Comparable)Integer.valueOf(7));
                    world.setBlock(pos, state, 2);
                }
                if (blockState.is(this.rootBlock) && !blockState2.is((Block)this.vegetableBlock) && bl2) {
                    world.setBlockAndUpdate(blockPos2, this.vegetableBlock.defaultBlockState());
                }
            }
        }
    }

    public ItemStack getCloneItemStack(LevelReader world, BlockPos pos, BlockState state) {
        return new ItemStack((ItemLike)this.pickBlockItem.get());
    }

    public boolean isValidBonemealTarget(LevelReader world, BlockPos pos, BlockState state) {
        return (Integer)state.getValue((Property)AGE) < 7;
    }

    public boolean isBonemealSuccess(Level world, RandomSource random, BlockPos pos, BlockState state) {
        return true;
    }

    public void performBonemeal(ServerLevel world, RandomSource random, BlockPos pos, BlockState state) {
        int i = Math.min(7, (Integer)state.getValue((Property)AGE) + Mth.nextInt((RandomSource)world.random, (int)2, (int)5));
        BlockState blockState = (BlockState)state.setValue((Property)AGE, (Comparable)Integer.valueOf(i));
        world.setBlock(pos, blockState, 2);
        if (i == 7) {
            blockState.randomTick(world, pos, world.random);
        }
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{AGE});
    }
}

