/*
 * Decompiled with CFR 0.152.
 */
package net.hibiscus.naturespirit.blocks;

import com.mojang.serialization.MapCodec;
import net.hibiscus.naturespirit.blocks.SproutingCoconutBlock;
import net.hibiscus.naturespirit.registration.NSBlocks;
import net.hibiscus.naturespirit.registration.NSCriteria;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.FallingBlockEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.FallingBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class CoconutBlock
extends FallingBlock
implements BonemealableBlock,
SimpleWaterloggedBlock {
    public static final DirectionProperty FACING;
    public static final BooleanProperty FILLED;
    public static final VoxelShape SHAPE;
    public static final VoxelShape NORTH_SHAPE;
    public static final VoxelShape SOUTH_SHAPE;
    public static final BooleanProperty WATERLOGGED;
    public static final VoxelShape WEST_SHAPE;
    public static final VoxelShape EAST_SHAPE;
    public static final VoxelShape CEILING_SHAPE;
    private static final float FALLING_BLOCK_ENTITY_DAMAGE_MULTIPLIER = 1.2f;
    private static final int FALLING_BLOCK_ENTITY_MAX_DAMAGE = 20;

    public CoconutBlock(BlockBehaviour.Properties settings) {
        super(settings);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)FACING, (Comparable)Direction.UP)).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false))).setValue((Property)FILLED, (Comparable)Boolean.valueOf(true)));
    }

    protected MapCodec<? extends FallingBlock> codec() {
        return null;
    }

    public BlockState getStateForPlacement(BlockPlaceContext ctx) {
        Direction direction = ctx.getClickedFace();
        FluidState fluidState = ctx.getLevel().getFluidState(ctx.getClickedPos());
        return (BlockState)((BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)direction)).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(fluidState.is(FluidTags.WATER) && fluidState.getAmount() == 8));
    }

    protected void falling(FallingBlockEntity entity) {
        entity.setHurtsEntities(1.2f, 20);
    }

    public static boolean isFree(BlockState state) {
        return state.isAir() || state.is(BlockTags.FIRE) || state.liquid() || state.canBeReplaced();
    }

    public boolean canSurvive(BlockState state, LevelReader world, BlockPos pos) {
        return world.getBlockState(pos.relative(((Direction)state.getValue((Property)FACING)).getOpposite())).isFaceSturdy((BlockGetter)world, pos.relative(((Direction)state.getValue((Property)FACING)).getOpposite()), (Direction)state.getValue((Property)FACING));
    }

    public void onProjectileHit(Level world, BlockState state, BlockHitResult hit, Projectile projectile) {
        Entity entity = projectile.getOwner();
        if (entity instanceof ServerPlayer) {
            ServerPlayer serverPlayerEntity = (ServerPlayer)entity;
            NSCriteria.COCONUT_HIT_CRITERION.get().trigger(serverPlayerEntity, (Entity)projectile);
        }
        if (CoconutBlock.isFree(world.getBlockState(hit.getBlockPos().below())) && !((Boolean)state.getValue((Property)WATERLOGGED)).booleanValue()) {
            world.setBlockAndUpdate(hit.getBlockPos(), (BlockState)state.setValue((Property)FACING, (Comparable)Direction.UP));
        } else {
            world.destroyBlock(hit.getBlockPos(), true);
        }
    }

    public InteractionResult useWithoutItem(BlockState state, Level world, BlockPos pos, Player player, BlockHitResult hit) {
        ItemStack itemStack = player.getItemInHand(player.getUsedItemHand());
        boolean bl = (Boolean)state.getValue((Property)FILLED);
        Item item = itemStack.getItem();
        if (itemStack.is(Items.BUCKET) && bl) {
            itemStack.shrink(1);
            world.playSound(player, player.getX(), player.getY(), player.getZ(), SoundEvents.COW_MILK, SoundSource.BLOCKS, 1.0f, 1.0f);
            if (itemStack.isEmpty()) {
                player.setItemInHand(player.getUsedItemHand(), new ItemStack((ItemLike)Items.MILK_BUCKET));
            } else if (!player.getInventory().add(new ItemStack((ItemLike)Items.MILK_BUCKET))) {
                player.drop(new ItemStack((ItemLike)Items.MILK_BUCKET), false);
            }
            world.setBlockAndUpdate(pos, (BlockState)state.setValue((Property)FILLED, (Comparable)Boolean.valueOf(false)));
            world.gameEvent((Entity)player, (Holder)GameEvent.FLUID_PICKUP, pos);
        }
        if (!world.isClientSide() && bl) {
            player.awardStat(Stats.ITEM_USED.get((Object)item));
        }
        return super.useWithoutItem(state, world, pos, player, hit);
    }

    public void tick(BlockState state, ServerLevel world, BlockPos pos, RandomSource random) {
        if (CoconutBlock.isFree(world.getBlockState(pos.below())) && pos.getY() >= world.getMinBuildHeight() && world.getBlockState(pos.relative(((Direction)state.getValue((Property)FACING)).getOpposite())).isAir()) {
            state = (BlockState)state.setValue((Property)FACING, (Comparable)Direction.UP);
            FallingBlockEntity fallingBlockEntity = FallingBlockEntity.fall((Level)world, (BlockPos)pos, (BlockState)state);
            this.falling(fallingBlockEntity);
        }
        if (!CoconutBlock.isFree(world.getBlockState(pos.below())) && world.getBlockState(pos.relative(((Direction)state.getValue((Property)FACING)).getOpposite())).isAir()) {
            state.setValue((Property)FACING, (Comparable)Direction.UP);
        }
    }

    public VoxelShape getShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        return switch ((Direction)state.getValue((Property)FACING)) {
            default -> throw new MatchException(null, null);
            case Direction.DOWN -> CEILING_SHAPE;
            case Direction.UP -> SHAPE;
            case Direction.NORTH -> NORTH_SHAPE;
            case Direction.SOUTH -> SOUTH_SHAPE;
            case Direction.WEST -> WEST_SHAPE;
            case Direction.EAST -> EAST_SHAPE;
        };
    }

    public FluidState getFluidState(BlockState state) {
        return (Boolean)state.getValue((Property)WATERLOGGED) != false ? Fluids.WATER.getSource(false) : super.getFluidState(state);
    }

    public void animateTick(BlockState state, Level world, BlockPos pos, RandomSource random) {
    }

    public BlockState rotate(BlockState state, Rotation rotation) {
        return (BlockState)state.setValue((Property)FACING, (Comparable)rotation.rotate((Direction)state.getValue((Property)FACING)));
    }

    public BlockState mirror(BlockState state, Mirror mirror) {
        return (BlockState)state.setValue((Property)FACING, (Comparable)mirror.mirror((Direction)state.getValue((Property)FACING)));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{FACING, FILLED, WATERLOGGED});
    }

    public boolean isValidBonemealTarget(LevelReader world, BlockPos pos, BlockState state) {
        return state.getValue((Property)FACING) == Direction.UP;
    }

    public boolean isBonemealSuccess(Level world, RandomSource random, BlockPos pos, BlockState state) {
        return true;
    }

    public void performBonemeal(ServerLevel world, RandomSource random, BlockPos pos, BlockState state) {
        world.setBlockAndUpdate(pos, ((SproutingCoconutBlock)((Object)NSBlocks.COCONUT_SPROUT.get())).defaultBlockState());
    }

    static {
        WATERLOGGED = BlockStateProperties.WATERLOGGED;
        FACING = BlockStateProperties.FACING;
        FILLED = BooleanProperty.create((String)"filled");
        SHAPE = Block.box((double)3.0, (double)0.0, (double)3.0, (double)13.0, (double)10.0, (double)13.0);
        EAST_SHAPE = Block.box((double)0.0, (double)3.0, (double)3.0, (double)10.0, (double)13.0, (double)13.0);
        WEST_SHAPE = Block.box((double)6.0, (double)3.0, (double)3.0, (double)16.0, (double)13.0, (double)13.0);
        NORTH_SHAPE = Block.box((double)3.0, (double)3.0, (double)6.0, (double)13.0, (double)13.0, (double)16.0);
        SOUTH_SHAPE = Block.box((double)3.0, (double)3.0, (double)0.0, (double)13.0, (double)13.0, (double)10.0);
        CEILING_SHAPE = Block.box((double)3.0, (double)3.0, (double)3.0, (double)13.0, (double)13.0, (double)13.0);
    }
}

