/*
 * Decompiled with CFR 0.152.
 */
package net.hibiscus.naturespirit.blocks;

import java.util.Optional;
import net.hibiscus.naturespirit.registration.NSBlocks;
import net.hibiscus.naturespirit.registration.NSStatTypes;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.BucketPickup;
import net.minecraft.world.level.block.CakeBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.BlockHitResult;

public class CheeseBlock
extends CakeBlock
implements BucketPickup {
    public CheeseBlock(BlockBehaviour.Properties settings) {
        super(settings);
    }

    public ItemStack pickupBlock(Player player, LevelAccessor world, BlockPos pos, BlockState state) {
        if ((Integer)world.getBlockState(pos).getValue((Property)BITES) == 0) {
            world.setBlock(pos, Blocks.AIR.defaultBlockState(), 11);
            if (!world.isClientSide()) {
                world.levelEvent(2001, pos, Block.getId((BlockState)state));
            }
            return new ItemStack((ItemLike)NSBlocks.CHEESE_BUCKET.get());
        }
        return new ItemStack((ItemLike)Items.BUCKET);
    }

    protected ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        return stack.is(Items.BUCKET) && (Integer)state.getValue((Property)BITES) == 0 ? ItemInteractionResult.SKIP_DEFAULT_BLOCK_INTERACTION : super.useItemOn(stack, state, world, pos, player, hand, hit);
    }

    public InteractionResult useWithoutItem(BlockState state, Level world, BlockPos pos, Player player, BlockHitResult hit) {
        if (world.isClientSide) {
            if (CheeseBlock.eat((LevelAccessor)world, pos, state, player).consumesAction()) {
                return InteractionResult.SUCCESS;
            }
            if (player.getItemInHand(InteractionHand.MAIN_HAND).isEmpty()) {
                return InteractionResult.CONSUME;
            }
        }
        return CheeseBlock.eat((LevelAccessor)world, pos, state, player);
    }

    protected static InteractionResult eat(LevelAccessor world, BlockPos pos, BlockState state, Player player) {
        if (!player.canEat(false)) {
            return InteractionResult.PASS;
        }
        player.awardStat(NSStatTypes.EAT_CHEESE.get());
        player.getFoodData().eat(2, 0.1f);
        int i = (Integer)state.getValue((Property)BITES);
        world.gameEvent((Entity)player, (Holder)GameEvent.EAT, pos);
        if (i < 6) {
            world.setBlock(pos, (BlockState)state.setValue((Property)BITES, (Comparable)Integer.valueOf(i + 1)), 3);
        } else {
            world.removeBlock(pos, false);
            world.gameEvent((Entity)player, (Holder)GameEvent.BLOCK_DESTROY, pos);
        }
        return InteractionResult.SUCCESS;
    }

    public Optional<SoundEvent> getPickupSound() {
        return Optional.of(SoundEvents.BUCKET_FILL);
    }
}

