/*
 * Decompiled with CFR 0.152.
 */
package net.hibiscus.naturespirit.blocks;

import com.mojang.serialization.MapCodec;
import javax.annotation.Nullable;
import net.hibiscus.naturespirit.blocks.GrowingBranchingTrunkBlock;
import net.hibiscus.naturespirit.registration.NSBlocks;
import net.hibiscus.naturespirit.registration.NSTags;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.ItemTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.AxeItem;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.PipeBlock;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.SupportType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.neoforged.neoforge.common.ItemAbility;

public class BranchingTrunkBlock
extends PipeBlock
implements SimpleWaterloggedBlock {
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.WATERLOGGED;
    public static final BooleanProperty SHEARED = BooleanProperty.create((String)"sheared");

    public BranchingTrunkBlock(BlockBehaviour.Properties settings) {
        super(0.3125f, settings);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)NORTH, (Comparable)Boolean.valueOf(false))).setValue((Property)EAST, (Comparable)Boolean.valueOf(false))).setValue((Property)SOUTH, (Comparable)Boolean.valueOf(false))).setValue((Property)WEST, (Comparable)Boolean.valueOf(false))).setValue((Property)UP, (Comparable)Boolean.valueOf(false))).setValue((Property)DOWN, (Comparable)Boolean.valueOf(false))).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false))).setValue((Property)SHEARED, (Comparable)Boolean.valueOf(false)));
    }

    public BlockState getStateForPlacement(BlockPlaceContext ctx) {
        FluidState fluidState = ctx.getLevel().getFluidState(ctx.getClickedPos());
        return (BlockState)this.withConnectionProperties((BlockGetter)ctx.getLevel(), ctx.getClickedPos()).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(fluidState.is(FluidTags.WATER) && fluidState.getAmount() == 8));
    }

    public BlockState withConnectionProperties(BlockGetter world, BlockPos pos) {
        BlockState blockState = world.getBlockState(pos.below());
        BlockState blockState2 = world.getBlockState(pos.above());
        BlockState blockState3 = world.getBlockState(pos.north());
        BlockState blockState4 = world.getBlockState(pos.east());
        BlockState blockState5 = world.getBlockState(pos.south());
        BlockState blockState6 = world.getBlockState(pos.west());
        return (BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.defaultBlockState().setValue((Property)DOWN, (Comparable)Boolean.valueOf(blockState.is(BlockTags.LEAVES) || blockState.getBlock() instanceof BranchingTrunkBlock && (Boolean)blockState.getValue((Property)SHEARED) == false || blockState.isFaceSturdy(world, pos, Direction.UP, SupportType.CENTER)))).setValue((Property)UP, (Comparable)Boolean.valueOf(blockState2.is(BlockTags.LEAVES) || blockState2.getBlock() instanceof BranchingTrunkBlock && (Boolean)blockState2.getValue((Property)SHEARED) == false || blockState2.isFaceSturdy(world, pos, Direction.DOWN, SupportType.CENTER) || blockState2.is(NSTags.Blocks.SUCCULENTS)))).setValue((Property)NORTH, (Comparable)Boolean.valueOf(blockState3.is(BlockTags.LEAVES) || blockState3.getBlock() instanceof BranchingTrunkBlock && (Boolean)blockState3.getValue((Property)SHEARED) == false || blockState3.isFaceSturdy(world, pos, Direction.SOUTH, SupportType.CENTER)))).setValue((Property)EAST, (Comparable)Boolean.valueOf(blockState4.is(BlockTags.LEAVES) || blockState4.getBlock() instanceof BranchingTrunkBlock && (Boolean)blockState4.getValue((Property)SHEARED) == false || blockState4.isFaceSturdy(world, pos, Direction.WEST, SupportType.CENTER)))).setValue((Property)SOUTH, (Comparable)Boolean.valueOf(blockState5.is(BlockTags.LEAVES) || blockState5.getBlock() instanceof BranchingTrunkBlock && (Boolean)blockState5.getValue((Property)SHEARED) == false || blockState5.isFaceSturdy(world, pos, Direction.NORTH, SupportType.CENTER)))).setValue((Property)WEST, (Comparable)Boolean.valueOf(blockState6.is(BlockTags.LEAVES) || blockState6.getBlock() instanceof BranchingTrunkBlock && (Boolean)blockState6.getValue((Property)SHEARED) == false || blockState6.isFaceSturdy(world, pos, Direction.EAST, SupportType.CENTER)));
    }

    public BlockState withHorizontalConnectingProperties(BlockGetter world, BlockPos pos) {
        BlockState blockState3 = world.getBlockState(pos.north());
        BlockState blockState4 = world.getBlockState(pos.east());
        BlockState blockState5 = world.getBlockState(pos.south());
        BlockState blockState6 = world.getBlockState(pos.west());
        BlockState blockState = world.getBlockState(pos).getBlock() instanceof BranchingTrunkBlock ? world.getBlockState(pos) : this.defaultBlockState();
        return (BlockState)((BlockState)((BlockState)((BlockState)blockState.setValue((Property)NORTH, (Comparable)Boolean.valueOf(blockState3.is(BlockTags.LEAVES) || blockState3.getBlock() instanceof BranchingTrunkBlock || blockState3.isFaceSturdy(world, pos, Direction.SOUTH, SupportType.CENTER)))).setValue((Property)EAST, (Comparable)Boolean.valueOf(blockState4.is(BlockTags.LEAVES) || blockState4.getBlock() instanceof BranchingTrunkBlock || blockState4.isFaceSturdy(world, pos, Direction.WEST, SupportType.CENTER)))).setValue((Property)SOUTH, (Comparable)Boolean.valueOf(blockState5.is(BlockTags.LEAVES) || blockState5.getBlock() instanceof BranchingTrunkBlock || blockState5.isFaceSturdy(world, pos, Direction.NORTH, SupportType.CENTER)))).setValue((Property)WEST, (Comparable)Boolean.valueOf(blockState6.is(BlockTags.LEAVES) || blockState6.getBlock() instanceof BranchingTrunkBlock || blockState6.isFaceSturdy(world, pos, Direction.EAST, SupportType.CENTER)));
    }

    public BlockState withConnectionPropertiesVertical(BlockGetter world, BlockPos pos) {
        BlockState blockState = world.getBlockState(pos.below());
        BlockState blockState2 = world.getBlockState(pos.above());
        BlockState blockState3 = world.getBlockState(pos).getBlock() instanceof BranchingTrunkBlock ? world.getBlockState(pos) : this.defaultBlockState();
        return (BlockState)((BlockState)blockState3.setValue((Property)DOWN, (Comparable)Boolean.valueOf(blockState.is(BlockTags.LEAVES) || blockState.getBlock() instanceof BranchingTrunkBlock || blockState.isFaceSturdy(world, pos, Direction.UP, SupportType.CENTER)))).setValue((Property)UP, (Comparable)Boolean.valueOf(blockState2.is(BlockTags.LEAVES) || blockState2.getBlock() instanceof BranchingTrunkBlock || blockState2.isFaceSturdy(world, pos, Direction.DOWN, SupportType.CENTER)));
    }

    public BlockState updateShape(BlockState state, Direction direction, BlockState neighborState, LevelAccessor world, BlockPos pos, BlockPos neighborPos) {
        boolean bl = neighborState.isFaceSturdy((BlockGetter)world, pos, direction.getOpposite(), SupportType.CENTER) || neighborState.getBlock() instanceof BranchingTrunkBlock || neighborState.is(BlockTags.LEAVES) || direction == Direction.UP && neighborState.is(NSTags.Blocks.SUCCULENTS);
        return (BlockState)state.setValue((Property)PROPERTY_BY_DIRECTION.get(direction), (Comparable)Boolean.valueOf(bl));
    }

    public void tick(BlockState state, ServerLevel world, BlockPos pos, RandomSource random) {
        if (!state.canSurvive((LevelReader)world, pos)) {
            world.destroyBlock(pos, true);
        }
    }

    public boolean isFlammable(BlockState state, BlockGetter level, BlockPos pos, Direction direction) {
        return true;
    }

    public int getFlammability(BlockState state, BlockGetter level, BlockPos pos, Direction direction) {
        return 5;
    }

    public int getFireSpreadSpeed(BlockState state, BlockGetter level, BlockPos pos, Direction direction) {
        return 5;
    }

    @Nullable
    public BlockState getToolModifiedState(BlockState state, UseOnContext context, ItemAbility itemAbility, boolean simulate) {
        if (context.getItemInHand().getItem() instanceof AxeItem || context.getItemInHand().is(ItemTags.AXES) || context.getItemInHand().is(NSTags.Items.C_AXES)) {
            if (state.is((Block)NSBlocks.ALLUAUDIA.get())) {
                return (BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((GrowingBranchingTrunkBlock)((Object)NSBlocks.STRIPPED_ALLUAUDIA.get())).defaultBlockState().setValue((Property)DOWN, (Comparable)((Boolean)state.getValue((Property)DOWN)))).setValue((Property)UP, (Comparable)((Boolean)state.getValue((Property)UP)))).setValue((Property)NORTH, (Comparable)((Boolean)state.getValue((Property)NORTH)))).setValue((Property)SOUTH, (Comparable)((Boolean)state.getValue((Property)SOUTH)))).setValue((Property)EAST, (Comparable)((Boolean)state.getValue((Property)EAST)))).setValue((Property)WEST, (Comparable)((Boolean)state.getValue((Property)WEST)))).setValue((Property)WATERLOGGED, (Comparable)((Boolean)state.getValue((Property)WATERLOGGED)))).setValue((Property)SHEARED, (Comparable)((Boolean)state.getValue((Property)SHEARED)));
            }
            if (state.is((Block)NSBlocks.JOSHUA.getLog().get())) {
                return (BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((Block)NSBlocks.JOSHUA.getStrippedLog().get()).defaultBlockState().setValue((Property)DOWN, (Comparable)((Boolean)state.getValue((Property)DOWN)))).setValue((Property)UP, (Comparable)((Boolean)state.getValue((Property)UP)))).setValue((Property)NORTH, (Comparable)((Boolean)state.getValue((Property)NORTH)))).setValue((Property)SOUTH, (Comparable)((Boolean)state.getValue((Property)SOUTH)))).setValue((Property)EAST, (Comparable)((Boolean)state.getValue((Property)EAST)))).setValue((Property)WEST, (Comparable)((Boolean)state.getValue((Property)WEST)))).setValue((Property)WATERLOGGED, (Comparable)((Boolean)state.getValue((Property)WATERLOGGED)))).setValue((Property)SHEARED, (Comparable)((Boolean)state.getValue((Property)SHEARED)));
            }
        }
        return super.getToolModifiedState(state, context, itemAbility, simulate);
    }

    public boolean canSurvive(BlockState state, LevelReader world, BlockPos pos) {
        return true;
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{NORTH, EAST, SOUTH, WEST, UP, DOWN, WATERLOGGED, SHEARED});
    }

    public boolean isPathfindable(BlockState state, BlockGetter world, BlockPos pos, PathComputationType type) {
        return false;
    }

    public FluidState getFluidState(BlockState state) {
        return (Boolean)state.getValue((Property)WATERLOGGED) != false ? Fluids.WATER.getSource(false) : super.getFluidState(state);
    }

    protected MapCodec<? extends PipeBlock> codec() {
        return null;
    }
}

