/*
 * Decompiled with CFR 0.152.
 */
package net.hibiscus.naturespirit.advancements;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import net.hibiscus.naturespirit.registration.NSCriteria;
import net.minecraft.advancements.Criterion;
import net.minecraft.advancements.CriterionTriggerInstance;
import net.minecraft.advancements.critereon.ContextAwarePredicate;
import net.minecraft.advancements.critereon.CriterionValidator;
import net.minecraft.advancements.critereon.EntityPredicate;
import net.minecraft.advancements.critereon.SimpleCriterionTrigger;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.storage.loot.LootContext;
import org.jetbrains.annotations.NotNull;

public class CoconutHitCriterion
extends SimpleCriterionTrigger<Conditions> {
    public Codec<Conditions> codec() {
        return Conditions.CODEC;
    }

    public void trigger(ServerPlayer player, Entity projectile) {
        LootContext lootContext = EntityPredicate.createContext((ServerPlayer)player, (Entity)projectile);
        this.trigger(player, conditions -> conditions.test(lootContext));
    }

    public record Conditions(Optional<ContextAwarePredicate> player, Optional<ContextAwarePredicate> projectile) implements SimpleCriterionTrigger.SimpleInstance
    {
        public static final Codec<Conditions> CODEC = RecordCodecBuilder.create((T instance) -> instance.group((App)EntityPredicate.ADVANCEMENT_CODEC.optionalFieldOf("player").forGetter(Conditions::player), (App)EntityPredicate.ADVANCEMENT_CODEC.optionalFieldOf("projectile").forGetter(Conditions::projectile)).apply((Applicative)instance, Conditions::new));

        public static Criterion<Conditions> create(Optional<ContextAwarePredicate> projectile) {
            return NSCriteria.COCONUT_HIT_CRITERION.get().createCriterion((CriterionTriggerInstance)new Conditions(Optional.empty(), projectile));
        }

        public boolean test(LootContext projectileContext) {
            return this.projectile.isEmpty() || this.projectile.get().matches(projectileContext);
        }

        public void validate(@NotNull CriterionValidator validator) {
            validator.validateEntity(this.projectile, ".projectile");
        }
    }
}

