/*
 * Decompiled with CFR 0.152.
 */
package net.hibiscus.naturespirit;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import net.hibiscus.naturespirit.blocks.BearberryBlock;
import net.hibiscus.naturespirit.blocks.CattailBlock;
import net.hibiscus.naturespirit.blocks.CoconutBlock;
import net.hibiscus.naturespirit.blocks.DesertTurnipBlock;
import net.hibiscus.naturespirit.blocks.DownwardVineBlock;
import net.hibiscus.naturespirit.blocks.GrowingBranchingTrunkBlock;
import net.hibiscus.naturespirit.blocks.LargeDesertFernBlock;
import net.hibiscus.naturespirit.blocks.LargeSproutsBlock;
import net.hibiscus.naturespirit.blocks.LotusStemBlock;
import net.hibiscus.naturespirit.blocks.NSCauldronBehavior;
import net.hibiscus.naturespirit.blocks.NSFernBlock;
import net.hibiscus.naturespirit.blocks.OliveBranchBlock;
import net.hibiscus.naturespirit.blocks.PaperLanternBlock;
import net.hibiscus.naturespirit.blocks.PolyporeBlock;
import net.hibiscus.naturespirit.blocks.RedMossBlock;
import net.hibiscus.naturespirit.blocks.SedgeGrassBlock;
import net.hibiscus.naturespirit.blocks.SemiTallGrassBlock;
import net.hibiscus.naturespirit.blocks.ShiitakeMushroomPlantBlock;
import net.hibiscus.naturespirit.blocks.TallLargeDesertFernBlock;
import net.hibiscus.naturespirit.blocks.TallSedgeGrassBlock;
import net.hibiscus.naturespirit.blocks.block_entities.PizzaToppingVariant;
import net.hibiscus.naturespirit.config.NSConfig;
import net.hibiscus.naturespirit.items.AzollaItem;
import net.hibiscus.naturespirit.items.CoconutHalfItem;
import net.hibiscus.naturespirit.items.DesertTurnipItem;
import net.hibiscus.naturespirit.items.NSBoatItem;
import net.hibiscus.naturespirit.items.PizzaItem;
import net.hibiscus.naturespirit.registration.NSBlocks;
import net.hibiscus.naturespirit.registration.NSCriteria;
import net.hibiscus.naturespirit.registration.NSDataComponents;
import net.hibiscus.naturespirit.registration.NSEntityTypes;
import net.hibiscus.naturespirit.registration.NSItemGroups;
import net.hibiscus.naturespirit.registration.NSParticleTypes;
import net.hibiscus.naturespirit.registration.NSSounds;
import net.hibiscus.naturespirit.registration.NSStatTypes;
import net.hibiscus.naturespirit.registration.NSVillagers;
import net.hibiscus.naturespirit.registration.NSWorldGen;
import net.hibiscus.naturespirit.registration.compat.NSArtsAndCraftsCompat;
import net.hibiscus.naturespirit.registration.sets.WoodSet;
import net.hibiscus.naturespirit.terrablender.TerraFeraxRegion;
import net.hibiscus.naturespirit.terrablender.TerraFlavaRegion;
import net.hibiscus.naturespirit.terrablender.TerraLaetaRegion;
import net.hibiscus.naturespirit.terrablender.TerraMaterRegion;
import net.hibiscus.naturespirit.terrablender.TerraSolarisRegion;
import net.hibiscus.naturespirit.world.NSSurfaceRules;
import net.minecraft.core.Registry;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.repository.Pack;
import net.minecraft.server.packs.repository.PackSource;
import net.minecraft.world.item.AxeItem;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.CreativeModeTabs;
import net.minecraft.world.item.HangingSignItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.PlaceOnWaterBlockItem;
import net.minecraft.world.item.SignItem;
import net.minecraft.world.item.SolidBucketItem;
import net.minecraft.world.item.StandingAndWallBlockItem;
import net.minecraft.world.item.trading.ItemCost;
import net.minecraft.world.item.trading.MerchantOffer;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.CarpetBlock;
import net.minecraft.world.level.block.ColoredFallingBlock;
import net.minecraft.world.level.block.DoublePlantBlock;
import net.minecraft.world.level.block.DropExperienceBlock;
import net.minecraft.world.level.block.FlowerPotBlock;
import net.minecraft.world.level.block.HugeMushroomBlock;
import net.minecraft.world.level.block.LeavesBlock;
import net.minecraft.world.level.block.RedStoneOreBlock;
import net.minecraft.world.level.block.RotatedPillarBlock;
import net.minecraft.world.level.block.SaplingBlock;
import net.minecraft.world.level.block.SlabBlock;
import net.minecraft.world.level.block.StairBlock;
import net.minecraft.world.level.block.WallBlock;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.levelgen.SurfaceRules;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.ModList;
import net.neoforged.fml.ModLoadingContext;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.config.ModConfig;
import net.neoforged.fml.event.lifecycle.FMLCommonSetupEvent;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.AddPackFindersEvent;
import net.neoforged.neoforge.event.BlockEntityTypeAddBlocksEvent;
import net.neoforged.neoforge.event.BuildCreativeModeTabContentsEvent;
import net.neoforged.neoforge.event.village.WandererTradesEvent;
import net.neoforged.neoforge.registries.DataPackRegistryEvent;
import terrablender.api.Region;
import terrablender.api.Regions;
import terrablender.api.SurfaceRuleManager;

@Mod(value="natures_spirit")
public class NatureSpirit {
    public static final String MOD_ID = "natures_spirit";
    public static final ResourceKey<Registry<PizzaToppingVariant>> PIZZA_TOPPING_VARIANT = ResourceKey.createRegistryKey((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"natures_spirit", (String)"pizza_topping_variant"));

    public NatureSpirit() {
        IEventBus modEventBus = ModLoadingContext.get().getActiveContainer().getEventBus();
        modEventBus.addListener(this::commonSetup);
        NSBlocks.BLOCKS.register(modEventBus);
        NSDataComponents.DATA_COMPONENTS.register(modEventBus);
        NSBlocks.ITEMS.register(modEventBus);
        NSBlocks.BLOCK_ENTITIES.register(modEventBus);
        NSEntityTypes.ENTITIES.register(modEventBus);
        NSItemGroups.CREATIVE_MODE_TABS.register(modEventBus);
        NSParticleTypes.PARTICLES.register(modEventBus);
        NSStatTypes.CUSTOM_STATS.register(modEventBus);
        NSSounds.SOUND_EVENTS.register(modEventBus);
        NSWorldGen.FOLIAGE_PLACERS.register(modEventBus);
        NSWorldGen.TREE_DECORATORS.register(modEventBus);
        NSWorldGen.TRUNK_PLACERS.register(modEventBus);
        NSWorldGen.CARVERS.register(modEventBus);
        NSWorldGen.FEATURES.register(modEventBus);
        NSVillagers.VILLAGER_TYPES.register(modEventBus);
        modEventBus.addListener(this::creativeInventory);
        modEventBus.addListener(this::addPackFinders);
        modEventBus.addListener(this::blockTypes);
        modEventBus.addListener(this::datapackRegistries);
        NSCriteria.CRITERIA.register(modEventBus);
        NeoForge.EVENT_BUS.addListener(this::wandererTrades);
        ModLoadingContext.get().getActiveContainer().registerConfig(ModConfig.Type.COMMON, NSConfig.SPEC);
        if (ModList.get().isLoaded("arts_and_crafts")) {
            NSArtsAndCraftsCompat.ANC_BLOCKS.register(modEventBus);
            NSArtsAndCraftsCompat.ANC_ITEMS.register(modEventBus);
        }
    }

    private void commonSetup(FMLCommonSetupEvent event) {
        Regions.register((Region)new TerraFeraxRegion(ResourceLocation.fromNamespaceAndPath((String)MOD_ID, (String)"terra_ferax"), NSConfig.terraFeraxWeight));
        Regions.register((Region)new TerraSolarisRegion(ResourceLocation.fromNamespaceAndPath((String)MOD_ID, (String)"terra_solaris"), NSConfig.terraSolarisWeight));
        Regions.register((Region)new TerraFlavaRegion(ResourceLocation.fromNamespaceAndPath((String)MOD_ID, (String)"terra_flava"), NSConfig.terraFlavaWeight));
        Regions.register((Region)new TerraMaterRegion(ResourceLocation.fromNamespaceAndPath((String)MOD_ID, (String)"terra_mater"), NSConfig.terraMaterWeight));
        Regions.register((Region)new TerraLaetaRegion(ResourceLocation.fromNamespaceAndPath((String)MOD_ID, (String)"terra_laeta"), NSConfig.terraLaetaWeight));
        SurfaceRuleManager.addSurfaceRules((SurfaceRuleManager.RuleCategory)SurfaceRuleManager.RuleCategory.OVERWORLD, (String)MOD_ID, (SurfaceRules.RuleSource)NSSurfaceRules.makeRules());
        event.enqueueWork(() -> {
            ((FlowerPotBlock)Blocks.FLOWER_POT).addPlant(NSBlocks.SCORCHED_GRASS.getId(), NSBlocks.POTTED_SCORCHED_GRASS);
            ((FlowerPotBlock)Blocks.FLOWER_POT).addPlant(NSBlocks.BEACH_GRASS.getId(), NSBlocks.POTTED_BEACH_GRASS);
            ((FlowerPotBlock)Blocks.FLOWER_POT).addPlant(NSBlocks.SEDGE_GRASS.getId(), NSBlocks.POTTED_SEDGE_GRASS);
            ((FlowerPotBlock)Blocks.FLOWER_POT).addPlant(NSBlocks.FLAXEN_FERN.getId(), NSBlocks.POTTED_FLAXEN_FERN);
            ((FlowerPotBlock)Blocks.FLOWER_POT).addPlant(NSBlocks.OAT_GRASS.getId(), NSBlocks.POTTED_OAT_GRASS);
            ((FlowerPotBlock)Blocks.FLOWER_POT).addPlant(NSBlocks.MELIC_GRASS.getId(), NSBlocks.POTTED_MELIC_GRASS);
            ((FlowerPotBlock)Blocks.FLOWER_POT).addPlant(NSBlocks.LUSH_FERN.getId(), NSBlocks.POTTED_LUSH_FERN);
            ((FlowerPotBlock)Blocks.FLOWER_POT).addPlant(NSBlocks.FRIGID_GRASS.getId(), NSBlocks.POTTED_FRIGID_GRASS);
            ((FlowerPotBlock)Blocks.FLOWER_POT).addPlant(NSBlocks.GREEN_BEARBERRIES.getId(), NSBlocks.POTTED_GREEN_BEARBERRIES);
            ((FlowerPotBlock)Blocks.FLOWER_POT).addPlant(NSBlocks.RED_BEARBERRIES.getId(), NSBlocks.POTTED_RED_BEARBERRIES);
            ((FlowerPotBlock)Blocks.FLOWER_POT).addPlant(NSBlocks.PURPLE_BEARBERRIES.getId(), NSBlocks.POTTED_PURPLE_BEARBERRIES);
            ((FlowerPotBlock)Blocks.FLOWER_POT).addPlant(NSBlocks.ORNATE_SUCCULENT.getId(), NSBlocks.POTTED_ORNATE_SUCCULENT);
            ((FlowerPotBlock)Blocks.FLOWER_POT).addPlant(NSBlocks.DROWSY_SUCCULENT.getId(), NSBlocks.POTTED_DROWSY_SUCCULENT);
            ((FlowerPotBlock)Blocks.FLOWER_POT).addPlant(NSBlocks.AUREATE_SUCCULENT.getId(), NSBlocks.POTTED_AUREATE_SUCCULENT);
            ((FlowerPotBlock)Blocks.FLOWER_POT).addPlant(NSBlocks.SAGE_SUCCULENT.getId(), NSBlocks.POTTED_SAGE_SUCCULENT);
            ((FlowerPotBlock)Blocks.FLOWER_POT).addPlant(NSBlocks.FOAMY_SUCCULENT.getId(), NSBlocks.POTTED_FOAMY_SUCCULENT);
            ((FlowerPotBlock)Blocks.FLOWER_POT).addPlant(NSBlocks.IMPERIAL_SUCCULENT.getId(), NSBlocks.POTTED_IMPERIAL_SUCCULENT);
            ((FlowerPotBlock)Blocks.FLOWER_POT).addPlant(NSBlocks.REGAL_SUCCULENT.getId(), NSBlocks.POTTED_REGAL_SUCCULENT);
            ((FlowerPotBlock)Blocks.FLOWER_POT).addPlant(NSBlocks.SHIITAKE_MUSHROOM.getId(), NSBlocks.POTTED_SHIITAKE_MUSHROOM);
            ((FlowerPotBlock)Blocks.FLOWER_POT).addPlant(NSBlocks.MARIGOLD.getFlowerBlock().getId(), NSBlocks.MARIGOLD.getPottedFlowerBlock());
            ((FlowerPotBlock)Blocks.FLOWER_POT).addPlant(NSBlocks.BLUEBELL.getFlowerBlock().getId(), NSBlocks.BLUEBELL.getPottedFlowerBlock());
            ((FlowerPotBlock)Blocks.FLOWER_POT).addPlant(NSBlocks.TIGER_LILY.getFlowerBlock().getId(), NSBlocks.TIGER_LILY.getPottedFlowerBlock());
            ((FlowerPotBlock)Blocks.FLOWER_POT).addPlant(NSBlocks.PURPLE_WILDFLOWER.getFlowerBlock().getId(), NSBlocks.PURPLE_WILDFLOWER.getPottedFlowerBlock());
            ((FlowerPotBlock)Blocks.FLOWER_POT).addPlant(NSBlocks.YELLOW_WILDFLOWER.getFlowerBlock().getId(), NSBlocks.YELLOW_WILDFLOWER.getPottedFlowerBlock());
            ((FlowerPotBlock)Blocks.FLOWER_POT).addPlant(NSBlocks.RED_HEATHER.getFlowerBlock().getId(), NSBlocks.RED_HEATHER.getPottedFlowerBlock());
            ((FlowerPotBlock)Blocks.FLOWER_POT).addPlant(NSBlocks.WHITE_HEATHER.getFlowerBlock().getId(), NSBlocks.WHITE_HEATHER.getPottedFlowerBlock());
            ((FlowerPotBlock)Blocks.FLOWER_POT).addPlant(NSBlocks.PURPLE_HEATHER.getFlowerBlock().getId(), NSBlocks.PURPLE_HEATHER.getPottedFlowerBlock());
            ((FlowerPotBlock)Blocks.FLOWER_POT).addPlant(NSBlocks.ANEMONE.getFlowerBlock().getId(), NSBlocks.ANEMONE.getPottedFlowerBlock());
            ((FlowerPotBlock)Blocks.FLOWER_POT).addPlant(NSBlocks.DWARF_BLOSSOMS.getFlowerBlock().getId(), NSBlocks.DWARF_BLOSSOMS.getPottedFlowerBlock());
            ((FlowerPotBlock)Blocks.FLOWER_POT).addPlant(NSBlocks.PROTEA.getFlowerBlock().getId(), NSBlocks.PROTEA.getPottedFlowerBlock());
            ((FlowerPotBlock)Blocks.FLOWER_POT).addPlant(NSBlocks.HIBISCUS.getFlowerBlock().getId(), NSBlocks.HIBISCUS.getPottedFlowerBlock());
            ((FlowerPotBlock)Blocks.FLOWER_POT).addPlant(NSBlocks.BLUE_IRIS.getFlowerBlock().getId(), NSBlocks.BLUE_IRIS.getPottedFlowerBlock());
            ((FlowerPotBlock)Blocks.FLOWER_POT).addPlant(NSBlocks.BLACK_IRIS.getFlowerBlock().getId(), NSBlocks.BLACK_IRIS.getPottedFlowerBlock());
            ((FlowerPotBlock)Blocks.FLOWER_POT).addPlant(NSBlocks.RUBY_BLOSSOMS.getFlowerBlock().getId(), NSBlocks.RUBY_BLOSSOMS.getPottedFlowerBlock());
            ((FlowerPotBlock)Blocks.FLOWER_POT).addPlant(NSBlocks.REDWOOD.getSapling().getId(), NSBlocks.REDWOOD.getPottedSapling());
            ((FlowerPotBlock)Blocks.FLOWER_POT).addPlant(NSBlocks.SUGI.getSapling().getId(), NSBlocks.SUGI.getPottedSapling());
            ((FlowerPotBlock)Blocks.FLOWER_POT).addPlant(NSBlocks.WISTERIA.getPurpleSapling().getId(), NSBlocks.WISTERIA.getPottedPurpleSapling());
            ((FlowerPotBlock)Blocks.FLOWER_POT).addPlant(NSBlocks.WISTERIA.getWhiteSapling().getId(), NSBlocks.WISTERIA.getPottedWhiteSapling());
            ((FlowerPotBlock)Blocks.FLOWER_POT).addPlant(NSBlocks.WISTERIA.getBlueSapling().getId(), NSBlocks.WISTERIA.getPottedBlueSapling());
            ((FlowerPotBlock)Blocks.FLOWER_POT).addPlant(NSBlocks.WISTERIA.getPinkSapling().getId(), NSBlocks.WISTERIA.getPottedPinkSapling());
            ((FlowerPotBlock)Blocks.FLOWER_POT).addPlant(NSBlocks.FIR.getSapling().getId(), NSBlocks.FIR.getPottedSapling());
            ((FlowerPotBlock)Blocks.FLOWER_POT).addPlant(NSBlocks.WILLOW.getSapling().getId(), NSBlocks.WILLOW.getPottedSapling());
            ((FlowerPotBlock)Blocks.FLOWER_POT).addPlant(NSBlocks.ASPEN.getSapling().getId(), NSBlocks.ASPEN.getPottedSapling());
            ((FlowerPotBlock)Blocks.FLOWER_POT).addPlant(NSBlocks.MAPLE.getRedSapling().getId(), NSBlocks.MAPLE.getPottedRedSapling());
            ((FlowerPotBlock)Blocks.FLOWER_POT).addPlant(NSBlocks.MAPLE.getOrangeSapling().getId(), NSBlocks.MAPLE.getPottedOrangeSapling());
            ((FlowerPotBlock)Blocks.FLOWER_POT).addPlant(NSBlocks.MAPLE.getYellowSapling().getId(), NSBlocks.MAPLE.getPottedYellowSapling());
            ((FlowerPotBlock)Blocks.FLOWER_POT).addPlant(NSBlocks.CYPRESS.getSapling().getId(), NSBlocks.CYPRESS.getPottedSapling());
            ((FlowerPotBlock)Blocks.FLOWER_POT).addPlant(NSBlocks.OLIVE.getSapling().getId(), NSBlocks.OLIVE.getPottedSapling());
            ((FlowerPotBlock)Blocks.FLOWER_POT).addPlant(NSBlocks.JOSHUA.getSapling().getId(), NSBlocks.JOSHUA.getPottedSapling());
            ((FlowerPotBlock)Blocks.FLOWER_POT).addPlant(NSBlocks.GHAF.getSapling().getId(), NSBlocks.GHAF.getPottedSapling());
            ((FlowerPotBlock)Blocks.FLOWER_POT).addPlant(NSBlocks.PALO_VERDE.getSapling().getId(), NSBlocks.PALO_VERDE.getPottedSapling());
            ((FlowerPotBlock)Blocks.FLOWER_POT).addPlant(NSBlocks.CEDAR.getSapling().getId(), NSBlocks.CEDAR.getPottedSapling());
            ((FlowerPotBlock)Blocks.FLOWER_POT).addPlant(NSBlocks.LARCH.getSapling().getId(), NSBlocks.LARCH.getPottedSapling());
            ((FlowerPotBlock)Blocks.FLOWER_POT).addPlant(NSBlocks.MAHOGANY.getSapling().getId(), NSBlocks.MAHOGANY.getPottedSapling());
            ((FlowerPotBlock)Blocks.FLOWER_POT).addPlant(NSBlocks.SAXAUL.getSapling().getId(), NSBlocks.SAXAUL.getPottedSapling());
            NSCauldronBehavior.registerBehavior();
            HashMap<Block, Block> strippables = new HashMap<Block, Block>(AxeItem.STRIPPABLES);
            strippables.put((Block)NSBlocks.REDWOOD.getLog().get(), (Block)NSBlocks.REDWOOD.getStrippedLog().get());
            strippables.put((Block)NSBlocks.SUGI.getLog().get(), (Block)NSBlocks.SUGI.getStrippedLog().get());
            strippables.put((Block)NSBlocks.WISTERIA.getLog().get(), (Block)NSBlocks.WISTERIA.getStrippedLog().get());
            strippables.put((Block)NSBlocks.FIR.getLog().get(), (Block)NSBlocks.FIR.getStrippedLog().get());
            strippables.put((Block)NSBlocks.WILLOW.getLog().get(), (Block)NSBlocks.WILLOW.getStrippedLog().get());
            strippables.put((Block)NSBlocks.ASPEN.getLog().get(), (Block)NSBlocks.ASPEN.getStrippedLog().get());
            strippables.put((Block)NSBlocks.MAPLE.getLog().get(), (Block)NSBlocks.MAPLE.getStrippedLog().get());
            strippables.put((Block)NSBlocks.CYPRESS.getLog().get(), (Block)NSBlocks.CYPRESS.getStrippedLog().get());
            strippables.put((Block)NSBlocks.OLIVE.getLog().get(), (Block)NSBlocks.OLIVE.getStrippedLog().get());
            strippables.put((Block)NSBlocks.GHAF.getLog().get(), (Block)NSBlocks.GHAF.getStrippedLog().get());
            strippables.put((Block)NSBlocks.PALO_VERDE.getLog().get(), (Block)NSBlocks.PALO_VERDE.getStrippedLog().get());
            strippables.put((Block)NSBlocks.CEDAR.getLog().get(), (Block)NSBlocks.CEDAR.getStrippedLog().get());
            strippables.put((Block)NSBlocks.COCONUT.getLog().get(), (Block)NSBlocks.COCONUT.getStrippedLog().get());
            strippables.put((Block)NSBlocks.LARCH.getLog().get(), (Block)NSBlocks.LARCH.getStrippedLog().get());
            strippables.put((Block)NSBlocks.MAHOGANY.getLog().get(), (Block)NSBlocks.MAHOGANY.getStrippedLog().get());
            strippables.put((Block)NSBlocks.SAXAUL.getLog().get(), (Block)NSBlocks.SAXAUL.getStrippedLog().get());
            strippables.put((Block)NSBlocks.REDWOOD.getWood().get(), (Block)NSBlocks.REDWOOD.getStrippedWood().get());
            strippables.put((Block)NSBlocks.SUGI.getWood().get(), (Block)NSBlocks.SUGI.getStrippedWood().get());
            strippables.put((Block)NSBlocks.WISTERIA.getWood().get(), (Block)NSBlocks.WISTERIA.getStrippedWood().get());
            strippables.put((Block)NSBlocks.FIR.getWood().get(), (Block)NSBlocks.FIR.getStrippedWood().get());
            strippables.put((Block)NSBlocks.WILLOW.getWood().get(), (Block)NSBlocks.WILLOW.getStrippedWood().get());
            strippables.put((Block)NSBlocks.ASPEN.getWood().get(), (Block)NSBlocks.ASPEN.getStrippedWood().get());
            strippables.put((Block)NSBlocks.MAPLE.getWood().get(), (Block)NSBlocks.MAPLE.getStrippedWood().get());
            strippables.put((Block)NSBlocks.CYPRESS.getWood().get(), (Block)NSBlocks.CYPRESS.getStrippedWood().get());
            strippables.put((Block)NSBlocks.OLIVE.getWood().get(), (Block)NSBlocks.OLIVE.getStrippedWood().get());
            strippables.put((Block)NSBlocks.GHAF.getWood().get(), (Block)NSBlocks.GHAF.getStrippedWood().get());
            strippables.put((Block)NSBlocks.PALO_VERDE.getWood().get(), (Block)NSBlocks.PALO_VERDE.getStrippedWood().get());
            strippables.put((Block)NSBlocks.CEDAR.getWood().get(), (Block)NSBlocks.CEDAR.getStrippedWood().get());
            strippables.put((Block)NSBlocks.COCONUT.getWood().get(), (Block)NSBlocks.COCONUT.getStrippedWood().get());
            strippables.put((Block)NSBlocks.LARCH.getWood().get(), (Block)NSBlocks.LARCH.getStrippedWood().get());
            strippables.put((Block)NSBlocks.MAHOGANY.getWood().get(), (Block)NSBlocks.MAHOGANY.getStrippedWood().get());
            strippables.put((Block)NSBlocks.SAXAUL.getWood().get(), (Block)NSBlocks.SAXAUL.getStrippedWood().get());
            strippables.put((Block)NSBlocks.ALLUAUDIA_BUNDLE.get(), (Block)NSBlocks.STRIPPED_ALLUAUDIA_BUNDLE.get());
            strippables.put((Block)NSBlocks.JOSHUA.getBundle().get(), (Block)NSBlocks.JOSHUA.getStrippedBundle().get());
            AxeItem.STRIPPABLES = strippables;
        });
    }

    public void datapackRegistries(DataPackRegistryEvent.NewRegistry event) {
        event.dataPackRegistry(PIZZA_TOPPING_VARIANT, PizzaToppingVariant.CODEC, PizzaToppingVariant.CODEC, builder -> builder.maxId(256).sync(true));
    }

    public void wandererTrades(WandererTradesEvent event) {
        List genericTrades = event.getGenericTrades();
        genericTrades.add((pTrader, pRandom) -> new MerchantOffer(new ItemCost((ItemLike)Items.EMERALD, 1), new ItemStack((ItemLike)NSBlocks.RED_MOSS_BLOCK.get(), 2), 5, 1, 0.5f));
        genericTrades.add((pTrader, pRandom) -> new MerchantOffer(new ItemCost((ItemLike)Items.EMERALD, 1), new ItemStack((ItemLike)NSBlocks.HIBISCUS.getFlowerBlock().get(), 2), 12, 1, 0.5f));
        genericTrades.add((pTrader, pRandom) -> new MerchantOffer(new ItemCost((ItemLike)Items.EMERALD, 1), new ItemStack((ItemLike)NSBlocks.BLUE_IRIS.getFlowerBlock().get(), 2), 12, 1, 0.5f));
        genericTrades.add((pTrader, pRandom) -> new MerchantOffer(new ItemCost((ItemLike)Items.EMERALD, 1), new ItemStack((ItemLike)NSBlocks.BLACK_IRIS.getFlowerBlock().get(), 2), 12, 1, 0.5f));
        genericTrades.add((pTrader, pRandom) -> new MerchantOffer(new ItemCost((ItemLike)Items.EMERALD, 1), new ItemStack((ItemLike)NSBlocks.ANEMONE.getFlowerBlock().get(), 2), 12, 1, 0.5f));
        genericTrades.add((pTrader, pRandom) -> new MerchantOffer(new ItemCost((ItemLike)Items.EMERALD, 1), new ItemStack((ItemLike)NSBlocks.LOTUS_FLOWER_ITEM.get(), 2), 12, 1, 0.5f));
        genericTrades.add((pTrader, pRandom) -> new MerchantOffer(new ItemCost((ItemLike)Items.EMERALD, 5), new ItemStack((ItemLike)NSBlocks.REDWOOD.getSapling().get(), 5), 8, 1, 0.5f));
        genericTrades.add((pTrader, pRandom) -> new MerchantOffer(new ItemCost((ItemLike)Items.EMERALD, 5), new ItemStack((ItemLike)NSBlocks.SUGI.getSapling().get(), 5), 8, 1, 0.5f));
        genericTrades.add((pTrader, pRandom) -> new MerchantOffer(new ItemCost((ItemLike)Items.EMERALD, 5), new ItemStack((ItemLike)NSBlocks.WISTERIA.getPurpleSapling().get(), 5), 8, 1, 0.5f));
        genericTrades.add((pTrader, pRandom) -> new MerchantOffer(new ItemCost((ItemLike)Items.EMERALD, 5), new ItemStack((ItemLike)NSBlocks.WISTERIA.getWhiteSapling().get(), 5), 8, 1, 0.5f));
        genericTrades.add((pTrader, pRandom) -> new MerchantOffer(new ItemCost((ItemLike)Items.EMERALD, 5), new ItemStack((ItemLike)NSBlocks.WISTERIA.getBlueSapling().get(), 5), 8, 1, 0.5f));
        genericTrades.add((pTrader, pRandom) -> new MerchantOffer(new ItemCost((ItemLike)Items.EMERALD, 5), new ItemStack((ItemLike)NSBlocks.WISTERIA.getPinkSapling().get(), 5), 8, 1, 0.5f));
        genericTrades.add((pTrader, pRandom) -> new MerchantOffer(new ItemCost((ItemLike)Items.EMERALD, 5), new ItemStack((ItemLike)NSBlocks.FIR.getSapling().get(), 5), 8, 1, 0.5f));
        genericTrades.add((pTrader, pRandom) -> new MerchantOffer(new ItemCost((ItemLike)Items.EMERALD, 5), new ItemStack((ItemLike)NSBlocks.WILLOW.getSapling().get(), 5), 8, 1, 0.5f));
        genericTrades.add((pTrader, pRandom) -> new MerchantOffer(new ItemCost((ItemLike)Items.EMERALD, 5), new ItemStack((ItemLike)NSBlocks.ASPEN.getSapling().get(), 5), 8, 1, 0.5f));
        genericTrades.add((pTrader, pRandom) -> new MerchantOffer(new ItemCost((ItemLike)Items.EMERALD, 5), new ItemStack((ItemLike)NSBlocks.MAPLE.getRedSapling().get(), 5), 8, 1, 0.5f));
        genericTrades.add((pTrader, pRandom) -> new MerchantOffer(new ItemCost((ItemLike)Items.EMERALD, 5), new ItemStack((ItemLike)NSBlocks.MAPLE.getOrangeSapling().get(), 5), 8, 1, 0.5f));
        genericTrades.add((pTrader, pRandom) -> new MerchantOffer(new ItemCost((ItemLike)Items.EMERALD, 5), new ItemStack((ItemLike)NSBlocks.MAPLE.getYellowSapling().get(), 5), 8, 1, 0.5f));
        genericTrades.add((pTrader, pRandom) -> new MerchantOffer(new ItemCost((ItemLike)Items.EMERALD, 5), new ItemStack((ItemLike)NSBlocks.CYPRESS.getSapling().get(), 5), 8, 1, 0.5f));
        genericTrades.add((pTrader, pRandom) -> new MerchantOffer(new ItemCost((ItemLike)Items.EMERALD, 5), new ItemStack((ItemLike)NSBlocks.OLIVE.getSapling().get(), 5), 8, 1, 0.5f));
        genericTrades.add((pTrader, pRandom) -> new MerchantOffer(new ItemCost((ItemLike)Items.EMERALD, 5), new ItemStack((ItemLike)NSBlocks.JOSHUA.getSapling().get(), 5), 8, 1, 0.5f));
        genericTrades.add((pTrader, pRandom) -> new MerchantOffer(new ItemCost((ItemLike)Items.EMERALD, 5), new ItemStack((ItemLike)NSBlocks.GHAF.getSapling().get(), 5), 8, 1, 0.5f));
        genericTrades.add((pTrader, pRandom) -> new MerchantOffer(new ItemCost((ItemLike)Items.EMERALD, 5), new ItemStack((ItemLike)NSBlocks.PALO_VERDE.getSapling().get(), 5), 8, 1, 0.5f));
        genericTrades.add((pTrader, pRandom) -> new MerchantOffer(new ItemCost((ItemLike)Items.EMERALD, 5), new ItemStack((ItemLike)NSBlocks.CEDAR.getSapling().get(), 5), 8, 1, 0.5f));
        genericTrades.add((pTrader, pRandom) -> new MerchantOffer(new ItemCost((ItemLike)Items.EMERALD, 5), new ItemStack((ItemLike)NSBlocks.LARCH.getSapling().get(), 5), 8, 1, 0.5f));
        genericTrades.add((pTrader, pRandom) -> new MerchantOffer(new ItemCost((ItemLike)Items.EMERALD, 5), new ItemStack((ItemLike)NSBlocks.MAHOGANY.getSapling().get(), 5), 8, 1, 0.5f));
        genericTrades.add((pTrader, pRandom) -> new MerchantOffer(new ItemCost((ItemLike)Items.EMERALD, 5), new ItemStack((ItemLike)NSBlocks.SAXAUL.getSapling().get(), 5), 8, 1, 0.5f));
    }

    public void blockTypes(BlockEntityTypeAddBlocksEvent event) {
        event.modify(BlockEntityType.SIGN, new Block[]{(Block)NSBlocks.REDWOOD.getSign().get(), (Block)NSBlocks.REDWOOD.getWallSign().get(), (Block)NSBlocks.SUGI.getSign().get(), (Block)NSBlocks.SUGI.getWallSign().get(), (Block)NSBlocks.WISTERIA.getSign().get(), (Block)NSBlocks.WISTERIA.getWallSign().get(), (Block)NSBlocks.FIR.getSign().get(), (Block)NSBlocks.FIR.getWallSign().get(), (Block)NSBlocks.WILLOW.getSign().get(), (Block)NSBlocks.WILLOW.getWallSign().get(), (Block)NSBlocks.ASPEN.getSign().get(), (Block)NSBlocks.ASPEN.getWallSign().get(), (Block)NSBlocks.MAPLE.getSign().get(), (Block)NSBlocks.MAPLE.getWallSign().get(), (Block)NSBlocks.CYPRESS.getSign().get(), (Block)NSBlocks.CYPRESS.getWallSign().get(), (Block)NSBlocks.OLIVE.getSign().get(), (Block)NSBlocks.OLIVE.getWallSign().get(), (Block)NSBlocks.JOSHUA.getSign().get(), (Block)NSBlocks.JOSHUA.getWallSign().get(), (Block)NSBlocks.GHAF.getSign().get(), (Block)NSBlocks.GHAF.getWallSign().get(), (Block)NSBlocks.PALO_VERDE.getSign().get(), (Block)NSBlocks.PALO_VERDE.getWallSign().get(), (Block)NSBlocks.COCONUT.getSign().get(), (Block)NSBlocks.COCONUT.getWallSign().get(), (Block)NSBlocks.CEDAR.getSign().get(), (Block)NSBlocks.CEDAR.getWallSign().get(), (Block)NSBlocks.LARCH.getSign().get(), (Block)NSBlocks.LARCH.getWallSign().get(), (Block)NSBlocks.MAHOGANY.getSign().get(), (Block)NSBlocks.MAHOGANY.getWallSign().get(), (Block)NSBlocks.SAXAUL.getSign().get(), (Block)NSBlocks.SAXAUL.getWallSign().get(), (Block)NSBlocks.PAPER_SIGN.get(), (Block)NSBlocks.PAPER_WALL_SIGN.get()});
        event.modify(BlockEntityType.HANGING_SIGN, new Block[]{(Block)NSBlocks.REDWOOD.getHangingSign().get(), (Block)NSBlocks.REDWOOD.getHangingWallSign().get(), (Block)NSBlocks.SUGI.getHangingSign().get(), (Block)NSBlocks.SUGI.getHangingWallSign().get(), (Block)NSBlocks.WISTERIA.getHangingSign().get(), (Block)NSBlocks.WISTERIA.getHangingWallSign().get(), (Block)NSBlocks.FIR.getHangingSign().get(), (Block)NSBlocks.FIR.getHangingWallSign().get(), (Block)NSBlocks.WILLOW.getHangingSign().get(), (Block)NSBlocks.WILLOW.getHangingWallSign().get(), (Block)NSBlocks.ASPEN.getHangingSign().get(), (Block)NSBlocks.ASPEN.getHangingWallSign().get(), (Block)NSBlocks.MAPLE.getHangingSign().get(), (Block)NSBlocks.MAPLE.getHangingWallSign().get(), (Block)NSBlocks.CYPRESS.getHangingSign().get(), (Block)NSBlocks.CYPRESS.getHangingWallSign().get(), (Block)NSBlocks.OLIVE.getHangingSign().get(), (Block)NSBlocks.OLIVE.getHangingWallSign().get(), (Block)NSBlocks.JOSHUA.getHangingSign().get(), (Block)NSBlocks.JOSHUA.getHangingWallSign().get(), (Block)NSBlocks.GHAF.getHangingSign().get(), (Block)NSBlocks.GHAF.getHangingWallSign().get(), (Block)NSBlocks.PALO_VERDE.getHangingSign().get(), (Block)NSBlocks.PALO_VERDE.getHangingWallSign().get(), (Block)NSBlocks.COCONUT.getHangingSign().get(), (Block)NSBlocks.COCONUT.getHangingWallSign().get(), (Block)NSBlocks.CEDAR.getHangingSign().get(), (Block)NSBlocks.CEDAR.getHangingWallSign().get(), (Block)NSBlocks.LARCH.getHangingSign().get(), (Block)NSBlocks.LARCH.getHangingWallSign().get(), (Block)NSBlocks.MAHOGANY.getHangingSign().get(), (Block)NSBlocks.MAHOGANY.getHangingWallSign().get(), (Block)NSBlocks.SAXAUL.getHangingSign().get(), (Block)NSBlocks.SAXAUL.getHangingWallSign().get(), (Block)NSBlocks.PAPER_HANGING_SIGN.get(), (Block)NSBlocks.PAPER_WALL_HANGING_SIGN.get()});
    }

    public void creativeInventory(BuildCreativeModeTabContentsEvent event) {
        if (event.getTabKey() == CreativeModeTabs.BUILDING_BLOCKS) {
            ArrayList<ItemLike> wood = new ArrayList<ItemLike>();
            wood.add((ItemLike)Items.BAMBOO_BUTTON);
            for (WoodSet woodset : NSBlocks.getWoodSets()) {
                wood.add((ItemLike)woodset.getLog().get());
                if (woodset.getWoodPreset() == WoodSet.WoodPreset.JOSHUA) {
                    wood.addAll(List.of((Block)woodset.getBundle().get(), (Block)woodset.getStrippedLog().get(), (Block)woodset.getStrippedBundle().get(), (Block)woodset.getPlanks().get()));
                } else if (!woodset.hasBark()) {
                    wood.addAll(List.of((Block)woodset.getStrippedLog().get(), (Block)woodset.getPlanks().get()));
                } else {
                    wood.addAll(List.of((Block)woodset.getWood().get(), (Block)woodset.getStrippedLog().get(), (Block)woodset.getStrippedWood().get(), (Block)woodset.getPlanks().get()));
                }
                if (woodset.hasMosaic()) {
                    wood.addAll(List.of((Block)woodset.getMosaic().get(), (Block)woodset.getStairs().get(), (Block)woodset.getMosaicStairs().get(), (Block)woodset.getSlab().get(), (Block)woodset.getMosaicSlab().get(), (Block)woodset.getFence().get(), (Block)woodset.getFenceGate().get(), (Block)woodset.getDoor().get(), (Block)woodset.getTrapDoor().get(), (Block)woodset.getPressurePlate().get(), (Block)woodset.getButton().get()));
                    continue;
                }
                wood.addAll(List.of((Block)woodset.getStairs().get(), (Block)woodset.getSlab().get(), (Block)woodset.getFence().get(), (Block)woodset.getFenceGate().get(), (Block)woodset.getDoor().get(), (Block)woodset.getTrapDoor().get(), (Block)woodset.getPressurePlate().get(), (Block)woodset.getButton().get()));
            }
            NatureSpirit.addAllAfterFirst(event, wood, CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.insertAfter(Items.POLISHED_ANDESITE_SLAB.getDefaultInstance(), ((Block)NSBlocks.TRAVERTINE.getBase().get()).asItem().getDefaultInstance(), CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.insertAfter(((Block)NSBlocks.TRAVERTINE.getBase().get()).asItem().getDefaultInstance(), ((StairBlock)NSBlocks.TRAVERTINE.getBaseStairs().get()).asItem().getDefaultInstance(), CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.insertAfter(((StairBlock)NSBlocks.TRAVERTINE.getBaseStairs().get()).asItem().getDefaultInstance(), ((SlabBlock)NSBlocks.TRAVERTINE.getBaseSlab().get()).asItem().getDefaultInstance(), CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.insertAfter(((SlabBlock)NSBlocks.TRAVERTINE.getBaseSlab().get()).asItem().getDefaultInstance(), ((Block)NSBlocks.TRAVERTINE.getCobbled().get()).asItem().getDefaultInstance(), CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.insertAfter(((Block)NSBlocks.TRAVERTINE.getCobbled().get()).asItem().getDefaultInstance(), ((StairBlock)NSBlocks.TRAVERTINE.getCobbledStairs().get()).asItem().getDefaultInstance(), CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.insertAfter(((StairBlock)NSBlocks.TRAVERTINE.getCobbledStairs().get()).asItem().getDefaultInstance(), ((SlabBlock)NSBlocks.TRAVERTINE.getCobbledSlab().get()).asItem().getDefaultInstance(), CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.insertAfter(((SlabBlock)NSBlocks.TRAVERTINE.getCobbledSlab().get()).asItem().getDefaultInstance(), ((WallBlock)NSBlocks.TRAVERTINE.getCobbledWall().get()).asItem().getDefaultInstance(), CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.insertAfter(((WallBlock)NSBlocks.TRAVERTINE.getCobbledWall().get()).asItem().getDefaultInstance(), ((Block)NSBlocks.TRAVERTINE.getMossyCobbled().get()).asItem().getDefaultInstance(), CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.insertAfter(((Block)NSBlocks.TRAVERTINE.getMossyCobbled().get()).asItem().getDefaultInstance(), ((StairBlock)NSBlocks.TRAVERTINE.getMossyCobbledStairs().get()).asItem().getDefaultInstance(), CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.insertAfter(((StairBlock)NSBlocks.TRAVERTINE.getMossyCobbledStairs().get()).asItem().getDefaultInstance(), ((SlabBlock)NSBlocks.TRAVERTINE.getMossyCobbledSlab().get()).asItem().getDefaultInstance(), CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.insertAfter(((SlabBlock)NSBlocks.TRAVERTINE.getMossyCobbledSlab().get()).asItem().getDefaultInstance(), ((WallBlock)NSBlocks.TRAVERTINE.getMossyCobbledWall().get()).asItem().getDefaultInstance(), CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.insertAfter(((WallBlock)NSBlocks.TRAVERTINE.getMossyCobbledWall().get()).asItem().getDefaultInstance(), ((Block)NSBlocks.TRAVERTINE.getChiseled().get()).asItem().getDefaultInstance(), CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.insertAfter(((Block)NSBlocks.TRAVERTINE.getChiseled().get()).asItem().getDefaultInstance(), ((Block)NSBlocks.TRAVERTINE.getPolished().get()).asItem().getDefaultInstance(), CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.insertAfter(((Block)NSBlocks.TRAVERTINE.getPolished().get()).asItem().getDefaultInstance(), ((StairBlock)NSBlocks.TRAVERTINE.getPolishedStairs().get()).asItem().getDefaultInstance(), CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.insertAfter(((StairBlock)NSBlocks.TRAVERTINE.getPolishedStairs().get()).asItem().getDefaultInstance(), ((SlabBlock)NSBlocks.TRAVERTINE.getPolishedSlab().get()).asItem().getDefaultInstance(), CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.insertAfter(((SlabBlock)NSBlocks.TRAVERTINE.getPolishedSlab().get()).asItem().getDefaultInstance(), ((WallBlock)NSBlocks.TRAVERTINE.getPolishedWall().get()).asItem().getDefaultInstance(), CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.insertAfter(((WallBlock)NSBlocks.TRAVERTINE.getPolishedWall().get()).asItem().getDefaultInstance(), ((Block)NSBlocks.TRAVERTINE.getBricks().get()).asItem().getDefaultInstance(), CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.insertAfter(((Block)NSBlocks.TRAVERTINE.getBricks().get()).asItem().getDefaultInstance(), ((Block)NSBlocks.TRAVERTINE.getCrackedBricks().get()).asItem().getDefaultInstance(), CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.insertAfter(((Block)NSBlocks.TRAVERTINE.getCrackedBricks().get()).asItem().getDefaultInstance(), ((StairBlock)NSBlocks.TRAVERTINE.getBricksStairs().get()).asItem().getDefaultInstance(), CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.insertAfter(((StairBlock)NSBlocks.TRAVERTINE.getBricksStairs().get()).asItem().getDefaultInstance(), ((SlabBlock)NSBlocks.TRAVERTINE.getBricksSlab().get()).asItem().getDefaultInstance(), CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.insertAfter(((SlabBlock)NSBlocks.TRAVERTINE.getBricksSlab().get()).asItem().getDefaultInstance(), ((WallBlock)NSBlocks.TRAVERTINE.getBricksWall().get()).asItem().getDefaultInstance(), CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.insertAfter(((WallBlock)NSBlocks.TRAVERTINE.getBricksWall().get()).asItem().getDefaultInstance(), ((Block)NSBlocks.TRAVERTINE.getMossyBricks().get()).asItem().getDefaultInstance(), CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.insertAfter(((Block)NSBlocks.TRAVERTINE.getMossyBricks().get()).asItem().getDefaultInstance(), ((StairBlock)NSBlocks.TRAVERTINE.getMossyBricksStairs().get()).asItem().getDefaultInstance(), CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.insertAfter(((StairBlock)NSBlocks.TRAVERTINE.getMossyBricksStairs().get()).asItem().getDefaultInstance(), ((SlabBlock)NSBlocks.TRAVERTINE.getMossyBricksSlab().get()).asItem().getDefaultInstance(), CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.insertAfter(((SlabBlock)NSBlocks.TRAVERTINE.getMossyBricksSlab().get()).asItem().getDefaultInstance(), ((WallBlock)NSBlocks.TRAVERTINE.getMossyBricksWall().get()).asItem().getDefaultInstance(), CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.insertAfter(((WallBlock)NSBlocks.TRAVERTINE.getMossyBricksWall().get()).asItem().getDefaultInstance(), ((Block)NSBlocks.TRAVERTINE.getTiles().get()).asItem().getDefaultInstance(), CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.insertAfter(((Block)NSBlocks.TRAVERTINE.getTiles().get()).asItem().getDefaultInstance(), ((Block)NSBlocks.TRAVERTINE.getCrackedTiles().get()).asItem().getDefaultInstance(), CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.insertAfter(((Block)NSBlocks.TRAVERTINE.getCrackedTiles().get()).asItem().getDefaultInstance(), ((StairBlock)NSBlocks.TRAVERTINE.getTilesStairs().get()).asItem().getDefaultInstance(), CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.insertAfter(((StairBlock)NSBlocks.TRAVERTINE.getTilesStairs().get()).asItem().getDefaultInstance(), ((SlabBlock)NSBlocks.TRAVERTINE.getTilesSlab().get()).asItem().getDefaultInstance(), CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.insertAfter(((SlabBlock)NSBlocks.TRAVERTINE.getTilesSlab().get()).asItem().getDefaultInstance(), ((WallBlock)NSBlocks.TRAVERTINE.getTilesWall().get()).asItem().getDefaultInstance(), CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.insertAfter(((WallBlock)NSBlocks.TRAVERTINE.getTilesWall().get()).asItem().getDefaultInstance(), ((Block)NSBlocks.CHERT.getBase().get()).asItem().getDefaultInstance(), CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.insertAfter(((Block)NSBlocks.CHERT.getBase().get()).asItem().getDefaultInstance(), ((StairBlock)NSBlocks.CHERT.getBaseStairs().get()).asItem().getDefaultInstance(), CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.insertAfter(((StairBlock)NSBlocks.CHERT.getBaseStairs().get()).asItem().getDefaultInstance(), ((SlabBlock)NSBlocks.CHERT.getBaseSlab().get()).asItem().getDefaultInstance(), CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.insertAfter(((SlabBlock)NSBlocks.CHERT.getBaseSlab().get()).asItem().getDefaultInstance(), ((Block)NSBlocks.CHERT.getChiseled().get()).asItem().getDefaultInstance(), CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.insertAfter(((Block)NSBlocks.CHERT.getChiseled().get()).asItem().getDefaultInstance(), ((Block)NSBlocks.CHERT.getPolished().get()).asItem().getDefaultInstance(), CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.insertAfter(((Block)NSBlocks.CHERT.getPolished().get()).asItem().getDefaultInstance(), ((StairBlock)NSBlocks.CHERT.getPolishedStairs().get()).asItem().getDefaultInstance(), CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.insertAfter(((StairBlock)NSBlocks.CHERT.getPolishedStairs().get()).asItem().getDefaultInstance(), ((SlabBlock)NSBlocks.CHERT.getPolishedSlab().get()).asItem().getDefaultInstance(), CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.insertAfter(((SlabBlock)NSBlocks.CHERT.getPolishedSlab().get()).asItem().getDefaultInstance(), ((WallBlock)NSBlocks.CHERT.getPolishedWall().get()).asItem().getDefaultInstance(), CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.insertAfter(((WallBlock)NSBlocks.CHERT.getPolishedWall().get()).asItem().getDefaultInstance(), ((Block)NSBlocks.CHERT.getBricks().get()).asItem().getDefaultInstance(), CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.insertAfter(((Block)NSBlocks.CHERT.getBricks().get()).asItem().getDefaultInstance(), ((Block)NSBlocks.CHERT.getCrackedBricks().get()).asItem().getDefaultInstance(), CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.insertAfter(((Block)NSBlocks.CHERT.getCrackedBricks().get()).asItem().getDefaultInstance(), ((StairBlock)NSBlocks.CHERT.getBricksStairs().get()).asItem().getDefaultInstance(), CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.insertAfter(((StairBlock)NSBlocks.CHERT.getBricksStairs().get()).asItem().getDefaultInstance(), ((SlabBlock)NSBlocks.CHERT.getBricksSlab().get()).asItem().getDefaultInstance(), CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.insertAfter(((SlabBlock)NSBlocks.CHERT.getBricksSlab().get()).asItem().getDefaultInstance(), ((WallBlock)NSBlocks.CHERT.getBricksWall().get()).asItem().getDefaultInstance(), CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.insertAfter(((WallBlock)NSBlocks.CHERT.getBricksWall().get()).asItem().getDefaultInstance(), ((Block)NSBlocks.CHERT.getTiles().get()).asItem().getDefaultInstance(), CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.insertAfter(((Block)NSBlocks.CHERT.getTiles().get()).asItem().getDefaultInstance(), ((Block)NSBlocks.CHERT.getCrackedTiles().get()).asItem().getDefaultInstance(), CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.insertAfter(((Block)NSBlocks.CHERT.getCrackedTiles().get()).asItem().getDefaultInstance(), ((StairBlock)NSBlocks.CHERT.getTilesStairs().get()).asItem().getDefaultInstance(), CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.insertAfter(((StairBlock)NSBlocks.CHERT.getTilesStairs().get()).asItem().getDefaultInstance(), ((SlabBlock)NSBlocks.CHERT.getTilesSlab().get()).asItem().getDefaultInstance(), CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.insertAfter(((SlabBlock)NSBlocks.CHERT.getTilesSlab().get()).asItem().getDefaultInstance(), ((WallBlock)NSBlocks.CHERT.getTilesWall().get()).asItem().getDefaultInstance(), CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.insertAfter(Items.CUT_RED_SANDSTONE_SLAB.getDefaultInstance(), ((Block)NSBlocks.PINK_SANDSTONE.get()).asItem().getDefaultInstance(), CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.insertAfter(((Block)NSBlocks.PINK_SANDSTONE.get()).asItem().getDefaultInstance(), ((StairBlock)NSBlocks.PINK_SANDSTONE_STAIRS.get()).asItem().getDefaultInstance(), CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.insertAfter(((StairBlock)NSBlocks.PINK_SANDSTONE_STAIRS.get()).asItem().getDefaultInstance(), ((SlabBlock)NSBlocks.PINK_SANDSTONE_SLAB.get()).asItem().getDefaultInstance(), CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.insertAfter(((SlabBlock)NSBlocks.PINK_SANDSTONE_SLAB.get()).asItem().getDefaultInstance(), ((WallBlock)NSBlocks.PINK_SANDSTONE_WALL.get()).asItem().getDefaultInstance(), CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.insertAfter(((WallBlock)NSBlocks.PINK_SANDSTONE_WALL.get()).asItem().getDefaultInstance(), ((Block)NSBlocks.CHISELED_PINK_SANDSTONE.get()).asItem().getDefaultInstance(), CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.insertAfter(((Block)NSBlocks.CHISELED_PINK_SANDSTONE.get()).asItem().getDefaultInstance(), ((Block)NSBlocks.SMOOTH_PINK_SANDSTONE.get()).asItem().getDefaultInstance(), CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.insertAfter(((Block)NSBlocks.SMOOTH_PINK_SANDSTONE.get()).asItem().getDefaultInstance(), ((StairBlock)NSBlocks.SMOOTH_PINK_SANDSTONE_STAIRS.get()).asItem().getDefaultInstance(), CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.insertAfter(((StairBlock)NSBlocks.SMOOTH_PINK_SANDSTONE_STAIRS.get()).asItem().getDefaultInstance(), ((SlabBlock)NSBlocks.SMOOTH_PINK_SANDSTONE_SLAB.get()).asItem().getDefaultInstance(), CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.insertAfter(((SlabBlock)NSBlocks.SMOOTH_PINK_SANDSTONE_SLAB.get()).asItem().getDefaultInstance(), ((Block)NSBlocks.CUT_PINK_SANDSTONE.get()).asItem().getDefaultInstance(), CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.insertAfter(((Block)NSBlocks.CUT_PINK_SANDSTONE.get()).asItem().getDefaultInstance(), ((SlabBlock)NSBlocks.CUT_PINK_SANDSTONE_SLAB.get()).asItem().getDefaultInstance(), CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
        }
        if (event.getTabKey() == CreativeModeTabs.NATURAL_BLOCKS) {
            event.insertAfter(Items.CHERRY_LOG.getDefaultInstance(), ((Block)NSBlocks.REDWOOD.getLog().get()).asItem().getDefaultInstance(), CreativeModeTab.TabVisibility.PARENT_TAB_ONLY);
            event.insertAfter(((Block)NSBlocks.REDWOOD.getLog().get()).asItem().getDefaultInstance(), ((Block)NSBlocks.SUGI.getLog().get()).asItem().getDefaultInstance(), CreativeModeTab.TabVisibility.PARENT_TAB_ONLY);
            event.insertAfter(((Block)NSBlocks.SUGI.getLog().get()).asItem().getDefaultInstance(), ((Block)NSBlocks.WISTERIA.getLog().get()).asItem().getDefaultInstance(), CreativeModeTab.TabVisibility.PARENT_TAB_ONLY);
            event.insertAfter(((Block)NSBlocks.WISTERIA.getLog().get()).asItem().getDefaultInstance(), ((Block)NSBlocks.FIR.getLog().get()).asItem().getDefaultInstance(), CreativeModeTab.TabVisibility.PARENT_TAB_ONLY);
            event.insertAfter(((Block)NSBlocks.FIR.getLog().get()).asItem().getDefaultInstance(), ((Block)NSBlocks.WILLOW.getLog().get()).asItem().getDefaultInstance(), CreativeModeTab.TabVisibility.PARENT_TAB_ONLY);
            event.insertAfter(((Block)NSBlocks.WILLOW.getLog().get()).asItem().getDefaultInstance(), ((Block)NSBlocks.ASPEN.getLog().get()).asItem().getDefaultInstance(), CreativeModeTab.TabVisibility.PARENT_TAB_ONLY);
            event.insertAfter(((Block)NSBlocks.ASPEN.getLog().get()).asItem().getDefaultInstance(), ((Block)NSBlocks.MAPLE.getLog().get()).asItem().getDefaultInstance(), CreativeModeTab.TabVisibility.PARENT_TAB_ONLY);
            event.insertAfter(((Block)NSBlocks.MAPLE.getLog().get()).asItem().getDefaultInstance(), ((Block)NSBlocks.CYPRESS.getLog().get()).asItem().getDefaultInstance(), CreativeModeTab.TabVisibility.PARENT_TAB_ONLY);
            event.insertAfter(((Block)NSBlocks.CYPRESS.getLog().get()).asItem().getDefaultInstance(), ((Block)NSBlocks.OLIVE.getLog().get()).asItem().getDefaultInstance(), CreativeModeTab.TabVisibility.PARENT_TAB_ONLY);
            event.insertAfter(((Block)NSBlocks.OLIVE.getLog().get()).asItem().getDefaultInstance(), ((Block)NSBlocks.JOSHUA.getLog().get()).asItem().getDefaultInstance(), CreativeModeTab.TabVisibility.PARENT_TAB_ONLY);
            event.insertAfter(((Block)NSBlocks.JOSHUA.getLog().get()).asItem().getDefaultInstance(), ((Block)NSBlocks.GHAF.getLog().get()).asItem().getDefaultInstance(), CreativeModeTab.TabVisibility.PARENT_TAB_ONLY);
            event.insertAfter(((Block)NSBlocks.GHAF.getLog().get()).asItem().getDefaultInstance(), ((Block)NSBlocks.PALO_VERDE.getLog().get()).asItem().getDefaultInstance(), CreativeModeTab.TabVisibility.PARENT_TAB_ONLY);
            event.insertAfter(((Block)NSBlocks.PALO_VERDE.getLog().get()).asItem().getDefaultInstance(), ((Block)NSBlocks.COCONUT.getLog().get()).asItem().getDefaultInstance(), CreativeModeTab.TabVisibility.PARENT_TAB_ONLY);
            event.insertAfter(((Block)NSBlocks.COCONUT.getLog().get()).asItem().getDefaultInstance(), ((Block)NSBlocks.CEDAR.getLog().get()).asItem().getDefaultInstance(), CreativeModeTab.TabVisibility.PARENT_TAB_ONLY);
            event.insertAfter(((Block)NSBlocks.CEDAR.getLog().get()).asItem().getDefaultInstance(), ((Block)NSBlocks.LARCH.getLog().get()).asItem().getDefaultInstance(), CreativeModeTab.TabVisibility.PARENT_TAB_ONLY);
            event.insertAfter(((Block)NSBlocks.LARCH.getLog().get()).asItem().getDefaultInstance(), ((Block)NSBlocks.MAHOGANY.getLog().get()).asItem().getDefaultInstance(), CreativeModeTab.TabVisibility.PARENT_TAB_ONLY);
            event.insertAfter(((Block)NSBlocks.MAHOGANY.getLog().get()).asItem().getDefaultInstance(), ((Block)NSBlocks.SAXAUL.getLog().get()).asItem().getDefaultInstance(), CreativeModeTab.TabVisibility.PARENT_TAB_ONLY);
            event.insertAfter(Items.GOLD_ORE.getDefaultInstance(), ((DropExperienceBlock)NSBlocks.CHERT_GOLD_ORE.get()).asItem().getDefaultInstance(), CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.insertAfter(Items.IRON_ORE.getDefaultInstance(), ((DropExperienceBlock)NSBlocks.CHERT_IRON_ORE.get()).asItem().getDefaultInstance(), CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.insertAfter(Items.COAL_ORE.getDefaultInstance(), ((DropExperienceBlock)NSBlocks.CHERT_COAL_ORE.get()).asItem().getDefaultInstance(), CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.insertAfter(Items.LAPIS_ORE.getDefaultInstance(), ((DropExperienceBlock)NSBlocks.CHERT_LAPIS_ORE.get()).asItem().getDefaultInstance(), CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.insertAfter(Items.DIAMOND_ORE.getDefaultInstance(), ((DropExperienceBlock)NSBlocks.CHERT_DIAMOND_ORE.get()).asItem().getDefaultInstance(), CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.insertAfter(Items.REDSTONE_ORE.getDefaultInstance(), ((RedStoneOreBlock)NSBlocks.CHERT_REDSTONE_ORE.get()).asItem().getDefaultInstance(), CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.insertAfter(Items.EMERALD_ORE.getDefaultInstance(), ((DropExperienceBlock)NSBlocks.CHERT_EMERALD_ORE.get()).asItem().getDefaultInstance(), CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.insertAfter(Items.COPPER_ORE.getDefaultInstance(), ((DropExperienceBlock)NSBlocks.CHERT_COPPER_ORE.get()).asItem().getDefaultInstance(), CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.insertAfter(Items.ANDESITE.getDefaultInstance(), ((Block)NSBlocks.TRAVERTINE.getBase().get()).asItem().getDefaultInstance(), CreativeModeTab.TabVisibility.PARENT_TAB_ONLY);
            event.insertAfter(((Block)NSBlocks.TRAVERTINE.getBase().get()).asItem().getDefaultInstance(), ((Block)NSBlocks.CHERT.getBase().get()).asItem().getDefaultInstance(), CreativeModeTab.TabVisibility.PARENT_TAB_ONLY);
            event.insertAfter(Items.RED_SANDSTONE.getDefaultInstance(), ((ColoredFallingBlock)NSBlocks.PINK_SAND.get()).asItem().getDefaultInstance(), CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.insertAfter(((ColoredFallingBlock)NSBlocks.PINK_SAND.get()).asItem().getDefaultInstance(), ((Block)NSBlocks.PINK_SANDSTONE.get()).asItem().getDefaultInstance(), CreativeModeTab.TabVisibility.PARENT_TAB_ONLY);
            event.insertAfter(Items.BAMBOO.getDefaultInstance(), ((OliveBranchBlock)((Object)NSBlocks.OLIVE_BRANCH.get())).asItem().getDefaultInstance(), CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.insertAfter(Items.SWEET_BERRIES.getDefaultInstance(), ((CoconutBlock)((Object)NSBlocks.COCONUT_BLOCK.get())).asItem().getDefaultInstance(), CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.insertAfter(Items.RED_MUSHROOM.getDefaultInstance(), ((ShiitakeMushroomPlantBlock)((Object)NSBlocks.SHIITAKE_MUSHROOM.get())).asItem().getDefaultInstance(), CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.insertAfter(((ShiitakeMushroomPlantBlock)((Object)NSBlocks.SHIITAKE_MUSHROOM.get())).asItem().getDefaultInstance(), ((PolyporeBlock)((Object)NSBlocks.GRAY_POLYPORE.get())).asItem().getDefaultInstance(), CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.insertAfter(Items.RED_MUSHROOM_BLOCK.getDefaultInstance(), ((HugeMushroomBlock)NSBlocks.SHIITAKE_MUSHROOM_BLOCK.get()).asItem().getDefaultInstance(), CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.insertAfter(((HugeMushroomBlock)NSBlocks.SHIITAKE_MUSHROOM_BLOCK.get()).asItem().getDefaultInstance(), ((HugeMushroomBlock)NSBlocks.GRAY_POLYPORE_BLOCK.get()).asItem().getDefaultInstance(), CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.insertAfter(Items.SHROOMLIGHT.getDefaultInstance(), ((RotatedPillarBlock)NSBlocks.DESERT_TURNIP_ROOT_BLOCK.get()).asItem().getDefaultInstance(), CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.insertAfter(((RotatedPillarBlock)NSBlocks.DESERT_TURNIP_ROOT_BLOCK.get()).asItem().getDefaultInstance(), ((DesertTurnipBlock)((Object)NSBlocks.DESERT_TURNIP_BLOCK.get())).asItem().getDefaultInstance(), CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.insertAfter(Items.VINE.getDefaultInstance(), ((DownwardVineBlock)((Object)NSBlocks.WILLOW.getVines().get())).asItem().getDefaultInstance(), CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.insertAfter(((DownwardVineBlock)((Object)NSBlocks.WILLOW.getVines().get())).asItem().getDefaultInstance(), ((DownwardVineBlock)((Object)NSBlocks.WISTERIA.getWhiteVines().get())).asItem().getDefaultInstance(), CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.insertAfter(((DownwardVineBlock)((Object)NSBlocks.WISTERIA.getWhiteVines().get())).asItem().getDefaultInstance(), ((DownwardVineBlock)((Object)NSBlocks.WISTERIA.getBlueVines().get())).asItem().getDefaultInstance(), CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.insertAfter(((DownwardVineBlock)((Object)NSBlocks.WISTERIA.getBlueVines().get())).asItem().getDefaultInstance(), ((DownwardVineBlock)((Object)NSBlocks.WISTERIA.getPinkVines().get())).asItem().getDefaultInstance(), CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.insertAfter(((DownwardVineBlock)((Object)NSBlocks.WISTERIA.getPinkVines().get())).asItem().getDefaultInstance(), ((DownwardVineBlock)((Object)NSBlocks.WISTERIA.getPurpleVines().get())).asItem().getDefaultInstance(), CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.insertAfter(Items.CACTUS.getDefaultInstance(), ((GrowingBranchingTrunkBlock)((Object)NSBlocks.ALLUAUDIA.get())).asItem().getDefaultInstance(), CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.insertAfter(((GrowingBranchingTrunkBlock)((Object)NSBlocks.ALLUAUDIA.get())).asItem().getDefaultInstance(), ((Block)NSBlocks.ALLUAUDIA_BUNDLE.get()).asItem().getDefaultInstance(), CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.insertAfter(((Block)NSBlocks.ALLUAUDIA_BUNDLE.get()).asItem().getDefaultInstance(), ((GrowingBranchingTrunkBlock)((Object)NSBlocks.STRIPPED_ALLUAUDIA.get())).asItem().getDefaultInstance(), CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.insertAfter(((GrowingBranchingTrunkBlock)((Object)NSBlocks.STRIPPED_ALLUAUDIA.get())).asItem().getDefaultInstance(), ((RotatedPillarBlock)NSBlocks.STRIPPED_ALLUAUDIA_BUNDLE.get()).asItem().getDefaultInstance(), CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.insertAfter(Items.LILY_PAD.getDefaultInstance(), ((PlaceOnWaterBlockItem)NSBlocks.HELVOLA_PAD_ITEM.get()).asItem().getDefaultInstance(), CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.insertAfter(((PlaceOnWaterBlockItem)NSBlocks.HELVOLA_PAD_ITEM.get()).asItem().getDefaultInstance(), ((Item)NSBlocks.HELVOLA_FLOWER_ITEM.get()).getDefaultInstance(), CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.insertAfter(((Item)NSBlocks.HELVOLA_FLOWER_ITEM.get()).asItem().getDefaultInstance(), ((PlaceOnWaterBlockItem)NSBlocks.LOTUS_FLOWER_ITEM.get()).getDefaultInstance(), CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.insertAfter(((PlaceOnWaterBlockItem)NSBlocks.LOTUS_FLOWER_ITEM.get()).asItem().getDefaultInstance(), ((LotusStemBlock)((Object)NSBlocks.LOTUS_STEM.get())).asItem().getDefaultInstance(), CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.insertAfter(((LotusStemBlock)((Object)NSBlocks.LOTUS_STEM.get())).asItem().getDefaultInstance(), ((AzollaItem)((Object)NSBlocks.AZOLLA_ITEM.get())).getDefaultInstance(), CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.insertAfter(Items.FARMLAND.getDefaultInstance(), ((Block)NSBlocks.SANDY_SOIL.get()).asItem().getDefaultInstance(), CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.insertAfter(Items.MOSS_BLOCK.getDefaultInstance(), ((RedMossBlock)((Object)NSBlocks.RED_MOSS_BLOCK.get())).asItem().getDefaultInstance(), CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.insertAfter(Items.MOSS_CARPET.getDefaultInstance(), ((CarpetBlock)NSBlocks.RED_MOSS_CARPET.get()).asItem().getDefaultInstance(), CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.insertAfter(Items.PITCHER_PLANT.getDefaultInstance(), ((StandingAndWallBlockItem)NSBlocks.ORNATE_SUCCULENT_ITEM.get()).getDefaultInstance(), CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.insertAfter(((StandingAndWallBlockItem)NSBlocks.ORNATE_SUCCULENT_ITEM.get()).getDefaultInstance(), ((StandingAndWallBlockItem)NSBlocks.DROWSY_SUCCULENT_ITEM.get()).getDefaultInstance(), CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.insertAfter(((StandingAndWallBlockItem)NSBlocks.DROWSY_SUCCULENT_ITEM.get()).getDefaultInstance(), ((StandingAndWallBlockItem)NSBlocks.AUREATE_SUCCULENT_ITEM.get()).getDefaultInstance(), CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.insertAfter(((StandingAndWallBlockItem)NSBlocks.AUREATE_SUCCULENT_ITEM.get()).getDefaultInstance(), ((StandingAndWallBlockItem)NSBlocks.SAGE_SUCCULENT_ITEM.get()).getDefaultInstance(), CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.insertAfter(((StandingAndWallBlockItem)NSBlocks.SAGE_SUCCULENT_ITEM.get()).getDefaultInstance(), ((StandingAndWallBlockItem)NSBlocks.FOAMY_SUCCULENT_ITEM.get()).getDefaultInstance(), CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.insertAfter(((StandingAndWallBlockItem)NSBlocks.FOAMY_SUCCULENT_ITEM.get()).getDefaultInstance(), ((StandingAndWallBlockItem)NSBlocks.IMPERIAL_SUCCULENT_ITEM.get()).getDefaultInstance(), CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.insertAfter(((StandingAndWallBlockItem)NSBlocks.IMPERIAL_SUCCULENT_ITEM.get()).getDefaultInstance(), ((StandingAndWallBlockItem)NSBlocks.REGAL_SUCCULENT_ITEM.get()).getDefaultInstance(), CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.insertAfter(Items.PEONY.getDefaultInstance(), ((Block)NSBlocks.LAVENDER.getFlowerBlock().get()).asItem().getDefaultInstance(), CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.insertAfter(((Block)NSBlocks.LAVENDER.getFlowerBlock().get()).asItem().getDefaultInstance(), ((Block)NSBlocks.BLEEDING_HEART.getFlowerBlock().get()).asItem().getDefaultInstance(), CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.insertAfter(((Block)NSBlocks.BLEEDING_HEART.getFlowerBlock().get()).asItem().getDefaultInstance(), ((Block)NSBlocks.BLUE_BULBS.getFlowerBlock().get()).asItem().getDefaultInstance(), CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.insertAfter(((Block)NSBlocks.BLUE_BULBS.getFlowerBlock().get()).asItem().getDefaultInstance(), ((Block)NSBlocks.CARNATION.getFlowerBlock().get()).asItem().getDefaultInstance(), CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.insertAfter(((Block)NSBlocks.CARNATION.getFlowerBlock().get()).asItem().getDefaultInstance(), ((Block)NSBlocks.GARDENIA.getFlowerBlock().get()).asItem().getDefaultInstance(), CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.insertAfter(((Block)NSBlocks.GARDENIA.getFlowerBlock().get()).asItem().getDefaultInstance(), ((Block)NSBlocks.SNAPDRAGON.getFlowerBlock().get()).asItem().getDefaultInstance(), CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.insertAfter(((Block)NSBlocks.SNAPDRAGON.getFlowerBlock().get()).asItem().getDefaultInstance(), ((Block)NSBlocks.FOXGLOVE.getFlowerBlock().get()).asItem().getDefaultInstance(), CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.insertAfter(((Block)NSBlocks.FOXGLOVE.getFlowerBlock().get()).asItem().getDefaultInstance(), ((Block)NSBlocks.BEGONIA.getFlowerBlock().get()).asItem().getDefaultInstance(), CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.insertAfter(Items.LILY_OF_THE_VALLEY.getDefaultInstance(), ((Block)NSBlocks.MARIGOLD.getFlowerBlock().get()).asItem().getDefaultInstance(), CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.insertAfter(((Block)NSBlocks.MARIGOLD.getFlowerBlock().get()).asItem().getDefaultInstance(), ((Block)NSBlocks.BLUEBELL.getFlowerBlock().get()).asItem().getDefaultInstance(), CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.insertAfter(((Block)NSBlocks.BLUEBELL.getFlowerBlock().get()).asItem().getDefaultInstance(), ((Block)NSBlocks.TIGER_LILY.getFlowerBlock().get()).asItem().getDefaultInstance(), CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.insertAfter(((Block)NSBlocks.TIGER_LILY.getFlowerBlock().get()).asItem().getDefaultInstance(), ((Block)NSBlocks.PURPLE_WILDFLOWER.getFlowerBlock().get()).asItem().getDefaultInstance(), CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.insertAfter(((Block)NSBlocks.PURPLE_WILDFLOWER.getFlowerBlock().get()).asItem().getDefaultInstance(), ((Block)NSBlocks.YELLOW_WILDFLOWER.getFlowerBlock().get()).asItem().getDefaultInstance(), CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.insertAfter(((Block)NSBlocks.YELLOW_WILDFLOWER.getFlowerBlock().get()).asItem().getDefaultInstance(), ((Block)NSBlocks.RED_HEATHER.getFlowerBlock().get()).asItem().getDefaultInstance(), CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.insertAfter(((Block)NSBlocks.RED_HEATHER.getFlowerBlock().get()).asItem().getDefaultInstance(), ((Block)NSBlocks.WHITE_HEATHER.getFlowerBlock().get()).asItem().getDefaultInstance(), CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.insertAfter(((Block)NSBlocks.WHITE_HEATHER.getFlowerBlock().get()).asItem().getDefaultInstance(), ((Block)NSBlocks.PURPLE_HEATHER.getFlowerBlock().get()).asItem().getDefaultInstance(), CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.insertAfter(((Block)NSBlocks.PURPLE_HEATHER.getFlowerBlock().get()).asItem().getDefaultInstance(), ((Block)NSBlocks.ANEMONE.getFlowerBlock().get()).asItem().getDefaultInstance(), CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.insertAfter(((Block)NSBlocks.ANEMONE.getFlowerBlock().get()).asItem().getDefaultInstance(), ((Block)NSBlocks.DWARF_BLOSSOMS.getFlowerBlock().get()).asItem().getDefaultInstance(), CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.insertAfter(((Block)NSBlocks.DWARF_BLOSSOMS.getFlowerBlock().get()).asItem().getDefaultInstance(), ((Block)NSBlocks.PROTEA.getFlowerBlock().get()).asItem().getDefaultInstance(), CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.insertAfter(((Block)NSBlocks.PROTEA.getFlowerBlock().get()).asItem().getDefaultInstance(), ((Block)NSBlocks.HIBISCUS.getFlowerBlock().get()).asItem().getDefaultInstance(), CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.insertAfter(((Block)NSBlocks.HIBISCUS.getFlowerBlock().get()).asItem().getDefaultInstance(), ((Block)NSBlocks.BLUE_IRIS.getFlowerBlock().get()).asItem().getDefaultInstance(), CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.insertAfter(((Block)NSBlocks.BLUE_IRIS.getFlowerBlock().get()).asItem().getDefaultInstance(), ((Block)NSBlocks.BLACK_IRIS.getFlowerBlock().get()).asItem().getDefaultInstance(), CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.insertAfter(((Block)NSBlocks.BLACK_IRIS.getFlowerBlock().get()).asItem().getDefaultInstance(), ((Block)NSBlocks.RUBY_BLOSSOMS.getFlowerBlock().get()).asItem().getDefaultInstance(), CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.insertAfter(((Block)NSBlocks.RUBY_BLOSSOMS.getFlowerBlock().get()).asItem().getDefaultInstance(), ((Block)NSBlocks.SILVERBUSH.getFlowerBlock().get()).asItem().getDefaultInstance(), CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.insertAfter(Items.LARGE_FERN.getDefaultInstance(), ((CattailBlock)((Object)NSBlocks.CATTAIL.get())).asItem().getDefaultInstance(), CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.insertAfter(((CattailBlock)((Object)NSBlocks.CATTAIL.get())).asItem().getDefaultInstance(), ((SemiTallGrassBlock)((Object)NSBlocks.TALL_FRIGID_GRASS.get())).asItem().getDefaultInstance(), CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.insertAfter(((SemiTallGrassBlock)((Object)NSBlocks.TALL_FRIGID_GRASS.get())).asItem().getDefaultInstance(), ((TallLargeDesertFernBlock)((Object)NSBlocks.TALL_SCORCHED_GRASS.get())).asItem().getDefaultInstance(), CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.insertAfter(((TallLargeDesertFernBlock)((Object)NSBlocks.TALL_SCORCHED_GRASS.get())).asItem().getDefaultInstance(), ((TallLargeDesertFernBlock)((Object)NSBlocks.TALL_BEACH_GRASS.get())).asItem().getDefaultInstance(), CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.insertAfter(((TallLargeDesertFernBlock)((Object)NSBlocks.TALL_BEACH_GRASS.get())).asItem().getDefaultInstance(), ((TallSedgeGrassBlock)((Object)NSBlocks.TALL_SEDGE_GRASS.get())).asItem().getDefaultInstance(), CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.insertAfter(((TallSedgeGrassBlock)((Object)NSBlocks.TALL_SEDGE_GRASS.get())).asItem().getDefaultInstance(), ((DoublePlantBlock)NSBlocks.LARGE_FLAXEN_FERN.get()).asItem().getDefaultInstance(), CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.insertAfter(((DoublePlantBlock)NSBlocks.LARGE_FLAXEN_FERN.get()).asItem().getDefaultInstance(), ((SemiTallGrassBlock)((Object)NSBlocks.TALL_OAT_GRASS.get())).asItem().getDefaultInstance(), CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.insertAfter(((SemiTallGrassBlock)((Object)NSBlocks.TALL_OAT_GRASS.get())).asItem().getDefaultInstance(), ((DoublePlantBlock)NSBlocks.LARGE_LUSH_FERN.get()).asItem().getDefaultInstance(), CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.insertAfter(((DoublePlantBlock)NSBlocks.LARGE_LUSH_FERN.get()).asItem().getDefaultInstance(), ((DoublePlantBlock)NSBlocks.TALL_MELIC_GRASS.get()).asItem().getDefaultInstance(), CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.insertAfter(((DoublePlantBlock)NSBlocks.TALL_MELIC_GRASS.get()).asItem().getDefaultInstance(), ((BearberryBlock)((Object)NSBlocks.GREEN_BEARBERRIES.get())).asItem().getDefaultInstance(), CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.insertAfter(((BearberryBlock)((Object)NSBlocks.GREEN_BEARBERRIES.get())).asItem().getDefaultInstance(), ((BearberryBlock)((Object)NSBlocks.RED_BEARBERRIES.get())).asItem().getDefaultInstance(), CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.insertAfter(((BearberryBlock)((Object)NSBlocks.RED_BEARBERRIES.get())).asItem().getDefaultInstance(), ((BearberryBlock)((Object)NSBlocks.PURPLE_BEARBERRIES.get())).asItem().getDefaultInstance(), CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.insertAfter(((BearberryBlock)((Object)NSBlocks.PURPLE_BEARBERRIES.get())).asItem().getDefaultInstance(), ((LargeSproutsBlock)((Object)NSBlocks.GREEN_BITTER_SPROUTS.get())).asItem().getDefaultInstance(), CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.insertAfter(((LargeSproutsBlock)((Object)NSBlocks.GREEN_BITTER_SPROUTS.get())).asItem().getDefaultInstance(), ((LargeSproutsBlock)((Object)NSBlocks.RED_BITTER_SPROUTS.get())).asItem().getDefaultInstance(), CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.insertAfter(((LargeSproutsBlock)((Object)NSBlocks.RED_BITTER_SPROUTS.get())).asItem().getDefaultInstance(), ((LargeSproutsBlock)((Object)NSBlocks.PURPLE_BITTER_SPROUTS.get())).asItem().getDefaultInstance(), CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.insertAfter(Items.FERN.getDefaultInstance(), ((LargeDesertFernBlock)((Object)NSBlocks.BEACH_GRASS.get())).asItem().getDefaultInstance(), CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.insertAfter(((LargeDesertFernBlock)((Object)NSBlocks.BEACH_GRASS.get())).asItem().getDefaultInstance(), ((LargeDesertFernBlock)((Object)NSBlocks.SCORCHED_GRASS.get())).asItem().getDefaultInstance(), CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.insertAfter(((LargeDesertFernBlock)((Object)NSBlocks.SCORCHED_GRASS.get())).asItem().getDefaultInstance(), ((SedgeGrassBlock)((Object)NSBlocks.SEDGE_GRASS.get())).asItem().getDefaultInstance(), CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.insertAfter(((SedgeGrassBlock)((Object)NSBlocks.SEDGE_GRASS.get())).asItem().getDefaultInstance(), ((NSFernBlock)((Object)NSBlocks.FLAXEN_FERN.get())).asItem().getDefaultInstance(), CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.insertAfter(((NSFernBlock)((Object)NSBlocks.FLAXEN_FERN.get())).asItem().getDefaultInstance(), ((NSFernBlock)((Object)NSBlocks.OAT_GRASS.get())).asItem().getDefaultInstance(), CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.insertAfter(((NSFernBlock)((Object)NSBlocks.OAT_GRASS.get())).asItem().getDefaultInstance(), ((NSFernBlock)((Object)NSBlocks.LUSH_FERN.get())).asItem().getDefaultInstance(), CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.insertAfter(((NSFernBlock)((Object)NSBlocks.LUSH_FERN.get())).asItem().getDefaultInstance(), ((NSFernBlock)((Object)NSBlocks.MELIC_GRASS.get())).asItem().getDefaultInstance(), CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.insertAfter(((NSFernBlock)((Object)NSBlocks.MELIC_GRASS.get())).asItem().getDefaultInstance(), ((NSFernBlock)((Object)NSBlocks.FRIGID_GRASS.get())).asItem().getDefaultInstance(), CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.insertAfter(Items.CHERRY_LEAVES.getDefaultInstance(), ((LeavesBlock)NSBlocks.REDWOOD.getLeaves().get()).asItem().getDefaultInstance(), CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.insertAfter(((LeavesBlock)NSBlocks.REDWOOD.getLeaves().get()).asItem().getDefaultInstance(), ((LeavesBlock)NSBlocks.REDWOOD.getFrostyLeaves().get()).asItem().getDefaultInstance(), CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.insertAfter(((LeavesBlock)NSBlocks.REDWOOD.getFrostyLeaves().get()).asItem().getDefaultInstance(), ((LeavesBlock)NSBlocks.SUGI.getLeaves().get()).asItem().getDefaultInstance(), CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.insertAfter(((LeavesBlock)NSBlocks.SUGI.getLeaves().get()).asItem().getDefaultInstance(), ((LeavesBlock)NSBlocks.WISTERIA.getPurpleLeaves().get()).asItem().getDefaultInstance(), CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.insertAfter(((LeavesBlock)NSBlocks.WISTERIA.getPurpleLeaves().get()).asItem().getDefaultInstance(), ((LeavesBlock)NSBlocks.WISTERIA.getWhiteLeaves().get()).asItem().getDefaultInstance(), CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.insertAfter(((LeavesBlock)NSBlocks.WISTERIA.getWhiteLeaves().get()).asItem().getDefaultInstance(), ((LeavesBlock)NSBlocks.WISTERIA.getBlueLeaves().get()).asItem().getDefaultInstance(), CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.insertAfter(((LeavesBlock)NSBlocks.WISTERIA.getBlueLeaves().get()).asItem().getDefaultInstance(), ((LeavesBlock)NSBlocks.WISTERIA.getPinkLeaves().get()).asItem().getDefaultInstance(), CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.insertAfter(((LeavesBlock)NSBlocks.WISTERIA.getPinkLeaves().get()).asItem().getDefaultInstance(), ((LeavesBlock)NSBlocks.WISTERIA.getPartPurpleLeaves().get()).asItem().getDefaultInstance(), CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.insertAfter(((LeavesBlock)NSBlocks.WISTERIA.getPartPurpleLeaves().get()).asItem().getDefaultInstance(), ((LeavesBlock)NSBlocks.WISTERIA.getPartWhiteLeaves().get()).asItem().getDefaultInstance(), CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.insertAfter(((LeavesBlock)NSBlocks.WISTERIA.getPartWhiteLeaves().get()).asItem().getDefaultInstance(), ((LeavesBlock)NSBlocks.WISTERIA.getPartBlueLeaves().get()).asItem().getDefaultInstance(), CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.insertAfter(((LeavesBlock)NSBlocks.WISTERIA.getPartBlueLeaves().get()).asItem().getDefaultInstance(), ((LeavesBlock)NSBlocks.WISTERIA.getPartPinkLeaves().get()).asItem().getDefaultInstance(), CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.insertAfter(((LeavesBlock)NSBlocks.WISTERIA.getPartPinkLeaves().get()).asItem().getDefaultInstance(), ((LeavesBlock)NSBlocks.FIR.getLeaves().get()).asItem().getDefaultInstance(), CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.insertAfter(((LeavesBlock)NSBlocks.FIR.getLeaves().get()).asItem().getDefaultInstance(), ((LeavesBlock)NSBlocks.FIR.getFrostyLeaves().get()).asItem().getDefaultInstance(), CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.insertAfter(((LeavesBlock)NSBlocks.FIR.getFrostyLeaves().get()).asItem().getDefaultInstance(), ((LeavesBlock)NSBlocks.WILLOW.getLeaves().get()).asItem().getDefaultInstance(), CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.insertAfter(((LeavesBlock)NSBlocks.WILLOW.getLeaves().get()).asItem().getDefaultInstance(), ((LeavesBlock)NSBlocks.ASPEN.getLeaves().get()).asItem().getDefaultInstance(), CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.insertAfter(((LeavesBlock)NSBlocks.ASPEN.getLeaves().get()).asItem().getDefaultInstance(), ((LeavesBlock)NSBlocks.ASPEN.getYellowLeaves().get()).asItem().getDefaultInstance(), CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.insertAfter(((LeavesBlock)NSBlocks.ASPEN.getYellowLeaves().get()).asItem().getDefaultInstance(), ((LeavesBlock)NSBlocks.MAPLE.getRedLeaves().get()).asItem().getDefaultInstance(), CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.insertAfter(((LeavesBlock)NSBlocks.MAPLE.getRedLeaves().get()).asItem().getDefaultInstance(), ((LeavesBlock)NSBlocks.MAPLE.getOrangeLeaves().get()).asItem().getDefaultInstance(), CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.insertAfter(((LeavesBlock)NSBlocks.MAPLE.getOrangeLeaves().get()).asItem().getDefaultInstance(), ((LeavesBlock)NSBlocks.MAPLE.getYellowLeaves().get()).asItem().getDefaultInstance(), CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.insertAfter(((LeavesBlock)NSBlocks.MAPLE.getYellowLeaves().get()).asItem().getDefaultInstance(), ((LeavesBlock)NSBlocks.CYPRESS.getLeaves().get()).asItem().getDefaultInstance(), CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.insertAfter(((LeavesBlock)NSBlocks.CYPRESS.getLeaves().get()).asItem().getDefaultInstance(), ((LeavesBlock)NSBlocks.OLIVE.getLeaves().get()).asItem().getDefaultInstance(), CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.insertAfter(((LeavesBlock)NSBlocks.OLIVE.getLeaves().get()).asItem().getDefaultInstance(), ((LeavesBlock)NSBlocks.JOSHUA.getLeaves().get()).asItem().getDefaultInstance(), CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.insertAfter(((LeavesBlock)NSBlocks.JOSHUA.getLeaves().get()).asItem().getDefaultInstance(), ((LeavesBlock)NSBlocks.GHAF.getLeaves().get()).asItem().getDefaultInstance(), CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.insertAfter(((LeavesBlock)NSBlocks.GHAF.getLeaves().get()).asItem().getDefaultInstance(), ((LeavesBlock)NSBlocks.PALO_VERDE.getLeaves().get()).asItem().getDefaultInstance(), CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.insertAfter(((LeavesBlock)NSBlocks.PALO_VERDE.getLeaves().get()).asItem().getDefaultInstance(), ((LeavesBlock)NSBlocks.CEDAR.getLeaves().get()).asItem().getDefaultInstance(), CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.insertAfter(((LeavesBlock)NSBlocks.CEDAR.getLeaves().get()).asItem().getDefaultInstance(), ((LeavesBlock)NSBlocks.COCONUT.getLeaves().get()).asItem().getDefaultInstance(), CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.insertAfter(((LeavesBlock)NSBlocks.COCONUT.getLeaves().get()).asItem().getDefaultInstance(), ((LeavesBlock)NSBlocks.LARCH.getLeaves().get()).asItem().getDefaultInstance(), CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.insertAfter(((LeavesBlock)NSBlocks.LARCH.getLeaves().get()).asItem().getDefaultInstance(), ((LeavesBlock)NSBlocks.MAHOGANY.getLeaves().get()).asItem().getDefaultInstance(), CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.insertAfter(((LeavesBlock)NSBlocks.MAHOGANY.getLeaves().get()).asItem().getDefaultInstance(), ((LeavesBlock)NSBlocks.SAXAUL.getLeaves().get()).asItem().getDefaultInstance(), CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.insertAfter(Items.CHERRY_SAPLING.getDefaultInstance(), ((SaplingBlock)NSBlocks.REDWOOD.getSapling().get()).asItem().getDefaultInstance(), CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.insertAfter(((SaplingBlock)NSBlocks.REDWOOD.getSapling().get()).asItem().getDefaultInstance(), ((SaplingBlock)NSBlocks.SUGI.getSapling().get()).asItem().getDefaultInstance(), CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.insertAfter(((SaplingBlock)NSBlocks.SUGI.getSapling().get()).asItem().getDefaultInstance(), ((SaplingBlock)NSBlocks.WISTERIA.getPurpleSapling().get()).asItem().getDefaultInstance(), CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.insertAfter(((SaplingBlock)NSBlocks.WISTERIA.getPurpleSapling().get()).asItem().getDefaultInstance(), ((SaplingBlock)NSBlocks.WISTERIA.getWhiteSapling().get()).asItem().getDefaultInstance(), CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.insertAfter(((SaplingBlock)NSBlocks.WISTERIA.getWhiteSapling().get()).asItem().getDefaultInstance(), ((SaplingBlock)NSBlocks.WISTERIA.getBlueSapling().get()).asItem().getDefaultInstance(), CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.insertAfter(((SaplingBlock)NSBlocks.WISTERIA.getBlueSapling().get()).asItem().getDefaultInstance(), ((SaplingBlock)NSBlocks.WISTERIA.getPinkSapling().get()).asItem().getDefaultInstance(), CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.insertAfter(((SaplingBlock)NSBlocks.WISTERIA.getPinkSapling().get()).asItem().getDefaultInstance(), ((SaplingBlock)NSBlocks.FIR.getSapling().get()).asItem().getDefaultInstance(), CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.insertAfter(((SaplingBlock)NSBlocks.FIR.getSapling().get()).asItem().getDefaultInstance(), ((SaplingBlock)NSBlocks.WILLOW.getSapling().get()).asItem().getDefaultInstance(), CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.insertAfter(((SaplingBlock)NSBlocks.WILLOW.getSapling().get()).asItem().getDefaultInstance(), ((SaplingBlock)NSBlocks.ASPEN.getSapling().get()).asItem().getDefaultInstance(), CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.insertAfter(((SaplingBlock)NSBlocks.ASPEN.getSapling().get()).asItem().getDefaultInstance(), ((SaplingBlock)NSBlocks.MAPLE.getRedSapling().get()).asItem().getDefaultInstance(), CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.insertAfter(((SaplingBlock)NSBlocks.MAPLE.getRedSapling().get()).asItem().getDefaultInstance(), ((SaplingBlock)NSBlocks.MAPLE.getOrangeSapling().get()).asItem().getDefaultInstance(), CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.insertAfter(((SaplingBlock)NSBlocks.MAPLE.getOrangeSapling().get()).asItem().getDefaultInstance(), ((SaplingBlock)NSBlocks.MAPLE.getYellowSapling().get()).asItem().getDefaultInstance(), CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.insertAfter(((SaplingBlock)NSBlocks.MAPLE.getYellowSapling().get()).asItem().getDefaultInstance(), ((SaplingBlock)NSBlocks.CYPRESS.getSapling().get()).asItem().getDefaultInstance(), CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.insertAfter(((SaplingBlock)NSBlocks.CYPRESS.getSapling().get()).asItem().getDefaultInstance(), ((SaplingBlock)NSBlocks.OLIVE.getSapling().get()).asItem().getDefaultInstance(), CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.insertAfter(((SaplingBlock)NSBlocks.OLIVE.getSapling().get()).asItem().getDefaultInstance(), ((SaplingBlock)NSBlocks.JOSHUA.getSapling().get()).asItem().getDefaultInstance(), CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.insertAfter(((SaplingBlock)NSBlocks.JOSHUA.getSapling().get()).asItem().getDefaultInstance(), ((SaplingBlock)NSBlocks.GHAF.getSapling().get()).asItem().getDefaultInstance(), CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.insertAfter(((SaplingBlock)NSBlocks.GHAF.getSapling().get()).asItem().getDefaultInstance(), ((SaplingBlock)NSBlocks.PALO_VERDE.getSapling().get()).asItem().getDefaultInstance(), CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.insertAfter(((SaplingBlock)NSBlocks.PALO_VERDE.getSapling().get()).asItem().getDefaultInstance(), ((SaplingBlock)NSBlocks.CEDAR.getSapling().get()).asItem().getDefaultInstance(), CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.insertAfter(((SaplingBlock)NSBlocks.CEDAR.getSapling().get()).asItem().getDefaultInstance(), ((SaplingBlock)NSBlocks.LARCH.getSapling().get()).asItem().getDefaultInstance(), CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.insertAfter(((SaplingBlock)NSBlocks.LARCH.getSapling().get()).asItem().getDefaultInstance(), ((SaplingBlock)NSBlocks.MAHOGANY.getSapling().get()).asItem().getDefaultInstance(), CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.insertAfter(((SaplingBlock)NSBlocks.MAHOGANY.getSapling().get()).asItem().getDefaultInstance(), ((SaplingBlock)NSBlocks.SAXAUL.getSapling().get()).asItem().getDefaultInstance(), CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
        }
        if (event.getTabKey() == CreativeModeTabs.FUNCTIONAL_BLOCKS) {
            event.insertAfter(Items.BAMBOO_HANGING_SIGN.getDefaultInstance(), ((SignItem)NSBlocks.REDWOOD.getSignItem().get()).getDefaultInstance(), CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.insertAfter(((SignItem)NSBlocks.REDWOOD.getSignItem().get()).getDefaultInstance(), ((HangingSignItem)NSBlocks.REDWOOD.getHangingSignItem().get()).getDefaultInstance(), CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.insertAfter(((HangingSignItem)NSBlocks.REDWOOD.getHangingSignItem().get()).getDefaultInstance(), ((SignItem)NSBlocks.SUGI.getSignItem().get()).getDefaultInstance(), CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.insertAfter(((SignItem)NSBlocks.SUGI.getSignItem().get()).getDefaultInstance(), ((HangingSignItem)NSBlocks.SUGI.getHangingSignItem().get()).getDefaultInstance(), CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.insertAfter(((HangingSignItem)NSBlocks.SUGI.getHangingSignItem().get()).getDefaultInstance(), ((SignItem)NSBlocks.WISTERIA.getSignItem().get()).getDefaultInstance(), CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.insertAfter(((SignItem)NSBlocks.WISTERIA.getSignItem().get()).getDefaultInstance(), ((HangingSignItem)NSBlocks.WISTERIA.getHangingSignItem().get()).getDefaultInstance(), CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.insertAfter(((HangingSignItem)NSBlocks.WISTERIA.getHangingSignItem().get()).getDefaultInstance(), ((SignItem)NSBlocks.FIR.getSignItem().get()).getDefaultInstance(), CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.insertAfter(((SignItem)NSBlocks.FIR.getSignItem().get()).getDefaultInstance(), ((HangingSignItem)NSBlocks.FIR.getHangingSignItem().get()).getDefaultInstance(), CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.insertAfter(((HangingSignItem)NSBlocks.FIR.getHangingSignItem().get()).getDefaultInstance(), ((SignItem)NSBlocks.WILLOW.getSignItem().get()).getDefaultInstance(), CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.insertAfter(((SignItem)NSBlocks.WILLOW.getSignItem().get()).getDefaultInstance(), ((HangingSignItem)NSBlocks.WILLOW.getHangingSignItem().get()).getDefaultInstance(), CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.insertAfter(((HangingSignItem)NSBlocks.WILLOW.getHangingSignItem().get()).getDefaultInstance(), ((SignItem)NSBlocks.ASPEN.getSignItem().get()).getDefaultInstance(), CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.insertAfter(((SignItem)NSBlocks.ASPEN.getSignItem().get()).getDefaultInstance(), ((HangingSignItem)NSBlocks.ASPEN.getHangingSignItem().get()).getDefaultInstance(), CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.insertAfter(((HangingSignItem)NSBlocks.ASPEN.getHangingSignItem().get()).getDefaultInstance(), ((SignItem)NSBlocks.MAPLE.getSignItem().get()).getDefaultInstance(), CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.insertAfter(((SignItem)NSBlocks.MAPLE.getSignItem().get()).getDefaultInstance(), ((HangingSignItem)NSBlocks.MAPLE.getHangingSignItem().get()).getDefaultInstance(), CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.insertAfter(((HangingSignItem)NSBlocks.MAPLE.getHangingSignItem().get()).getDefaultInstance(), ((SignItem)NSBlocks.CYPRESS.getSignItem().get()).getDefaultInstance(), CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.insertAfter(((SignItem)NSBlocks.CYPRESS.getSignItem().get()).getDefaultInstance(), ((HangingSignItem)NSBlocks.CYPRESS.getHangingSignItem().get()).getDefaultInstance(), CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.insertAfter(((HangingSignItem)NSBlocks.CYPRESS.getHangingSignItem().get()).getDefaultInstance(), ((SignItem)NSBlocks.OLIVE.getSignItem().get()).getDefaultInstance(), CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.insertAfter(((SignItem)NSBlocks.OLIVE.getSignItem().get()).getDefaultInstance(), ((HangingSignItem)NSBlocks.OLIVE.getHangingSignItem().get()).getDefaultInstance(), CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.insertAfter(((HangingSignItem)NSBlocks.OLIVE.getHangingSignItem().get()).getDefaultInstance(), ((SignItem)NSBlocks.JOSHUA.getSignItem().get()).getDefaultInstance(), CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.insertAfter(((SignItem)NSBlocks.JOSHUA.getSignItem().get()).getDefaultInstance(), ((HangingSignItem)NSBlocks.JOSHUA.getHangingSignItem().get()).getDefaultInstance(), CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.insertAfter(((HangingSignItem)NSBlocks.JOSHUA.getHangingSignItem().get()).getDefaultInstance(), ((SignItem)NSBlocks.GHAF.getSignItem().get()).getDefaultInstance(), CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.insertAfter(((SignItem)NSBlocks.GHAF.getSignItem().get()).getDefaultInstance(), ((HangingSignItem)NSBlocks.GHAF.getHangingSignItem().get()).getDefaultInstance(), CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.insertAfter(((HangingSignItem)NSBlocks.GHAF.getHangingSignItem().get()).getDefaultInstance(), ((SignItem)NSBlocks.PALO_VERDE.getSignItem().get()).getDefaultInstance(), CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.insertAfter(((SignItem)NSBlocks.PALO_VERDE.getSignItem().get()).getDefaultInstance(), ((HangingSignItem)NSBlocks.PALO_VERDE.getHangingSignItem().get()).getDefaultInstance(), CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.insertAfter(((HangingSignItem)NSBlocks.PALO_VERDE.getHangingSignItem().get()).getDefaultInstance(), ((SignItem)NSBlocks.COCONUT.getSignItem().get()).getDefaultInstance(), CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.insertAfter(((SignItem)NSBlocks.COCONUT.getSignItem().get()).getDefaultInstance(), ((HangingSignItem)NSBlocks.COCONUT.getHangingSignItem().get()).getDefaultInstance(), CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.insertAfter(((HangingSignItem)NSBlocks.COCONUT.getHangingSignItem().get()).getDefaultInstance(), ((SignItem)NSBlocks.CEDAR.getSignItem().get()).getDefaultInstance(), CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.insertAfter(((SignItem)NSBlocks.CEDAR.getSignItem().get()).getDefaultInstance(), ((HangingSignItem)NSBlocks.CEDAR.getHangingSignItem().get()).getDefaultInstance(), CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.insertAfter(((HangingSignItem)NSBlocks.CEDAR.getHangingSignItem().get()).getDefaultInstance(), ((SignItem)NSBlocks.LARCH.getSignItem().get()).getDefaultInstance(), CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.insertAfter(((SignItem)NSBlocks.LARCH.getSignItem().get()).getDefaultInstance(), ((HangingSignItem)NSBlocks.LARCH.getHangingSignItem().get()).getDefaultInstance(), CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.insertAfter(((HangingSignItem)NSBlocks.LARCH.getHangingSignItem().get()).getDefaultInstance(), ((SignItem)NSBlocks.MAHOGANY.getSignItem().get()).getDefaultInstance(), CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.insertAfter(((SignItem)NSBlocks.MAHOGANY.getSignItem().get()).getDefaultInstance(), ((HangingSignItem)NSBlocks.MAHOGANY.getHangingSignItem().get()).getDefaultInstance(), CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.insertAfter(((HangingSignItem)NSBlocks.MAHOGANY.getHangingSignItem().get()).getDefaultInstance(), ((SignItem)NSBlocks.SAXAUL.getSignItem().get()).getDefaultInstance(), CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.insertAfter(((SignItem)NSBlocks.SAXAUL.getSignItem().get()).getDefaultInstance(), ((HangingSignItem)NSBlocks.SAXAUL.getHangingSignItem().get()).getDefaultInstance(), CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.insertAfter(Items.SOUL_LANTERN.getDefaultInstance(), ((PaperLanternBlock)((Object)NSBlocks.WHITE_PAPER_LANTERN.get())).asItem().getDefaultInstance(), CreativeModeTab.TabVisibility.PARENT_TAB_ONLY);
            event.insertAfter(((PaperLanternBlock)((Object)NSBlocks.WHITE_PAPER_LANTERN.get())).asItem().getDefaultInstance(), ((PaperLanternBlock)((Object)NSBlocks.LIGHT_GRAY_PAPER_LANTERN.get())).asItem().getDefaultInstance(), CreativeModeTab.TabVisibility.PARENT_TAB_ONLY);
            event.insertAfter(((PaperLanternBlock)((Object)NSBlocks.LIGHT_GRAY_PAPER_LANTERN.get())).asItem().getDefaultInstance(), ((PaperLanternBlock)((Object)NSBlocks.GRAY_PAPER_LANTERN.get())).asItem().getDefaultInstance(), CreativeModeTab.TabVisibility.PARENT_TAB_ONLY);
            event.insertAfter(((PaperLanternBlock)((Object)NSBlocks.GRAY_PAPER_LANTERN.get())).asItem().getDefaultInstance(), ((PaperLanternBlock)((Object)NSBlocks.BLACK_PAPER_LANTERN.get())).asItem().getDefaultInstance(), CreativeModeTab.TabVisibility.PARENT_TAB_ONLY);
            event.insertAfter(((PaperLanternBlock)((Object)NSBlocks.BLACK_PAPER_LANTERN.get())).asItem().getDefaultInstance(), ((PaperLanternBlock)((Object)NSBlocks.BROWN_PAPER_LANTERN.get())).asItem().getDefaultInstance(), CreativeModeTab.TabVisibility.PARENT_TAB_ONLY);
            event.insertAfter(((PaperLanternBlock)((Object)NSBlocks.BROWN_PAPER_LANTERN.get())).asItem().getDefaultInstance(), ((PaperLanternBlock)((Object)NSBlocks.RED_PAPER_LANTERN.get())).asItem().getDefaultInstance(), CreativeModeTab.TabVisibility.PARENT_TAB_ONLY);
            event.insertAfter(((PaperLanternBlock)((Object)NSBlocks.RED_PAPER_LANTERN.get())).asItem().getDefaultInstance(), ((PaperLanternBlock)((Object)NSBlocks.ORANGE_PAPER_LANTERN.get())).asItem().getDefaultInstance(), CreativeModeTab.TabVisibility.PARENT_TAB_ONLY);
            event.insertAfter(((PaperLanternBlock)((Object)NSBlocks.ORANGE_PAPER_LANTERN.get())).asItem().getDefaultInstance(), ((PaperLanternBlock)((Object)NSBlocks.YELLOW_PAPER_LANTERN.get())).asItem().getDefaultInstance(), CreativeModeTab.TabVisibility.PARENT_TAB_ONLY);
            event.insertAfter(((PaperLanternBlock)((Object)NSBlocks.YELLOW_PAPER_LANTERN.get())).asItem().getDefaultInstance(), ((PaperLanternBlock)((Object)NSBlocks.LIME_PAPER_LANTERN.get())).asItem().getDefaultInstance(), CreativeModeTab.TabVisibility.PARENT_TAB_ONLY);
            event.insertAfter(((PaperLanternBlock)((Object)NSBlocks.LIME_PAPER_LANTERN.get())).asItem().getDefaultInstance(), ((PaperLanternBlock)((Object)NSBlocks.GREEN_PAPER_LANTERN.get())).asItem().getDefaultInstance(), CreativeModeTab.TabVisibility.PARENT_TAB_ONLY);
            event.insertAfter(((PaperLanternBlock)((Object)NSBlocks.GREEN_PAPER_LANTERN.get())).asItem().getDefaultInstance(), ((PaperLanternBlock)((Object)NSBlocks.CYAN_PAPER_LANTERN.get())).asItem().getDefaultInstance(), CreativeModeTab.TabVisibility.PARENT_TAB_ONLY);
            event.insertAfter(((PaperLanternBlock)((Object)NSBlocks.CYAN_PAPER_LANTERN.get())).asItem().getDefaultInstance(), ((PaperLanternBlock)((Object)NSBlocks.LIGHT_BLUE_PAPER_LANTERN.get())).asItem().getDefaultInstance(), CreativeModeTab.TabVisibility.PARENT_TAB_ONLY);
            event.insertAfter(((PaperLanternBlock)((Object)NSBlocks.LIGHT_BLUE_PAPER_LANTERN.get())).asItem().getDefaultInstance(), ((PaperLanternBlock)((Object)NSBlocks.BLUE_PAPER_LANTERN.get())).asItem().getDefaultInstance(), CreativeModeTab.TabVisibility.PARENT_TAB_ONLY);
            event.insertAfter(((PaperLanternBlock)((Object)NSBlocks.BLUE_PAPER_LANTERN.get())).asItem().getDefaultInstance(), ((PaperLanternBlock)((Object)NSBlocks.PURPLE_PAPER_LANTERN.get())).asItem().getDefaultInstance(), CreativeModeTab.TabVisibility.PARENT_TAB_ONLY);
            event.insertAfter(((PaperLanternBlock)((Object)NSBlocks.PURPLE_PAPER_LANTERN.get())).asItem().getDefaultInstance(), ((PaperLanternBlock)((Object)NSBlocks.MAGENTA_PAPER_LANTERN.get())).asItem().getDefaultInstance(), CreativeModeTab.TabVisibility.PARENT_TAB_ONLY);
            event.insertAfter(((PaperLanternBlock)((Object)NSBlocks.MAGENTA_PAPER_LANTERN.get())).asItem().getDefaultInstance(), ((PaperLanternBlock)((Object)NSBlocks.PINK_PAPER_LANTERN.get())).asItem().getDefaultInstance(), CreativeModeTab.TabVisibility.PARENT_TAB_ONLY);
        }
        if (event.getTabKey() == CreativeModeTabs.TOOLS_AND_UTILITIES) {
            event.insertAfter(Items.BAMBOO_CHEST_RAFT.getDefaultInstance(), ((NSBoatItem)((Object)NSBlocks.REDWOOD.getBoatItem().get())).getDefaultInstance(), CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.insertAfter(((NSBoatItem)((Object)NSBlocks.REDWOOD.getBoatItem().get())).getDefaultInstance(), ((NSBoatItem)((Object)NSBlocks.REDWOOD.getChestBoatItem().get())).getDefaultInstance(), CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.insertAfter(((NSBoatItem)((Object)NSBlocks.REDWOOD.getChestBoatItem().get())).getDefaultInstance(), ((NSBoatItem)((Object)NSBlocks.SUGI.getBoatItem().get())).getDefaultInstance(), CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.insertAfter(((NSBoatItem)((Object)NSBlocks.SUGI.getBoatItem().get())).getDefaultInstance(), ((NSBoatItem)((Object)NSBlocks.SUGI.getChestBoatItem().get())).getDefaultInstance(), CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.insertAfter(((NSBoatItem)((Object)NSBlocks.SUGI.getChestBoatItem().get())).getDefaultInstance(), ((NSBoatItem)((Object)NSBlocks.WISTERIA.getBoatItem().get())).getDefaultInstance(), CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.insertAfter(((NSBoatItem)((Object)NSBlocks.WISTERIA.getBoatItem().get())).getDefaultInstance(), ((NSBoatItem)((Object)NSBlocks.WISTERIA.getChestBoatItem().get())).getDefaultInstance(), CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.insertAfter(((NSBoatItem)((Object)NSBlocks.WISTERIA.getChestBoatItem().get())).getDefaultInstance(), ((NSBoatItem)((Object)NSBlocks.FIR.getBoatItem().get())).getDefaultInstance(), CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.insertAfter(((NSBoatItem)((Object)NSBlocks.FIR.getBoatItem().get())).getDefaultInstance(), ((NSBoatItem)((Object)NSBlocks.FIR.getChestBoatItem().get())).getDefaultInstance(), CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.insertAfter(((NSBoatItem)((Object)NSBlocks.FIR.getChestBoatItem().get())).getDefaultInstance(), ((NSBoatItem)((Object)NSBlocks.WILLOW.getBoatItem().get())).getDefaultInstance(), CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.insertAfter(((NSBoatItem)((Object)NSBlocks.WILLOW.getBoatItem().get())).getDefaultInstance(), ((NSBoatItem)((Object)NSBlocks.WILLOW.getChestBoatItem().get())).getDefaultInstance(), CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.insertAfter(((NSBoatItem)((Object)NSBlocks.WILLOW.getChestBoatItem().get())).getDefaultInstance(), ((NSBoatItem)((Object)NSBlocks.ASPEN.getBoatItem().get())).getDefaultInstance(), CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.insertAfter(((NSBoatItem)((Object)NSBlocks.ASPEN.getBoatItem().get())).getDefaultInstance(), ((NSBoatItem)((Object)NSBlocks.ASPEN.getChestBoatItem().get())).getDefaultInstance(), CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.insertAfter(((NSBoatItem)((Object)NSBlocks.ASPEN.getChestBoatItem().get())).getDefaultInstance(), ((NSBoatItem)((Object)NSBlocks.MAPLE.getBoatItem().get())).getDefaultInstance(), CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.insertAfter(((NSBoatItem)((Object)NSBlocks.MAPLE.getBoatItem().get())).getDefaultInstance(), ((NSBoatItem)((Object)NSBlocks.MAPLE.getChestBoatItem().get())).getDefaultInstance(), CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.insertAfter(((NSBoatItem)((Object)NSBlocks.MAPLE.getChestBoatItem().get())).getDefaultInstance(), ((NSBoatItem)((Object)NSBlocks.CYPRESS.getBoatItem().get())).getDefaultInstance(), CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.insertAfter(((NSBoatItem)((Object)NSBlocks.CYPRESS.getBoatItem().get())).getDefaultInstance(), ((NSBoatItem)((Object)NSBlocks.CYPRESS.getChestBoatItem().get())).getDefaultInstance(), CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.insertAfter(((NSBoatItem)((Object)NSBlocks.CYPRESS.getChestBoatItem().get())).getDefaultInstance(), ((NSBoatItem)((Object)NSBlocks.OLIVE.getBoatItem().get())).getDefaultInstance(), CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.insertAfter(((NSBoatItem)((Object)NSBlocks.OLIVE.getBoatItem().get())).getDefaultInstance(), ((NSBoatItem)((Object)NSBlocks.OLIVE.getChestBoatItem().get())).getDefaultInstance(), CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.insertAfter(((NSBoatItem)((Object)NSBlocks.OLIVE.getChestBoatItem().get())).getDefaultInstance(), ((NSBoatItem)((Object)NSBlocks.JOSHUA.getBoatItem().get())).getDefaultInstance(), CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.insertAfter(((NSBoatItem)((Object)NSBlocks.JOSHUA.getBoatItem().get())).getDefaultInstance(), ((NSBoatItem)((Object)NSBlocks.JOSHUA.getChestBoatItem().get())).getDefaultInstance(), CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.insertAfter(((NSBoatItem)((Object)NSBlocks.JOSHUA.getChestBoatItem().get())).getDefaultInstance(), ((NSBoatItem)((Object)NSBlocks.GHAF.getBoatItem().get())).getDefaultInstance(), CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.insertAfter(((NSBoatItem)((Object)NSBlocks.GHAF.getBoatItem().get())).getDefaultInstance(), ((NSBoatItem)((Object)NSBlocks.GHAF.getChestBoatItem().get())).getDefaultInstance(), CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.insertAfter(((NSBoatItem)((Object)NSBlocks.GHAF.getChestBoatItem().get())).getDefaultInstance(), ((NSBoatItem)((Object)NSBlocks.PALO_VERDE.getBoatItem().get())).getDefaultInstance(), CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.insertAfter(((NSBoatItem)((Object)NSBlocks.PALO_VERDE.getBoatItem().get())).getDefaultInstance(), ((NSBoatItem)((Object)NSBlocks.PALO_VERDE.getChestBoatItem().get())).getDefaultInstance(), CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.insertAfter(((NSBoatItem)((Object)NSBlocks.PALO_VERDE.getChestBoatItem().get())).getDefaultInstance(), ((NSBoatItem)((Object)NSBlocks.COCONUT.getBoatItem().get())).getDefaultInstance(), CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.insertAfter(((NSBoatItem)((Object)NSBlocks.COCONUT.getBoatItem().get())).getDefaultInstance(), ((NSBoatItem)((Object)NSBlocks.COCONUT.getChestBoatItem().get())).getDefaultInstance(), CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.insertAfter(((NSBoatItem)((Object)NSBlocks.COCONUT.getChestBoatItem().get())).getDefaultInstance(), ((NSBoatItem)((Object)NSBlocks.CEDAR.getBoatItem().get())).getDefaultInstance(), CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.insertAfter(((NSBoatItem)((Object)NSBlocks.CEDAR.getBoatItem().get())).getDefaultInstance(), ((NSBoatItem)((Object)NSBlocks.CEDAR.getChestBoatItem().get())).getDefaultInstance(), CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.insertAfter(((NSBoatItem)((Object)NSBlocks.CEDAR.getChestBoatItem().get())).getDefaultInstance(), ((NSBoatItem)((Object)NSBlocks.LARCH.getBoatItem().get())).getDefaultInstance(), CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.insertAfter(((NSBoatItem)((Object)NSBlocks.LARCH.getBoatItem().get())).getDefaultInstance(), ((NSBoatItem)((Object)NSBlocks.LARCH.getChestBoatItem().get())).getDefaultInstance(), CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.insertAfter(((NSBoatItem)((Object)NSBlocks.LARCH.getChestBoatItem().get())).getDefaultInstance(), ((NSBoatItem)((Object)NSBlocks.MAHOGANY.getBoatItem().get())).getDefaultInstance(), CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.insertAfter(((NSBoatItem)((Object)NSBlocks.MAHOGANY.getBoatItem().get())).getDefaultInstance(), ((NSBoatItem)((Object)NSBlocks.MAHOGANY.getChestBoatItem().get())).getDefaultInstance(), CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.insertAfter(((NSBoatItem)((Object)NSBlocks.MAHOGANY.getChestBoatItem().get())).getDefaultInstance(), ((NSBoatItem)((Object)NSBlocks.SAXAUL.getBoatItem().get())).getDefaultInstance(), CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.insertAfter(((NSBoatItem)((Object)NSBlocks.SAXAUL.getBoatItem().get())).getDefaultInstance(), ((NSBoatItem)((Object)NSBlocks.SAXAUL.getChestBoatItem().get())).getDefaultInstance(), CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
        }
        if (event.getTabKey() == CreativeModeTabs.COLORED_BLOCKS) {
            event.insertAfter(Items.PINK_TERRACOTTA.getDefaultInstance(), ((Block)NSBlocks.KAOLIN.get()).asItem().getDefaultInstance(), CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.insertAfter(((Block)NSBlocks.KAOLIN.get()).asItem().getDefaultInstance(), ((Block)NSBlocks.WHITE_KAOLIN.get()).asItem().getDefaultInstance(), CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.insertAfter(((Block)NSBlocks.WHITE_KAOLIN.get()).asItem().getDefaultInstance(), ((Block)NSBlocks.LIGHT_GRAY_KAOLIN.get()).asItem().getDefaultInstance(), CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.insertAfter(((Block)NSBlocks.LIGHT_GRAY_KAOLIN.get()).asItem().getDefaultInstance(), ((Block)NSBlocks.GRAY_KAOLIN.get()).asItem().getDefaultInstance(), CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.insertAfter(((Block)NSBlocks.GRAY_KAOLIN.get()).asItem().getDefaultInstance(), ((Block)NSBlocks.BLACK_KAOLIN.get()).asItem().getDefaultInstance(), CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.insertAfter(((Block)NSBlocks.BLACK_KAOLIN.get()).asItem().getDefaultInstance(), ((Block)NSBlocks.BROWN_KAOLIN.get()).asItem().getDefaultInstance(), CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.insertAfter(((Block)NSBlocks.BROWN_KAOLIN.get()).asItem().getDefaultInstance(), ((Block)NSBlocks.RED_KAOLIN.get()).asItem().getDefaultInstance(), CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.insertAfter(((Block)NSBlocks.RED_KAOLIN.get()).asItem().getDefaultInstance(), ((Block)NSBlocks.ORANGE_KAOLIN.get()).asItem().getDefaultInstance(), CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.insertAfter(((Block)NSBlocks.ORANGE_KAOLIN.get()).asItem().getDefaultInstance(), ((Block)NSBlocks.YELLOW_KAOLIN.get()).asItem().getDefaultInstance(), CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.insertAfter(((Block)NSBlocks.YELLOW_KAOLIN.get()).asItem().getDefaultInstance(), ((Block)NSBlocks.LIME_KAOLIN.get()).asItem().getDefaultInstance(), CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.insertAfter(((Block)NSBlocks.LIME_KAOLIN.get()).asItem().getDefaultInstance(), ((Block)NSBlocks.GREEN_KAOLIN.get()).asItem().getDefaultInstance(), CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.insertAfter(((Block)NSBlocks.GREEN_KAOLIN.get()).asItem().getDefaultInstance(), ((Block)NSBlocks.CYAN_KAOLIN.get()).asItem().getDefaultInstance(), CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.insertAfter(((Block)NSBlocks.CYAN_KAOLIN.get()).asItem().getDefaultInstance(), ((Block)NSBlocks.LIGHT_BLUE_KAOLIN.get()).asItem().getDefaultInstance(), CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.insertAfter(((Block)NSBlocks.LIGHT_BLUE_KAOLIN.get()).asItem().getDefaultInstance(), ((Block)NSBlocks.BLUE_KAOLIN.get()).asItem().getDefaultInstance(), CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.insertAfter(((Block)NSBlocks.BLUE_KAOLIN.get()).asItem().getDefaultInstance(), ((Block)NSBlocks.PURPLE_KAOLIN.get()).asItem().getDefaultInstance(), CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.insertAfter(((Block)NSBlocks.PURPLE_KAOLIN.get()).asItem().getDefaultInstance(), ((Block)NSBlocks.MAGENTA_KAOLIN.get()).asItem().getDefaultInstance(), CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.insertAfter(((Block)NSBlocks.MAGENTA_KAOLIN.get()).asItem().getDefaultInstance(), ((Block)NSBlocks.PINK_KAOLIN.get()).asItem().getDefaultInstance(), CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.insertAfter(((Block)NSBlocks.PINK_KAOLIN.get()).asItem().getDefaultInstance(), ((StairBlock)NSBlocks.KAOLIN_STAIRS.get()).asItem().getDefaultInstance(), CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.insertAfter(((StairBlock)NSBlocks.KAOLIN_STAIRS.get()).asItem().getDefaultInstance(), ((StairBlock)NSBlocks.WHITE_KAOLIN_STAIRS.get()).asItem().getDefaultInstance(), CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.insertAfter(((StairBlock)NSBlocks.WHITE_KAOLIN_STAIRS.get()).asItem().getDefaultInstance(), ((StairBlock)NSBlocks.LIGHT_GRAY_KAOLIN_STAIRS.get()).asItem().getDefaultInstance(), CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.insertAfter(((StairBlock)NSBlocks.LIGHT_GRAY_KAOLIN_STAIRS.get()).asItem().getDefaultInstance(), ((StairBlock)NSBlocks.GRAY_KAOLIN_STAIRS.get()).asItem().getDefaultInstance(), CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.insertAfter(((StairBlock)NSBlocks.GRAY_KAOLIN_STAIRS.get()).asItem().getDefaultInstance(), ((StairBlock)NSBlocks.BLACK_KAOLIN_STAIRS.get()).asItem().getDefaultInstance(), CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.insertAfter(((StairBlock)NSBlocks.BLACK_KAOLIN_STAIRS.get()).asItem().getDefaultInstance(), ((StairBlock)NSBlocks.BROWN_KAOLIN_STAIRS.get()).asItem().getDefaultInstance(), CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.insertAfter(((StairBlock)NSBlocks.BROWN_KAOLIN_STAIRS.get()).asItem().getDefaultInstance(), ((StairBlock)NSBlocks.RED_KAOLIN_STAIRS.get()).asItem().getDefaultInstance(), CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.insertAfter(((StairBlock)NSBlocks.RED_KAOLIN_STAIRS.get()).asItem().getDefaultInstance(), ((StairBlock)NSBlocks.ORANGE_KAOLIN_STAIRS.get()).asItem().getDefaultInstance(), CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.insertAfter(((StairBlock)NSBlocks.ORANGE_KAOLIN_STAIRS.get()).asItem().getDefaultInstance(), ((StairBlock)NSBlocks.YELLOW_KAOLIN_STAIRS.get()).asItem().getDefaultInstance(), CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.insertAfter(((StairBlock)NSBlocks.YELLOW_KAOLIN_STAIRS.get()).asItem().getDefaultInstance(), ((StairBlock)NSBlocks.LIME_KAOLIN_STAIRS.get()).asItem().getDefaultInstance(), CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.insertAfter(((StairBlock)NSBlocks.LIME_KAOLIN_STAIRS.get()).asItem().getDefaultInstance(), ((StairBlock)NSBlocks.GREEN_KAOLIN_STAIRS.get()).asItem().getDefaultInstance(), CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.insertAfter(((StairBlock)NSBlocks.GREEN_KAOLIN_STAIRS.get()).asItem().getDefaultInstance(), ((StairBlock)NSBlocks.CYAN_KAOLIN_STAIRS.get()).asItem().getDefaultInstance(), CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.insertAfter(((StairBlock)NSBlocks.CYAN_KAOLIN_STAIRS.get()).asItem().getDefaultInstance(), ((StairBlock)NSBlocks.LIGHT_BLUE_KAOLIN_STAIRS.get()).asItem().getDefaultInstance(), CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.insertAfter(((StairBlock)NSBlocks.LIGHT_BLUE_KAOLIN_STAIRS.get()).asItem().getDefaultInstance(), ((StairBlock)NSBlocks.BLUE_KAOLIN_STAIRS.get()).asItem().getDefaultInstance(), CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.insertAfter(((StairBlock)NSBlocks.BLUE_KAOLIN_STAIRS.get()).asItem().getDefaultInstance(), ((StairBlock)NSBlocks.PURPLE_KAOLIN_STAIRS.get()).asItem().getDefaultInstance(), CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.insertAfter(((StairBlock)NSBlocks.PURPLE_KAOLIN_STAIRS.get()).asItem().getDefaultInstance(), ((StairBlock)NSBlocks.MAGENTA_KAOLIN_STAIRS.get()).asItem().getDefaultInstance(), CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.insertAfter(((StairBlock)NSBlocks.MAGENTA_KAOLIN_STAIRS.get()).asItem().getDefaultInstance(), ((StairBlock)NSBlocks.PINK_KAOLIN_STAIRS.get()).asItem().getDefaultInstance(), CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.insertAfter(((StairBlock)NSBlocks.PINK_KAOLIN_STAIRS.get()).asItem().getDefaultInstance(), ((SlabBlock)NSBlocks.KAOLIN_SLAB.get()).asItem().getDefaultInstance(), CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.insertAfter(((SlabBlock)NSBlocks.KAOLIN_SLAB.get()).asItem().getDefaultInstance(), ((SlabBlock)NSBlocks.WHITE_KAOLIN_SLAB.get()).asItem().getDefaultInstance(), CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.insertAfter(((SlabBlock)NSBlocks.WHITE_KAOLIN_SLAB.get()).asItem().getDefaultInstance(), ((SlabBlock)NSBlocks.LIGHT_GRAY_KAOLIN_SLAB.get()).asItem().getDefaultInstance(), CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.insertAfter(((SlabBlock)NSBlocks.LIGHT_GRAY_KAOLIN_SLAB.get()).asItem().getDefaultInstance(), ((SlabBlock)NSBlocks.GRAY_KAOLIN_SLAB.get()).asItem().getDefaultInstance(), CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.insertAfter(((SlabBlock)NSBlocks.GRAY_KAOLIN_SLAB.get()).asItem().getDefaultInstance(), ((SlabBlock)NSBlocks.BLACK_KAOLIN_SLAB.get()).asItem().getDefaultInstance(), CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.insertAfter(((SlabBlock)NSBlocks.BLACK_KAOLIN_SLAB.get()).asItem().getDefaultInstance(), ((SlabBlock)NSBlocks.BROWN_KAOLIN_SLAB.get()).asItem().getDefaultInstance(), CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.insertAfter(((SlabBlock)NSBlocks.BROWN_KAOLIN_SLAB.get()).asItem().getDefaultInstance(), ((SlabBlock)NSBlocks.RED_KAOLIN_SLAB.get()).asItem().getDefaultInstance(), CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.insertAfter(((SlabBlock)NSBlocks.RED_KAOLIN_SLAB.get()).asItem().getDefaultInstance(), ((SlabBlock)NSBlocks.ORANGE_KAOLIN_SLAB.get()).asItem().getDefaultInstance(), CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.insertAfter(((SlabBlock)NSBlocks.ORANGE_KAOLIN_SLAB.get()).asItem().getDefaultInstance(), ((SlabBlock)NSBlocks.YELLOW_KAOLIN_SLAB.get()).asItem().getDefaultInstance(), CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.insertAfter(((SlabBlock)NSBlocks.YELLOW_KAOLIN_SLAB.get()).asItem().getDefaultInstance(), ((SlabBlock)NSBlocks.LIME_KAOLIN_SLAB.get()).asItem().getDefaultInstance(), CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.insertAfter(((SlabBlock)NSBlocks.LIME_KAOLIN_SLAB.get()).asItem().getDefaultInstance(), ((SlabBlock)NSBlocks.GREEN_KAOLIN_SLAB.get()).asItem().getDefaultInstance(), CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.insertAfter(((SlabBlock)NSBlocks.GREEN_KAOLIN_SLAB.get()).asItem().getDefaultInstance(), ((SlabBlock)NSBlocks.CYAN_KAOLIN_SLAB.get()).asItem().getDefaultInstance(), CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.insertAfter(((SlabBlock)NSBlocks.CYAN_KAOLIN_SLAB.get()).asItem().getDefaultInstance(), ((SlabBlock)NSBlocks.LIGHT_BLUE_KAOLIN_SLAB.get()).asItem().getDefaultInstance(), CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.insertAfter(((SlabBlock)NSBlocks.LIGHT_BLUE_KAOLIN_SLAB.get()).asItem().getDefaultInstance(), ((SlabBlock)NSBlocks.BLUE_KAOLIN_SLAB.get()).asItem().getDefaultInstance(), CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.insertAfter(((SlabBlock)NSBlocks.BLUE_KAOLIN_SLAB.get()).asItem().getDefaultInstance(), ((SlabBlock)NSBlocks.PURPLE_KAOLIN_SLAB.get()).asItem().getDefaultInstance(), CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.insertAfter(((SlabBlock)NSBlocks.PURPLE_KAOLIN_SLAB.get()).asItem().getDefaultInstance(), ((SlabBlock)NSBlocks.MAGENTA_KAOLIN_SLAB.get()).asItem().getDefaultInstance(), CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.insertAfter(((SlabBlock)NSBlocks.MAGENTA_KAOLIN_SLAB.get()).asItem().getDefaultInstance(), ((SlabBlock)NSBlocks.PINK_KAOLIN_SLAB.get()).asItem().getDefaultInstance(), CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.insertAfter(((SlabBlock)NSBlocks.PINK_KAOLIN_SLAB.get()).asItem().getDefaultInstance(), ((Block)NSBlocks.KAOLIN_BRICKS.get()).asItem().getDefaultInstance(), CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.insertAfter(((Block)NSBlocks.KAOLIN_BRICKS.get()).asItem().getDefaultInstance(), ((Block)NSBlocks.WHITE_KAOLIN_BRICKS.get()).asItem().getDefaultInstance(), CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.insertAfter(((Block)NSBlocks.WHITE_KAOLIN_BRICKS.get()).asItem().getDefaultInstance(), ((Block)NSBlocks.LIGHT_GRAY_KAOLIN_BRICKS.get()).asItem().getDefaultInstance(), CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.insertAfter(((Block)NSBlocks.LIGHT_GRAY_KAOLIN_BRICKS.get()).asItem().getDefaultInstance(), ((Block)NSBlocks.GRAY_KAOLIN_BRICKS.get()).asItem().getDefaultInstance(), CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.insertAfter(((Block)NSBlocks.GRAY_KAOLIN_BRICKS.get()).asItem().getDefaultInstance(), ((Block)NSBlocks.BLACK_KAOLIN_BRICKS.get()).asItem().getDefaultInstance(), CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.insertAfter(((Block)NSBlocks.BLACK_KAOLIN_BRICKS.get()).asItem().getDefaultInstance(), ((Block)NSBlocks.BROWN_KAOLIN_BRICKS.get()).asItem().getDefaultInstance(), CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.insertAfter(((Block)NSBlocks.BROWN_KAOLIN_BRICKS.get()).asItem().getDefaultInstance(), ((Block)NSBlocks.RED_KAOLIN_BRICKS.get()).asItem().getDefaultInstance(), CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.insertAfter(((Block)NSBlocks.RED_KAOLIN_BRICKS.get()).asItem().getDefaultInstance(), ((Block)NSBlocks.ORANGE_KAOLIN_BRICKS.get()).asItem().getDefaultInstance(), CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.insertAfter(((Block)NSBlocks.ORANGE_KAOLIN_BRICKS.get()).asItem().getDefaultInstance(), ((Block)NSBlocks.YELLOW_KAOLIN_BRICKS.get()).asItem().getDefaultInstance(), CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.insertAfter(((Block)NSBlocks.YELLOW_KAOLIN_BRICKS.get()).asItem().getDefaultInstance(), ((Block)NSBlocks.LIME_KAOLIN_BRICKS.get()).asItem().getDefaultInstance(), CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.insertAfter(((Block)NSBlocks.LIME_KAOLIN_BRICKS.get()).asItem().getDefaultInstance(), ((Block)NSBlocks.GREEN_KAOLIN_BRICKS.get()).asItem().getDefaultInstance(), CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.insertAfter(((Block)NSBlocks.GREEN_KAOLIN_BRICKS.get()).asItem().getDefaultInstance(), ((Block)NSBlocks.CYAN_KAOLIN_BRICKS.get()).asItem().getDefaultInstance(), CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.insertAfter(((Block)NSBlocks.CYAN_KAOLIN_BRICKS.get()).asItem().getDefaultInstance(), ((Block)NSBlocks.LIGHT_BLUE_KAOLIN_BRICKS.get()).asItem().getDefaultInstance(), CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.insertAfter(((Block)NSBlocks.LIGHT_BLUE_KAOLIN_BRICKS.get()).asItem().getDefaultInstance(), ((Block)NSBlocks.BLUE_KAOLIN_BRICKS.get()).asItem().getDefaultInstance(), CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.insertAfter(((Block)NSBlocks.BLUE_KAOLIN_BRICKS.get()).asItem().getDefaultInstance(), ((Block)NSBlocks.PURPLE_KAOLIN_BRICKS.get()).asItem().getDefaultInstance(), CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.insertAfter(((Block)NSBlocks.PURPLE_KAOLIN_BRICKS.get()).asItem().getDefaultInstance(), ((Block)NSBlocks.MAGENTA_KAOLIN_BRICKS.get()).asItem().getDefaultInstance(), CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.insertAfter(((Block)NSBlocks.MAGENTA_KAOLIN_BRICKS.get()).asItem().getDefaultInstance(), ((Block)NSBlocks.PINK_KAOLIN_BRICKS.get()).asItem().getDefaultInstance(), CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.insertAfter(((Block)NSBlocks.PINK_KAOLIN_BRICKS.get()).asItem().getDefaultInstance(), ((StairBlock)NSBlocks.KAOLIN_BRICK_STAIRS.get()).asItem().getDefaultInstance(), CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.insertAfter(((StairBlock)NSBlocks.KAOLIN_BRICK_STAIRS.get()).asItem().getDefaultInstance(), ((StairBlock)NSBlocks.WHITE_KAOLIN_BRICK_STAIRS.get()).asItem().getDefaultInstance(), CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.insertAfter(((StairBlock)NSBlocks.WHITE_KAOLIN_BRICK_STAIRS.get()).asItem().getDefaultInstance(), ((StairBlock)NSBlocks.LIGHT_GRAY_KAOLIN_BRICK_STAIRS.get()).asItem().getDefaultInstance(), CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.insertAfter(((StairBlock)NSBlocks.LIGHT_GRAY_KAOLIN_BRICK_STAIRS.get()).asItem().getDefaultInstance(), ((StairBlock)NSBlocks.GRAY_KAOLIN_BRICK_STAIRS.get()).asItem().getDefaultInstance(), CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.insertAfter(((StairBlock)NSBlocks.GRAY_KAOLIN_BRICK_STAIRS.get()).asItem().getDefaultInstance(), ((StairBlock)NSBlocks.BLACK_KAOLIN_BRICK_STAIRS.get()).asItem().getDefaultInstance(), CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.insertAfter(((StairBlock)NSBlocks.BLACK_KAOLIN_BRICK_STAIRS.get()).asItem().getDefaultInstance(), ((StairBlock)NSBlocks.BROWN_KAOLIN_BRICK_STAIRS.get()).asItem().getDefaultInstance(), CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.insertAfter(((StairBlock)NSBlocks.BROWN_KAOLIN_BRICK_STAIRS.get()).asItem().getDefaultInstance(), ((StairBlock)NSBlocks.RED_KAOLIN_BRICK_STAIRS.get()).asItem().getDefaultInstance(), CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.insertAfter(((StairBlock)NSBlocks.RED_KAOLIN_BRICK_STAIRS.get()).asItem().getDefaultInstance(), ((StairBlock)NSBlocks.ORANGE_KAOLIN_BRICK_STAIRS.get()).asItem().getDefaultInstance(), CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.insertAfter(((StairBlock)NSBlocks.ORANGE_KAOLIN_BRICK_STAIRS.get()).asItem().getDefaultInstance(), ((StairBlock)NSBlocks.YELLOW_KAOLIN_BRICK_STAIRS.get()).asItem().getDefaultInstance(), CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.insertAfter(((StairBlock)NSBlocks.YELLOW_KAOLIN_BRICK_STAIRS.get()).asItem().getDefaultInstance(), ((StairBlock)NSBlocks.LIME_KAOLIN_BRICK_STAIRS.get()).asItem().getDefaultInstance(), CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.insertAfter(((StairBlock)NSBlocks.LIME_KAOLIN_BRICK_STAIRS.get()).asItem().getDefaultInstance(), ((StairBlock)NSBlocks.GREEN_KAOLIN_BRICK_STAIRS.get()).asItem().getDefaultInstance(), CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.insertAfter(((StairBlock)NSBlocks.GREEN_KAOLIN_BRICK_STAIRS.get()).asItem().getDefaultInstance(), ((StairBlock)NSBlocks.CYAN_KAOLIN_BRICK_STAIRS.get()).asItem().getDefaultInstance(), CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.insertAfter(((StairBlock)NSBlocks.CYAN_KAOLIN_BRICK_STAIRS.get()).asItem().getDefaultInstance(), ((StairBlock)NSBlocks.LIGHT_BLUE_KAOLIN_BRICK_STAIRS.get()).asItem().getDefaultInstance(), CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.insertAfter(((StairBlock)NSBlocks.LIGHT_BLUE_KAOLIN_BRICK_STAIRS.get()).asItem().getDefaultInstance(), ((StairBlock)NSBlocks.BLUE_KAOLIN_BRICK_STAIRS.get()).asItem().getDefaultInstance(), CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.insertAfter(((StairBlock)NSBlocks.BLUE_KAOLIN_BRICK_STAIRS.get()).asItem().getDefaultInstance(), ((StairBlock)NSBlocks.PURPLE_KAOLIN_BRICK_STAIRS.get()).asItem().getDefaultInstance(), CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.insertAfter(((StairBlock)NSBlocks.PURPLE_KAOLIN_BRICK_STAIRS.get()).asItem().getDefaultInstance(), ((StairBlock)NSBlocks.MAGENTA_KAOLIN_BRICK_STAIRS.get()).asItem().getDefaultInstance(), CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.insertAfter(((StairBlock)NSBlocks.MAGENTA_KAOLIN_BRICK_STAIRS.get()).asItem().getDefaultInstance(), ((StairBlock)NSBlocks.PINK_KAOLIN_BRICK_STAIRS.get()).asItem().getDefaultInstance(), CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.insertAfter(((StairBlock)NSBlocks.PINK_KAOLIN_BRICK_STAIRS.get()).asItem().getDefaultInstance(), ((SlabBlock)NSBlocks.KAOLIN_BRICK_SLAB.get()).asItem().getDefaultInstance(), CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.insertAfter(((SlabBlock)NSBlocks.KAOLIN_BRICK_SLAB.get()).asItem().getDefaultInstance(), ((SlabBlock)NSBlocks.WHITE_KAOLIN_BRICK_SLAB.get()).asItem().getDefaultInstance(), CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.insertAfter(((SlabBlock)NSBlocks.WHITE_KAOLIN_BRICK_SLAB.get()).asItem().getDefaultInstance(), ((SlabBlock)NSBlocks.LIGHT_GRAY_KAOLIN_BRICK_SLAB.get()).asItem().getDefaultInstance(), CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.insertAfter(((SlabBlock)NSBlocks.LIGHT_GRAY_KAOLIN_BRICK_SLAB.get()).asItem().getDefaultInstance(), ((SlabBlock)NSBlocks.GRAY_KAOLIN_BRICK_SLAB.get()).asItem().getDefaultInstance(), CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.insertAfter(((SlabBlock)NSBlocks.GRAY_KAOLIN_BRICK_SLAB.get()).asItem().getDefaultInstance(), ((SlabBlock)NSBlocks.BLACK_KAOLIN_BRICK_SLAB.get()).asItem().getDefaultInstance(), CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.insertAfter(((SlabBlock)NSBlocks.BLACK_KAOLIN_BRICK_SLAB.get()).asItem().getDefaultInstance(), ((SlabBlock)NSBlocks.BROWN_KAOLIN_BRICK_SLAB.get()).asItem().getDefaultInstance(), CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.insertAfter(((SlabBlock)NSBlocks.BROWN_KAOLIN_BRICK_SLAB.get()).asItem().getDefaultInstance(), ((SlabBlock)NSBlocks.RED_KAOLIN_BRICK_SLAB.get()).asItem().getDefaultInstance(), CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.insertAfter(((SlabBlock)NSBlocks.RED_KAOLIN_BRICK_SLAB.get()).asItem().getDefaultInstance(), ((SlabBlock)NSBlocks.ORANGE_KAOLIN_BRICK_SLAB.get()).asItem().getDefaultInstance(), CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.insertAfter(((SlabBlock)NSBlocks.ORANGE_KAOLIN_BRICK_SLAB.get()).asItem().getDefaultInstance(), ((SlabBlock)NSBlocks.YELLOW_KAOLIN_BRICK_SLAB.get()).asItem().getDefaultInstance(), CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.insertAfter(((SlabBlock)NSBlocks.YELLOW_KAOLIN_BRICK_SLAB.get()).asItem().getDefaultInstance(), ((SlabBlock)NSBlocks.LIME_KAOLIN_BRICK_SLAB.get()).asItem().getDefaultInstance(), CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.insertAfter(((SlabBlock)NSBlocks.LIME_KAOLIN_BRICK_SLAB.get()).asItem().getDefaultInstance(), ((SlabBlock)NSBlocks.GREEN_KAOLIN_BRICK_SLAB.get()).asItem().getDefaultInstance(), CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.insertAfter(((SlabBlock)NSBlocks.GREEN_KAOLIN_BRICK_SLAB.get()).asItem().getDefaultInstance(), ((SlabBlock)NSBlocks.CYAN_KAOLIN_BRICK_SLAB.get()).asItem().getDefaultInstance(), CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.insertAfter(((SlabBlock)NSBlocks.CYAN_KAOLIN_BRICK_SLAB.get()).asItem().getDefaultInstance(), ((SlabBlock)NSBlocks.LIGHT_BLUE_KAOLIN_BRICK_SLAB.get()).asItem().getDefaultInstance(), CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.insertAfter(((SlabBlock)NSBlocks.LIGHT_BLUE_KAOLIN_BRICK_SLAB.get()).asItem().getDefaultInstance(), ((SlabBlock)NSBlocks.BLUE_KAOLIN_BRICK_SLAB.get()).asItem().getDefaultInstance(), CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.insertAfter(((SlabBlock)NSBlocks.BLUE_KAOLIN_BRICK_SLAB.get()).asItem().getDefaultInstance(), ((SlabBlock)NSBlocks.PURPLE_KAOLIN_BRICK_SLAB.get()).asItem().getDefaultInstance(), CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.insertAfter(((SlabBlock)NSBlocks.PURPLE_KAOLIN_BRICK_SLAB.get()).asItem().getDefaultInstance(), ((SlabBlock)NSBlocks.MAGENTA_KAOLIN_BRICK_SLAB.get()).asItem().getDefaultInstance(), CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.insertAfter(((SlabBlock)NSBlocks.MAGENTA_KAOLIN_BRICK_SLAB.get()).asItem().getDefaultInstance(), ((SlabBlock)NSBlocks.PINK_KAOLIN_BRICK_SLAB.get()).asItem().getDefaultInstance(), CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.insertAfter(((SlabBlock)NSBlocks.PINK_KAOLIN_BRICK_SLAB.get()).asItem().getDefaultInstance(), ((Block)NSBlocks.WHITE_CHALK.get()).asItem().getDefaultInstance(), CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.insertAfter(((Block)NSBlocks.WHITE_CHALK.get()).asItem().getDefaultInstance(), ((Block)NSBlocks.LIGHT_GRAY_CHALK.get()).asItem().getDefaultInstance(), CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.insertAfter(((Block)NSBlocks.LIGHT_GRAY_CHALK.get()).asItem().getDefaultInstance(), ((Block)NSBlocks.GRAY_CHALK.get()).asItem().getDefaultInstance(), CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.insertAfter(((Block)NSBlocks.GRAY_CHALK.get()).asItem().getDefaultInstance(), ((Block)NSBlocks.BLACK_CHALK.get()).asItem().getDefaultInstance(), CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.insertAfter(((Block)NSBlocks.BLACK_CHALK.get()).asItem().getDefaultInstance(), ((Block)NSBlocks.BROWN_CHALK.get()).asItem().getDefaultInstance(), CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.insertAfter(((Block)NSBlocks.BROWN_CHALK.get()).asItem().getDefaultInstance(), ((Block)NSBlocks.RED_CHALK.get()).asItem().getDefaultInstance(), CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.insertAfter(((Block)NSBlocks.RED_CHALK.get()).asItem().getDefaultInstance(), ((Block)NSBlocks.ORANGE_CHALK.get()).asItem().getDefaultInstance(), CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.insertAfter(((Block)NSBlocks.ORANGE_CHALK.get()).asItem().getDefaultInstance(), ((Block)NSBlocks.YELLOW_CHALK.get()).asItem().getDefaultInstance(), CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.insertAfter(((Block)NSBlocks.YELLOW_CHALK.get()).asItem().getDefaultInstance(), ((Block)NSBlocks.LIME_CHALK.get()).asItem().getDefaultInstance(), CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.insertAfter(((Block)NSBlocks.LIME_CHALK.get()).asItem().getDefaultInstance(), ((Block)NSBlocks.GREEN_CHALK.get()).asItem().getDefaultInstance(), CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.insertAfter(((Block)NSBlocks.GREEN_CHALK.get()).asItem().getDefaultInstance(), ((Block)NSBlocks.CYAN_CHALK.get()).asItem().getDefaultInstance(), CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.insertAfter(((Block)NSBlocks.CYAN_CHALK.get()).asItem().getDefaultInstance(), ((Block)NSBlocks.LIGHT_BLUE_CHALK.get()).asItem().getDefaultInstance(), CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.insertAfter(((Block)NSBlocks.LIGHT_BLUE_CHALK.get()).asItem().getDefaultInstance(), ((Block)NSBlocks.BLUE_CHALK.get()).asItem().getDefaultInstance(), CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.insertAfter(((Block)NSBlocks.BLUE_CHALK.get()).asItem().getDefaultInstance(), ((Block)NSBlocks.PURPLE_CHALK.get()).asItem().getDefaultInstance(), CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.insertAfter(((Block)NSBlocks.PURPLE_CHALK.get()).asItem().getDefaultInstance(), ((Block)NSBlocks.MAGENTA_CHALK.get()).asItem().getDefaultInstance(), CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.insertAfter(((Block)NSBlocks.MAGENTA_CHALK.get()).asItem().getDefaultInstance(), ((Block)NSBlocks.PINK_CHALK.get()).asItem().getDefaultInstance(), CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.insertAfter(((Block)NSBlocks.PINK_CHALK.get()).asItem().getDefaultInstance(), ((StairBlock)NSBlocks.WHITE_CHALK_STAIRS.get()).asItem().getDefaultInstance(), CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.insertAfter(((StairBlock)NSBlocks.WHITE_CHALK_STAIRS.get()).asItem().getDefaultInstance(), ((StairBlock)NSBlocks.LIGHT_GRAY_CHALK_STAIRS.get()).asItem().getDefaultInstance(), CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.insertAfter(((StairBlock)NSBlocks.LIGHT_GRAY_CHALK_STAIRS.get()).asItem().getDefaultInstance(), ((StairBlock)NSBlocks.GRAY_CHALK_STAIRS.get()).asItem().getDefaultInstance(), CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.insertAfter(((StairBlock)NSBlocks.GRAY_CHALK_STAIRS.get()).asItem().getDefaultInstance(), ((StairBlock)NSBlocks.BLACK_CHALK_STAIRS.get()).asItem().getDefaultInstance(), CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.insertAfter(((StairBlock)NSBlocks.BLACK_CHALK_STAIRS.get()).asItem().getDefaultInstance(), ((StairBlock)NSBlocks.BROWN_CHALK_STAIRS.get()).asItem().getDefaultInstance(), CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.insertAfter(((StairBlock)NSBlocks.BROWN_CHALK_STAIRS.get()).asItem().getDefaultInstance(), ((StairBlock)NSBlocks.RED_CHALK_STAIRS.get()).asItem().getDefaultInstance(), CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.insertAfter(((StairBlock)NSBlocks.RED_CHALK_STAIRS.get()).asItem().getDefaultInstance(), ((StairBlock)NSBlocks.ORANGE_CHALK_STAIRS.get()).asItem().getDefaultInstance(), CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.insertAfter(((StairBlock)NSBlocks.ORANGE_CHALK_STAIRS.get()).asItem().getDefaultInstance(), ((StairBlock)NSBlocks.YELLOW_CHALK_STAIRS.get()).asItem().getDefaultInstance(), CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.insertAfter(((StairBlock)NSBlocks.YELLOW_CHALK_STAIRS.get()).asItem().getDefaultInstance(), ((StairBlock)NSBlocks.LIME_CHALK_STAIRS.get()).asItem().getDefaultInstance(), CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.insertAfter(((StairBlock)NSBlocks.LIME_CHALK_STAIRS.get()).asItem().getDefaultInstance(), ((StairBlock)NSBlocks.GREEN_CHALK_STAIRS.get()).asItem().getDefaultInstance(), CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.insertAfter(((StairBlock)NSBlocks.GREEN_CHALK_STAIRS.get()).asItem().getDefaultInstance(), ((StairBlock)NSBlocks.CYAN_CHALK_STAIRS.get()).asItem().getDefaultInstance(), CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.insertAfter(((StairBlock)NSBlocks.CYAN_CHALK_STAIRS.get()).asItem().getDefaultInstance(), ((StairBlock)NSBlocks.LIGHT_BLUE_CHALK_STAIRS.get()).asItem().getDefaultInstance(), CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.insertAfter(((StairBlock)NSBlocks.LIGHT_BLUE_CHALK_STAIRS.get()).asItem().getDefaultInstance(), ((StairBlock)NSBlocks.BLUE_CHALK_STAIRS.get()).asItem().getDefaultInstance(), CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.insertAfter(((StairBlock)NSBlocks.BLUE_CHALK_STAIRS.get()).asItem().getDefaultInstance(), ((StairBlock)NSBlocks.PURPLE_CHALK_STAIRS.get()).asItem().getDefaultInstance(), CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.insertAfter(((StairBlock)NSBlocks.PURPLE_CHALK_STAIRS.get()).asItem().getDefaultInstance(), ((StairBlock)NSBlocks.MAGENTA_CHALK_STAIRS.get()).asItem().getDefaultInstance(), CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.insertAfter(((StairBlock)NSBlocks.MAGENTA_CHALK_STAIRS.get()).asItem().getDefaultInstance(), ((StairBlock)NSBlocks.PINK_CHALK_STAIRS.get()).asItem().getDefaultInstance(), CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.insertAfter(((StairBlock)NSBlocks.PINK_CHALK_STAIRS.get()).asItem().getDefaultInstance(), ((SlabBlock)NSBlocks.WHITE_CHALK_SLAB.get()).asItem().getDefaultInstance(), CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.insertAfter(((SlabBlock)NSBlocks.WHITE_CHALK_SLAB.get()).asItem().getDefaultInstance(), ((SlabBlock)NSBlocks.LIGHT_GRAY_CHALK_SLAB.get()).asItem().getDefaultInstance(), CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.insertAfter(((SlabBlock)NSBlocks.LIGHT_GRAY_CHALK_SLAB.get()).asItem().getDefaultInstance(), ((SlabBlock)NSBlocks.GRAY_CHALK_SLAB.get()).asItem().getDefaultInstance(), CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.insertAfter(((SlabBlock)NSBlocks.GRAY_CHALK_SLAB.get()).asItem().getDefaultInstance(), ((SlabBlock)NSBlocks.BLACK_CHALK_SLAB.get()).asItem().getDefaultInstance(), CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.insertAfter(((SlabBlock)NSBlocks.BLACK_CHALK_SLAB.get()).asItem().getDefaultInstance(), ((SlabBlock)NSBlocks.BROWN_CHALK_SLAB.get()).asItem().getDefaultInstance(), CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.insertAfter(((SlabBlock)NSBlocks.BROWN_CHALK_SLAB.get()).asItem().getDefaultInstance(), ((SlabBlock)NSBlocks.RED_CHALK_SLAB.get()).asItem().getDefaultInstance(), CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.insertAfter(((SlabBlock)NSBlocks.RED_CHALK_SLAB.get()).asItem().getDefaultInstance(), ((SlabBlock)NSBlocks.ORANGE_CHALK_SLAB.get()).asItem().getDefaultInstance(), CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.insertAfter(((SlabBlock)NSBlocks.ORANGE_CHALK_SLAB.get()).asItem().getDefaultInstance(), ((SlabBlock)NSBlocks.YELLOW_CHALK_SLAB.get()).asItem().getDefaultInstance(), CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.insertAfter(((SlabBlock)NSBlocks.YELLOW_CHALK_SLAB.get()).asItem().getDefaultInstance(), ((SlabBlock)NSBlocks.LIME_CHALK_SLAB.get()).asItem().getDefaultInstance(), CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.insertAfter(((SlabBlock)NSBlocks.LIME_CHALK_SLAB.get()).asItem().getDefaultInstance(), ((SlabBlock)NSBlocks.GREEN_CHALK_SLAB.get()).asItem().getDefaultInstance(), CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.insertAfter(((SlabBlock)NSBlocks.GREEN_CHALK_SLAB.get()).asItem().getDefaultInstance(), ((SlabBlock)NSBlocks.CYAN_CHALK_SLAB.get()).asItem().getDefaultInstance(), CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.insertAfter(((SlabBlock)NSBlocks.CYAN_CHALK_SLAB.get()).asItem().getDefaultInstance(), ((SlabBlock)NSBlocks.LIGHT_BLUE_CHALK_SLAB.get()).asItem().getDefaultInstance(), CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.insertAfter(((SlabBlock)NSBlocks.LIGHT_BLUE_CHALK_SLAB.get()).asItem().getDefaultInstance(), ((SlabBlock)NSBlocks.BLUE_CHALK_SLAB.get()).asItem().getDefaultInstance(), CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.insertAfter(((SlabBlock)NSBlocks.BLUE_CHALK_SLAB.get()).asItem().getDefaultInstance(), ((SlabBlock)NSBlocks.PURPLE_CHALK_SLAB.get()).asItem().getDefaultInstance(), CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.insertAfter(((SlabBlock)NSBlocks.PURPLE_CHALK_SLAB.get()).asItem().getDefaultInstance(), ((SlabBlock)NSBlocks.MAGENTA_CHALK_SLAB.get()).asItem().getDefaultInstance(), CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.insertAfter(((SlabBlock)NSBlocks.MAGENTA_CHALK_SLAB.get()).asItem().getDefaultInstance(), ((SlabBlock)NSBlocks.PINK_CHALK_SLAB.get()).asItem().getDefaultInstance(), CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.insertAfter(Items.PINK_CANDLE.getDefaultInstance(), ((PaperLanternBlock)((Object)NSBlocks.WHITE_PAPER_LANTERN.get())).asItem().getDefaultInstance(), CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.insertAfter(((PaperLanternBlock)((Object)NSBlocks.WHITE_PAPER_LANTERN.get())).asItem().getDefaultInstance(), ((PaperLanternBlock)((Object)NSBlocks.LIGHT_GRAY_PAPER_LANTERN.get())).asItem().getDefaultInstance(), CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.insertAfter(((PaperLanternBlock)((Object)NSBlocks.LIGHT_GRAY_PAPER_LANTERN.get())).asItem().getDefaultInstance(), ((PaperLanternBlock)((Object)NSBlocks.GRAY_PAPER_LANTERN.get())).asItem().getDefaultInstance(), CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.insertAfter(((PaperLanternBlock)((Object)NSBlocks.GRAY_PAPER_LANTERN.get())).asItem().getDefaultInstance(), ((PaperLanternBlock)((Object)NSBlocks.BLACK_PAPER_LANTERN.get())).asItem().getDefaultInstance(), CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.insertAfter(((PaperLanternBlock)((Object)NSBlocks.BLACK_PAPER_LANTERN.get())).asItem().getDefaultInstance(), ((PaperLanternBlock)((Object)NSBlocks.BROWN_PAPER_LANTERN.get())).asItem().getDefaultInstance(), CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.insertAfter(((PaperLanternBlock)((Object)NSBlocks.BROWN_PAPER_LANTERN.get())).asItem().getDefaultInstance(), ((PaperLanternBlock)((Object)NSBlocks.RED_PAPER_LANTERN.get())).asItem().getDefaultInstance(), CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.insertAfter(((PaperLanternBlock)((Object)NSBlocks.RED_PAPER_LANTERN.get())).asItem().getDefaultInstance(), ((PaperLanternBlock)((Object)NSBlocks.ORANGE_PAPER_LANTERN.get())).asItem().getDefaultInstance(), CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.insertAfter(((PaperLanternBlock)((Object)NSBlocks.ORANGE_PAPER_LANTERN.get())).asItem().getDefaultInstance(), ((PaperLanternBlock)((Object)NSBlocks.YELLOW_PAPER_LANTERN.get())).asItem().getDefaultInstance(), CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.insertAfter(((PaperLanternBlock)((Object)NSBlocks.YELLOW_PAPER_LANTERN.get())).asItem().getDefaultInstance(), ((PaperLanternBlock)((Object)NSBlocks.LIME_PAPER_LANTERN.get())).asItem().getDefaultInstance(), CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.insertAfter(((PaperLanternBlock)((Object)NSBlocks.LIME_PAPER_LANTERN.get())).asItem().getDefaultInstance(), ((PaperLanternBlock)((Object)NSBlocks.GREEN_PAPER_LANTERN.get())).asItem().getDefaultInstance(), CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.insertAfter(((PaperLanternBlock)((Object)NSBlocks.GREEN_PAPER_LANTERN.get())).asItem().getDefaultInstance(), ((PaperLanternBlock)((Object)NSBlocks.CYAN_PAPER_LANTERN.get())).asItem().getDefaultInstance(), CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.insertAfter(((PaperLanternBlock)((Object)NSBlocks.CYAN_PAPER_LANTERN.get())).asItem().getDefaultInstance(), ((PaperLanternBlock)((Object)NSBlocks.LIGHT_BLUE_PAPER_LANTERN.get())).asItem().getDefaultInstance(), CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.insertAfter(((PaperLanternBlock)((Object)NSBlocks.LIGHT_BLUE_PAPER_LANTERN.get())).asItem().getDefaultInstance(), ((PaperLanternBlock)((Object)NSBlocks.BLUE_PAPER_LANTERN.get())).asItem().getDefaultInstance(), CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.insertAfter(((PaperLanternBlock)((Object)NSBlocks.BLUE_PAPER_LANTERN.get())).asItem().getDefaultInstance(), ((PaperLanternBlock)((Object)NSBlocks.PURPLE_PAPER_LANTERN.get())).asItem().getDefaultInstance(), CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.insertAfter(((PaperLanternBlock)((Object)NSBlocks.PURPLE_PAPER_LANTERN.get())).asItem().getDefaultInstance(), ((PaperLanternBlock)((Object)NSBlocks.MAGENTA_PAPER_LANTERN.get())).asItem().getDefaultInstance(), CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.insertAfter(((PaperLanternBlock)((Object)NSBlocks.MAGENTA_PAPER_LANTERN.get())).asItem().getDefaultInstance(), ((PaperLanternBlock)((Object)NSBlocks.PINK_PAPER_LANTERN.get())).asItem().getDefaultInstance(), CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            if (ModList.get().isLoaded("arts_and_crafts")) {
                event.insertBefore(((Block)NSBlocks.WHITE_CHALK.get()).asItem().getDefaultInstance(), ((Block)NSArtsAndCraftsCompat.BLEACHED_CHALK.get()).asItem().getDefaultInstance(), CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
                event.insertBefore(((StairBlock)NSBlocks.WHITE_CHALK_STAIRS.get()).asItem().getDefaultInstance(), ((StairBlock)NSArtsAndCraftsCompat.BLEACHED_CHALK_STAIRS.get()).asItem().getDefaultInstance(), CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
                event.insertBefore(((SlabBlock)NSBlocks.WHITE_CHALK_SLAB.get()).asItem().getDefaultInstance(), ((SlabBlock)NSArtsAndCraftsCompat.BLEACHED_CHALK_SLAB.get()).asItem().getDefaultInstance(), CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            }
        }
        if (event.getTabKey() == CreativeModeTabs.INGREDIENTS) {
            event.insertAfter(Items.AMETHYST_SHARD.getDefaultInstance(), ((Item)NSBlocks.CALCITE_SHARD.get()).getDefaultInstance(), CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.insertAfter(Items.HONEYCOMB.getDefaultInstance(), ((Item)NSBlocks.CHALK_POWDER.get()).getDefaultInstance(), CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.insertAfter(Items.BOWL.getDefaultInstance(), ((Item)NSBlocks.COCONUT_SHELL.get()).getDefaultInstance(), CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
        }
        if (event.getTabKey() == CreativeModeTabs.FOOD_AND_DRINKS) {
            event.insertAfter(Items.BEETROOT.getDefaultInstance(), ((CoconutHalfItem)((Object)NSBlocks.COCONUT_HALF.get())).getDefaultInstance(), CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.insertAfter(((CoconutHalfItem)((Object)NSBlocks.COCONUT_HALF.get())).getDefaultInstance(), ((DesertTurnipItem)((Object)NSBlocks.DESERT_TURNIP.get())).getDefaultInstance(), CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.insertAfter(((DesertTurnipItem)((Object)NSBlocks.DESERT_TURNIP.get())).getDefaultInstance(), ((Item)NSBlocks.OLIVES.get()).getDefaultInstance(), CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.insertAfter(Items.BREAD.getDefaultInstance(), ((PizzaItem)((Object)NSBlocks.WHOLE_PIZZA.get())).getDefaultInstance(), CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.insertAfter(Items.MILK_BUCKET.getDefaultInstance(), ((SolidBucketItem)NSBlocks.CHEESE_BUCKET.get()).getDefaultInstance(), CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
        }
    }

    public static void addAllAfterFirst(BuildCreativeModeTabContentsEvent event, ArrayList<ItemLike> itemStacks, CreativeModeTab.TabVisibility tabVisibility) {
        for (int i = 1; i < itemStacks.size(); ++i) {
            event.insertAfter(itemStacks.get(i - 1).asItem().getDefaultInstance(), itemStacks.get(i).asItem().getDefaultInstance(), tabVisibility);
        }
    }

    public void addPackFinders(AddPackFindersEvent event) {
        if (ModList.get().isLoaded("arts_and_crafts")) {
            event.addPackFinders(ResourceLocation.fromNamespaceAndPath((String)MOD_ID, (String)"resourcepacks/arts_and_crafts_res"), PackType.CLIENT_RESOURCES, (Component)Component.translatable((String)"pack.natures_spirit.arts_and_crafts"), PackSource.BUILT_IN, true, Pack.Position.TOP);
            event.addPackFinders(ResourceLocation.fromNamespaceAndPath((String)MOD_ID, (String)"resourcepacks/arts_and_crafts_dat"), PackType.SERVER_DATA, (Component)Component.translatable((String)"pack.natures_spirit.arts_and_crafts"), PackSource.BUILT_IN, true, Pack.Position.TOP);
        }
        event.addPackFinders(ResourceLocation.fromNamespaceAndPath((String)MOD_ID, (String)"resourcepacks/plank_consistency"), PackType.CLIENT_RESOURCES, (Component)Component.translatable((String)"pack.natures_spirit.plank_consistency"), PackSource.FEATURE, false, Pack.Position.TOP);
        event.addPackFinders(ResourceLocation.fromNamespaceAndPath((String)MOD_ID, (String)"resourcepacks/emissive_ores_compatibility"), PackType.CLIENT_RESOURCES, (Component)Component.translatable((String)"pack.natures_spirit.emissive_ores_compatibility"), PackSource.FEATURE, false, Pack.Position.TOP);
        if (NSConfig.badlandsToggle) {
            event.addPackFinders(ResourceLocation.fromNamespaceAndPath((String)MOD_ID, (String)"resourcepacks/modified_badlands"), PackType.SERVER_DATA, (Component)Component.translatable((String)"pack.natures_spirit.modified_badlands"), PackSource.BUILT_IN, true, Pack.Position.TOP);
        }
        if (NSConfig.birchForestToggle) {
            event.addPackFinders(ResourceLocation.fromNamespaceAndPath((String)MOD_ID, (String)"resourcepacks/modified_birch_forest"), PackType.SERVER_DATA, (Component)Component.translatable((String)"pack.natures_spirit.modified_birch_forest"), PackSource.BUILT_IN, true, Pack.Position.TOP);
        }
        if (NSConfig.darkForestToggle) {
            event.addPackFinders(ResourceLocation.fromNamespaceAndPath((String)MOD_ID, (String)"resourcepacks/modified_dark_forest"), PackType.SERVER_DATA, (Component)Component.translatable((String)"pack.natures_spirit.modified_dark_forest"), PackSource.BUILT_IN, true, Pack.Position.TOP);
        }
        if (NSConfig.desertToggle) {
            event.addPackFinders(ResourceLocation.fromNamespaceAndPath((String)MOD_ID, (String)"resourcepacks/modified_desert"), PackType.SERVER_DATA, (Component)Component.translatable((String)"pack.natures_spirit.modified_desert"), PackSource.BUILT_IN, true, Pack.Position.TOP);
        }
        if (NSConfig.flowerForestToggle) {
            event.addPackFinders(ResourceLocation.fromNamespaceAndPath((String)MOD_ID, (String)"resourcepacks/modified_flower_forest"), PackType.SERVER_DATA, (Component)Component.translatable((String)"pack.natures_spirit.modified_flower_forest"), PackSource.BUILT_IN, true, Pack.Position.TOP);
        }
        if (NSConfig.jungleToggle) {
            event.addPackFinders(ResourceLocation.fromNamespaceAndPath((String)MOD_ID, (String)"resourcepacks/modified_jungle"), PackType.SERVER_DATA, (Component)Component.translatable((String)"pack.natures_spirit.modified_jungle"), PackSource.BUILT_IN, true, Pack.Position.TOP);
        }
        if (NSConfig.mountainBiomesToggle) {
            event.addPackFinders(ResourceLocation.fromNamespaceAndPath((String)MOD_ID, (String)"resourcepacks/modified_mountain_biomes"), PackType.SERVER_DATA, (Component)Component.translatable((String)"pack.natures_spirit.modified_mountain_biomes"), PackSource.BUILT_IN, true, Pack.Position.TOP);
        }
        if (NSConfig.savannaToggle) {
            event.addPackFinders(ResourceLocation.fromNamespaceAndPath((String)MOD_ID, (String)"resourcepacks/modified_savannas"), PackType.SERVER_DATA, (Component)Component.translatable((String)"pack.natures_spirit.modified_savannas"), PackSource.BUILT_IN, true, Pack.Position.TOP);
        }
        if (NSConfig.swampToggle) {
            event.addPackFinders(ResourceLocation.fromNamespaceAndPath((String)MOD_ID, (String)"resourcepacks/modified_swamp"), PackType.SERVER_DATA, (Component)Component.translatable((String)"pack.natures_spirit.modified_swamp"), PackSource.BUILT_IN, true, Pack.Position.TOP);
        }
        if (NSConfig.vanillaTreesToggle) {
            event.addPackFinders(ResourceLocation.fromNamespaceAndPath((String)MOD_ID, (String)"resourcepacks/modified_vanilla_trees"), PackType.SERVER_DATA, (Component)Component.translatable((String)"pack.natures_spirit.modified_vanilla_trees"), PackSource.BUILT_IN, false, Pack.Position.TOP);
        }
        if (NSConfig.windsweptHillsToggle) {
            event.addPackFinders(ResourceLocation.fromNamespaceAndPath((String)MOD_ID, (String)"resourcepacks/modified_windswept_hills"), PackType.SERVER_DATA, (Component)Component.translatable((String)"pack.natures_spirit.modified_windswept_hills"), PackSource.BUILT_IN, true, Pack.Position.TOP);
        }
    }
}

