/*
 * Decompiled with CFR 0.152.
 */
package moe.kfn.figuraextrabone.imp;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import java.util.ArrayList;
import java.util.UUID;
import org.figuramc.figura.math.vector.FiguraVec3;
import org.figuramc.figura.math.vector.FiguraVec4;
import org.figuramc.figura.math.vector.FiguraVector;
import org.figuramc.figura.model.ParentType;

public class BlockBenchModelEx {
    private static final String VERSION = "4.9";
    private final JsonObject root = new JsonObject();
    private final ArrayList<Cube> elements = new ArrayList();
    private final ArrayList<Element> outliner = new ArrayList();
    private final JsonArray textures = new JsonArray();

    public BlockBenchModelEx(String format) {
        JsonObject meta = new JsonObject();
        meta.addProperty("format_version", VERSION);
        meta.addProperty("model_format", format);
        this.root.add("meta", (JsonElement)meta);
    }

    public void setResolution(int w, int h) {
        JsonObject resolution = new JsonObject();
        resolution.addProperty("width", (Number)w);
        resolution.addProperty("height", (Number)h);
        this.root.add("resolution", (JsonElement)resolution);
    }

    public int addImage(String name, String source, int width, int height) {
        int id = this.textures.size();
        JsonObject texture = new JsonObject();
        texture.addProperty("name", name);
        texture.addProperty("id", String.valueOf(id));
        texture.addProperty("source", "data:image/png;base64," + source);
        texture.addProperty("width", (Number)width);
        texture.addProperty("height", (Number)height);
        texture.addProperty("uv_width", (Number)width);
        texture.addProperty("uv_height", (Number)height);
        this.textures.add((JsonElement)texture);
        return id;
    }

    public Group addGroup(String name, FiguraVec3 pivot) {
        return this.addGroup(name, pivot, null);
    }

    public Group addGroup(String name, FiguraVec3 pivot, Group parent) {
        Group g = new Group(name, pivot);
        this.addElement(g, parent);
        return g;
    }

    public Group addGroup(ParentType type, FiguraVec3 pivot, Group parent) {
        return this.addGroup(type.name(), pivot, parent);
    }

    public Cube addCube(FiguraVec3 position, FiguraVec3 size, Group parent) {
        return this.addCube(parent == null ? "cube" : parent.getName(), position, size, parent);
    }

    public Cube addCube(String name, FiguraVec3 position, FiguraVec3 size, Group parent) {
        return this.addCube(name, parent == null ? (FiguraVec3)position.plus((FiguraVector)((FiguraVec3)size.scaled(0.5))) : parent.getPivot(), position, size, parent);
    }

    public Cube addCube(String name, FiguraVec3 pivot, FiguraVec3 position, FiguraVec3 size, Group parent) {
        Cube c = new Cube(name, pivot, position, size);
        this.addElement(c, parent);
        return c;
    }

    public void addElement(Element element, Group parent) {
        if (element instanceof Cube) {
            Cube cube = (Cube)element;
            this.elements.add(cube);
        }
        if (parent == null) {
            this.outliner.add(element);
        } else {
            parent.addChild(element);
        }
    }

    public JsonObject build() {
        JsonArray elements = new JsonArray();
        for (Cube cube : this.elements) {
            elements.add((JsonElement)cube.build());
        }
        JsonArray outliner = new JsonArray();
        for (Element element : this.outliner) {
            outliner.add(element.outliner());
        }
        this.root.add("elements", (JsonElement)elements);
        this.root.add("outliner", (JsonElement)outliner);
        this.root.add("textures", (JsonElement)this.textures);
        return this.root;
    }

    private static JsonArray vec3ToJson(FiguraVec3 vec) {
        JsonArray json = new JsonArray();
        json.add((Number)vec.x);
        json.add((Number)vec.y);
        json.add((Number)vec.z);
        return json;
    }

    private static JsonArray vec4ToJson(FiguraVec4 vec) {
        JsonArray json = new JsonArray();
        json.add((Number)vec.x);
        json.add((Number)vec.y);
        json.add((Number)vec.z);
        json.add((Number)vec.w);
        return json;
    }

    public static class Group
    extends Element {
        private final ArrayList<Element> children = new ArrayList();

        public Group(String name, FiguraVec3 pivot) {
            super(name, pivot);
        }

        @Override
        public JsonObject build() {
            JsonArray children = new JsonArray();
            for (Element element : this.children) {
                children.add(element.outliner());
            }
            JsonObject group = super.build();
            group.addProperty("isOpen", Boolean.valueOf(true));
            group.add("children", (JsonElement)children);
            return group;
        }

        @Override
        public JsonElement outliner() {
            return this.build();
        }

        public void addChild(Element element) {
            this.children.add(element);
        }
    }

    private static abstract class Element {
        protected final UUID uuid;
        protected final String name;
        protected final FiguraVec3 pivot;

        public Element(String name, FiguraVec3 pivot) {
            this.name = name;
            this.uuid = UUID.randomUUID();
            this.pivot = pivot;
        }

        public JsonObject build() {
            JsonObject element = new JsonObject();
            element.addProperty("name", this.name);
            element.addProperty("uuid", this.uuid.toString());
            element.add("origin", (JsonElement)BlockBenchModelEx.vec3ToJson(this.pivot));
            return element;
        }

        public JsonElement outliner() {
            return new JsonPrimitive(this.uuid.toString());
        }

        public String getName() {
            return this.name;
        }

        public FiguraVec3 getPivot() {
            return this.pivot;
        }
    }

    public static class Cube
    extends Element {
        private final JsonObject faces = new JsonObject();
        private final FiguraVec3 position;
        private final FiguraVec3 size;
        public double inflate;

        public Cube(String name, FiguraVec3 pivot, FiguraVec3 position, FiguraVec3 size) {
            super(name, pivot);
            this.position = position;
            this.size = size;
        }

        @Override
        public JsonObject build() {
            JsonObject cube = super.build();
            cube.add("from", (JsonElement)BlockBenchModelEx.vec3ToJson(this.position));
            cube.add("to", (JsonElement)BlockBenchModelEx.vec3ToJson((FiguraVec3)this.position.plus((FiguraVector)this.size)));
            cube.addProperty("inflate", (Number)this.inflate);
            cube.add("faces", (JsonElement)this.faces);
            return cube;
        }

        public void addFace(String direction, FiguraVec4 uv, int texture, double scaleW, double scaleH) {
            this.addFace(direction, uv, texture, false, false, scaleW, scaleH);
        }

        public void addFace(String direction, FiguraVec4 uv, int texture, boolean mirrorW, boolean mirrorH, double scaleW, double scaleH) {
            if (Math.signum(scaleW) < 0.0) {
                boolean bl = mirrorW = !mirrorW;
            }
            if (Math.signum(scaleH) < 0.0) {
                boolean bl = mirrorH = !mirrorH;
            }
            if (mirrorW) {
                uv.set(uv.z, uv.y, uv.x, uv.w);
            }
            if (mirrorH) {
                uv.set(uv.x, uv.w, uv.z, uv.y);
            }
            scaleW = Math.abs(scaleW);
            scaleH = Math.abs(scaleH);
            uv.multiply(scaleW, scaleH, scaleW, scaleH);
            JsonObject face = new JsonObject();
            face.add("uv", (JsonElement)BlockBenchModelEx.vec4ToJson(uv));
            face.addProperty("texture", (Number)texture);
            this.faces.add(direction, (JsonElement)face);
        }

        public void generateBoxFaces(double x, double y, int texture) {
            this.generateBoxFaces(x, y, texture, 1.0, 1.0);
        }

        public void generateBoxFaces(double x, double y, int texture, int type) {
            this.generateBoxFaces(x, y, texture, 1.0, 1.0, type);
        }

        public void generateBoxFaces(double x, double y, int texture, double scaleW, double scaleH, int type) {
            String t;
            String[] faces = new String[]{"up", "down", "east", "north", "west", "south"};
            if (Math.signum(scaleW) < 0.0) {
                t = faces[2];
                faces[2] = faces[4];
                faces[4] = t;
            }
            if (Math.signum(scaleH) < 0.0) {
                t = faces[0];
                faces[0] = faces[1];
                faces[1] = t;
            }
            if (type == 0) {
                this.addFace(faces[0], FiguraVec4.of((double)(x + this.size.z), (double)y, (double)(x + this.size.z + this.size.x), (double)(y + this.size.z)), texture, true, true, scaleW, scaleH);
                this.addFace(faces[1], FiguraVec4.of((double)(x + this.size.z + this.size.x + 4.0), (double)y, (double)(x + this.size.z + this.size.x + this.size.x + 4.0), (double)(y + this.size.z)), texture, true, false, scaleW, scaleH);
            }
            if (type == 1) {
                this.addFace(faces[0], FiguraVec4.of((double)(x + this.size.z - 4.0), (double)(y - 6.0), (double)(x + this.size.z + this.size.x - 4.0), (double)(y - 6.0 + this.size.z)), texture, true, true, scaleW, scaleH);
                this.addFace(faces[1], FiguraVec4.of((double)(x + this.size.z + this.size.x), (double)(y - 6.0), (double)(x + this.size.z + this.size.x + this.size.x), (double)(y - 6.0 + this.size.z)), texture, true, false, scaleW, scaleH);
            }
            if (type == 2) {
                this.addFace(faces[0], FiguraVec4.of((double)(x + this.size.z - 4.0), (double)(y - 6.0), (double)(x + this.size.z + this.size.x - 8.0), (double)(y - 6.0 + this.size.z)), texture, true, true, scaleW, scaleH);
                this.addFace(faces[1], FiguraVec4.of((double)(x + this.size.z + this.size.x), (double)(y - 6.0), (double)(x + this.size.z + this.size.x + this.size.x), (double)(y - 6.0 + this.size.z)), texture, true, false, scaleW, scaleH);
            }
            if (type == 3) {
                this.addFace(faces[0], FiguraVec4.of((double)(x + this.size.z), (double)y, (double)(x + this.size.z + this.size.x), (double)(y + this.size.z)), texture, true, true, scaleW, scaleH);
                this.addFace(faces[1], FiguraVec4.of((double)(x + this.size.z + this.size.x + 8.0), (double)y, (double)(x + this.size.z + this.size.x + this.size.x + 4.0), (double)(y + this.size.z)), texture, true, false, scaleW, scaleH);
            }
            this.addFace(faces[2], FiguraVec4.of((double)x, (double)(y + this.size.z), (double)(x + this.size.z), (double)(y + this.size.z + this.size.y)), texture, scaleW, scaleH);
            this.addFace(faces[3], FiguraVec4.of((double)(x + this.size.z), (double)(y + this.size.z), (double)(x + this.size.z + this.size.x), (double)(y + this.size.z + this.size.y)), texture, scaleW, scaleH);
            this.addFace(faces[4], FiguraVec4.of((double)(x + this.size.z + this.size.x), (double)(y + this.size.z), (double)(x + this.size.z + this.size.x + this.size.z), (double)(y + this.size.z + this.size.y)), texture, scaleW, scaleH);
            this.addFace(faces[5], FiguraVec4.of((double)(x + this.size.z + this.size.x + this.size.z), (double)(y + this.size.z), (double)(x + this.size.z + this.size.x + this.size.z + this.size.x), (double)(y + this.size.z + this.size.y)), texture, scaleW, scaleH);
        }

        public void generateBoxFaces(double x, double y, int texture, double scaleW, double scaleH) {
            String t;
            String[] faces = new String[]{"up", "down", "east", "north", "west", "south"};
            if (Math.signum(scaleW) < 0.0) {
                t = faces[2];
                faces[2] = faces[4];
                faces[4] = t;
            }
            if (Math.signum(scaleH) < 0.0) {
                t = faces[0];
                faces[0] = faces[1];
                faces[1] = t;
            }
            this.addFace(faces[0], FiguraVec4.of((double)(x + this.size.z), (double)y, (double)(x + this.size.z + this.size.x), (double)(y + this.size.z)), texture, true, true, scaleW, scaleH);
            this.addFace(faces[1], FiguraVec4.of((double)(x + this.size.z + this.size.x), (double)y, (double)(x + this.size.z + this.size.x + this.size.x), (double)(y + this.size.z)), texture, true, false, scaleW, scaleH);
            this.addFace(faces[2], FiguraVec4.of((double)x, (double)(y + this.size.z), (double)(x + this.size.z), (double)(y + this.size.z + this.size.y)), texture, scaleW, scaleH);
            this.addFace(faces[3], FiguraVec4.of((double)(x + this.size.z), (double)(y + this.size.z), (double)(x + this.size.z + this.size.x), (double)(y + this.size.z + this.size.y)), texture, scaleW, scaleH);
            this.addFace(faces[4], FiguraVec4.of((double)(x + this.size.z + this.size.x), (double)(y + this.size.z), (double)(x + this.size.z + this.size.x + this.size.z), (double)(y + this.size.z + this.size.y)), texture, scaleW, scaleH);
            this.addFace(faces[5], FiguraVec4.of((double)(x + this.size.z + this.size.x + this.size.z), (double)(y + this.size.z), (double)(x + this.size.z + this.size.x + this.size.z + this.size.x), (double)(y + this.size.z + this.size.y)), texture, scaleW, scaleH);
        }
    }
}

