/*
 * Decompiled with CFR 0.152.
 */
package guideme.internal.shaded.lucene.index;

import guideme.internal.shaded.lucene.codecs.DocValuesConsumer;
import guideme.internal.shaded.lucene.codecs.DocValuesProducer;
import guideme.internal.shaded.lucene.index.DocValuesWriter;
import guideme.internal.shaded.lucene.index.DocsWithFieldSet;
import guideme.internal.shaded.lucene.index.EmptyDocValuesProducer;
import guideme.internal.shaded.lucene.index.FieldInfo;
import guideme.internal.shaded.lucene.index.NumericDocValues;
import guideme.internal.shaded.lucene.index.SegmentWriteState;
import guideme.internal.shaded.lucene.index.Sorter;
import guideme.internal.shaded.lucene.search.DocIdSetIterator;
import guideme.internal.shaded.lucene.util.BitSet;
import guideme.internal.shaded.lucene.util.Counter;
import guideme.internal.shaded.lucene.util.FixedBitSet;
import guideme.internal.shaded.lucene.util.packed.PackedLongValues;
import java.io.IOException;

class NumericDocValuesWriter
extends DocValuesWriter<NumericDocValues> {
    private final PackedLongValues.Builder pending = PackedLongValues.deltaPackedBuilder(0.0f);
    private PackedLongValues finalValues;
    private final Counter iwBytesUsed;
    private long bytesUsed;
    private DocsWithFieldSet docsWithField = new DocsWithFieldSet();
    private final FieldInfo fieldInfo;
    private int lastDocID = -1;

    NumericDocValuesWriter(FieldInfo fieldInfo, Counter iwBytesUsed) {
        this.bytesUsed = this.pending.ramBytesUsed() + this.docsWithField.ramBytesUsed();
        this.fieldInfo = fieldInfo;
        this.iwBytesUsed = iwBytesUsed;
        iwBytesUsed.addAndGet(this.bytesUsed);
    }

    public void addValue(int docID, long value) {
        if (docID <= this.lastDocID) {
            throw new IllegalArgumentException("DocValuesField \"" + this.fieldInfo.name + "\" appears more than once in this document (only one value is allowed per field)");
        }
        this.pending.add(value);
        this.docsWithField.add(docID);
        this.updateBytesUsed();
        this.lastDocID = docID;
    }

    private void updateBytesUsed() {
        long newBytesUsed = this.pending.ramBytesUsed() + this.docsWithField.ramBytesUsed();
        this.iwBytesUsed.addAndGet(newBytesUsed - this.bytesUsed);
        this.bytesUsed = newBytesUsed;
    }

    @Override
    NumericDocValues getDocValues() {
        if (this.finalValues == null) {
            this.finalValues = this.pending.build();
        }
        return new BufferedNumericDocValues(this.finalValues, this.docsWithField.iterator());
    }

    static NumericDVs sortDocValues(int maxDoc, Sorter.DocMap sortMap, NumericDocValues oldDocValues, boolean dense) throws IOException {
        int docID;
        FixedBitSet docsWithField = null;
        if (!dense) {
            docsWithField = new FixedBitSet(maxDoc);
        }
        long[] values = new long[maxDoc];
        while ((docID = oldDocValues.nextDoc()) != Integer.MAX_VALUE) {
            int newDocID = sortMap.oldToNew(docID);
            if (docsWithField != null) {
                docsWithField.set(newDocID);
            }
            values[newDocID] = oldDocValues.longValue();
        }
        return new NumericDVs(values, docsWithField);
    }

    @Override
    public void flush(SegmentWriteState state, Sorter.DocMap sortMap, DocValuesConsumer dvConsumer) throws IOException {
        if (this.finalValues == null) {
            this.finalValues = this.pending.build();
        }
        dvConsumer.addNumericField(this.fieldInfo, NumericDocValuesWriter.getDocValuesProducer(this.fieldInfo, this.finalValues, this.docsWithField, sortMap));
    }

    static DocValuesProducer getDocValuesProducer(final FieldInfo writerFieldInfo, final PackedLongValues values, final DocsWithFieldSet docsWithField, Sorter.DocMap sortMap) throws IOException {
        NumericDVs sorted;
        if (sortMap != null) {
            BufferedNumericDocValues oldValues = new BufferedNumericDocValues(values, docsWithField.iterator());
            sorted = NumericDocValuesWriter.sortDocValues(sortMap.size(), sortMap, oldValues, sortMap.size() == docsWithField.cardinality());
        } else {
            sorted = null;
        }
        return new EmptyDocValuesProducer(){

            @Override
            public NumericDocValues getNumeric(FieldInfo fieldInfo) {
                if (fieldInfo != writerFieldInfo) {
                    throw new IllegalArgumentException("wrong fieldInfo");
                }
                if (sorted == null) {
                    return new BufferedNumericDocValues(values, docsWithField.iterator());
                }
                return new SortingNumericDocValues(sorted);
            }
        };
    }

    static class BufferedNumericDocValues
    extends NumericDocValues {
        final PackedLongValues.Iterator iter;
        final DocIdSetIterator docsWithField;
        private long value;

        BufferedNumericDocValues(PackedLongValues values, DocIdSetIterator docsWithFields) {
            this.iter = values.iterator();
            this.docsWithField = docsWithFields;
        }

        @Override
        public int docID() {
            return this.docsWithField.docID();
        }

        @Override
        public int nextDoc() throws IOException {
            int docID = this.docsWithField.nextDoc();
            if (docID != Integer.MAX_VALUE) {
                this.value = this.iter.next();
            }
            return docID;
        }

        @Override
        public int advance(int target) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean advanceExact(int target) throws IOException {
            throw new UnsupportedOperationException();
        }

        @Override
        public long cost() {
            return this.docsWithField.cost();
        }

        @Override
        public long longValue() {
            return this.value;
        }
    }

    static class NumericDVs {
        private final long[] values;
        private final BitSet docsWithField;
        private final int maxDoc;

        NumericDVs(long[] values, BitSet docsWithField) {
            this.values = values;
            this.docsWithField = docsWithField;
            this.maxDoc = values.length;
        }

        int maxDoc() {
            return this.maxDoc;
        }

        private boolean advanceExact(int target) {
            if (this.docsWithField != null) {
                return this.docsWithField.get(target);
            }
            return true;
        }

        private int advance(int target) {
            if (this.docsWithField != null) {
                return this.docsWithField.nextSetBit(target);
            }
            return target;
        }

        private long cost() {
            if (this.docsWithField != null) {
                return this.docsWithField.cardinality();
            }
            return this.maxDoc;
        }
    }

    static class SortingNumericDocValues
    extends NumericDocValues {
        private final NumericDVs dvs;
        private int docID = -1;
        private long cost = -1L;

        SortingNumericDocValues(NumericDVs dvs) {
            this.dvs = dvs;
        }

        @Override
        public int docID() {
            return this.docID;
        }

        @Override
        public int nextDoc() {
            this.docID = this.docID + 1 == this.dvs.maxDoc() ? Integer.MAX_VALUE : this.dvs.advance(this.docID + 1);
            return this.docID;
        }

        @Override
        public int advance(int target) {
            throw new UnsupportedOperationException("use nextDoc() instead");
        }

        @Override
        public boolean advanceExact(int target) throws IOException {
            this.docID = target;
            return this.dvs.advanceExact(target);
        }

        @Override
        public long longValue() {
            return this.dvs.values[this.docID];
        }

        @Override
        public long cost() {
            if (this.cost == -1L) {
                this.cost = this.dvs.cost();
            }
            return this.cost;
        }
    }
}

