/*
 * Decompiled with CFR 0.152.
 */
package guideme.internal.shaded.lucene.index;

import guideme.internal.shaded.lucene.index.CodecReader;
import guideme.internal.shaded.lucene.index.CorruptIndexException;
import guideme.internal.shaded.lucene.index.FieldInfos;
import guideme.internal.shaded.lucene.index.IndexSorter;
import guideme.internal.shaded.lucene.index.LeafMetaData;
import guideme.internal.shaded.lucene.index.MergeState;
import guideme.internal.shaded.lucene.index.NumericDocValues;
import guideme.internal.shaded.lucene.search.Sort;
import guideme.internal.shaded.lucene.search.SortField;
import guideme.internal.shaded.lucene.util.BitSet;
import guideme.internal.shaded.lucene.util.Bits;
import guideme.internal.shaded.lucene.util.PriorityQueue;
import guideme.internal.shaded.lucene.util.Version;
import guideme.internal.shaded.lucene.util.packed.PackedLongValues;
import java.io.IOException;
import java.util.List;

final class MultiSorter {
    MultiSorter() {
    }

    static MergeState.DocMap[] sort(Sort sort, List<CodecReader> readers) throws IOException {
        SortField[] fields = sort.getSort();
        final IndexSorter.ComparableProvider[][] comparables = new IndexSorter.ComparableProvider[fields.length][];
        final int[] reverseMuls = new int[fields.length];
        for (int i = 0; i < fields.length; ++i) {
            IndexSorter sorter = fields[i].getIndexSorter();
            if (sorter == null) {
                throw new IllegalArgumentException("Cannot use sort field " + String.valueOf(fields[i]) + " for index sorting");
            }
            comparables[i] = sorter.getComparableProviders(readers);
            for (int j = 0; j < readers.size(); ++j) {
                CodecReader codecReader = readers.get(j);
                FieldInfos fieldInfos = codecReader.getFieldInfos();
                LeafMetaData metaData = codecReader.getMetaData();
                if (metaData.hasBlocks() && fieldInfos.getParentField() != null) {
                    NumericDocValues parentDocs = codecReader.getNumericDocValues(fieldInfos.getParentField());
                    assert (parentDocs != null) : "parent field: " + fieldInfos.getParentField() + " must be present if index sorting is used with blocks";
                    BitSet parents = BitSet.of(parentDocs, codecReader.maxDoc());
                    IndexSorter.ComparableProvider[] providers = comparables[i];
                    IndexSorter.ComparableProvider provider = providers[j];
                    providers[j] = docId -> provider.getAsComparableLong(parents.nextSetBit(docId));
                }
                if (!metaData.hasBlocks() || fieldInfos.getParentField() != null || metaData.createdVersionMajor() < Version.LUCENE_10_0_0.major) continue;
                throw new CorruptIndexException("parent field is not set but the index has blocks and uses index sorting. indexCreatedVersionMajor: " + metaData.createdVersionMajor(), "IndexingChain");
            }
            reverseMuls[i] = fields[i].getReverse() ? -1 : 1;
        }
        int leafCount = readers.size();
        PriorityQueue<LeafAndDocID> queue = new PriorityQueue<LeafAndDocID>(leafCount){

            @Override
            public boolean lessThan(LeafAndDocID a, LeafAndDocID b) {
                for (int i = 0; i < comparables.length; ++i) {
                    int cmp = Long.compare(a.valuesAsComparableLongs[i], b.valuesAsComparableLongs[i]);
                    if (cmp == 0) continue;
                    return reverseMuls[i] * cmp < 0;
                }
                if (a.readerIndex != b.readerIndex) {
                    return a.readerIndex < b.readerIndex;
                }
                return a.docID < b.docID;
            }
        };
        PackedLongValues.Builder[] builders = new PackedLongValues.Builder[leafCount];
        for (int i = 0; i < leafCount; ++i) {
            CodecReader reader = readers.get(i);
            LeafAndDocID leaf = new LeafAndDocID(i, reader.getLiveDocs(), reader.maxDoc(), comparables.length);
            for (int j = 0; j < comparables.length; ++j) {
                leaf.valuesAsComparableLongs[j] = comparables[j][i].getAsComparableLong(leaf.docID);
            }
            queue.add(leaf);
            builders[i] = PackedLongValues.monotonicBuilder(0.0f);
        }
        int mappedDocID = 0;
        int lastReaderIndex = 0;
        boolean isSorted = true;
        while (queue.size() != 0) {
            LeafAndDocID top = (LeafAndDocID)queue.top();
            if (lastReaderIndex > top.readerIndex) {
                isSorted = false;
            }
            lastReaderIndex = top.readerIndex;
            builders[top.readerIndex].add(mappedDocID);
            if (top.liveDocs == null || top.liveDocs.get(top.docID)) {
                ++mappedDocID;
            }
            ++top.docID;
            if (top.docID < top.maxDoc) {
                for (int j = 0; j < comparables.length; ++j) {
                    top.valuesAsComparableLongs[j] = comparables[j][top.readerIndex].getAsComparableLong(top.docID);
                }
                queue.updateTop();
                continue;
            }
            queue.pop();
        }
        if (isSorted) {
            return null;
        }
        MergeState.DocMap[] docMaps = new MergeState.DocMap[leafCount];
        for (int i = 0; i < leafCount; ++i) {
            PackedLongValues remapped = builders[i].build();
            Bits liveDocs = readers.get(i).getLiveDocs();
            docMaps[i] = docID -> {
                if (liveDocs == null || liveDocs.get(docID)) {
                    return (int)remapped.get(docID);
                }
                return -1;
            };
        }
        return docMaps;
    }

    private static class LeafAndDocID {
        final int readerIndex;
        final Bits liveDocs;
        final int maxDoc;
        final long[] valuesAsComparableLongs;
        int docID;

        public LeafAndDocID(int readerIndex, Bits liveDocs, int maxDoc, int numComparables) {
            this.readerIndex = readerIndex;
            this.liveDocs = liveDocs;
            this.maxDoc = maxDoc;
            this.valuesAsComparableLongs = new long[numComparables];
        }
    }
}

