/*
 * Decompiled with CFR 0.152.
 */
package guideme.compiler.tags;

import guideme.PageAnchor;
import guideme.compiler.PageCompiler;
import guideme.compiler.ParsedGuidePage;
import guideme.compiler.tags.BlockTagCompiler;
import guideme.document.block.LytBlockContainer;
import guideme.document.block.LytList;
import guideme.document.block.LytListItem;
import guideme.document.block.LytParagraph;
import guideme.document.flow.LytFlowLink;
import guideme.indices.CategoryIndex;
import guideme.libs.mdast.mdx.model.MdxJsxElementFields;
import java.util.List;
import java.util.Set;

public class CategoryIndexCompiler
extends BlockTagCompiler {
    @Override
    public Set<String> getTagNames() {
        return Set.of("CategoryIndex");
    }

    @Override
    protected void compile(PageCompiler compiler, LytBlockContainer parent, MdxJsxElementFields el) {
        String category = el.getAttributeString("category", null);
        if (category == null) {
            parent.appendError(compiler, "Missing category", el);
            return;
        }
        List categories = compiler.getIndex(CategoryIndex.class).get(category);
        LytList list = new LytList(false, 0);
        for (PageAnchor pageAnchor : categories) {
            ParsedGuidePage page = compiler.getPageCollection().getParsedPage(pageAnchor.pageId());
            LytListItem listItem = new LytListItem();
            LytParagraph listItemPar = new LytParagraph();
            if (page == null) {
                listItemPar.appendText("Unknown page id: " + String.valueOf(pageAnchor.pageId()));
            } else {
                LytFlowLink link = new LytFlowLink();
                link.setClickCallback(guideScreen -> guideScreen.navigateTo(pageAnchor));
                link.appendText(page.getFrontmatter().navigationEntry().title());
                listItemPar.append(link);
            }
            listItem.append(listItemPar);
            list.append(listItem);
        }
        parent.append(list);
    }
}

