/*
 * Decompiled with CFR 0.152.
 */
package net.salju.kobolds.init;

import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.EntityAttributeCreationEvent;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.DeferredRegister;
import net.salju.kobolds.entity.Kobold;
import net.salju.kobolds.entity.KoboldCaptain;
import net.salju.kobolds.entity.KoboldChild;
import net.salju.kobolds.entity.KoboldEnchanter;
import net.salju.kobolds.entity.KoboldEngineer;
import net.salju.kobolds.entity.KoboldRascal;
import net.salju.kobolds.entity.KoboldSkeleton;
import net.salju.kobolds.entity.KoboldWarrior;
import net.salju.kobolds.entity.KoboldWither;
import net.salju.kobolds.entity.KoboldZombie;
import net.salju.kobolds.events.KoboldsManager;

@EventBusSubscriber
public class KoboldsMobs {
    public static final DeferredRegister<EntityType<?>> REGISTRY = DeferredRegister.create((ResourceKey)Registries.ENTITY_TYPE, (String)"kobolds");
    public static final DeferredHolder<EntityType<?>, EntityType<Kobold>> KOBOLD = KoboldsMobs.register("kobold", EntityType.Builder.of(Kobold::new, (MobCategory)MobCategory.MISC).sized(0.5f, 1.48f).eyeHeight(1.26f).ridingOffset(-0.45f));
    public static final DeferredHolder<EntityType<?>, EntityType<KoboldWarrior>> KOBOLD_WARRIOR = KoboldsMobs.register("kobold_warrior", EntityType.Builder.of(KoboldWarrior::new, (MobCategory)MobCategory.MISC).sized(0.5f, 1.48f).eyeHeight(1.26f).ridingOffset(-0.45f));
    public static final DeferredHolder<EntityType<?>, EntityType<KoboldEnchanter>> KOBOLD_ENCHANTER = KoboldsMobs.register("kobold_enchanter", EntityType.Builder.of(KoboldEnchanter::new, (MobCategory)MobCategory.MISC).sized(0.5f, 1.48f).eyeHeight(1.26f).ridingOffset(-0.45f));
    public static final DeferredHolder<EntityType<?>, EntityType<KoboldRascal>> KOBOLD_RASCAL = KoboldsMobs.register("kobold_rascal", EntityType.Builder.of(KoboldRascal::new, (MobCategory)MobCategory.MISC).sized(0.5f, 1.48f).eyeHeight(1.26f).ridingOffset(-0.45f));
    public static final DeferredHolder<EntityType<?>, EntityType<KoboldEngineer>> KOBOLD_ENGINEER = KoboldsMobs.register("kobold_engineer", EntityType.Builder.of(KoboldEngineer::new, (MobCategory)MobCategory.MISC).sized(0.5f, 1.48f).eyeHeight(1.26f).ridingOffset(-0.45f));
    public static final DeferredHolder<EntityType<?>, EntityType<Kobold>> KOBOLD_PIRATE = KoboldsMobs.register("kobold_pirate", EntityType.Builder.of(Kobold::new, (MobCategory)MobCategory.MISC).sized(0.5f, 1.48f).eyeHeight(1.26f).ridingOffset(-0.45f));
    public static final DeferredHolder<EntityType<?>, EntityType<KoboldCaptain>> KOBOLD_CAPTAIN = KoboldsMobs.register("kobold_captain", EntityType.Builder.of(KoboldCaptain::new, (MobCategory)MobCategory.MISC).sized(0.5f, 1.48f).eyeHeight(1.26f).ridingOffset(-0.45f));
    public static final DeferredHolder<EntityType<?>, EntityType<KoboldChild>> KOBOLD_CHILD = KoboldsMobs.register("kobold_child", EntityType.Builder.of(KoboldChild::new, (MobCategory)MobCategory.MISC).sized(0.4f, 0.76f).eyeHeight(0.66f).ridingOffset(-0.225f));
    public static final DeferredHolder<EntityType<?>, EntityType<KoboldZombie>> KOBOLD_ZOMBIE = KoboldsMobs.register("kobold_zombie", EntityType.Builder.of(KoboldZombie::new, (MobCategory)MobCategory.MONSTER).sized(0.5f, 1.48f).eyeHeight(1.26f).ridingOffset(-0.45f));
    public static final DeferredHolder<EntityType<?>, EntityType<KoboldSkeleton>> KOBOLD_SKELETON = KoboldsMobs.register("kobold_skeleton", EntityType.Builder.of(KoboldSkeleton::new, (MobCategory)MobCategory.MONSTER).sized(0.5f, 1.48f).eyeHeight(1.26f).ridingOffset(-0.45f));
    public static final DeferredHolder<EntityType<?>, EntityType<KoboldWither>> WITHERBOLD = KoboldsMobs.register("witherbold", EntityType.Builder.of(KoboldWither::new, (MobCategory)MobCategory.MONSTER).sized(0.5f, 1.48f).eyeHeight(1.26f).ridingOffset(-0.45f).fireImmune());

    private static <T extends Entity> DeferredHolder<EntityType<?>, EntityType<T>> register(String registryname, EntityType.Builder<T> entityTypeBuilder) {
        return REGISTRY.register(registryname, () -> entityTypeBuilder.build(registryname));
    }

    @SubscribeEvent
    public static void registerAttributes(EntityAttributeCreationEvent event) {
        event.put((EntityType)KOBOLD.get(), KoboldsManager.createAttributes(18.0, 1.0, 2.0, 0.25).build());
        event.put((EntityType)KOBOLD_WARRIOR.get(), KoboldsManager.createAttributes(18.0, 1.0, 2.0, 0.25).build());
        event.put((EntityType)KOBOLD_ENCHANTER.get(), KoboldsManager.createAttributes(18.0, 1.0, 2.0, 0.25).build());
        event.put((EntityType)KOBOLD_RASCAL.get(), KoboldsManager.createAttributes(18.0, 1.0, 2.0, 0.25).build());
        event.put((EntityType)KOBOLD_ENGINEER.get(), KoboldsManager.createAttributes(18.0, 1.0, 2.0, 0.25).build());
        event.put((EntityType)KOBOLD_PIRATE.get(), KoboldsManager.createAttributes(18.0, 1.0, 2.0, 0.25).build());
        event.put((EntityType)KOBOLD_CAPTAIN.get(), KoboldsManager.createAttributes(18.0, 1.0, 2.0, 0.25).build());
        event.put((EntityType)KOBOLD_CHILD.get(), KoboldsManager.createAttributes(18.0, 1.0, 2.0, 0.25).build());
        event.put((EntityType)KOBOLD_ZOMBIE.get(), KoboldsManager.createAttributes(18.0, 3.0, 2.0, 0.2).add(Attributes.SPAWN_REINFORCEMENTS_CHANCE).build());
        event.put((EntityType)KOBOLD_SKELETON.get(), KoboldsManager.createAttributes(18.0, 3.0, 0.0, 0.25).build());
        event.put((EntityType)WITHERBOLD.get(), KoboldsManager.createAttributes(32.0, 3.0, 2.0, 0.25).build());
    }
}

