/*
 * Decompiled with CFR 0.152.
 */
package net.salju.kobolds.entity;

import net.minecraft.core.RegistryAccess;
import net.minecraft.resources.ResourceKey;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.providers.VanillaEnchantmentProviders;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.salju.kobolds.entity.AbstractKoboldEntity;
import net.salju.kobolds.entity.ai.KoboldAttackSelector;
import net.salju.kobolds.entity.ai.KoboldBowGoal;
import net.salju.kobolds.entity.ai.KoboldCrossbowGoal;
import net.salju.kobolds.entity.ai.KoboldPotionGoal;
import net.salju.kobolds.entity.ai.KoboldRevengeGoal;
import net.salju.kobolds.entity.ai.KoboldTargetGoal;
import net.salju.kobolds.entity.ai.KoboldTradeGoal;
import net.salju.kobolds.events.KoboldsManager;
import net.salju.kobolds.init.KoboldsTags;

public class KoboldEngineer
extends AbstractKoboldEntity {
    public KoboldEngineer(EntityType<KoboldEngineer> type, Level world) {
        super(type, world);
    }

    @Override
    protected void registerGoals() {
        super.registerGoals();
        KoboldsManager.addPirateGoals(this);
        this.targetSelector.addGoal(0, (Goal)new KoboldRevengeGoal(this));
        this.goalSelector.addGoal(1, (Goal)new KoboldPotionGoal(this));
        this.goalSelector.addGoal(1, new KoboldCrossbowGoal<KoboldEngineer>(this, 1.0, 12.0f));
        this.goalSelector.addGoal(1, new KoboldBowGoal<KoboldEngineer>(this, 1.0, 20, 15.0f));
        this.goalSelector.addGoal(1, (Goal)new KoboldTradeGoal(this, "gameplay/engineer_loot"));
        this.targetSelector.addGoal(2, new KoboldTargetGoal<LivingEntity>((Mob)this, LivingEntity.class, new KoboldAttackSelector(this)));
    }

    @Override
    protected void populateDefaultEquipmentSlots(RandomSource randy, DifficultyInstance souls) {
        this.setItemSlot(EquipmentSlot.MAINHAND, new ItemStack((ItemLike)Items.CROSSBOW));
        super.populateDefaultEquipmentSlots(randy, souls);
    }

    protected void populateDefaultEquipmentEnchantments(ServerLevelAccessor lvl, RandomSource randy, DifficultyInstance difficulty) {
        ItemStack stack = this.getItemBySlot(EquipmentSlot.MAINHAND);
        if (!stack.isEmpty()) {
            EnchantmentHelper.enchantItemFromProvider((ItemStack)stack, (RegistryAccess)lvl.registryAccess(), (ResourceKey)VanillaEnchantmentProviders.MOB_SPAWN_EQUIPMENT, (DifficultyInstance)difficulty, (RandomSource)randy);
            this.setItemSlot(EquipmentSlot.MAINHAND, stack);
        }
    }

    @Override
    public boolean isPreferredWeapon(ItemStack stack) {
        return stack.is(KoboldsTags.ENGI);
    }
}

