/*
 * Decompiled with CFR 0.152.
 */
package net.salju.kobolds.entity;

import net.minecraft.core.RegistryAccess;
import net.minecraft.resources.ResourceKey;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.providers.VanillaEnchantmentProviders;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.salju.kobolds.entity.AbstractKoboldEntity;
import net.salju.kobolds.entity.ai.KoboldAttackSelector;
import net.salju.kobolds.entity.ai.KoboldBowGoal;
import net.salju.kobolds.entity.ai.KoboldCaptainGoal;
import net.salju.kobolds.entity.ai.KoboldCrossbowGoal;
import net.salju.kobolds.entity.ai.KoboldMeleeGoal;
import net.salju.kobolds.entity.ai.KoboldPotionGoal;
import net.salju.kobolds.entity.ai.KoboldRevengeGoal;
import net.salju.kobolds.entity.ai.KoboldShieldGoal;
import net.salju.kobolds.entity.ai.KoboldTargetGoal;
import net.salju.kobolds.entity.ai.KoboldTridentGoal;
import net.salju.kobolds.events.KoboldsManager;
import net.salju.kobolds.init.KoboldsItems;
import net.salju.kobolds.init.KoboldsTags;

public class KoboldCaptain
extends AbstractKoboldEntity {
    public KoboldCaptain(EntityType<KoboldCaptain> type, Level world) {
        super(type, world);
    }

    @Override
    protected void registerGoals() {
        super.registerGoals();
        KoboldsManager.addPirateGoals(this);
        this.targetSelector.addGoal(0, (Goal)new KoboldRevengeGoal(this));
        this.goalSelector.addGoal(1, (Goal)new KoboldPotionGoal(this));
        this.goalSelector.addGoal(1, (Goal)new KoboldShieldGoal(this));
        this.goalSelector.addGoal(1, (Goal)new KoboldTridentGoal(this, 1.0, 40, 12.0f));
        this.goalSelector.addGoal(1, new KoboldCrossbowGoal<KoboldCaptain>(this, 1.0, 12.0f));
        this.goalSelector.addGoal(1, new KoboldBowGoal<KoboldCaptain>(this, 1.0, 20, 15.0f));
        this.goalSelector.addGoal(1, (Goal)new KoboldCaptainGoal(this));
        this.goalSelector.addGoal(2, new KoboldMeleeGoal<KoboldCaptain>(this, 1.2, false));
        this.targetSelector.addGoal(2, new KoboldTargetGoal<LivingEntity>((Mob)this, LivingEntity.class, new KoboldAttackSelector(this)));
    }

    @Override
    public InteractionResult mobInteract(Player player, InteractionHand hand) {
        ItemStack gem = player.getItemInHand(hand).copy();
        if (gem.is(KoboldsTags.CAPTAIN)) {
            if (this.isEffectiveAi()) {
                gem.setCount(1);
                this.setItemInHand(InteractionHand.OFF_HAND, gem);
                if (!player.isCreative()) {
                    player.getItemInHand(hand).shrink(1);
                }
            }
            return InteractionResult.SUCCESS;
        }
        return super.mobInteract(player, hand);
    }

    @Override
    protected boolean canReplaceCurrentItem(ItemStack drop, ItemStack hand) {
        if (drop.is(Items.EMERALD)) {
            return false;
        }
        return super.canReplaceCurrentItem(drop, hand);
    }

    @Override
    protected void populateDefaultEquipmentSlots(RandomSource randy, DifficultyInstance difficulty) {
        this.setItemSlot(EquipmentSlot.MAINHAND, new ItemStack((ItemLike)KoboldsItems.KOBOLD_IRON_SWORD.get()));
        super.populateDefaultEquipmentSlots(randy, difficulty);
    }

    protected void populateDefaultEquipmentEnchantments(ServerLevelAccessor lvl, RandomSource randy, DifficultyInstance difficulty) {
        ItemStack stack = this.getItemBySlot(EquipmentSlot.MAINHAND);
        if (!stack.isEmpty()) {
            EnchantmentHelper.enchantItemFromProvider((ItemStack)stack, (RegistryAccess)lvl.registryAccess(), (ResourceKey)VanillaEnchantmentProviders.MOB_SPAWN_EQUIPMENT, (DifficultyInstance)difficulty, (RandomSource)randy);
            this.setItemSlot(EquipmentSlot.MAINHAND, stack);
        }
    }
}

