/*
 * Decompiled with CFR 0.152.
 */
package com.tiviacz.pizzadelight.util;

import java.util.stream.IntStream;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.world.Containers;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.neoforged.neoforge.items.IItemHandlerModifiable;
import net.neoforged.neoforge.items.ItemStackHandler;
import org.lwjgl.glfw.GLFW;

public class Utils {
    @Nullable
    public static <E extends BlockEntity, A extends BlockEntity> BlockEntityTicker<A> getTicker(BlockEntityType<A> type, BlockEntityType<E> targetType, BlockEntityTicker<? super E> ticker) {
        return targetType == type ? ticker : null;
    }

    public static void dropContents(Level pLevel, BlockPos pPos, ItemStackHandler handler) {
        IntStream.range(0, handler.getSlots() - 1).forEach(i -> Containers.dropItemStack((Level)pLevel, (double)pPos.getX(), (double)pPos.getY(), (double)pPos.getZ(), (ItemStack)handler.getStackInSlot(i)));
    }

    public static void spawnItemStackInWorld(Level level, BlockPos pos, ItemStack stack) {
        ItemEntity itemEntity = new ItemEntity(level, (double)pos.getX() + 0.5, (double)pos.getY() + 0.5, (double)pos.getZ() + 0.5, stack);
        itemEntity.setDefaultPickUpDelay();
        level.addFreshEntity((Entity)itemEntity);
    }

    public static boolean isEmpty(ItemStackHandler handler) {
        for (int i = 0; i < handler.getSlots(); ++i) {
            if (handler.getStackInSlot(i).isEmpty()) continue;
            return false;
        }
        return true;
    }

    public static boolean checkCount(ItemStack stack1, ItemStack stack2, int count) {
        return stack1.getCount() + stack2.getCount() <= count;
    }

    public static boolean checkItemStacks(ItemStack stack1, ItemStack stack2) {
        return !stack1.isEmpty() && stack1.getItem() == stack2.getItem();
    }

    public static boolean checkItemStacksAndCount(ItemStack stack1, ItemStack stack2, int count) {
        return Utils.checkItemStacks(stack1, stack2) && Utils.checkCount(stack1, stack2, count);
    }

    public static int getProperSlotForInsert(ItemStack stack, IItemHandlerModifiable inv) {
        for (int i = 0; i < inv.getSlots(); ++i) {
            if (!inv.getStackInSlot(i).isEmpty()) continue;
            return i;
        }
        return 0;
    }

    public static int getProperSlotForExtract(IItemHandlerModifiable inv) {
        for (int i = inv.getSlots() - 1; i > 0; --i) {
            if (inv.getStackInSlot(i).isEmpty()) continue;
            return i;
        }
        return 0;
    }

    public static boolean isShiftPressed() {
        return GLFW.glfwGetKey((long)Minecraft.getInstance().getWindow().getWindow(), (int)340) == 1 || GLFW.glfwGetKey((long)Minecraft.getInstance().getWindow().getWindow(), (int)344) == 1;
    }
}

