/*
 * Decompiled with CFR 0.152.
 */
package com.tiviacz.pizzadelight.network;

import com.tiviacz.pizzadelight.PizzaDelight;
import com.tiviacz.pizzadelight.container.PizzaStationMenu;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public record ServerboundRenamePizzaPacket(String name) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<ServerboundRenamePizzaPacket> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"pizzadelight", (String)"rename_pizza"));
    public static final StreamCodec<RegistryFriendlyByteBuf, ServerboundRenamePizzaPacket> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.STRING_UTF8, ServerboundRenamePizzaPacket::name, ServerboundRenamePizzaPacket::new);

    public static void handle(ServerboundRenamePizzaPacket message, IPayloadContext ctx) {
        ctx.enqueueWork(() -> {
            Player player = ctx.player();
            AbstractContainerMenu menu = player.containerMenu;
            if (menu instanceof PizzaStationMenu) {
                PizzaStationMenu stationMenu = (PizzaStationMenu)menu;
                if (!stationMenu.stillValid(player)) {
                    PizzaDelight.LOGGER.debug("Player {} interacted with invalid menu {}", (Object)player, (Object)stationMenu);
                    return;
                }
                stationMenu.setItemName(message.name());
            }
        });
    }

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }
}

