/*
 * Decompiled with CFR 0.152.
 */
package com.tiviacz.pizzadelight.items;

import java.util.EnumMap;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.Util;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.crafting.Ingredient;

public class ModArmorMaterials {
    public static final Holder<ArmorMaterial> CHEF_ARMOR_MATERIAL = ModArmorMaterials.register("chef", (EnumMap)Util.make(new EnumMap(ArmorItem.Type.class), attribute -> {
        attribute.put(ArmorItem.Type.BOOTS, 1);
        attribute.put(ArmorItem.Type.LEGGINGS, 2);
        attribute.put(ArmorItem.Type.CHESTPLATE, 3);
        attribute.put(ArmorItem.Type.HELMET, 1);
        attribute.put(ArmorItem.Type.BODY, 3);
    }), 10, 0.0f, 0.0f);

    private static Holder<ArmorMaterial> register(String name, EnumMap<ArmorItem.Type, Integer> typeProtection, int enchantability, float toughness, float knockbackResistance) {
        ResourceLocation location = ResourceLocation.fromNamespaceAndPath((String)"pizzadelight", (String)name);
        Holder equipSound = SoundEvents.ARMOR_EQUIP_LEATHER;
        Supplier<Ingredient> ingredient = () -> Ingredient.EMPTY;
        List<ArmorMaterial.Layer> layers = List.of(new ArmorMaterial.Layer(location));
        EnumMap<ArmorItem.Type, Integer> typeMap = new EnumMap<ArmorItem.Type, Integer>(ArmorItem.Type.class);
        for (ArmorItem.Type type : ArmorItem.Type.values()) {
            typeMap.put(type, typeProtection.get(type));
        }
        return Registry.registerForHolder((Registry)BuiltInRegistries.ARMOR_MATERIAL, (ResourceLocation)location, (Object)new ArmorMaterial(typeProtection, enchantability, equipSound, ingredient, layers, toughness, knockbackResistance));
    }
}

