/*
 * Decompiled with CFR 0.152.
 */
package com.tiviacz.pizzadelight.container.slots;

import com.tiviacz.pizzadelight.container.PizzaStationMenu;
import javax.annotation.Nonnull;
import net.minecraft.core.component.DataComponents;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.PotionItem;
import net.minecraft.world.level.ItemLike;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.ItemHandlerHelper;
import net.neoforged.neoforge.items.SlotItemHandler;

public class PizzaStationResultSlot
extends SlotItemHandler {
    private final PizzaStationMenu menu;

    public PizzaStationResultSlot(PizzaStationMenu menu, IItemHandler itemHandler, int index, int xPosition, int yPosition) {
        super(itemHandler, index, xPosition, yPosition);
        this.menu = menu;
    }

    public void setChanged() {
        this.menu.updateOutput();
    }

    public boolean mayPlace(@Nonnull ItemStack stack) {
        return false;
    }

    public void onTake(@Nonnull Player player, @Nonnull ItemStack stack) {
        for (int i = 0; i < this.menu.blockEntity.getInventory().getSlots() - 1; ++i) {
            ItemStack itemStack = this.menu.blockEntity.getInventory().getStackInSlot(i).copy();
            if (itemStack.isEmpty()) continue;
            boolean isPotion = itemStack.getItem() instanceof PotionItem;
            boolean isSauce = itemStack.has(DataComponents.FOOD) && !((FoodProperties)itemStack.get(DataComponents.FOOD)).usingConvertsTo().isEmpty();
            ItemStack container = itemStack.getCraftingRemainingItem();
            itemStack.shrink(1);
            this.menu.blockEntity.getInventory().setStackInSlot(i, itemStack);
            if (container.isEmpty()) {
                FoodProperties foodProperties;
                if (isPotion) {
                    container = new ItemStack((ItemLike)Items.GLASS_BOTTLE);
                } else if (isSauce && (foodProperties = (FoodProperties)itemStack.get(DataComponents.FOOD)) != null && foodProperties.usingConvertsTo().isPresent()) {
                    container = (ItemStack)foodProperties.usingConvertsTo().get();
                }
            }
            if (container.isEmpty()) continue;
            if (itemStack.isEmpty()) {
                this.menu.blockEntity.getInventory().setStackInSlot(i, container);
                continue;
            }
            ItemHandlerHelper.giveItemToPlayer((Player)player, (ItemStack)container);
        }
        this.menu.updateOutput();
    }
}

