/*
 * Decompiled with CFR 0.152.
 */
package com.tiviacz.pizzadelight.container;

import com.tiviacz.pizzadelight.blockentity.PizzaStationBlockEntity;
import com.tiviacz.pizzadelight.common.PizzaCalculator;
import com.tiviacz.pizzadelight.container.slots.PizzaStationResultSlot;
import com.tiviacz.pizzadelight.init.ModItems;
import com.tiviacz.pizzadelight.init.ModMenuTypes;
import com.tiviacz.pizzadelight.tags.ModTags;
import com.tiviacz.pizzadelight.util.Utils;
import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.util.StringUtil;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.PotionItem;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.ItemStackHandler;
import net.neoforged.neoforge.items.SlotItemHandler;

public class PizzaStationMenu
extends AbstractContainerMenu {
    public Inventory inv;
    public PizzaStationBlockEntity blockEntity;
    private String itemName;

    public PizzaStationMenu(int windowID, Inventory inv, FriendlyByteBuf data) {
        this(windowID, inv, PizzaStationMenu.getBlockEntity(inv, data));
    }

    public PizzaStationMenu(int windowID, Inventory inv, BlockEntity tile) {
        super((MenuType)ModMenuTypes.PIZZA_STATION.get(), windowID);
        this.inv = inv;
        this.blockEntity = (PizzaStationBlockEntity)tile;
        this.addResultSlot();
        this.addBaseSlot();
        this.addSauceSlot();
        this.addIngredientsSlots();
        this.addPlayerInventoryAndHotbar(inv);
    }

    public void addPlayerInventoryAndHotbar(Inventory inv) {
        for (int y = 0; y < 3; ++y) {
            for (int x = 0; x < 9; ++x) {
                this.addSlot(new Slot((Container)inv, x + y * 9 + 9, 8 + x * 18, 114 + y * 18));
            }
        }
        for (int x = 0; x < 9; ++x) {
            this.addSlot(new Slot((Container)inv, x, 8 + x * 18, 172));
        }
    }

    public void addResultSlot() {
        this.addSlot((Slot)new PizzaStationResultSlot(this, (IItemHandler)this.blockEntity.getInventory(), 0, 148, 65));
    }

    public void addBaseSlot() {
        this.addSlot((Slot)new SlotItemHandler((IItemHandler)this.blockEntity.getInventory(), 1, 12, 77){

            public void setChanged() {
                super.setChanged();
                PizzaStationMenu.this.updateOutput();
            }
        });
    }

    public void addSauceSlot() {
        this.addSlot((Slot)new SlotItemHandler((IItemHandler)this.blockEntity.getInventory(), 2, 12, 54){

            public void setChanged() {
                super.setChanged();
                PizzaStationMenu.this.updateOutput();
            }
        });
    }

    public void addIngredientsSlots() {
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < 3; ++j) {
                this.addSlot((Slot)new SlotItemHandler((IItemHandler)this.blockEntity.getInventory(), 3 + (j + i * 3), 55 + j * 18, 47 + i * 18){

                    public void setChanged() {
                        super.setChanged();
                        PizzaStationMenu.this.updateOutput();
                    }
                });
            }
        }
    }

    public void updateOutput() {
        int i;
        ItemStackHandler handler = this.blockEntity.getInventory();
        ItemStack baseStack = handler.getStackInSlot(1);
        ItemStack sauceCopy = handler.getStackInSlot(2).copy();
        sauceCopy.setCount(1);
        if (baseStack.isEmpty()) {
            this.resetOutput();
            return;
        }
        ItemStackHandler ingredientsHandler = new ItemStackHandler(10);
        if (!(sauceCopy.isEmpty() || sauceCopy.getItem() instanceof PotionItem || sauceCopy.is(ModTags.SAUCE))) {
            this.resetOutput();
            return;
        }
        int index = 0;
        for (i = 3; i < 12; ++i) {
            ItemStack stack = handler.getStackInSlot(i);
            ItemStack copy = stack.copy();
            copy.setCount(1);
            ingredientsHandler.setStackInSlot(index, copy);
            ++index;
        }
        for (i = 0; i < ingredientsHandler.getSlots(); ++i) {
            if (ingredientsHandler.getStackInSlot(i).isEmpty() || ingredientsHandler.getStackInSlot(i).has(DataComponents.FOOD)) continue;
            this.resetOutput();
            return;
        }
        if (Utils.isEmpty(ingredientsHandler)) {
            this.resetOutput();
            return;
        }
        ItemStack baseCopy = baseStack.copy();
        baseCopy.setCount(1);
        PizzaCalculator calc = new PizzaCalculator(baseCopy, sauceCopy, ingredientsHandler);
        ItemStack result = calc.getResultStackBlock(((Item)ModItems.RAW_PIZZA.get()).getDefaultInstance());
        if (result.isEmpty()) {
            this.resetOutput();
            return;
        }
        if (this.itemName != null && !StringUtil.isBlank((String)this.itemName)) {
            if (!this.itemName.equals(result.getHoverName().getString())) {
                result.set(DataComponents.CUSTOM_NAME, (Object)Component.literal((String)this.itemName));
            }
        } else if (result.has(DataComponents.CUSTOM_NAME)) {
            result.remove(DataComponents.CUSTOM_NAME);
        }
        this.setOutput(result.copy());
    }

    public boolean setItemName(String itemName) {
        String s = PizzaStationMenu.validateName(itemName);
        if (s != null && !s.equals(this.itemName)) {
            this.itemName = s;
            if (this.getSlot(1).hasItem()) {
                ItemStack itemstack = this.getSlot(1).getItem();
                if (StringUtil.isBlank((String)s)) {
                    itemstack.remove(DataComponents.CUSTOM_NAME);
                } else {
                    itemstack.set(DataComponents.CUSTOM_NAME, (Object)Component.literal((String)s));
                }
            }
            this.updateOutput();
            return true;
        }
        return false;
    }

    @Nullable
    private static String validateName(String itemName) {
        String s = StringUtil.filterText((String)itemName);
        return s.length() <= 50 ? s : null;
    }

    private void setOutput(ItemStack stack) {
        this.blockEntity.getInventory().setStackInSlot(0, stack);
        this.broadcastChanges();
    }

    private void resetOutput() {
        ItemStack stack = this.blockEntity.getInventory().getStackInSlot(0);
        if (!stack.isEmpty()) {
            this.setOutput(ItemStack.EMPTY);
        }
    }

    public ItemStack quickMoveStack(Player player, int index) {
        ItemStack itemstack = ItemStack.EMPTY;
        Slot slot = (Slot)this.slots.get(index);
        if (slot != null && slot.hasItem()) {
            ItemStack itemstack1 = slot.getItem();
            itemstack = itemstack1.copy();
            if (index < 12 ? !this.moveItemStackTo(itemstack1, 12, 48, true) : !this.moveItemStackTo(itemstack1, 0, 12, false)) {
                return ItemStack.EMPTY;
            }
            if (itemstack1.isEmpty()) {
                slot.set(ItemStack.EMPTY);
            } else {
                slot.setChanged();
            }
            slot.onTake(player, itemstack1);
        }
        return itemstack;
    }

    public void removed(Player player) {
        super.removed(player);
    }

    public boolean stillValid(Player player) {
        return true;
    }

    private static PizzaStationBlockEntity getBlockEntity(Inventory inv, FriendlyByteBuf data) {
        Objects.requireNonNull(inv, "inv cannot be null");
        Objects.requireNonNull(data, "data cannot be null");
        BlockEntity blockEntity = inv.player.level().getBlockEntity(data.readBlockPos());
        if (blockEntity instanceof PizzaStationBlockEntity) {
            return (PizzaStationBlockEntity)blockEntity;
        }
        throw new IllegalStateException("Block entity is not correct! " + String.valueOf(blockEntity));
    }
}

