/*
 * Decompiled with CFR 0.152.
 */
package com.tiviacz.pizzadelight.components;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.List;
import java.util.OptionalInt;
import net.minecraft.core.NonNullList;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.items.ItemStackHandler;

public final class PizzaIngredients {
    public static final PizzaIngredients EMPTY = new PizzaIngredients((NonNullList<ItemStack>)NonNullList.withSize((int)10, (Object)ItemStack.EMPTY));
    public static final Codec<PizzaIngredients> CODEC = Slot.CODEC.sizeLimitedListOf(10).xmap(PizzaIngredients::fromSlots, PizzaIngredients::asSlots);
    public static final StreamCodec<RegistryFriendlyByteBuf, PizzaIngredients> STREAM_CODEC = ItemStack.OPTIONAL_STREAM_CODEC.apply(ByteBufCodecs.list((int)10)).map(PizzaIngredients::new, p_331691_ -> p_331691_.items);
    private final NonNullList<ItemStack> items;
    private final int hashCode;

    private PizzaIngredients(NonNullList<ItemStack> items) {
        if (items.size() > 10) {
            throw new IllegalArgumentException("Got " + items.size() + " items, but maximum is 10");
        }
        this.items = items;
        this.hashCode = ItemStack.hashStackList(items);
    }

    private PizzaIngredients() {
        this((NonNullList<ItemStack>)NonNullList.withSize((int)10, (Object)ItemStack.EMPTY));
    }

    public PizzaIngredients(List<ItemStack> items) {
        this((NonNullList<ItemStack>)NonNullList.withSize((int)10, (Object)ItemStack.EMPTY));
        for (int i = 0; i < Math.min(items.size(), 10); ++i) {
            this.items.set(i, (Object)items.get(i));
        }
    }

    public NonNullList<ItemStack> getIngredients() {
        return this.items;
    }

    public static PizzaIngredients fromHandler(ItemStackHandler handler) {
        PizzaIngredients ingredients = new PizzaIngredients();
        for (int i = 0; i < Math.min(handler.getSlots(), 10); ++i) {
            ingredients.items.set(i, (Object)handler.getStackInSlot(i));
        }
        return ingredients;
    }

    private static PizzaIngredients fromSlots(List<Slot> slots) {
        OptionalInt optionalint = slots.stream().mapToInt(Slot::index).max();
        if (optionalint.isEmpty()) {
            return EMPTY;
        }
        PizzaIngredients ingredients = new PizzaIngredients();
        for (Slot itemcontainercontents$slot : slots) {
            ingredients.items.set(itemcontainercontents$slot.index(), (Object)itemcontainercontents$slot.item());
        }
        return ingredients;
    }

    private List<Slot> asSlots() {
        ArrayList<Slot> list = new ArrayList<Slot>();
        for (int i = 0; i < this.items.size(); ++i) {
            ItemStack itemstack = (ItemStack)this.items.get(i);
            if (itemstack.isEmpty()) continue;
            list.add(new Slot(i, itemstack));
        }
        return list;
    }

    public void copyInto(NonNullList<ItemStack> list) {
        for (int i = 0; i < list.size(); ++i) {
            ItemStack itemstack = i < this.items.size() ? (ItemStack)this.items.get(i) : ItemStack.EMPTY;
            list.set(i, (Object)itemstack.copy());
        }
    }

    public ItemStack getSauceStack() {
        return (ItemStack)this.items.get(9);
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other instanceof PizzaIngredients) {
            PizzaIngredients ingredients = (PizzaIngredients)other;
            return ItemStack.listMatches(this.items, ingredients.items);
        }
        return false;
    }

    public int hashCode() {
        return this.hashCode;
    }

    public int getSlots() {
        return this.items.size();
    }

    public ItemStack getStackInSlot(int slot) {
        this.validateSlotIndex(slot);
        return ((ItemStack)this.items.get(slot)).copy();
    }

    private void validateSlotIndex(int slot) {
        if (slot < 0 || slot >= this.getSlots()) {
            throw new UnsupportedOperationException("Slot " + slot + " not in valid range - [0," + this.getSlots() + ")");
        }
    }

    record Slot(int index, ItemStack item) {
        public static final Codec<Slot> CODEC = RecordCodecBuilder.create(p_331695_ -> p_331695_.group((App)Codec.intRange((int)0, (int)9).fieldOf("slot").forGetter(Slot::index), (App)ItemStack.CODEC.fieldOf("item").forGetter(Slot::item)).apply((Applicative)p_331695_, Slot::new));
    }
}

