/*
 * Decompiled with CFR 0.152.
 */
package com.tiviacz.pizzadelight.common;

import com.tiviacz.pizzadelight.common.PizzaCalculator;
import java.util.List;
import net.minecraft.core.component.DataComponents;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.items.ItemStackHandler;

public class PizzaBlockCalculator
extends PizzaCalculator {
    public PizzaBlockCalculator(ItemStackHandler ingredients) {
        super(ItemStack.EMPTY, ingredients.getStackInSlot(9), ingredients);
        this.resetStats();
    }

    public void process() {
        this.resetStats();
        for (int i = 0; i < this.ingredients.getSlots(); ++i) {
            this.processFood(this.ingredients.getStackInSlot(i).copyWithCount(1));
        }
        if (this.getEffect() != null) {
            this.effects.add(new FoodProperties.PossibleEffect(this::getEffect, 1.0f));
        }
    }

    public List<FoodProperties.PossibleEffect> findEffects() {
        this.effects.clear();
        this.processedFoods.clear();
        for (int i = 0; i < this.ingredients.getSlots(); ++i) {
            this.findEffects(this.ingredients.getStackInSlot(i).copyWithCount(1));
        }
        if (this.getEffect() != null) {
            this.effects.add(new FoodProperties.PossibleEffect(this::getEffect, 1.0f));
        }
        return this.effects;
    }

    public int getHunger() {
        return this.hunger;
    }

    public float getSaturation() {
        return this.saturation;
    }

    public List<FoodProperties.PossibleEffect> getEffects() {
        return this.effects;
    }

    public void findEffects(ItemStack stack) {
        if (!stack.has(DataComponents.FOOD)) {
            return;
        }
        FoodProperties food = stack.getItem().getFoodProperties(stack, null);
        if (!food.effects().isEmpty()) {
            for (FoodProperties.PossibleEffect possibleEffect : food.effects()) {
                if (this.effects.contains(possibleEffect)) continue;
                this.effects.add(possibleEffect);
            }
        }
        if (this.processedFoods.stream().noneMatch(s -> ItemStack.isSameItemSameComponents((ItemStack)s, (ItemStack)stack))) {
            ++this.uniqueness;
        }
        this.processedFoods.add((Object)stack);
    }
}

