/*
 * Decompiled with CFR 0.152.
 */
package com.tiviacz.pizzadelight.client;

import com.google.common.collect.Maps;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonObject;
import com.mojang.math.Transformation;
import com.tiviacz.pizzadelight.client.ColoredQuadTransformer;
import com.tiviacz.pizzadelight.client.LayerSelector;
import com.tiviacz.pizzadelight.components.PizzaIngredients;
import com.tiviacz.pizzadelight.init.ModDataComponents;
import com.tiviacz.pizzadelight.init.ModItems;
import com.tiviacz.pizzadelight.init.PizzaLayers;
import com.tiviacz.pizzadelight.util.RenderUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.model.ItemOverrides;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.BlockModelRotation;
import net.minecraft.client.resources.model.Material;
import net.minecraft.client.resources.model.ModelBaker;
import net.minecraft.client.resources.model.ModelState;
import net.minecraft.core.component.DataComponents;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.alchemy.PotionContents;
import net.neoforged.neoforge.client.NeoForgeRenderTypes;
import net.neoforged.neoforge.client.RenderTypeGroup;
import net.neoforged.neoforge.client.model.CompositeModel;
import net.neoforged.neoforge.client.model.SimpleModelState;
import net.neoforged.neoforge.client.model.geometry.IGeometryBakingContext;
import net.neoforged.neoforge.client.model.geometry.IGeometryLoader;
import net.neoforged.neoforge.client.model.geometry.IUnbakedGeometry;
import net.neoforged.neoforge.client.model.geometry.StandaloneGeometryBakingContext;
import net.neoforged.neoforge.client.model.geometry.UnbakedGeometryHelper;
import net.neoforged.neoforge.items.ItemStackHandler;
import org.joml.Quaternionf;
import org.joml.Vector3f;

public class DynamicPizzaSliceModel
implements IUnbakedGeometry<DynamicPizzaSliceModel> {
    private static final float NORTH_Z_COVER = 0.4685f;
    private static final float SOUTH_Z_COVER = 0.5315f;
    private static final float NORTH_Z_FLUID = 0.468625f;
    private static final float SOUTH_Z_FLUID = 0.531375f;
    private static final Transformation FLUID_TRANSFORM = new Transformation(new Vector3f(), new Quaternionf(), new Vector3f(1.0f, 1.0f, 1.002f), new Quaternionf());
    private static final Transformation COVER_TRANSFORM = new Transformation(new Vector3f(), new Quaternionf(), new Vector3f(1.0f, 1.0f, 1.004f), new Quaternionf());
    @Nonnull
    private final ItemStack stack;

    public DynamicPizzaSliceModel(ItemStack stack) {
        this.stack = stack;
    }

    public DynamicPizzaSliceModel withStack(ItemStack stack) {
        return new DynamicPizzaSliceModel(stack);
    }

    public BakedModel bake(IGeometryBakingContext context, ModelBaker baker, Function<Material, TextureAtlasSprite> spriteGetter, ModelState modelState, ItemOverrides overrides) {
        Transformation rootTransform;
        TextureAtlasSprite particleSprite;
        int i;
        Material particleLocation = context.hasMaterial("particle") ? context.getMaterial("particle") : null;
        Material baseLocation = context.hasMaterial("base") ? context.getMaterial("base") : null;
        ArrayList<TagKey> tags = new ArrayList<TagKey>();
        LayerSelector selector = new LayerSelector(true);
        ItemStackHandler handler = new ItemStackHandler(((PizzaIngredients)this.stack.getOrDefault(ModDataComponents.PIZZA_INGREDIENTS, (Object)PizzaIngredients.EMPTY)).getIngredients());
        for (int i2 = 0; i2 < handler.getSlots(); ++i2) {
            tags.add(null);
        }
        List tintIndexes = this.initializeNullList(10);
        for (int i3 = 0; i3 < handler.getSlots(); ++i3) {
            if (handler.getStackInSlot(i3).isEmpty()) continue;
            ResourceLocation layerLocation = null;
            List itemTags = handler.getStackInSlot(i3).getTags().toList();
            for (TagKey tag : itemTags) {
                if (!PizzaLayers.VALID_ITEM_TAGS.contains(tag)) continue;
                layerLocation = PizzaLayers.getTagToItemLayer().get(tag);
                tags.set(i3, tag);
                tintIndexes.set(i3, -1);
            }
            if (layerLocation != null) continue;
            tags.set(i3, null);
            tintIndexes.set(i3, i3);
        }
        ArrayList<ResourceLocation> layers = new ArrayList<ResourceLocation>(tags.size());
        for (i = 0; i < tags.size(); ++i) {
            TagKey tagKey = (TagKey)tags.get(i);
            if (tagKey != null) {
                selector.processLayer((TagKey<Item>)tagKey);
                layers.add(i, PizzaLayers.getTagToItemLayer().get(tagKey));
                continue;
            }
            layers.add(i, null);
        }
        for (i = 0; i < layers.size(); ++i) {
            if (layers.get(i) != null || handler.getStackInSlot(i).isEmpty()) continue;
            layers.set(i, selector.selectItemLayer());
        }
        TextureAtlasSprite textureAtlasSprite = particleSprite = particleLocation != null ? spriteGetter.apply(particleLocation) : null;
        if (particleSprite == null) {
            particleSprite = spriteGetter.apply(baseLocation);
        }
        if (!(rootTransform = context.getRootTransform()).isIdentity()) {
            modelState = new SimpleModelState(modelState.getRotation().compose(rootTransform), modelState.isUvLocked());
        }
        StandaloneGeometryBakingContext itemContext = StandaloneGeometryBakingContext.builder((IGeometryBakingContext)context).withGui3d(false).withUseBlockLight(false).build(ResourceLocation.fromNamespaceAndPath((String)"pizzadelight", (String)"pizza_slice_override"));
        CompositeModel.Baked.Builder builder = CompositeModel.Baked.builder((IGeometryBakingContext)itemContext, (TextureAtlasSprite)particleSprite, (ItemOverrides)new PizzaSliceOverrideHandler(overrides, baker, (IGeometryBakingContext)itemContext, this), (ItemTransforms)context.getTransforms());
        RenderTypeGroup normalRenderTypes = DynamicPizzaSliceModel.getLayerRenderTypes();
        if (baseLocation != null) {
            TextureAtlasSprite sprite = spriteGetter.apply(baseLocation);
            List unbaked = UnbakedGeometryHelper.createUnbakedItemElements((int)0, (TextureAtlasSprite)sprite);
            List quads = UnbakedGeometryHelper.bakeElements((List)unbaked, $ -> sprite, (ModelState)modelState);
            builder.addQuads(normalRenderTypes, (Collection)quads);
        }
        if (!layers.isEmpty()) {
            int i4 = 0;
            for (int j = 0; j < layers.size(); ++j) {
                if (layers.get(j) == null) continue;
                Material material = new Material(InventoryMenu.BLOCK_ATLAS, (ResourceLocation)layers.get(j));
                TextureAtlasSprite sprite = spriteGetter.apply(material);
                ++i4;
                if (sprite == null) continue;
                SimpleModelState transformedState = new SimpleModelState(modelState.getRotation().compose(DynamicPizzaSliceModel.getLayerTransformation(i4)), modelState.isUvLocked());
                List unbaked = UnbakedGeometryHelper.createUnbakedItemMaskElements((int)2, (TextureAtlasSprite)sprite);
                List quads = UnbakedGeometryHelper.bakeElements((List)unbaked, $ -> sprite, (ModelState)transformedState);
                ColoredQuadTransformer colorizer = new ColoredQuadTransformer();
                if ((Integer)tintIndexes.get(j) != -1) {
                    if (handler.getStackInSlot(((Integer)tintIndexes.get(j)).intValue()).getItem() == ModItems.CHEESE.get()) continue;
                    int color = RenderUtils.getDominantColor(Minecraft.getInstance().getItemRenderer().getItemModelShaper().getItemModel(handler.getStackInSlot(((Integer)tintIndexes.get(j)).intValue())).getParticleIcon(), false);
                    if (handler.getStackInSlot(((Integer)tintIndexes.get(j)).intValue()).has(DataComponents.POTION_CONTENTS)) {
                        PotionContents contents = (PotionContents)handler.getStackInSlot(((Integer)tintIndexes.get(j)).intValue()).getOrDefault(DataComponents.POTION_CONTENTS, (Object)PotionContents.EMPTY);
                        color = contents.getColor();
                    }
                    colorizer.color(quads, color);
                }
                builder.addQuads(DynamicPizzaSliceModel.getLayerRenderTypes(), (Collection)quads);
            }
        }
        builder.setParticle(particleSprite);
        return builder.build();
    }

    public List initializeNullList(int size) {
        ArrayList<Object> list = new ArrayList<Object>();
        for (int i = 0; i < size; ++i) {
            list.add(null);
        }
        return list;
    }

    public static Transformation getLayerTransformation(int i) {
        return new Transformation(new Vector3f(0.0f, 0.0f, 1.0E-5f + (float)i * 1.0E-5f), new Quaternionf(), new Vector3f(1.0f, 1.0f, 1.0f + 1.0E-5f * (float)i), new Quaternionf());
    }

    public static RenderTypeGroup getLayerRenderTypes() {
        return new RenderTypeGroup(RenderType.translucent(), NeoForgeRenderTypes.ITEM_UNSORTED_TRANSLUCENT.get());
    }

    private static final class PizzaSliceOverrideHandler
    extends ItemOverrides {
        private final Map<String, BakedModel> cache = Maps.newHashMap();
        private final ItemOverrides nested;
        private final ModelBaker baker;
        private final IGeometryBakingContext owner;
        private final DynamicPizzaSliceModel parent;

        private PizzaSliceOverrideHandler(ItemOverrides nested, ModelBaker baker, IGeometryBakingContext owner, DynamicPizzaSliceModel parent) {
            this.nested = nested;
            this.baker = baker;
            this.owner = owner;
            this.parent = parent;
        }

        public BakedModel resolve(BakedModel originalModel, ItemStack stack, @Nullable ClientLevel level, @Nullable LivingEntity entity, int integer) {
            BakedModel overriden = this.nested.resolve(originalModel, stack, level, entity, integer);
            if (overriden != originalModel) {
                return overriden;
            }
            if (stack.has(ModDataComponents.PIZZA_INGREDIENTS)) {
                String name = ((PizzaIngredients)stack.get(ModDataComponents.PIZZA_INGREDIENTS)).getIngredients().toString();
                if (!this.cache.containsKey(name)) {
                    DynamicPizzaSliceModel unbaked = this.parent.withStack(stack);
                    BakedModel bakedModel = unbaked.bake(this.owner, this.baker, Material::sprite, (ModelState)BlockModelRotation.X0_Y0, this);
                    this.cache.put(name, bakedModel);
                    return bakedModel;
                }
                return this.cache.get(name);
            }
            return originalModel;
        }
    }

    public static enum Loader implements IGeometryLoader<DynamicPizzaSliceModel>
    {
        INSTANCE;


        public DynamicPizzaSliceModel read(JsonObject jsonObject, JsonDeserializationContext deserializationContext) {
            return new DynamicPizzaSliceModel(ItemStack.EMPTY);
        }
    }
}

