/*
 * Decompiled with CFR 0.152.
 */
package com.tiviacz.pizzadelight.blocks;

import com.tiviacz.pizzadelight.blockentity.PizzaBlockEntity;
import com.tiviacz.pizzadelight.blocks.AbstractPizzaBlock;
import com.tiviacz.pizzadelight.init.ModItems;
import com.tiviacz.pizzadelight.items.PizzaPeelItem;
import com.tiviacz.pizzadelight.util.Utils;
import java.util.List;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.BlockHitResult;
import vectorwing.farmersdelight.common.tag.ModTags;
import vectorwing.farmersdelight.common.utility.ItemUtils;
import vectorwing.farmersdelight.common.utility.TextUtils;

public class PizzaBlock
extends AbstractPizzaBlock {
    public static final IntegerProperty SLICES = IntegerProperty.create((String)"slices", (int)0, (int)3);

    public PizzaBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)this.getStateDefinition().any()).setValue((Property)SLICES, (Comparable)Integer.valueOf(0)));
    }

    public ItemStack getPizzaSliceItem() {
        return new ItemStack((ItemLike)ModItems.PIZZA_SLICE.get());
    }

    public ItemStack getPizzaSliceItem(@Nonnull Level level, @Nonnull BlockPos pos) {
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof PizzaBlockEntity) {
            PizzaBlockEntity blockEntity2 = (PizzaBlockEntity)blockEntity;
            ItemStack stack = this.getPizzaSliceItem();
            blockEntity2.getSlice(stack);
            return stack;
        }
        return this.getPizzaSliceItem();
    }

    public int getMaxSlices() {
        return 4;
    }

    public float getDestroyProgress(BlockState pState, Player pPlayer, BlockGetter pLevel, BlockPos pPos) {
        pPlayer.hurt(pPlayer.damageSources().onFire(), 1.0f);
        return super.getDestroyProgress(pState, pPlayer, pLevel, pPos);
    }

    public ItemInteractionResult useItemOn(ItemStack heldStack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        return heldStack.is(ModTags.KNIVES) ? this.cutSlice(level, pos, state, player.getDirection().getOpposite()) : (heldStack.getItem() instanceof PizzaPeelItem && (Integer)state.getValue((Property)SLICES) == 0 ? this.pickUpPizza(level, pos, state, player.getDirection().getOpposite()) : ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION);
    }

    protected InteractionResult useWithoutItem(BlockState state, Level level, BlockPos pos, Player player, BlockHitResult hitResult) {
        if (level.isClientSide) {
            if (this.consumeSlice(level, pos, state, player).consumesAction()) {
                return InteractionResult.SUCCESS;
            }
            if (player.getItemInHand(InteractionHand.MAIN_HAND).isEmpty()) {
                return InteractionResult.CONSUME;
            }
        }
        return this.consumeSlice(level, pos, state, player);
    }

    protected InteractionResult consumeSlice(Level level, BlockPos pos, BlockState state, Player playerIn) {
        int slices;
        if (!playerIn.canEat(false)) {
            return InteractionResult.PASS;
        }
        ItemStack sliceStack = this.getPizzaSliceItem(level, pos);
        FoodProperties sliceFood = sliceStack.getItem().getFoodProperties(sliceStack, (LivingEntity)playerIn);
        if (sliceFood != null) {
            playerIn.getFoodData().eat(sliceFood);
            for (FoodProperties.PossibleEffect effect : sliceFood.effects()) {
                if (level.isClientSide || effect == null || !(level.random.nextFloat() < effect.probability())) continue;
                playerIn.addEffect(effect.effect());
            }
        }
        if ((slices = ((Integer)state.getValue((Property)SLICES)).intValue()) < this.getMaxSlices() - 1) {
            level.setBlock(pos, (BlockState)state.setValue((Property)SLICES, (Comparable)Integer.valueOf(slices + 1)), 3);
        } else {
            level.removeBlock(pos, false);
        }
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof PizzaBlockEntity) {
            PizzaBlockEntity blockEntity2 = (PizzaBlockEntity)blockEntity;
            blockEntity2.requestModelDataUpdate();
        }
        level.playSound(null, pos, SoundEvents.GENERIC_EAT, SoundSource.PLAYERS, 0.8f, 0.8f);
        return InteractionResult.SUCCESS;
    }

    public ItemInteractionResult cutSlice(Level level, BlockPos pos, BlockState state, Direction direction) {
        int slices = (Integer)state.getValue((Property)SLICES);
        ItemStack pizzaSlice = this.getPizzaSliceItem(level, pos);
        if (slices < this.getMaxSlices() - 1) {
            level.setBlock(pos, (BlockState)state.setValue((Property)SLICES, (Comparable)Integer.valueOf(slices + 1)), 3);
        } else {
            level.removeBlock(pos, false);
        }
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof PizzaBlockEntity) {
            PizzaBlockEntity blockEntity2 = (PizzaBlockEntity)blockEntity;
            blockEntity2.requestModelDataUpdate();
        }
        ItemUtils.spawnItemEntity((Level)level, (ItemStack)pizzaSlice, (double)((double)pos.getX() + 0.5), (double)((double)pos.getY() + 0.3), (double)((double)pos.getZ() + 0.5), (double)((double)direction.getStepX() * 0.15), (double)0.05, (double)((double)direction.getStepZ() * 0.15));
        level.playSound(null, pos, SoundEvents.WOOL_BREAK, SoundSource.PLAYERS, 0.8f, 0.8f);
        return ItemInteractionResult.SUCCESS;
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{SLICES});
    }

    public int getAnalogOutputSignal(BlockState blockState, Level level, BlockPos pos) {
        return this.getMaxSlices() - (Integer)blockState.getValue((Property)SLICES);
    }

    public boolean hasAnalogOutputSignal(BlockState state) {
        return true;
    }

    public boolean isPathfindable(BlockState state, PathComputationType type) {
        return false;
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltipComponents, TooltipFlag tooltipFlag) {
        super.appendHoverText(stack, context, tooltipComponents, tooltipFlag);
        FoodProperties foodProperties = (FoodProperties)stack.get(DataComponents.FOOD);
        PizzaBlock.addInformationForPizza(stack, tooltipComponents::add, foodProperties != null && !foodProperties.effects().isEmpty(), context.tickRate());
    }

    public static void addInformationForPizza(ItemStack stack, Consumer<Component> tooltip, boolean addEffects, float tickRate) {
        if (addEffects) {
            TextUtils.addFoodEffectTooltip((ItemStack)stack, tooltip, (float)1.0f, (float)tickRate);
        }
        if (!Utils.isShiftPressed()) {
            tooltip.accept((Component)Component.translatable((String)"information.pizzadelight.view_ingredients"));
        }
    }
}

