/*
 * Decompiled with CFR 0.152.
 */
package com.tiviacz.pizzadelight.blockentity;

import com.tiviacz.pizzadelight.blockentity.BaseBlockEntity;
import com.tiviacz.pizzadelight.config.PizzaDelightConfig;
import com.tiviacz.pizzadelight.container.PizzaStationMenu;
import com.tiviacz.pizzadelight.init.ModBlockEntityTypes;
import com.tiviacz.pizzadelight.init.ModItems;
import com.tiviacz.pizzadelight.tags.ModTags;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.PotionItem;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.items.ItemStackHandler;
import org.jetbrains.annotations.NotNull;

public class PizzaStationBlockEntity
extends BaseBlockEntity
implements MenuProvider {
    private final ItemStackHandler inventory = this.createHandler();

    public PizzaStationBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)ModBlockEntityTypes.PIZZA_STATION.get(), pos, state);
    }

    public void loadAdditional(CompoundTag compound, HolderLookup.Provider pRegistries) {
        super.loadAdditional(compound, pRegistries);
        this.inventory.deserializeNBT(pRegistries, compound.getCompound("Inventory"));
    }

    public void saveAdditional(CompoundTag compound, HolderLookup.Provider pRegistries) {
        super.saveAdditional(compound, pRegistries);
        compound.put("Inventory", (Tag)this.inventory.serializeNBT(pRegistries));
    }

    public ItemStackHandler getInventory() {
        return this.inventory;
    }

    public Component getDisplayName() {
        return Component.translatable((String)this.getBlockState().getBlock().getDescriptionId());
    }

    @Nullable
    public AbstractContainerMenu createMenu(int id, Inventory playerInventory, Player player) {
        return new PizzaStationMenu(id, playerInventory, this);
    }

    public void openGUI(Player player, MenuProvider containerSupplier, BlockPos pos) {
        if (!player.level().isClientSide) {
            player.openMenu(containerSupplier, pos);
        }
    }

    private ItemStackHandler createHandler() {
        return new ItemStackHandler(13){

            public boolean isItemValid(int slot, @NotNull ItemStack stack) {
                if (stack.getItemHolder().is(ResourceLocation.fromNamespaceAndPath((String)"some_assembly_required", (String)"sandwich"))) {
                    return false;
                }
                if (slot == 0) {
                    return false;
                }
                if (slot == 1) {
                    return stack.is((Item)ModItems.RAW_PIZZA.get());
                }
                if (slot == 2) {
                    return stack.is(ModTags.SAUCE) || stack.getItem() instanceof PotionItem;
                }
                if (((Boolean)PizzaDelightConfig.SERVER.allowOnlyRecommendedIngredients.get()).booleanValue()) {
                    return stack.is(ModTags.INGREDIENTS);
                }
                return stack.has(DataComponents.FOOD) || stack.is(ModTags.INGREDIENTS);
            }

            protected void onContentsChanged(int slot) {
                super.onContentsChanged(slot);
                PizzaStationBlockEntity.this.setChanged();
            }
        };
    }
}

