/*
 * Decompiled with CFR 0.152.
 */
package com.tiviacz.pizzadelight.blockentity;

import com.tiviacz.pizzadelight.blockentity.BaseBlockEntity;
import com.tiviacz.pizzadelight.blocks.PizzaBlock;
import com.tiviacz.pizzadelight.blocks.RawPizzaBlock;
import com.tiviacz.pizzadelight.client.PizzaBakedModel;
import com.tiviacz.pizzadelight.common.PizzaBlockCalculator;
import com.tiviacz.pizzadelight.components.PizzaIngredients;
import com.tiviacz.pizzadelight.container.PizzaMenu;
import com.tiviacz.pizzadelight.init.ModBlockEntityTypes;
import com.tiviacz.pizzadelight.init.ModBlocks;
import com.tiviacz.pizzadelight.init.ModDataComponents;
import com.tiviacz.pizzadelight.tags.ModTags;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.core.component.DataComponentMap;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.Nameable;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.PotionItem;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.neoforge.client.model.data.ModelData;
import net.neoforged.neoforge.items.IItemHandlerModifiable;
import net.neoforged.neoforge.items.ItemStackHandler;

public class PizzaBlockEntity
extends BaseBlockEntity
implements MenuProvider,
Nameable {
    public ItemStackHandler inventory = this.createHandler((NonNullList<ItemStack>)NonNullList.withSize((int)10, (Object)ItemStack.EMPTY));
    private Component customName = null;
    private int bakingTime = 0;
    private final int BASE_BAKING_TIME = 600;
    private int selectedSlot = 0;
    private static final String BAKING_TIME = "BakingTime";
    private static final String CUSTOM_NAME = "CustomName";

    public PizzaBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)ModBlockEntityTypes.PIZZA.get(), pos, state);
    }

    public void loadAdditional(CompoundTag compound, HolderLookup.Provider pRegistries) {
        super.loadAdditional(compound, pRegistries);
        this.inventory.deserializeNBT(pRegistries, compound.getCompound("Inventory"));
        this.bakingTime = compound.getInt(BAKING_TIME);
        if (compound.contains(CUSTOM_NAME, 8)) {
            this.customName = Component.Serializer.fromJson((String)compound.getString(CUSTOM_NAME), (HolderLookup.Provider)pRegistries);
        }
    }

    public void saveAdditional(CompoundTag compound, HolderLookup.Provider pRegistries) {
        super.saveAdditional(compound, pRegistries);
        compound.put("Inventory", (Tag)this.inventory.serializeNBT(pRegistries));
        compound.putInt(BAKING_TIME, this.bakingTime);
        if (this.customName != null) {
            compound.putString(CUSTOM_NAME, Component.Serializer.toJson((Component)this.customName, (HolderLookup.Provider)pRegistries));
        }
    }

    public ItemInteractionResult onBlockActivated(Player player, InteractionHand hand) {
        if (hand == InteractionHand.MAIN_HAND) {
            ItemStack stack = player.getItemInHand(hand);
            if (this.isRaw() && !this.isBaking()) {
                if (stack.isEmpty()) {
                    if (player.isCrouching()) {
                        this.openGUI(player, this, this.getBlockPos());
                        return ItemInteractionResult.SUCCESS;
                    }
                    for (int i = this.inventory.getSlots() - 1; i >= 0; --i) {
                        ItemStack firstNotEmpty = this.inventory.getStackInSlot(i);
                        if (firstNotEmpty.isEmpty()) continue;
                        this.selectedSlot = i;
                        break;
                    }
                    if (!this.inventory.getStackInSlot(this.selectedSlot).isEmpty()) {
                        ItemStack modifiedCopy = this.inventory.getStackInSlot(this.selectedSlot).copy();
                        if (this.selectedSlot != 9 && !player.getInventory().add(modifiedCopy)) {
                            Containers.dropItemStack((Level)this.level, (double)this.getBlockPos().getX(), (double)this.getBlockPos().getY(), (double)this.getBlockPos().getZ(), (ItemStack)modifiedCopy);
                        }
                        if (this.selectedSlot == 9 && modifiedCopy.is(ModTags.SAUCE) && !player.getInventory().add(modifiedCopy)) {
                            Containers.dropItemStack((Level)this.level, (double)this.getBlockPos().getX(), (double)this.getBlockPos().getY(), (double)this.getBlockPos().getZ(), (ItemStack)modifiedCopy);
                        }
                        this.level.playSound(player, this.getBlockPos(), SoundEvents.ITEM_PICKUP, SoundSource.BLOCKS, 0.7f, 0.8f + this.level.random.nextFloat());
                        this.removeFromSlot(this.selectedSlot);
                        this.setChanged();
                        return ItemInteractionResult.SUCCESS;
                    }
                } else {
                    for (int i = 0; i < this.inventory.getSlots(); ++i) {
                        ItemStack firstEmpty = this.inventory.getStackInSlot(i);
                        if (!firstEmpty.isEmpty()) continue;
                        this.selectedSlot = i;
                        break;
                    }
                    if (stack.getItem() instanceof PotionItem) {
                        if (!this.inventory.getStackInSlot(9).isEmpty() && !player.getInventory().add(this.inventory.getStackInSlot(9))) {
                            Containers.dropItemStack((Level)this.level, (double)this.getBlockPos().getX(), (double)this.getBlockPos().getY(), (double)this.getBlockPos().getZ(), (ItemStack)this.inventory.getStackInSlot(9));
                        }
                        ItemStack modifiedCopy = stack.copy();
                        modifiedCopy.setCount(1);
                        this.inventory.setStackInSlot(9, modifiedCopy);
                        stack.shrink(player.isCreative() ? 0 : 1);
                        ItemStack container = PizzaMenu.getItemStack(modifiedCopy);
                        player.addItem(container);
                        this.level.playSound(player, this.getBlockPos(), SoundEvents.AXOLOTL_SPLASH, SoundSource.BLOCKS, 0.7f, 0.8f + this.level.random.nextFloat());
                        this.setChanged();
                        return ItemInteractionResult.SUCCESS;
                    }
                    if (this.selectedSlot < 9 && this.canAddIngredient(stack, this.selectedSlot)) {
                        ItemStack modifiedCopy = stack.copy();
                        modifiedCopy.setCount(1);
                        this.inventory.setStackInSlot(this.selectedSlot, modifiedCopy);
                        stack.shrink(player.isCreative() ? 0 : 1);
                        this.level.playSound(player, this.getBlockPos(), SoundEvents.ITEM_PICKUP, SoundSource.BLOCKS, 0.7f, 0.8f + this.level.random.nextFloat());
                        this.setChanged();
                        return ItemInteractionResult.SUCCESS;
                    }
                }
            }
        }
        return ItemInteractionResult.FAIL;
    }

    public ItemStack cloneToItemStack(ItemStack stack) {
        if (this.inventory != null) {
            stack.set(ModDataComponents.PIZZA_INGREDIENTS, (Object)PizzaIngredients.fromHandler(this.inventory));
        }
        if (this.customName != null) {
            stack.set(DataComponents.CUSTOM_NAME, (Object)this.customName);
        }
        return stack;
    }

    public ItemStack getSlice(ItemStack stack) {
        if (this.inventory != null) {
            stack.set(ModDataComponents.PIZZA_INGREDIENTS, (Object)PizzaIngredients.fromHandler(this.inventory));
        }
        PizzaBlockCalculator calculator = new PizzaBlockCalculator(this.inventory);
        calculator.process();
        int allNutrition = (calculator.getHunger() + 3) / 4 * 4;
        FoodProperties.Builder foodProperties = new FoodProperties.Builder().nutrition(allNutrition / 4).saturationModifier(calculator.getSaturation());
        if (!calculator.getEffects().isEmpty()) {
            foodProperties.alwaysEdible();
        }
        stack.set(DataComponents.FOOD, (Object)foodProperties.build());
        return stack;
    }

    public void tryRemoving(Player player, ItemStack stack) {
        if (!player.getInventory().add(stack)) {
            Containers.dropItemStack((Level)this.level, (double)this.getBlockPos().getX(), (double)this.getBlockPos().getY(), (double)this.getBlockPos().getZ(), (ItemStack)stack);
        }
    }

    public ItemInteractionResult manageIngredients(Player player, InteractionHand hand) {
        if (hand == InteractionHand.MAIN_HAND) {
            ItemStack stack = player.getItemInHand(hand);
            if (this.isRaw() && !this.isBaking()) {
                if (stack.isEmpty()) {
                    for (int i = this.inventory.getSlots() - 1; i >= 0; --i) {
                        ItemStack nonEmpty = this.inventory.getStackInSlot(i);
                        if (nonEmpty.isEmpty()) continue;
                        this.selectedSlot = i;
                        break;
                    }
                    if (!this.inventory.getStackInSlot(this.selectedSlot).isEmpty()) {
                        ItemStack modifiedCopy = this.inventory.getStackInSlot(this.selectedSlot).copy();
                        if (this.selectedSlot != 9) {
                            this.tryRemoving(player, modifiedCopy);
                        }
                        this.level.playSound(player, this.getBlockPos(), SoundEvents.ITEM_PICKUP, SoundSource.BLOCKS, 0.7f, 0.8f + this.level.random.nextFloat());
                        this.removeFromSlot(this.selectedSlot);
                        this.setChanged();
                        return ItemInteractionResult.SUCCESS;
                    }
                } else {
                    for (int i = 0; i < this.inventory.getSlots(); ++i) {
                        ItemStack empty = this.inventory.getStackInSlot(i);
                        if (!empty.isEmpty()) continue;
                        this.selectedSlot = i;
                        break;
                    }
                    if (stack.getItem() instanceof PotionItem) {
                        ItemStack modifiedCopy = stack.copy();
                        modifiedCopy.setCount(1);
                        this.inventory.setStackInSlot(9, modifiedCopy);
                        stack.shrink(player.isCreative() ? 0 : 1);
                        ItemStack container = PizzaMenu.getItemStack(modifiedCopy);
                        this.tryRemoving(player, container);
                        this.level.playSound(player, this.getBlockPos(), SoundEvents.AXOLOTL_SPLASH, SoundSource.BLOCKS, 0.7f, 0.8f + this.level.random.nextFloat());
                        this.setChanged();
                        return ItemInteractionResult.SUCCESS;
                    }
                    if (this.selectedSlot < 9 && this.canAddIngredient(stack, this.selectedSlot)) {
                        ItemStack modifiedCopy = stack.copy();
                        modifiedCopy.setCount(1);
                        this.inventory.setStackInSlot(this.selectedSlot, modifiedCopy);
                        stack.shrink(player.isCreative() ? 0 : 1);
                        this.level.playSound(player, this.getBlockPos(), SoundEvents.ITEM_PICKUP, SoundSource.BLOCKS, 0.7f, 0.8f + this.level.random.nextFloat());
                        this.setChanged();
                        return ItemInteractionResult.SUCCESS;
                    }
                }
            }
        }
        return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
    }

    protected void applyImplicitComponents(BlockEntity.DataComponentInput pComponentInput) {
        super.applyImplicitComponents(pComponentInput);
        this.inventory = this.createHandler(((PizzaIngredients)pComponentInput.getOrDefault(ModDataComponents.PIZZA_INGREDIENTS, (Object)PizzaIngredients.fromHandler(this.inventory))).getIngredients());
        this.customName = (Component)pComponentInput.getOrDefault(DataComponents.CUSTOM_NAME, null);
    }

    protected void collectImplicitComponents(DataComponentMap.Builder pComponents) {
        super.collectImplicitComponents(pComponents);
        if (this.inventory != null) {
            pComponents.set(ModDataComponents.PIZZA_INGREDIENTS, (Object)PizzaIngredients.fromHandler(this.inventory));
        }
        if (this.hasCustomName()) {
            pComponents.set(DataComponents.CUSTOM_NAME, (Object)this.getCustomName());
        }
    }

    public boolean isBaking() {
        return this.bakingTime > 0;
    }

    public int getBakingTime() {
        return this.bakingTime;
    }

    public int getDefaultBakingTime() {
        return 600;
    }

    public boolean isRaw() {
        if (this.level == null) {
            return true;
        }
        return this.level.getBlockState(this.getBlockPos()).getBlock() instanceof RawPizzaBlock;
    }

    public int getCalculatedBakingTime() {
        int bakingTime = this.getDefaultBakingTime();
        for (int i = 0; i < this.inventory.getSlots(); ++i) {
            if (this.inventory.getStackInSlot(i).isEmpty()) continue;
            bakingTime += 20 * this.inventory.getStackInSlot(i).getCount();
        }
        return bakingTime;
    }

    public static void tick(Level level, BlockPos pos, BlockState state, PizzaBlockEntity blockEntity) {
        boolean save = false;
        if (blockEntity.isRaw() && blockEntity.bakingTime == 0 && level.getBlockState(pos.below()).is(vectorwing.farmersdelight.common.tag.ModTags.HEAT_SOURCES)) {
            blockEntity.bakingTime = 1;
            save = true;
        }
        if (blockEntity.isBaking()) {
            ++blockEntity.bakingTime;
            save = true;
            if (blockEntity.getBakingTime() >= blockEntity.getCalculatedBakingTime() && !level.isClientSide) {
                level.setBlockAndUpdate(blockEntity.getBlockPos(), ((Block)ModBlocks.PIZZA.get()).defaultBlockState());
                blockEntity.bakingTime = 0;
            }
            if (!level.getBlockState(pos.below()).is(vectorwing.farmersdelight.common.tag.ModTags.HEAT_SOURCES)) {
                blockEntity.bakingTime = 0;
            }
        }
        if (save) {
            blockEntity.setChanged();
        }
    }

    public IItemHandlerModifiable getInventory() {
        return this.inventory;
    }

    public boolean canAddIngredient(ItemStack stack, int slot) {
        if (stack.getItemHolder().is(ResourceLocation.fromNamespaceAndPath((String)"some_assembly_required", (String)"sandwich"))) {
            return false;
        }
        if (stack.has(DataComponents.FOOD) || stack.is(ModTags.INGREDIENTS)) {
            return this.inventory.getStackInSlot(slot).isEmpty();
        }
        return false;
    }

    public void removeFromSlot(int slot) {
        this.inventory.setStackInSlot(slot, ItemStack.EMPTY);
    }

    private ItemStackHandler createHandler(NonNullList<ItemStack> contents) {
        return new ItemStackHandler(contents){

            public int getSlotLimit(int slot) {
                return 1;
            }

            public boolean isItemValid(int slot, @Nonnull ItemStack stack) {
                if (PizzaBlockEntity.this.isRaw() && !PizzaBlockEntity.this.isBaking()) {
                    return PizzaBlockEntity.this.canAddIngredient(stack, slot);
                }
                return false;
            }

            protected void onContentsChanged(int slot) {
                if (PizzaBlockEntity.this.getBlockState().getBlock() instanceof RawPizzaBlock) {
                    PizzaBlockEntity.this.setChanged();
                    PizzaBlockEntity.this.requestModelDataUpdate();
                }
            }
        };
    }

    public Component getName() {
        return this.customName != null ? this.customName : this.getDefaultName();
    }

    @Nullable
    public Component getCustomName() {
        return this.customName;
    }

    public Component getDisplayName() {
        return this.getName();
    }

    public Component getDefaultName() {
        return Component.translatable((String)this.getBlockState().getBlock().getDescriptionId());
    }

    @Nullable
    public AbstractContainerMenu createMenu(int id, Inventory playerInventory, Player playerEntity) {
        return new PizzaMenu(id, playerInventory, this);
    }

    public void openGUI(Player player, MenuProvider menuSupplier, BlockPos pos) {
        if (!player.level().isClientSide) {
            player.openMenu(menuSupplier, pos);
        }
    }

    @Nonnull
    public ModelData getModelData() {
        ModelData.Builder builder = ModelData.builder();
        builder.with(PizzaBakedModel.LAYER_PROVIDERS, Optional.of(this.getInventory()));
        builder.with(PizzaBakedModel.INTEGER_PROPERTY, Optional.of(this.getBlockState().getBlock() == ModBlocks.PIZZA.get() ? (Integer)this.getBlockState().getValue((Property)PizzaBlock.SLICES) : Integer.valueOf(0)));
        builder.with(PizzaBakedModel.IS_RAW, Optional.of(this.isRaw()));
        ModelData modelData = builder.build();
        return modelData;
    }
}

