/*
 * Decompiled with CFR 0.152.
 */
package com.starfish_studios.another_furniture.util.block;

import com.starfish_studios.another_furniture.block.ChairBlock;
import com.starfish_studios.another_furniture.block.ShelfBlock;
import com.starfish_studios.another_furniture.block.properties.HorizontalConnectionType;
import com.starfish_studios.another_furniture.block.properties.ModBlockStateProperties;
import com.starfish_studios.another_furniture.entity.SeatEntity;
import com.starfish_studios.another_furniture.registry.AFBlockTags;
import com.starfish_studios.another_furniture.registry.AFSoundEvents;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SlabBlock;
import net.minecraft.world.level.block.StairBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Half;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.SlabType;
import net.minecraft.world.level.block.state.properties.StairsShape;
import net.minecraft.world.phys.AABB;

public interface TuckableBlock {
    public static final BooleanProperty TUCKED = ModBlockStateProperties.TUCKED;

    public static boolean tryTuck(BlockState state, Level level, BlockPos pos, Player player) {
        boolean tucked = (Boolean)state.getValue((Property)TUCKED);
        if (!player.isCrouching() || !TuckableBlock.canTuckUnderBlockInfront(state, level, pos)) {
            return false;
        }
        if (tucked) {
            level.setBlockAndUpdate(pos, (BlockState)state.setValue((Property)TUCKED, (Comparable)Boolean.valueOf(false)));
            level.playSound(null, pos, AFSoundEvents.CHAIR_UNTUCK.get(), SoundSource.BLOCKS, 1.0f, 1.0f);
            return true;
        }
        if (!TuckableBlock.isBlockedFromTucking(state, level, pos)) {
            level.setBlockAndUpdate(pos, (BlockState)state.setValue((Property)TUCKED, (Comparable)Boolean.valueOf(true)));
            level.playSound(null, pos, AFSoundEvents.CHAIR_TUCK.get(), SoundSource.BLOCKS, 1.0f, 1.0f);
            return true;
        }
        return false;
    }

    public static boolean canTuckUnderBlockInfront(BlockState state, Level level, BlockPos pos) {
        Direction forward = (Direction)state.getValue((Property)BlockStateProperties.HORIZONTAL_FACING);
        BlockState forwardState = level.getBlockState(pos.relative(forward));
        Block forwardBlock = forwardState.getBlock();
        if (forwardBlock instanceof ShelfBlock) {
            return forwardState.getValue(ShelfBlock.TYPE) == HorizontalConnectionType.MIDDLE || forwardState.getValue((Property)BlockStateProperties.HORIZONTAL_FACING) != forward;
        }
        if (forwardBlock instanceof SlabBlock) {
            return forwardState.getValue((Property)SlabBlock.TYPE) == SlabType.TOP;
        }
        if (forwardBlock instanceof StairBlock) {
            StairsShape shape = (StairsShape)forwardState.getValue((Property)StairBlock.SHAPE);
            Direction facing_dir = (Direction)forwardState.getValue((Property)BlockStateProperties.HORIZONTAL_FACING);
            return forwardState.getValue((Property)StairBlock.HALF) == Half.TOP && (forward == facing_dir || shape == StairsShape.OUTER_LEFT && forward == facing_dir.getCounterClockWise() || shape == StairsShape.OUTER_RIGHT && forward == facing_dir.getClockWise());
        }
        return forwardState.is(AFBlockTags.CHAIRS_TUCKABLE_UNDER);
    }

    public static boolean isBlockedFromTucking(BlockState state, Level level, BlockPos pos) {
        if (!level.getEntitiesOfClass(SeatEntity.class, new AABB(pos)).isEmpty()) {
            return true;
        }
        Direction facing = (Direction)state.getValue((Property)BlockStateProperties.HORIZONTAL_FACING);
        BlockState left = level.getBlockState(pos.relative(facing).relative(facing.getCounterClockWise()));
        BlockState right = level.getBlockState(pos.relative(facing).relative(facing.getClockWise()));
        if (left.getBlock() instanceof ChairBlock && ((Boolean)left.getValue((Property)TUCKED)).booleanValue() && left.getValue((Property)BlockStateProperties.HORIZONTAL_FACING) == facing.getClockWise()) {
            return true;
        }
        return right.getBlock() instanceof ChairBlock && (Boolean)right.getValue((Property)TUCKED) != false && right.getValue((Property)BlockStateProperties.HORIZONTAL_FACING) == facing.getCounterClockWise();
    }
}

