/*
 * Decompiled with CFR 0.152.
 */
package com.starfish_studios.another_furniture.block;

import com.starfish_studios.another_furniture.block.properties.ModBlockStateProperties;
import com.starfish_studios.another_furniture.block.properties.VerticalConnectionType;
import com.starfish_studios.another_furniture.util.block.BlockPart;
import com.starfish_studios.another_furniture.util.block.HammerableBlock;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.DoorHingeSide;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class ShutterBlock
extends Block
implements SimpleWaterloggedBlock,
HammerableBlock {
    public static final DirectionProperty FACING = BlockStateProperties.HORIZONTAL_FACING;
    public static final EnumProperty<VerticalConnectionType> VERTICAL = ModBlockStateProperties.VERTICAL_CONNECTION_TYPE;
    public static final BooleanProperty OPEN = BlockStateProperties.OPEN;
    public static final EnumProperty<DoorHingeSide> HINGE = BlockStateProperties.DOOR_HINGE;
    public static final BooleanProperty POWERED = BlockStateProperties.POWERED;
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.WATERLOGGED;
    public static final IntegerProperty VARIANT = ModBlockStateProperties.VARIANT;
    protected static final VoxelShape EAST = Block.box((double)0.0, (double)0.0, (double)0.0, (double)3.0, (double)16.0, (double)16.0);
    protected static final VoxelShape WEST = Block.box((double)13.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
    protected static final VoxelShape SOUTH = Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)3.0);
    protected static final VoxelShape NORTH = Block.box((double)0.0, (double)0.0, (double)13.0, (double)16.0, (double)16.0, (double)16.0);
    protected static final VoxelShape[] SHAPES = new VoxelShape[]{SOUTH, WEST, NORTH, EAST};

    public ShutterBlock(int defaultVariant, BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)FACING, (Comparable)Direction.NORTH)).setValue(VERTICAL, (Comparable)((Object)VerticalConnectionType.SINGLE))).setValue((Property)OPEN, (Comparable)Boolean.valueOf(false))).setValue((Property)VARIANT, (Comparable)Integer.valueOf(defaultVariant))).setValue((Property)POWERED, (Comparable)Boolean.valueOf(false))).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    public VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        int shape = ((Direction)state.getValue((Property)FACING)).get2DDataValue() + (((Boolean)state.getValue((Property)OPEN)).booleanValue() ? (state.getValue(HINGE) == DoorHingeSide.LEFT ? 3 : 1) : 0);
        return SHAPES[shape % 4];
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext context) {
        Vec3 clickLocation;
        Direction facing = context.getHorizontalDirection().getOpposite();
        BlockState state = (BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)facing);
        Level level = context.getLevel();
        BlockPos clickedPos = context.getClickedPos();
        state = (BlockState)state.setValue(HINGE, (Comparable)(BlockPart.get1D(clickedPos, clickLocation = context.getClickLocation(), facing.getClockWise(), 2) == 0 ? DoorHingeSide.LEFT : DoorHingeSide.RIGHT));
        boolean powered = level.hasNeighborSignal(clickedPos);
        return (BlockState)((BlockState)((BlockState)((BlockState)state.setValue((Property)OPEN, (Comparable)Boolean.valueOf(powered))).setValue((Property)POWERED, (Comparable)Boolean.valueOf(powered))).setValue(VERTICAL, (Comparable)((Object)this.getType(state, level.getBlockState(clickedPos.above()), level.getBlockState(clickedPos.below()))))).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(level.getFluidState(context.getClickedPos()).getType() == Fluids.WATER));
    }

    public void neighborChanged(BlockState state, Level level, BlockPos pos, Block block, BlockPos fromPos, boolean isMoving) {
        if (level.isClientSide) {
            return;
        }
        boolean powered = level.hasNeighborSignal(pos);
        if (powered != (Boolean)state.getValue((Property)POWERED)) {
            if ((Boolean)state.getValue((Property)OPEN) != powered) {
                state = (BlockState)state.setValue((Property)OPEN, (Comparable)Boolean.valueOf(powered));
                this.toggleShutters((BlockState)state.setValue((Property)OPEN, (Comparable)Boolean.valueOf(!powered)), level, pos, null);
            }
            if (((Boolean)(state = (BlockState)state.setValue((Property)POWERED, (Comparable)Boolean.valueOf(powered))).getValue((Property)WATERLOGGED)).booleanValue()) {
                level.scheduleTick(pos, (Fluid)Fluids.WATER, Fluids.WATER.getTickDelay((LevelReader)level));
            }
        }
        VerticalConnectionType type = this.getType(state, level.getBlockState(pos.above()), level.getBlockState(pos.below()));
        state = (BlockState)state.setValue(VERTICAL, (Comparable)((Object)type));
        level.setBlock(pos, state, 3);
    }

    protected ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        if (this.tryHammerBlock((Property)VARIANT, stack, state, (LevelAccessor)level, pos, player)) {
            return ItemInteractionResult.SUCCESS;
        }
        return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
    }

    protected InteractionResult useWithoutItem(BlockState state, Level level, BlockPos pos, Player player, BlockHitResult hitResult) {
        return this.toggleShutters(state, level, pos, player);
    }

    public InteractionResult toggleShutters(BlockState state, Level level, BlockPos pos, Player player) {
        state = (BlockState)state.cycle((Property)OPEN);
        level.setBlock(pos, state, 3);
        if (player == null || !player.isCrouching()) {
            this.toggleShutters(state, level, pos, (Boolean)state.getValue((Property)OPEN));
        }
        level.playSound(null, pos, ShutterBlock.shutterSound((Boolean)state.getValue((Property)OPEN)), SoundSource.BLOCKS, 1.0f, 1.0f);
        if (((Boolean)state.getValue((Property)WATERLOGGED)).booleanValue()) {
            level.scheduleTick(pos, (Fluid)Fluids.WATER, Fluids.WATER.getTickDelay((LevelReader)level));
        }
        return InteractionResult.sidedSuccess((boolean)level.isClientSide);
    }

    public void toggleShutters(BlockState state, Level level, BlockPos pos, boolean open) {
        int i;
        BlockState updateState = state;
        BlockPos updatePos = pos;
        if (state.getValue(VERTICAL) == VerticalConnectionType.MIDDLE || state.getValue(VERTICAL) == VerticalConnectionType.BOTTOM) {
            BlockState above;
            int heightUp = level.dimensionType().height() - updatePos.getY();
            for (i = 0; i < heightUp && (above = level.getBlockState(updatePos.above())).is(state.getBlock()) && above.getValue((Property)FACING) == updateState.getValue((Property)FACING) && above.getValue(HINGE) == updateState.getValue(HINGE) && (Boolean)above.getValue((Property)OPEN) != open; ++i) {
                updateState = above;
                updatePos = updatePos.above();
                level.setBlock(updatePos, (BlockState)updateState.setValue((Property)OPEN, (Comparable)Boolean.valueOf(open)), 3);
            }
        }
        if (state.getValue(VERTICAL) == VerticalConnectionType.MIDDLE || state.getValue(VERTICAL) == VerticalConnectionType.TOP) {
            BlockState below;
            updateState = state;
            updatePos = pos;
            int heightDown = level.dimensionType().minY() - updatePos.getY();
            heightDown = heightDown < 0 ? -heightDown : heightDown;
            for (i = 0; i < heightDown && (below = level.getBlockState(updatePos.below())).is(state.getBlock()) && below.getValue((Property)FACING) == updateState.getValue((Property)FACING) && below.getValue(HINGE) == updateState.getValue(HINGE) && (Boolean)below.getValue((Property)OPEN) != open; ++i) {
                updateState = below;
                updatePos = updatePos.below();
                level.setBlock(updatePos, (BlockState)updateState.setValue((Property)OPEN, (Comparable)Boolean.valueOf(open)), 3);
            }
        }
    }

    public static SoundEvent shutterSound(boolean open) {
        return open ? SoundEvents.WOODEN_TRAPDOOR_OPEN : SoundEvents.WOODEN_TRAPDOOR_CLOSE;
    }

    public VerticalConnectionType getType(BlockState state, BlockState above, BlockState below) {
        boolean up = this.isConnected(state, above);
        boolean down = this.isConnected(state, below);
        if (up && down) {
            return VerticalConnectionType.MIDDLE;
        }
        if (up) {
            return VerticalConnectionType.BOTTOM;
        }
        if (down) {
            return VerticalConnectionType.TOP;
        }
        return VerticalConnectionType.SINGLE;
    }

    public boolean isConnected(BlockState state, BlockState other) {
        return other.is(state.getBlock()) && other.getValue((Property)FACING) == state.getValue((Property)FACING) && other.getValue((Property)OPEN) == state.getValue((Property)OPEN) && other.getValue(HINGE) == state.getValue(HINGE) && ((Integer)other.getValue((Property)VARIANT)).equals(state.getValue((Property)VARIANT));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{FACING, VERTICAL, OPEN, HINGE, VARIANT, POWERED, WATERLOGGED});
    }

    public FluidState getFluidState(BlockState state) {
        return (Boolean)state.getValue((Property)WATERLOGGED) != false ? Fluids.WATER.getSource(false) : super.getFluidState(state);
    }

    public BlockState updateShape(BlockState state, Direction direction, BlockState neighborState, LevelAccessor level, BlockPos currentPos, BlockPos neighborPos) {
        if (((Boolean)state.getValue((Property)WATERLOGGED)).booleanValue()) {
            level.scheduleTick(currentPos, (Fluid)Fluids.WATER, Fluids.WATER.getTickDelay((LevelReader)level));
        }
        return super.updateShape(state, direction, neighborState, level, currentPos, neighborPos);
    }

    public BlockState rotate(BlockState state, Rotation rotation) {
        return (BlockState)state.setValue((Property)FACING, (Comparable)rotation.rotate((Direction)state.getValue((Property)FACING)));
    }

    public BlockState mirror(BlockState state, Mirror mirror) {
        return state.rotate(mirror.getRotation((Direction)state.getValue((Property)FACING)));
    }
}

