/*
 * Decompiled with CFR 0.152.
 */
package com.brpacks.arkanis.aac.util;

import com.brpacks.arkanis.aac.util.ColorUtils;
import com.mojang.brigadier.context.CommandContext;
import java.util.UUID;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.commands.arguments.UuidArgument;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.HoverEvent;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.entity.player.Player;

public class CommandUtils {
    public static UUID getCorrectUUID(CommandContext<CommandSourceStack> context) {
        UUID playerUUID = null;
        try {
            playerUUID = EntityArgument.getPlayer(context, (String)"player").getUUID();
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (playerUUID == null) {
            try {
                playerUUID = UuidArgument.getUuid(context, (String)"playerUUID");
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return playerUUID;
    }

    public static void sendColorMessage(CommandContext<CommandSourceStack> context, MutableComponent message, int red, int green, int blue, String hexColor, Player player) {
        message.append((String)(player != null ? "\u00a7a" + player.getName().getString() : "\u00a74offline") + "\u00a7r: ");
        ((CommandSourceStack)context.getSource()).sendSystemMessage((Component)message);
        int color = ColorUtils.packRGB(red, green, blue);
        message = Component.literal((String)("RGB: \u00a7c" + red + "\u00a7f, \u00a7a" + green + "\u00a7f, \u00a79" + blue + "\u00a7f) /"));
        message.append((Component)Component.literal((String)(" #" + hexColor)).withStyle(style -> style.withColor(color)));
        message.withStyle(hover -> hover.withHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_TEXT, (Object)Component.literal((String)"Clique para mais informa\u00e7\u00f5es sobre a cor"))));
        message.withStyle(action -> action.withClickEvent(new ClickEvent(ClickEvent.Action.OPEN_URL, "https://www.colorhexa.com/" + hexColor)));
        ((CommandSourceStack)context.getSource()).sendSystemMessage((Component)message);
    }
}

