/*
 * Decompiled with CFR 0.152.
 */
package com.brpacks.arkanis.aac.util;

import com.mojang.brigadier.context.CommandContext;
import java.util.List;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;

public class ColorUtils {
    public static List<Integer> hexToRGB(String hexColor, CommandContext<CommandSourceStack> context) {
        if (!hexColor.matches("^#?[A-Fa-f0-9]{6}$")) {
            MutableComponent message = Component.literal((String)"Hexadecimal invalido, use: ");
            message.append("https://htmlcolorcodes.com/color-picker/");
            message.withStyle(style -> style.withClickEvent(new ClickEvent(ClickEvent.Action.OPEN_URL, "https://htmlcolorcodes.com/color-picker/")));
            ((CommandSourceStack)context.getSource()).sendFailure((Component)message);
            return null;
        }
        if (hexColor.startsWith("#")) {
            hexColor = hexColor.substring(1);
        }
        int rgb = Integer.parseInt(hexColor, 16);
        return ColorUtils.unpackRGB(rgb);
    }

    public static int packRGB(int red, int green, int blue) {
        return red << 16 | green << 8 | blue;
    }

    public static List<Integer> unpackRGB(int rgb) {
        int red = rgb >> 16 & 0xFF;
        int green = rgb >> 8 & 0xFF;
        int blue = rgb & 0xFF;
        return List.of(Integer.valueOf(red), Integer.valueOf(green), Integer.valueOf(blue));
    }

    public static boolean isTooBright(int red, int green, int blue) {
        double luminance = 0.299 * (double)red + 0.587 * (double)green + 0.114 * (double)blue;
        double brightnessLimit = 127.5;
        return luminance > brightnessLimit;
    }

    public static boolean isColoursTooClose(int red1, int green1, int blue1, int red2, int green2, int blue2) {
        double distanceLimit;
        double distance = Math.sqrt(Math.pow(red1 - red2, 2.0) + Math.pow(green1 - green2, 2.0) + Math.pow(blue1 - blue2, 2.0));
        return distance < (distanceLimit = 50.0);
    }

    public static boolean isColoursTooCloseInBrightness(int red1, int green1, int blue1, int red2, int green2, int blue2) {
        double distanceLimit;
        double luminance1 = 0.299 * (double)red1 + 0.587 * (double)green1 + 0.114 * (double)blue1;
        double luminance2 = 0.299 * (double)red2 + 0.587 * (double)green2 + 0.114 * (double)blue2;
        double distance = Math.abs(luminance1 - luminance2);
        return distance < (distanceLimit = 120.0);
    }
}

