/*
 * Decompiled with CFR 0.152.
 */
package com.brpacks.arkanis.aac.mixin;

import com.brpacks.arkanis.aac.Data;
import java.util.function.Supplier;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.Holder;
import net.minecraft.core.RegistryAccess;
import net.minecraft.resources.ResourceKey;
import net.minecraft.util.Mth;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.dimension.DimensionType;
import net.minecraft.world.level.storage.WritableLevelData;
import net.minecraft.world.phys.Vec3;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={ClientLevel.class})
public abstract class SkyColorMixin
extends Level {
    protected SkyColorMixin(WritableLevelData pLevelData, ResourceKey<Level> pDimension, RegistryAccess pRegistryAccess, Holder<DimensionType> pDimensionTypeRegistration, Supplier<ProfilerFiller> pProfiler, boolean pIsClientSide, boolean pIsDebug, long pBiomeZoomSeed, int pMaxChainedNeighborUpdates) {
        super(pLevelData, pDimension, pRegistryAccess, pDimensionTypeRegistration, pProfiler, pIsClientSide, pIsDebug, pBiomeZoomSeed, pMaxChainedNeighborUpdates);
    }

    @Shadow
    public abstract int getSkyFlashTime();

    @Inject(method={"getSkyColor"}, at={@At(value="HEAD")}, cancellable=true)
    private void injectGetSkyColor(Vec3 pPos, float pPartialTick, CallbackInfoReturnable<Vec3> cir) {
        int i;
        float f9;
        int color = Data.getSkyData();
        if (color == 0) {
            return;
        }
        cir.cancel();
        Vec3 vec31 = Vec3.fromRGB24((int)color);
        float f = this.getTimeOfDay(pPartialTick);
        float f1 = Mth.cos((float)(f * ((float)Math.PI * 2))) * 2.0f + 0.5f;
        f1 = Mth.clamp((float)f1, (float)0.0f, (float)1.0f);
        float f2 = (float)vec31.x * f1;
        float f3 = (float)vec31.y * f1;
        float f4 = (float)vec31.z * f1;
        float f5 = this.getRainLevel(pPartialTick);
        if (f5 > 0.0f) {
            float f6 = (f2 * 0.3f + f3 * 0.59f + f4 * 0.11f) * 0.6f;
            float f7 = 1.0f - f5 * 0.75f;
            f2 = f2 * f7 + f6 * (1.0f - f7);
            f3 = f3 * f7 + f6 * (1.0f - f7);
            f4 = f4 * f7 + f6 * (1.0f - f7);
        }
        if ((f9 = this.getThunderLevel(pPartialTick)) > 0.0f) {
            float f10 = (f2 * 0.3f + f3 * 0.59f + f4 * 0.11f) * 0.2f;
            float f8 = 1.0f - f9 * 0.75f;
            f2 = f2 * f8 + f10 * (1.0f - f8);
            f3 = f3 * f8 + f10 * (1.0f - f8);
            f4 = f4 * f8 + f10 * (1.0f - f8);
        }
        if ((i = this.getSkyFlashTime()) > 0) {
            float f11 = (float)i - pPartialTick;
            if (f11 > 1.0f) {
                f11 = 1.0f;
            }
            f2 = f2 * (1.0f - (f11 *= 0.45f)) + 0.8f * f11;
            f3 = f3 * (1.0f - f11) + 0.8f * f11;
            f4 = f4 * (1.0f - f11) + f11;
        }
        cir.setReturnValue((Object)new Vec3((double)f2, (double)f3, (double)f4));
    }
}

