/*
 * Decompiled with CFR 0.152.
 */
package com.brpacks.arkanis.aac.custom.entity.meteor;

import com.mojang.logging.LogUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.animatable.instance.SingletonAnimatableInstanceCache;
import software.bernie.geckolib.animation.AnimatableManager;
import software.bernie.geckolib.animation.Animation;
import software.bernie.geckolib.animation.AnimationController;
import software.bernie.geckolib.animation.AnimationState;
import software.bernie.geckolib.animation.PlayState;
import software.bernie.geckolib.animation.RawAnimation;

public class MeteorEntity
extends Entity
implements GeoEntity {
    AnimatableInstanceCache cache = new SingletonAnimatableInstanceCache((GeoAnimatable)this);
    public static EntityDataAccessor<Float> sizeMul = SynchedEntityData.defineId(MeteorEntity.class, (EntityDataSerializer)EntityDataSerializers.FLOAT);
    public static EntityDataAccessor<BlockPos> targetPos = SynchedEntityData.defineId(MeteorEntity.class, (EntityDataSerializer)EntityDataSerializers.BLOCK_POS);
    Vec3 direction;

    public MeteorEntity(EntityType<MeteorEntity> meteorEntityEntityType, Level pLevel) {
        super(meteorEntityEntityType, pLevel);
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllerRegistrar) {
        controllerRegistrar.add(new AnimationController((GeoAnimatable)this, "controller", 0, this::meteorController));
    }

    private PlayState meteorController(AnimationState<GeoAnimatable> meteorEntityAnimationState) {
        meteorEntityAnimationState.getController().setAnimation(RawAnimation.begin().then("rotate", Animation.LoopType.LOOP));
        return PlayState.CONTINUE;
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    public float getSizeMul() {
        return ((Float)this.entityData.get(sizeMul)).floatValue();
    }

    public void setSizeMul(float value) {
        this.entityData.set(sizeMul, (Object)Float.valueOf(value));
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        builder.define(sizeMul, (Object)Float.valueOf(1.0f));
        builder.define(targetPos, (Object)BlockPos.ZERO);
    }

    protected void addAdditionalSaveData(CompoundTag pCompound) {
        pCompound.putFloat("sizeMul", ((Float)this.entityData.get(sizeMul)).floatValue());
        pCompound.put("targetPos", (Tag)MeteorEntity.writeBlockPosToNBT((BlockPos)this.entityData.get(targetPos)));
    }

    protected void readAdditionalSaveData(CompoundTag pCompound) {
        if (pCompound.contains("sizeMul")) {
            this.setSizeMul(pCompound.getFloat("sizeMul"));
        }
        if (!pCompound.contains("targetPos")) {
            return;
        }
        BlockPos target = MeteorEntity.readBlockPosFromNBT(pCompound.getCompound("targetPos"));
        this.setTarget(target);
    }

    public static CompoundTag writeBlockPosToNBT(BlockPos pos) {
        CompoundTag nbt = new CompoundTag();
        nbt.putInt("targetPosX", pos.getX());
        nbt.putInt("targetPosY", pos.getY());
        nbt.putInt("targetPosZ", pos.getZ());
        return nbt;
    }

    public static BlockPos readBlockPosFromNBT(CompoundTag nbt) {
        int x = nbt.getInt("targetPosX");
        int y = nbt.getInt("targetPosY");
        int z = nbt.getInt("targetPosZ");
        return new BlockPos(x, y, z);
    }

    public void setTarget(BlockPos targetPos) {
        this.entityData.set(MeteorEntity.targetPos, (Object)targetPos);
    }

    public BlockPos getTarget() {
        return (BlockPos)this.entityData.get(targetPos);
    }

    public void tick() {
        super.tick();
        if (this.getTarget() == null || this.getTarget().equals((Object)BlockPos.ZERO)) {
            LogUtils.getLogger().warn("Meteor target is null or zero, removing entity");
            this.remove(Entity.RemovalReason.DISCARDED);
            return;
        }
        double distanceToTarget = this.getTarget().distManhattan((Vec3i)this.getOnPos());
        if (!this.onGround()) {
            this.setDeltaMovement(this.calculateDirection(this.getTarget()).scale(3.0));
        }
        this.move(MoverType.SELF, this.getDeltaMovement());
        if (distanceToTarget > 0.0 && !this.onGround()) {
            return;
        }
        if (this.level().isClientSide) {
            return;
        }
        this.level().explode((Entity)this, this.getX(), this.getY(), this.getZ(), 50.0f, true, Level.ExplosionInteraction.BLOCK);
        this.remove(Entity.RemovalReason.DISCARDED);
    }

    private Vec3 calculateDirection(BlockPos target) {
        if (this.direction != null) {
            return this.direction;
        }
        double targetX = (double)target.getX() - this.getX();
        double targetY = (double)target.getY() - this.getY();
        double targetZ = (double)target.getZ() - this.getZ();
        this.direction = new Vec3(targetX, targetY, targetZ).normalize();
        return this.direction;
    }
}

