/*
 * Decompiled with CFR 0.152.
 */
package com.brpacks.arkanis.aac.custom.entity.laser.mode;

import com.brpacks.arkanis.aac.custom.entity.CustomLightningBolt;
import com.brpacks.arkanis.aac.custom.entity.laser.LaserEntity;
import com.brpacks.arkanis.aac.custom.entity.laser.mode.LaserTickFeature;
import com.brpacks.arkanis.aac.registry.ModEntities;
import com.brpacks.arkanis.aac.registry.ModSounds;
import java.util.UUID;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public class LaserTeleport
implements LaserTickFeature {
    private Vec3 location;
    private float height;
    private boolean hasStarted;
    private Player owner;

    @Override
    public void tick(LaserEntity laserEntity) {
        if (!this.hasStarted) {
            this.init(laserEntity);
        }
        if (this.goUp(laserEntity, 170)) {
            this.finish(laserEntity);
        }
    }

    private void init(LaserEntity laserEntity) {
        if (this.location == null) {
            this.location = laserEntity.position();
        }
        Level level = laserEntity.level();
        this.owner = level.getPlayerByUUID((UUID)laserEntity.getOwner().orElse(null));
        if (this.owner == null) {
            laserEntity.remove(Entity.RemovalReason.DISCARDED);
            return;
        }
        laserEntity.level().playSound(null, this.location.x, this.location.y, this.location.z, ModSounds.LASER_TP.get(), SoundSource.AMBIENT, 1000.0f, 1.0f);
        this.owner.addEffect(new MobEffectInstance(MobEffects.MOVEMENT_SLOWDOWN, 10000, 100, false, false));
        for (int i = 0; i < 500; ++i) {
            level.addParticle((ParticleOptions)ParticleTypes.CLOUD, this.location.x, this.location.y, this.location.z, Math.random() - 0.5, Math.random() - 0.5, Math.random() - 0.5);
        }
        this.hasStarted = true;
    }

    private void finish(LaserEntity laserEntity) {
        CustomLightningBolt bolt = new CustomLightningBolt(ModEntities.CUSTOM_LIGHTNING_BOLT.get(), laserEntity.level());
        bolt.setPos(this.location.x, this.location.y, this.location.z);
        bolt.setPackedColor(laserEntity.getPackedColor());
        laserEntity.level().addFreshEntity((Entity)bolt);
        this.owner.teleportTo((double)laserEntity.getDestination().getX(), (double)laserEntity.getDestination().getY(), (double)laserEntity.getDestination().getZ());
        this.owner.removeEffect(MobEffects.MOVEMENT_SLOWDOWN);
        laserEntity.remove(Entity.RemovalReason.DISCARDED);
    }

    private boolean goUp(LaserEntity laserEntity, int limitHeight) {
        this.height = this.height < 10.0f ? this.height + 0.7f : this.height + 5.0f;
        laserEntity.setHeight(this.height);
        if (this.height < (float)limitHeight) {
            return false;
        }
        if (this.height > (float)limitHeight && this.location.y < (double)limitHeight) {
            this.location = this.location.add(0.0, 2.0, 0.0);
            laserEntity.teleportTo(this.location.x, this.location.y, this.location.z);
            this.owner.teleportTo(this.location.x, this.location.y + 10.0, this.location.z);
            return false;
        }
        return true;
    }
}

