/*
 * Decompiled with CFR 0.152.
 */
package com.brpacks.arkanis.aac.custom.entity.laser;

import com.brpacks.arkanis.aac.custom.entity.laser.mode.LaserMode;
import com.brpacks.arkanis.aac.custom.entity.laser.mode.LaserOrbitalCannon;
import com.brpacks.arkanis.aac.custom.entity.laser.mode.LaserTeleport;
import com.brpacks.arkanis.aac.custom.entity.laser.mode.LaserTickFeature;
import com.mojang.logging.LogUtils;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;

public class LaserEntity
extends Entity {
    private static final EntityDataAccessor<Integer> PACKED_COLOR = SynchedEntityData.defineId(LaserEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private static final EntityDataAccessor<Float> HEIGHT = SynchedEntityData.defineId(LaserEntity.class, (EntityDataSerializer)EntityDataSerializers.FLOAT);
    private static final EntityDataAccessor<Optional<UUID>> OWNER = SynchedEntityData.defineId(LaserEntity.class, (EntityDataSerializer)EntityDataSerializers.OPTIONAL_UUID);
    private static final EntityDataAccessor<BlockPos> DESTINATION = SynchedEntityData.defineId(LaserEntity.class, (EntityDataSerializer)EntityDataSerializers.BLOCK_POS);
    private static final EntityDataAccessor<String> MODE = SynchedEntityData.defineId(LaserEntity.class, (EntityDataSerializer)EntityDataSerializers.STRING);
    LaserTickFeature laserTick;

    public LaserEntity(EntityType<?> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        builder.define(PACKED_COLOR, (Object)0);
        builder.define(HEIGHT, (Object)Float.valueOf(100.0f));
        builder.define(OWNER, Optional.empty());
        builder.define(DESTINATION, (Object)BlockPos.ZERO);
        builder.define(MODE, (Object)"");
    }

    public int getPackedColor() {
        return (Integer)this.entityData.get(PACKED_COLOR);
    }

    public float getHeight() {
        return ((Float)this.entityData.get(HEIGHT)).floatValue();
    }

    public Optional<UUID> getOwner() {
        return (Optional)this.entityData.get(OWNER);
    }

    public BlockPos getDestination() {
        return (BlockPos)this.entityData.get(DESTINATION);
    }

    public void setDestination(BlockPos destination) {
        this.entityData.set(DESTINATION, (Object)destination);
    }

    public void setOwner(UUID owner) {
        this.entityData.set(OWNER, Optional.of(owner));
    }

    public void setPackedColor(int value) {
        this.entityData.set(PACKED_COLOR, (Object)value);
    }

    public void setHeight(float value) {
        this.entityData.set(HEIGHT, (Object)Float.valueOf(value));
    }

    public void setMode(LaserMode mode) {
        this.entityData.set(MODE, (Object)mode.name());
    }

    public LaserMode getMode() {
        String mode = (String)this.entityData.get(MODE);
        if (mode.isEmpty() || mode.isBlank()) {
            LogUtils.getLogger().error("Laser mode is not valid, setting as invalid");
            return LaserMode.INVALID;
        }
        return LaserMode.valueOf(mode);
    }

    public void addAdditionalSaveData(@NotNull CompoundTag nbt) {
        nbt.putInt("packedColor", this.getPackedColor());
    }

    public void readAdditionalSaveData(@NotNull CompoundTag nbt) {
        if (nbt.contains("packedColor")) {
            this.setPackedColor(nbt.getInt("packedColor"));
        }
    }

    public void playerTouch(Player player) {
        if (player.getUUID().equals(this.getOwner().orElse(null))) {
            return;
        }
        Vec3 lookingVec = player.getLookAngle();
        player.setDeltaMovement(lookingVec.multiply(-1.0, -1.0, -1.0).multiply(2.0, 2.0, 2.0));
        super.playerTouch(player);
    }

    public void tick() {
        super.tick();
        if (this.laserTick == null) {
            switch (this.getMode()) {
                case TELEPORT: {
                    this.laserTick = new LaserTeleport();
                    break;
                }
                case ORBITAL_CANNON: {
                    this.laserTick = new LaserOrbitalCannon();
                    break;
                }
                case INVALID: {
                    this.remove(Entity.RemovalReason.DISCARDED);
                    return;
                }
            }
        }
        this.laserTick.tick(this);
    }

    public boolean shouldRenderAtSqrDistance(double pDistance) {
        double d0 = 64.0 * LaserEntity.getViewScale();
        return pDistance < d0 * d0;
    }
}

