/*
 * Decompiled with CFR 0.152.
 */
package com.brpacks.arkanis.aac.custom.entity;

import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LightningBolt;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;

public class CustomLightningBolt
extends LightningBolt {
    private static final EntityDataAccessor<Integer> PACKED_COLOR = SynchedEntityData.defineId(CustomLightningBolt.class, (EntityDataSerializer)EntityDataSerializers.INT);

    public CustomLightningBolt(EntityType<CustomLightningBolt> entityType, Level pLevel) {
        super(entityType, pLevel);
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        builder.define(PACKED_COLOR, (Object)0);
    }

    public int getPackedColor() {
        return (Integer)this.entityData.get(PACKED_COLOR);
    }

    public void setPackedColor(int value) {
        this.entityData.set(PACKED_COLOR, (Object)value);
    }

    public void addAdditionalSaveData(@NotNull CompoundTag nbt) {
        super.addAdditionalSaveData(nbt);
        nbt.putInt("packedColor", this.getPackedColor());
    }

    public void readAdditionalSaveData(@NotNull CompoundTag nbt) {
        super.readAdditionalSaveData(nbt);
        if (nbt.contains("packedColor")) {
            this.setPackedColor(nbt.getInt("packedColor"));
        }
    }

    public void tick() {
        super.tick();
    }
}

