/*
 * Decompiled with CFR 0.152.
 */
package com.brpacks.arkanis.aac.custom.command;

import com.brpacks.arkanis.aac.custom.command.BaseCommand;
import com.brpacks.arkanis.aac.custom.command.ICommand;
import com.brpacks.arkanis.aac.custom.entity.CustomLightningBolt;
import com.brpacks.arkanis.aac.custom.entity.laser.LaserEntity;
import com.brpacks.arkanis.aac.custom.entity.laser.mode.LaserMode;
import com.brpacks.arkanis.aac.registry.ModEntities;
import com.brpacks.arkanis.aac.util.ColorUtils;
import com.brpacks.arkanis.aac.util.CommandUtils;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import java.util.List;
import java.util.UUID;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.commands.arguments.coordinates.Vec3Argument;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.phys.Vec3;

public class TeleportCommand
implements ICommand {
    @Override
    public LiteralArgumentBuilder<CommandSourceStack> getBaseCommandBuilder() {
        return BaseCommand.buildWithColor((LiteralArgumentBuilder<CommandSourceStack>)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"teleport").then(Commands.argument((String)"player", (ArgumentType)EntityArgument.player()).then(((RequiredArgumentBuilder)Commands.argument((String)"destination", (ArgumentType)Vec3Argument.vec3()).then(Commands.literal((String)"thunder").executes(this::teleportWithThunder))).then(Commands.literal((String)"laser").executes(this::teleportWithLaser))))).then(((RequiredArgumentBuilder)Commands.argument((String)"destination", (ArgumentType)Vec3Argument.vec3()).then(Commands.literal((String)"thunder").executes(this::teleportWithThunder))).then(Commands.literal((String)"laser").executes(this::teleportWithLaser)))), true);
    }

    private int teleportWithLaser(CommandContext<CommandSourceStack> ctx) {
        DyeColor dyeColor;
        UUID uuid = CommandUtils.getCorrectUUID(ctx);
        String rgb = (String)ctx.getArgument("color", String.class);
        Vec3 destination = Vec3Argument.getVec3(ctx, (String)"destination");
        try {
            dyeColor = DyeColor.byName((String)rgb, null);
        }
        catch (Exception e) {
            dyeColor = null;
        }
        if (uuid == null) {
            ((CommandSourceStack)ctx.getSource()).sendFailure((Component)Component.literal((String)"Invalid player"));
            return 0;
        }
        ServerPlayer player = ((CommandSourceStack)ctx.getSource()).getServer().getPlayerList().getPlayer(uuid);
        if (player == null) {
            ((CommandSourceStack)ctx.getSource()).sendFailure((Component)Component.literal((String)"Player not found"));
            return 0;
        }
        List<Integer> colorList = ColorUtils.unpackRGB(dyeColor.getTextColor());
        if (colorList == null) {
            ((CommandSourceStack)ctx.getSource()).sendFailure((Component)Component.literal((String)"Invalid color"));
            return 0;
        }
        LaserEntity laser = new LaserEntity(ModEntities.LASER_ENTITY.get(), player.level());
        laser.setOwner(player.getUUID());
        laser.setPackedColor(ColorUtils.packRGB(colorList.get(0), colorList.get(1), colorList.get(2)));
        laser.setPos(player.getX(), player.getY(), player.getZ());
        laser.setMode(LaserMode.TELEPORT);
        laser.setDestination(new BlockPos((int)destination.x, (int)destination.y, (int)destination.z));
        player.level().addFreshEntity((Entity)laser);
        return 1;
    }

    private int teleportWithThunder(CommandContext<CommandSourceStack> ctx) {
        UUID uuid = CommandUtils.getCorrectUUID(ctx);
        DyeColor dyeColor = (DyeColor)ctx.getArgument("color", DyeColor.class);
        Vec3 destination = Vec3Argument.getVec3(ctx, (String)"destination");
        if (uuid == null) {
            ((CommandSourceStack)ctx.getSource()).sendFailure((Component)Component.literal((String)"Invalid player"));
            return 0;
        }
        ServerPlayer player = ((CommandSourceStack)ctx.getSource()).getServer().getPlayerList().getPlayer(uuid);
        if (player == null) {
            ((CommandSourceStack)ctx.getSource()).sendFailure((Component)Component.literal((String)"Player not found"));
            return 0;
        }
        List<Integer> colorList = ColorUtils.unpackRGB(dyeColor.getTextColor());
        if (colorList == null) {
            ((CommandSourceStack)ctx.getSource()).sendFailure((Component)Component.literal((String)"Invalid color"));
            return 0;
        }
        CustomLightningBolt bolt = new CustomLightningBolt(ModEntities.CUSTOM_LIGHTNING_BOLT.get(), player.level());
        bolt.setPackedColor(ColorUtils.packRGB(colorList.get(0), colorList.get(1), colorList.get(2)));
        bolt.setPos(player.getX(), player.getY(), player.getZ());
        player.level().addFreshEntity((Entity)bolt);
        player.teleportTo(destination.x, destination.y, destination.z);
        return 1;
    }
}

