/*
 * Decompiled with CFR 0.152.
 */
package com.brpacks.arkanis.aac.custom.command;

import com.brpacks.arkanis.aac.custom.command.BaseCommand;
import com.brpacks.arkanis.aac.custom.command.ICommand;
import com.brpacks.arkanis.aac.custom.entity.CustomLightningBolt;
import com.brpacks.arkanis.aac.registry.ModEntities;
import com.brpacks.arkanis.aac.util.ColorUtils;
import com.brpacks.arkanis.aac.util.CommandUtils;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import java.util.List;
import java.util.UUID;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.FastColor;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.DyeColor;

public class SummonLightning
implements ICommand {
    @Override
    public LiteralArgumentBuilder<CommandSourceStack> getBaseCommandBuilder() {
        return BaseCommand.buildWithColor((LiteralArgumentBuilder<CommandSourceStack>)((LiteralArgumentBuilder)Commands.literal((String)"summon").then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"lightning").then(Commands.argument((String)"player", (ArgumentType)EntityArgument.player()).executes(this::summonLightning))).then(Commands.argument((String)"playerUUID", (ArgumentType)EntityArgument.player()).executes(this::summonLightning))).executes(this::summonLightning))), true);
    }

    private int summonLightning(CommandContext<CommandSourceStack> ctx) {
        DyeColor rgb = (DyeColor)ctx.getArgument("color", DyeColor.class);
        UUID playerUUID = CommandUtils.getCorrectUUID(ctx);
        ServerPlayer target = ((CommandSourceStack)ctx.getSource()).getServer().getPlayerList().getPlayer(playerUUID);
        if (target == null) {
            ((CommandSourceStack)ctx.getSource()).sendFailure((Component)Component.literal((String)"Player not found"));
            return 0;
        }
        List<Integer> colorList = ColorUtils.unpackRGB(rgb.getTextColor());
        if (colorList == null) {
            ((CommandSourceStack)ctx.getSource()).sendFailure((Component)Component.literal((String)"Invalid color"));
            return 0;
        }
        CustomLightningBolt bolt = new CustomLightningBolt(ModEntities.CUSTOM_LIGHTNING_BOLT.get(), target.getCommandSenderWorld());
        bolt.setPackedColor(FastColor.ABGR32.color((int)1, (int)colorList.get(0), (int)colorList.get(1), (int)colorList.get(2)));
        bolt.setPos(target.getX(), target.getY(), target.getZ());
        target.getCommandSenderWorld().addFreshEntity((Entity)bolt);
        return 1;
    }
}

