/*
 * Decompiled with CFR 0.152.
 */
package com.brpacks.arkanis.aac.custom.client.renderer;

import com.brpacks.arkanis.aac.custom.entity.laser.LaserEntity;
import com.brpacks.arkanis.aac.util.ColorUtils;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.List;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.NotNull;
import org.joml.Matrix4f;

public class LaserRenderer
extends EntityRenderer<LaserEntity> {
    public LaserRenderer(EntityRendererProvider.Context pContext) {
        super(pContext);
    }

    public void render(@NotNull LaserEntity entity, float yaw, float partialTicks, @NotNull PoseStack poseStack, @NotNull MultiBufferSource buffer, int packedLight) {
        int packedColor = entity.getPackedColor();
        List<Integer> colours = ColorUtils.unpackRGB(packedColor);
        float height = entity.getHeight();
        float red = (float)colours.get(0).intValue() / 255.0f;
        float green = (float)colours.get(1).intValue() / 255.0f;
        float blue = (float)colours.get(2).intValue() / 255.0f;
        poseStack.pushPose();
        VertexConsumer vertexConsumer = buffer.getBuffer(RenderType.debugQuads());
        Matrix4f matrix = poseStack.last().pose();
        RenderSystem.disableCull();
        float size = 0.5f;
        LaserRenderer.quad(matrix, vertexConsumer, 0.0f, 0.0f, 0.0f, height, 0.0f, 0.0f, red, green, blue, 90.0f, size * 2.0f, false, false, true, false);
        LaserRenderer.quad(matrix, vertexConsumer, 0.0f, 0.0f, 0.0f, height, 0.0f, 0.0f, red, green, blue, 90.0f, size * 2.0f, true, false, true, true);
        LaserRenderer.quad(matrix, vertexConsumer, 0.0f, 0.0f, 0.0f, height, 0.0f, 0.0f, red, green, blue, 90.0f, size * 2.0f, true, true, false, true);
        LaserRenderer.quad(matrix, vertexConsumer, 0.0f, 0.0f, 0.0f, height, 0.0f, 0.0f, red, green, blue, 90.0f, size * 2.0f, false, true, false, false);
        LaserRenderer.quad(matrix, vertexConsumer, 0.0f, 2.0f, 0.0f, 0.0f, 0.0f, 0.0f, red, green, blue, 90.0f, size * 2.0f, false, false, true, false);
        poseStack.popPose();
    }

    private static void quad(Matrix4f pMatrix, VertexConsumer pConsumer, float pX1, float pZ1, float pY1, float pY2, float pX2, float pZ2, float pRed, float pGreen, float pBlue, float alpha, float size, boolean p_115285_, boolean p_115286_, boolean p_115287_, boolean p_115288_) {
        if (alpha < 2.0f) {
            return;
        }
        pConsumer.addVertex(pMatrix, pX1 + (p_115285_ ? size : -size), pY1, pZ1 + (p_115286_ ? size : -size)).setColor(pRed, pGreen, pBlue, alpha);
        pConsumer.addVertex(pMatrix, pX2 + (p_115285_ ? size : -size), pY1 + pY2, pZ2 + (p_115286_ ? size : -size)).setColor(pRed, pGreen, pBlue, alpha);
        pConsumer.addVertex(pMatrix, pX2 + (p_115287_ ? size : -size), pY1 + pY2, pZ2 + (p_115288_ ? size : -size)).setColor(pRed, pGreen, pBlue, alpha);
        pConsumer.addVertex(pMatrix, pX1 + (p_115287_ ? size : -size), pY1, pZ1 + (p_115288_ ? size : -size)).setColor(pRed, pGreen, pBlue, alpha);
    }

    @NotNull
    public ResourceLocation getTextureLocation(@NotNull LaserEntity laserEntity) {
        return TextureAtlas.LOCATION_BLOCKS;
    }
}

