/*
 * Decompiled with CFR 0.152.
 */
package io.wispforest.owo.command.debug;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import com.mojang.logging.LogUtils;
import io.wispforest.owo.Owo;
import io.wispforest.owo.command.EnumArgumentType;
import io.wispforest.owo.command.debug.DumpdataCommand;
import io.wispforest.owo.command.debug.HealCommand;
import io.wispforest.owo.command.debug.MakeLootContainerCommand;
import io.wispforest.owo.ops.TextOps;
import io.wispforest.owo.renderdoc.RenderDoc;
import io.wispforest.owo.renderdoc.RenderdocScreen;
import io.wispforest.owo.ui.hud.HudInspectorScreen;
import io.wispforest.owo.ui.parsing.ConfigureHotReloadScreen;
import io.wispforest.owo.ui.parsing.UIModelLoader;
import java.lang.reflect.Field;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.commands.CommandBuildContext;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.commands.arguments.ResourceLocationArgument;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.HoverEvent;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.ai.village.poi.PoiManager;
import net.minecraft.world.entity.ai.village.poi.PoiRecord;
import net.minecraft.world.entity.ai.village.poi.PoiType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.registries.RegisterEvent;
import org.jetbrains.annotations.ApiStatus;
import org.slf4j.event.Level;

@ApiStatus.Internal
public class OwoDebugCommands {
    private static EnumArgumentType<Level> LEVEL_ARGUMENT_TYPE;
    private static final SuggestionProvider<CommandSourceStack> POI_TYPES;
    private static final SimpleCommandExceptionType NO_POI_TYPE;
    public static final int GENERAL_PURPLE = 12157951;
    public static final int KEY_BLUE = 9745405;
    public static final int VALUE_BLUE = 9755391;

    public static void register(IEventBus modBus) {
        modBus.addListener(RegisterEvent.class, event -> event.register(Registries.COMMAND_ARGUMENT_TYPE, helper -> {
            LEVEL_ARGUMENT_TYPE = EnumArgumentType.create(Level.class, "'{}' is not a valid logging level");
        }));
        NeoForge.EVENT_BUS.addListener(event -> {
            CommandDispatcher dispatcher = event.getDispatcher();
            CommandBuildContext registryAccess = event.getBuildContext();
            dispatcher.register((LiteralArgumentBuilder)Commands.literal((String)"logger").then(Commands.argument((String)"level", LEVEL_ARGUMENT_TYPE).executes(context -> {
                Level level = LEVEL_ARGUMENT_TYPE.get(context, "level");
                LogUtils.configureRootLoggingLevel((Level)level);
                ((CommandSourceStack)context.getSource()).sendSuccess(() -> TextOps.concat(Owo.PREFIX, Component.nullToEmpty((String)("global logging level set to: \u00a79" + String.valueOf(level)))), false);
                return 0;
            })));
            dispatcher.register((LiteralArgumentBuilder)Commands.literal((String)"query-poi").then(Commands.argument((String)"poi_type", (ArgumentType)ResourceLocationArgument.id()).suggests(POI_TYPES).then(Commands.argument((String)"radius", (ArgumentType)IntegerArgumentType.integer()).executes(context -> {
                ServerPlayer player = ((CommandSourceStack)context.getSource()).getPlayer();
                PoiType poiType = (PoiType)BuiltInRegistries.POINT_OF_INTEREST_TYPE.getOptional(ResourceLocationArgument.getId((CommandContext)context, (String)"poi_type")).orElseThrow(() -> ((SimpleCommandExceptionType)NO_POI_TYPE).create());
                List entries = ((ServerLevel)player.level()).getPoiManager().getInRange(type -> type.value() == poiType, player.blockPosition(), IntegerArgumentType.getInteger((CommandContext)context, (String)"radius"), PoiManager.Occupancy.ANY).toList();
                player.displayClientMessage((Component)TextOps.concat(Owo.PREFIX, (Component)TextOps.withColor("Found \u00a7" + entries.size() + " \u00a7entr" + (entries.size() == 1 ? "y" : "ies"), TextOps.color(ChatFormatting.GRAY), 12157951, TextOps.color(ChatFormatting.GRAY))), false);
                for (PoiRecord entry : entries) {
                    BlockPos entryPos = entry.getPos();
                    String blockId = BuiltInRegistries.BLOCK.getKey((Object)player.level().getBlockState(entryPos).getBlock()).toString();
                    String posString = "(" + entryPos.getX() + " " + entryPos.getY() + " " + entryPos.getZ() + ")";
                    MutableComponent message = TextOps.withColor("-> \u00a7" + blockId + " \u00a7" + posString, TextOps.color(ChatFormatting.GRAY), 9745405, 9755391);
                    message.withStyle(style -> style.withClickEvent(new ClickEvent(ClickEvent.Action.SUGGEST_COMMAND, "/tp " + entryPos.getX() + " " + entryPos.getY() + " " + entryPos.getZ())).withHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_TEXT, (Object)Component.nullToEmpty((String)"Click to teleport"))));
                    player.displayClientMessage((Component)message, false);
                }
                return entries.size();
            }))));
            dispatcher.register((LiteralArgumentBuilder)Commands.literal((String)"dumpfield").then(Commands.argument((String)"field_name", (ArgumentType)StringArgumentType.string()).executes(context -> {
                String targetField = StringArgumentType.getString((CommandContext)context, (String)"field_name");
                CommandSourceStack source = (CommandSourceStack)context.getSource();
                ServerPlayer player = source.getPlayer();
                HitResult target = player.pick(5.0, 0.0f, false);
                if (target.getType() != HitResult.Type.BLOCK) {
                    source.sendFailure((Component)TextOps.concat(Owo.PREFIX, (Component)Component.literal((String)"You're not looking at a block")));
                    return 1;
                }
                BlockPos pos = ((BlockHitResult)target).getBlockPos();
                BlockEntity blockEntity = player.level().getBlockEntity(pos);
                if (blockEntity == null) {
                    source.sendFailure((Component)TextOps.concat(Owo.PREFIX, (Component)Component.literal((String)"No block entity")));
                    return 1;
                }
                Class<?> blockEntityClass = blockEntity.getClass();
                try {
                    Field field = blockEntityClass.getDeclaredField(targetField);
                    if (!field.canAccess(blockEntity)) {
                        field.setAccessible(true);
                    }
                    Object value = field.get(blockEntity);
                    source.sendSuccess(() -> TextOps.concat(Owo.PREFIX, (Component)TextOps.withColor("Field value: \u00a7" + String.valueOf(value), TextOps.color(ChatFormatting.GRAY), 9745405)), false);
                }
                catch (Exception e) {
                    source.sendFailure((Component)TextOps.concat(Owo.PREFIX, (Component)Component.literal((String)("Could not access field - " + e.getClass().getSimpleName() + ": " + e.getMessage()))));
                }
                return 0;
            })));
            MakeLootContainerCommand.register((CommandDispatcher<CommandSourceStack>)dispatcher, registryAccess);
            DumpdataCommand.register((CommandDispatcher<CommandSourceStack>)dispatcher);
            HealCommand.register((CommandDispatcher<CommandSourceStack>)dispatcher);
        });
    }

    static {
        POI_TYPES = (context, builder) -> SharedSuggestionProvider.suggestResource((Iterable)BuiltInRegistries.POINT_OF_INTEREST_TYPE.keySet(), (SuggestionsBuilder)builder);
        NO_POI_TYPE = new SimpleCommandExceptionType((Message)Component.nullToEmpty((String)"Invalid POI type"));
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class Client {
        private static final SuggestionProvider<CommandSourceStack> LOADED_UI_MODELS = (context, builder) -> SharedSuggestionProvider.suggestResource(UIModelLoader.allLoadedModels(), (SuggestionsBuilder)builder);
        private static final SimpleCommandExceptionType NO_SUCH_UI_MODEL = new SimpleCommandExceptionType((Message)Component.literal((String)"No such UI model is loaded"));

        public static void register() {
            NeoForge.EVENT_BUS.addListener(event -> {
                CommandDispatcher dispatcher = event.getDispatcher();
                CommandBuildContext registryAccess = event.getBuildContext();
                dispatcher.register((LiteralArgumentBuilder)Commands.literal((String)"owo-hud-inspect").executes(context -> {
                    Minecraft.getInstance().setScreen((Screen)new HudInspectorScreen());
                    return 0;
                }));
                dispatcher.register((LiteralArgumentBuilder)Commands.literal((String)"owo-ui-set-reload-path").then(Commands.argument((String)"model-id", (ArgumentType)ResourceLocationArgument.id()).suggests(LOADED_UI_MODELS).executes(context -> {
                    ResourceLocation modelId = (ResourceLocation)context.getArgument("model-id", ResourceLocation.class);
                    if (UIModelLoader.getPreloaded(modelId) == null) {
                        throw NO_SUCH_UI_MODEL.create();
                    }
                    Minecraft.getInstance().setScreen((Screen)new ConfigureHotReloadScreen(modelId, null));
                    return 0;
                })));
                if (RenderDoc.isAvailable()) {
                    dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"renderdoc").executes(context -> {
                        Minecraft.getInstance().setScreen((Screen)new RenderdocScreen());
                        return 1;
                    })).then(Commands.literal((String)"comment").then(Commands.argument((String)"capture_index", (ArgumentType)IntegerArgumentType.integer((int)0)).then(Commands.argument((String)"comment", (ArgumentType)StringArgumentType.greedyString()).executes(context -> {
                        RenderDoc.Capture capture = RenderDoc.getCapture(IntegerArgumentType.getInteger((CommandContext)context, (String)"capture_index"));
                        if (capture == null) {
                            ((CommandSourceStack)context.getSource()).sendFailure((Component)TextOps.concat(Owo.PREFIX, Component.nullToEmpty((String)"no such capture")));
                            return 0;
                        }
                        RenderDoc.setCaptureComments(capture, StringArgumentType.getString((CommandContext)context, (String)"comment"));
                        ((CommandSourceStack)context.getSource()).sendSuccess(() -> TextOps.concat(Owo.PREFIX, Component.nullToEmpty((String)"comment updated")), false);
                        return 1;
                    })))));
                }
            });
        }
    }
}

